/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.configuracao.ExameImpressao;
import jalis.laboratorio.configuracao.Mensageiro;
import jalis.laboratorio.configuracao.PesquisaFinalizada;
import jalis.laboratorio.configuracao.Pesquisar;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class ImprimirLayoutExame
extends FrmPadrao
implements ActionListener,
PesquisaFinalizada {
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemModelo;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemExame;
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'i', this);
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JCheckBox checkPadrao = new JCheckBox("Apenas material padr\u00e3o");
    private JTextArea textArea = new JTextArea();
    private Mensageiro mensageiro = null;
    private Statement st = null;

    public ImprimirLayoutExame() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Impress\u00e3o de modelos", "Impress\u00e3o dos modelos dos exames configurados", "configuracoes/impressao_modelos.jpg");
        this.montaTela();
    }

    private void montaTela() {
        this.panelEsquerdo.setPreferredSize(new Dimension(200, 100));
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonFechar);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        Dimension dim = new Dimension(10, 25);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.itemModelo = new CheckItemFiltro("Modelo", "Filtrar", "Filtrando modelos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemModelo.setDados("layout", new String[]{"lay_codigo", "lay_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemModelo.setColunaHint(1);
        this.itemModelo.setPreferredSize(dim);
        this.panelEsquerdo.add((Component)this.itemModelo, c);
        ++c.gridy;
        this.itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando Setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemSetor.setPreferredSize(dim);
        this.panelEsquerdo.add((Component)this.itemSetor, c);
        ++c.gridy;
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando Exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dim);
        this.panelEsquerdo.add((Component)this.itemExame, c);
        ++c.gridy;
        this.panelEsquerdo.add((Component)this.checkPadrao, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonImprimir, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        this.panelEsquerdo.add((Component)new JPanel(), c);
        this.panelCentro.add((Component)new JScrollPane(this.textArea), "Center");
        this.textArea.setEditable(false);
        this.textArea.setBackground(this.getBackground());
    }

    public static long getModuloAcesso() {
        return 501000000L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonImprimir) {
            this.imprimir();
        } else if (o == this.buttonNovo) {
            this.novo();
        }
    }

    private void novo() {
        this.textArea.setText("");
        this.itemModelo.clear();
        this.itemSetor.clear();
        this.itemExame.clear();
    }

    private void imprimir() {
        int i;
        StringBuilder bui = new StringBuilder();
        bui.append("select \n");
        bui.append("  elm.fil_codigo, elm.exa_codigo, elm.mco_codigo, elm.lay_codigo, elm.ela_idadeini, elm.ela_idadefim, \n");
        bui.append("  elm.ela_idadeinitipo, elm.ela_idadefimtipo, elm.met_codigo, lay.lay_descricao, ");
        bui.append("  emc.emc_pagina, emc.emc_ordem, mco.mco_descricao, elm.elm_formato, met.met_descricao, exa.exa_descricao ");
        bui.append("from examelayoutmetodo elm ");
        bui.append("join examelayout ela \n");
        bui.append("  on elm.fil_codigo = ela.fil_codigo and elm.exa_codigo = ela.exa_codigo and elm.mco_codigo = ela.mco_codigo and \n");
        bui.append("     elm.lay_codigo = ela.lay_codigo and elm.ela_idadeini = ela.ela_idadeini and elm.ela_idadefim = ela.ela_idadefim and \n");
        bui.append("     elm.ela_idadeinitipo = ela.ela_idadeinitipo and elm.ela_idadefimtipo = ela.ela_idadefimtipo \n");
        bui.append("join examesetor ese on ");
        bui.append("     elm.fil_codigo = ese.fil_codigo and ");
        bui.append("     elm.exa_codigo = ese.exa_codigo and ");
        bui.append("     ese.ese_default = true ");
        bui.append("left join examematcoleta emc on ");
        bui.append("     elm.fil_codigo = emc.fil_codigo and ");
        bui.append("     elm.exa_codigo = emc.exa_codigo and ");
        bui.append("     elm.mco_codigo = emc.mco_codigo ");
        bui.append("left join materialcoleta mco on ");
        bui.append("     emc.fil_codigo = mco.fil_codigo and ");
        bui.append("     emc.mco_codigo = mco.mco_codigo ");
        bui.append("left join exames exa on ");
        bui.append("     emc.fil_codigo = exa.fil_codigo and ");
        bui.append("     emc.exa_codigo = exa.exa_codigo ");
        bui.append("left join metodologia met on ");
        bui.append("     elm.fil_codigo = met.fil_codigo and ");
        bui.append("     elm.met_codigo = met.met_codigo ");
        bui.append("left join layout lay on ");
        bui.append("     elm.fil_codigo = lay.fil_codigo and ");
        bui.append("     elm.lay_codigo = lay.lay_codigo ");
        bui.append("where ");
        bui.append(" ela.fil_codigo = ").append(Variaveis.filialPadrao);
        if (this.checkPadrao.isSelected()) {
            bui.append(" and emc.emc_default = true ");
        }
        String[] exames = this.itemExame.getSelecionados(0);
        String[] modelos = this.itemModelo.getSelecionados(0);
        String[] setores = this.itemSetor.getSelecionados(0);
        if (exames != null && exames.length > 0) {
            bui.append("  and ela.exa_codigo in (");
            for (i = 0; i < exames.length; ++i) {
                bui.append("'").append(StringUtil.textoDB(exames[i])).append("'");
                if (i >= exames.length - 1) continue;
                bui.append(", ");
            }
            bui.append(") ");
        }
        if (modelos != null && modelos.length > 0) {
            bui.append("  and ela.lay_codigo in (");
            for (i = 0; i < modelos.length; ++i) {
                bui.append(modelos[i]);
                if (i >= modelos.length - 1) continue;
                bui.append(", ");
            }
            bui.append(") ");
        }
        if (setores != null && setores.length > 0) {
            bui.append("  and ese.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                bui.append(setores[i]);
                if (i >= setores.length - 1) continue;
                bui.append(", ");
            }
            bui.append(") ");
        }
        bui.append("order by \n");
        bui.append("  ela.exa_codigo \n");
        this.buttonImprimir.setEnabled(false);
        this.buttonNovo.setEnabled(false);
        this.buttonFechar.setEnabled(false);
        try {
            this.mensageiro = new Mensageiro(this.textArea);
            this.mensageiro.start();
            this.mensageiro.escrever("Pesquisando exames...");
            this.st = Conexao.getStatement();
            Pesquisar p = new Pesquisar(this.st, bui.toString());
            p.addPesquisaFinalizada(this);
            p.start();
            this.mensageiro.interrupt();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void examePesquisado(ExameImpressao e) {
        this.mensageiro.escrever("Adicionando exame " + e.exa_descricao);
    }

    @Override
    public void pesquisaFinalizada() {
        Conexao.fecharStatement(this.st);
        this.buttonImprimir.setEnabled(true);
        this.buttonNovo.setEnabled(true);
        this.buttonFechar.setEnabled(true);
    }
}

