/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.configuracao.ExameImpressao;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

class Impressao
implements Printable {
    private ArrayList<ExameImpressao> exames;

    public Impressao(ArrayList<ExameImpressao> exames) {
        try {
            this.exames = exames;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImprimirLayoutExame (380)");
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > this.exames.size() - 1) {
            return 1;
        }
        graphics.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Arial", 0, 10));
        graphics.drawString("Pg: " + (pageIndex + 1), (int)ScreenUtil.getPixelsDeCentimetros(18.0f), 50);
        try {
            this.imprimir(graphics, this.exames.get(pageIndex));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void imprimir() throws Exception {
        PrintService ps = Funcoes.localizarImpressora(ParametrosLocais.getParametro("impressoraLaudo"));
        if (ps == null) {
            ps = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (ps != null) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            PrinterJob job = PrinterJob.getPrinterJob();
            PageFormat pageFormat = new PageFormat();
            pageFormat.setOrientation(1);
            Paper paper = new Paper();
            paper.setSize(ScreenUtil.getPixelsDeCentimetros(21.0f), ScreenUtil.getPixelsDeCentimetros(29.7f));
            pageFormat.setPaper(paper);
            pageFormat = job.pageDialog(pageFormat);
            job.setPrintService(ps);
            job.setPrintable(this, pageFormat);
            job.setCopies(1);
            job.print();
        }
    }

    private void imprimir(Graphics g, ExameImpressao exame) throws Exception {
        if (exame != null) {
            StringBuilder bui = new StringBuilder();
            bui.delete(0, bui.length());
            bui.append("Exame: ").append(exame.exa_codigo);
            bui.append("      Material: ").append(exame.mco_descricao);
            bui.append("      Pagina: ").append(exame.emc_pagina);
            bui.append("      Ordem: ").append(exame.emc_ordem);
            bui.append("      Modelo: ").append(exame.lay_descricao);
            g.setColor(Color.black);
            g.drawString(bui.toString(), 0, 50);
            bui.delete(0, bui.length());
            bui.append("Nome: ").append(exame.exa_descricao);
            bui.append("      M\u00e9todo: ").append(exame.met_descricao);
            g.drawString(bui.toString(), 0, 65);
            g.drawLine(0, 70, (int)ScreenUtil.getPixelsDeCentimetros(19.0f), 70);
            g.translate(0, 70);
            this.imprimirFormato(g, exame.elm_formato);
        }
    }

    private void imprimirFormato(Graphics g, String formato) throws Exception {
        ArrayList<Component> comps = new ArrayList<Component>();
        String tmp = StringUtil.getValor(formato, "pagina");
        tmp = StringUtil.getValor(StringUtil.getValor(tmp, "itens"), "corpo");
        for (String item : StringUtil.getListValores(tmp, "componente")) {
            Componente comp = (Componente)Class.forName(StringUtil.getValor(item, "tipo")).newInstance();
            comp.setAtributos(StringUtil.getValor(item, "atributos"));
            comps.add(comp instanceof Rotulo ? comp.getComponenteDigitacao(false) : (Component)((Object)comp));
        }
        ScreenUtil.setMargem(comps, 0, 5);
        ListIterator<Component> itr = comps.listIterator(comps.size());
        while (itr.hasPrevious()) {
            Component c = itr.previous();
            Rectangle rec = c.getBounds();
            g.setClip(rec);
            g.translate(rec.x, rec.y);
            c.paint(g);
            g.translate(-rec.x, -rec.y);
        }
    }
}

