/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.configuracao.TabelaPreco;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class ImportacaoTabelaPreco
extends JPanel
implements ActionListener {
    private static final long ACESSO = Long.parseLong("0500800000");
    private JPanel panelCentral = ComponenteFactory.novoJPanel(new BorderLayout(), null);
    private JPanel panelArquivo = ComponenteFactory.novoJPanel(new GridBagLayout(), null);
    private JLabel labelArquivo = ComponenteFactory.novoJLabel("Arquivo:", new Dimension(80, 20));
    private TTextField textArquivo = ComponenteFactory.novoTTextField(255, 3);
    private JButton buttonAbrirArquivo = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonProcessarArquivo = ComponenteFactory.novoJButton("Processar", 'P', this, null, null);
    private JCheckBox checkRemoveAspas = ComponenteFactory.novoJCheckBox("Remove aspas", 'R');
    private JLabel labelDelimitador = ComponenteFactory.novoJLabel("Delimitador:", new Dimension(80, 20));
    private TTextField textDelimitador = ComponenteFactory.novoTTextField(1, 3);
    private JLabel labelColunaExame = ComponenteFactory.novoJLabel("Coluna Exame:", new Dimension(100, 20));
    private TTextField textColunaExame = ComponenteFactory.novoTTextField(1, 1);
    private JLabel labelColunaMaterial = ComponenteFactory.novoJLabel("Coluna Material:", new Dimension(100, 20));
    private TTextField textColunaMaterial = ComponenteFactory.novoTTextField(1, 1);
    private JPanel panelItens = ComponenteFactory.novoJPanel(new BorderLayout(), null);
    private ModeloGridTable modeloExames;
    private JTable tableExames;
    private JScrollPane scrollExames = new JScrollPane();
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private JPanel panelTabela = ComponenteFactory.novoJPanel(new GridBagLayout(), null);
    private JLabel labelTabela = ComponenteFactory.novoJLabel("Tabela:", new Dimension(85, 20));
    private JComboBox comboTabelas = ComponenteFactory.novoJComboBox(this);
    private JLabel labelAMB = ComponenteFactory.novoJLabel("Coluna AMB:", new Dimension(90, 20));
    private TTextField textColunaAMB = ComponenteFactory.novoTTextField(3, 1);
    private JLabel labelValor = ComponenteFactory.novoJLabel("Coluna Valor:", new Dimension(90, 20));
    private TTextField textColunaValor = ComponenteFactory.novoTTextField(3, 1);
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'I', this, null, null);
    private JPanel panelRetorno = ComponenteFactory.novoJPanel(new BorderLayout(), null);
    private JTextArea textStatus = new JTextArea();
    private JTextArea textErros = new JTextArea();
    private JScrollPane scrollStatus = new JScrollPane(this.textStatus);
    private JScrollPane scrollErros = new JScrollPane(this.textErros);
    private JSplitPane splitRetorno = new JSplitPane(1, this.scrollStatus, this.scrollErros);
    private JSplitPane splitCentral = new JSplitPane(0, this.panelItens, this.splitRetorno);
    private JPanel panelBotoes = ComponenteFactory.novoJPanel(new FlowLayout(2), null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private static final String POSICAO_DIVISOR_CENTRAL = "ImportacaoTabelaPreco.posicaoDivisorCentral";
    private static final String POSICAO_DIVISOR_RETORNO = "ImportacaoTabelaPreco.posicaoDivisorRetorno";
    private static final String ULTIMA_IMPORTACAO = "ImportacaoTabelaPreco.ultimaImportacao";
    private static final String REMOVE_ASPAS_IMPORTACAO = "ImportacaoTabelaPreco.removeAspasImportacao";
    private static final String DELIMITADOR_IMPORTACAO = "ImportacaoTabelaPreco.delimitadorImportacao";
    private static final String COLUNA_EXAME_IMPORTACAO = "ImportacaoTabelaPreco.colunaExameImportacao";
    private static final String COLUNA_MATERIAL_IMPORTACAO = "ImportacaoTabelaPreco.colunaMaterialImportacao";
    private static final String ARQUIVO_IMPORTACAO = "ImportacaoTabelaPreco.arquivoImportacao";
    private int posicaoDivisorCentral = 350;
    private int posicaoDivisorRetorno = 350;
    private ArrayList<TabelaPreco> tabelas = new ArrayList();
    private Statement st;

    public ImportacaoTabelaPreco() {
        this.construirTela();
    }

    private void construirTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Importa\u00e7\u00e3o de Tabela de Pre\u00e7o", "Realiza a importa\u00e7\u00e3o de tabelas de pre\u00e7o no formato CSV", "importar_csv.jpg");
        this.carregarParametros();
        this.add((Component)this.panelCentral, "Center");
        this.criaPanelArquivo();
        this.criaPanelIntes();
        this.criaPanelTabela();
        this.configuraSplitsScroll();
        this.criarPanelBotoes();
        this.textStatus.setEditable(false);
        this.textErros.setEditable(false);
        this.carregarTabelas();
    }

    private void criaPanelArquivo() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.ipadx = 5;
        cons.weightx = 0.0;
        cons.gridx = 0;
        cons.gridy = 0;
        this.panelArquivo.add((Component)this.labelArquivo, cons);
        this.textArquivo.setMinimumSize(new Dimension(200, 20));
        this.textArquivo.setPreferredSize(new Dimension(200, 20));
        cons.weightx = 1.0;
        cons.gridx = 1;
        cons.ipadx = 5;
        this.panelArquivo.add((Component)this.textArquivo, cons);
        cons.weightx = 0.0;
        cons.gridx = 2;
        cons.ipadx = 5;
        this.buttonAbrirArquivo.setFocusable(false);
        this.buttonAbrirArquivo.setPreferredSize(new Dimension(20, 20));
        this.buttonAbrirArquivo.setMinimumSize(new Dimension(20, 20));
        this.panelArquivo.add((Component)this.buttonAbrirArquivo, cons);
        cons.weightx = 0.0;
        cons.gridx = 3;
        cons.ipadx = 5;
        this.buttonProcessarArquivo.setFocusable(false);
        this.buttonProcessarArquivo.setPreferredSize(new Dimension(100, 20));
        this.buttonProcessarArquivo.setMinimumSize(new Dimension(100, 20));
        this.panelArquivo.add((Component)this.buttonProcessarArquivo, cons);
        JPanel temp = new JPanel(new GridBagLayout());
        cons.weightx = 0.0;
        cons.gridwidth = 0;
        cons.gridx = 0;
        cons.gridy = 1;
        this.panelArquivo.add((Component)temp, cons);
        cons = new GridBagConstraints();
        cons.ipadx = 5;
        cons.gridx = 0;
        cons.gridy = 0;
        temp.add((Component)this.labelDelimitador, cons);
        cons.gridx = 1;
        cons.ipadx = 5;
        this.textDelimitador.setMinimumSize(new Dimension(50, 20));
        this.textDelimitador.setPreferredSize(new Dimension(50, 20));
        temp.add((Component)this.textDelimitador, cons);
        cons.ipadx = 5;
        cons.gridx = 2;
        cons.gridy = 0;
        temp.add((Component)this.labelColunaExame, cons);
        cons.gridx = 3;
        cons.ipadx = 5;
        this.textColunaExame.setMinimumSize(new Dimension(50, 20));
        this.textColunaExame.setPreferredSize(new Dimension(50, 20));
        temp.add((Component)this.textColunaExame, cons);
        cons.ipadx = 5;
        cons.gridx = 2;
        cons.gridy = 0;
        temp.add((Component)this.labelColunaExame, cons);
        cons.gridx = 3;
        cons.ipadx = 5;
        this.textColunaExame.setMinimumSize(new Dimension(50, 20));
        this.textColunaExame.setPreferredSize(new Dimension(50, 20));
        temp.add((Component)this.textColunaExame, cons);
        cons.ipadx = 5;
        cons.gridx = 4;
        cons.gridy = 0;
        temp.add((Component)this.labelColunaMaterial, cons);
        cons.gridx = 5;
        cons.ipadx = 5;
        this.textColunaMaterial.setMinimumSize(new Dimension(50, 20));
        this.textColunaMaterial.setPreferredSize(new Dimension(50, 20));
        temp.add((Component)this.textColunaMaterial, cons);
        cons.fill = 2;
        cons.weightx = 1.0;
        cons.ipadx = 5;
        cons.gridx = 6;
        temp.add((Component)this.checkRemoveAspas, cons);
        this.panelCentral.add((Component)this.panelArquivo, "North");
    }

    private void criaPanelIntes() {
        this.panelItens.add((Component)this.scrollExames, "Center");
    }

    private void criaPanelTabela() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        this.panelTabela.add((Component)this.labelTabela, cons);
        cons.weightx = 1.0;
        this.comboTabelas.setMinimumSize(new Dimension(200, 20));
        this.comboTabelas.setPreferredSize(new Dimension(200, 20));
        cons.gridx = 1;
        this.panelTabela.add((Component)this.comboTabelas, cons);
        cons.weightx = 0.0;
        cons.gridx = 2;
        this.panelTabela.add((Component)this.labelAMB, cons);
        this.textColunaAMB.setMinimumSize(new Dimension(50, 20));
        this.textColunaAMB.setPreferredSize(new Dimension(50, 20));
        cons.gridx = 3;
        this.panelTabela.add((Component)this.textColunaAMB, cons);
        cons.gridx = 4;
        this.panelTabela.add((Component)this.labelValor, cons);
        this.textColunaValor.setMinimumSize(new Dimension(50, 20));
        this.textColunaValor.setPreferredSize(new Dimension(50, 20));
        cons.gridx = 5;
        this.panelTabela.add((Component)this.textColunaValor, cons);
        cons.gridx = 6;
        this.panelTabela.add((Component)this.buttonImportar, cons);
        this.panelItens.add((Component)this.panelTabela, "South");
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR_CENTRAL)) {
            this.posicaoDivisorCentral = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR_CENTRAL));
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR_RETORNO)) {
            this.posicaoDivisorRetorno = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR_RETORNO));
        }
        if (ParametrosUsuarios.contemParametro(REMOVE_ASPAS_IMPORTACAO)) {
            this.checkRemoveAspas.setSelected(Boolean.parseBoolean(ParametrosUsuarios.getValor(REMOVE_ASPAS_IMPORTACAO)));
        }
        if (ParametrosUsuarios.contemParametro(DELIMITADOR_IMPORTACAO)) {
            this.textDelimitador.setText(ParametrosUsuarios.getValor(DELIMITADOR_IMPORTACAO));
        }
        if (ParametrosUsuarios.contemParametro(COLUNA_EXAME_IMPORTACAO)) {
            this.textColunaExame.setText(ParametrosUsuarios.getValor(COLUNA_EXAME_IMPORTACAO));
        }
        if (ParametrosUsuarios.contemParametro(COLUNA_MATERIAL_IMPORTACAO)) {
            this.textColunaMaterial.setText(ParametrosUsuarios.getValor(COLUNA_MATERIAL_IMPORTACAO));
        }
        if (ParametrosUsuarios.contemParametro(ARQUIVO_IMPORTACAO)) {
            this.textArquivo.setText(ParametrosUsuarios.getValor(ARQUIVO_IMPORTACAO));
        }
    }

    private void gravarParametros() {
        ParametrosUsuarios.setValor(POSICAO_DIVISOR_CENTRAL, String.valueOf(this.splitCentral.getDividerLocation()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR_RETORNO, String.valueOf(this.splitRetorno.getDividerLocation()));
        ParametrosUsuarios.setValor(REMOVE_ASPAS_IMPORTACAO, this.checkRemoveAspas.isSelected() ? "true" : "false");
        ParametrosUsuarios.setValor(DELIMITADOR_IMPORTACAO, this.textDelimitador.getText());
        ParametrosUsuarios.setValor(COLUNA_EXAME_IMPORTACAO, this.textColunaExame.getText());
        ParametrosUsuarios.setValor(COLUNA_MATERIAL_IMPORTACAO, this.textColunaMaterial.getText());
        ParametrosUsuarios.setValor(ARQUIVO_IMPORTACAO, this.textArquivo.getText());
    }

    private void configuraSplitsScroll() {
        this.panelCentral.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisorCentral);
        this.splitRetorno.setBorder(null);
        this.splitRetorno.setDividerSize(3);
        this.splitRetorno.setDividerLocation(this.posicaoDivisorRetorno);
        this.scrollErros.setBorder(BorderFactory.createTitledBorder("Erros"));
        this.scrollStatus.setBorder(BorderFactory.createTitledBorder("Status"));
    }

    private void criarPanelBotoes() {
        this.panelBotoes.add(this.buttonFechar);
        this.panelCentral.add((Component)this.panelBotoes, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.gravarParametros();
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonAbrirArquivo) {
            this.abrirArquivo();
        } else if (o == this.buttonProcessarArquivo) {
            this.processarArquivo();
        } else if (o == this.buttonImportar) {
            this.importarTabela();
        }
    }

    private void abrirArquivo() {
        JFileChooser f = ComponenteFactory.novoJFileChooser();
        FileFilter flt = ComponenteFactory.novoFileFilter("(*.csv)", "csv");
        f.setFileFilter(flt);
        if (f.showOpenDialog(this) == 0) {
            this.textArquivo.setText(f.getSelectedFile().getAbsolutePath());
        }
        this.renderer.limpar();
    }

    private void processarArquivo() {
        new Thread(){

            @Override
            public void run() {
                if (Funcoes.textoVazio(ImportacaoTabelaPreco.this.textArquivo.getText())) {
                    return;
                }
                String delimitador = ImportacaoTabelaPreco.this.textDelimitador.getText();
                int linhasPula = 0;
                String arquivo = "";
                try {
                    arquivo = StringUtil.lerArquivoTexto(ImportacaoTabelaPreco.this.textArquivo.getText());
                }
                catch (Exception e1) {
                    Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel ler o arquivo.\nMensagem: " + e1.getMessage(), 1);
                }
                String[] linhas = arquivo.split("\n");
                int qtdeColunas = linhas[linhasPula].split(delimitador).length + 1;
                String[] nomeColunas = new String[qtdeColunas];
                int[] tamanhoColunas = new int[qtdeColunas];
                nomeColunas[0] = "Linha";
                tamanhoColunas[0] = 35;
                nomeColunas[1] = "Exa.";
                tamanhoColunas[1] = 70;
                nomeColunas[2] = "Mat.";
                tamanhoColunas[2] = 70;
                nomeColunas[3] = "Exame";
                tamanhoColunas[3] = 85;
                nomeColunas[4] = "Material";
                tamanhoColunas[4] = 85;
                for (int i = 5; i < qtdeColunas; ++i) {
                    nomeColunas[i] = "Col " + Integer.toString(i);
                    tamanhoColunas[i] = 75;
                }
                ImportacaoTabelaPreco.this.modeloExames = new ModeloGridTable(nomeColunas);
                ImportacaoTabelaPreco.this.tableExames = ComponenteFactory.novoJTable((TableModel)ImportacaoTabelaPreco.this.modeloExames, null, tamanhoColunas);
                ImportacaoTabelaPreco.this.tableExames.setDefaultRenderer(Object.class, ImportacaoTabelaPreco.this.renderer);
                ImportacaoTabelaPreco.this.tableExames.setAutoResizeMode(0);
                ImportacaoTabelaPreco.this.scrollExames.setViewportView(ImportacaoTabelaPreco.this.tableExames);
                for (int linha = linhasPula; linha < linhas.length; ++linha) {
                    try {
                        Object[] lin = new String[qtdeColunas];
                        String[] cols = ImportacaoTabelaPreco.this.checkRemoveAspas.isSelected() ? StringUtil.removeCaractere(linhas[linha], '\"').split(delimitador) : linhas[linha].split(delimitador);
                        if (cols.length + 1 != qtdeColunas) {
                            ImportacaoTabelaPreco.this.textErros.append("Erro na linha : " + Integer.toString(linha + 1) + " (Colunas diferentes)\n");
                            continue;
                        }
                        lin[0] = Integer.toString(linha + 1);
                        for (int i = 1; i < qtdeColunas; ++i) {
                            lin[i] = cols[i - 1];
                        }
                        ImportacaoTabelaPreco.this.modeloExames.addLine(lin);
                        continue;
                    }
                    catch (Exception e) {
                        ImportacaoTabelaPreco.this.textErros.append(" 1 - Erro na linha : " + Integer.toString(linha) + "(" + e.getMessage() + ")\n");
                    }
                }
                ImportacaoTabelaPreco.this.repaint();
            }
        }.start();
    }

    private void carregarTabelas() {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select tpe_codigo, tpe_descricao from tabelaprecoexames where fil_codigo = ");
            sql.append(Variaveis.filialPadrao);
            sql.append(" order by tpe_descricao");
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            this.tabelas.clear();
            while (rs.next()) {
                TabelaPreco tab = new TabelaPreco();
                tab.codigo = rs.getInt("tpe_codigo");
                tab.descricao = rs.getString("tpe_descricao");
                this.tabelas.add(tab);
                this.comboTabelas.addItem(tab);
            }
            st.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoTabelaPreco: 370");
        }
    }

    private void importarTabela() {
        this.st = Conexao.getStatement();
        this.textErros.setText("");
        new Thread(){

            @Override
            public void run() {
                int colAMB = Integer.parseInt(ImportacaoTabelaPreco.this.textColunaAMB.getText());
                int colValor = Integer.parseInt(ImportacaoTabelaPreco.this.textColunaValor.getText());
                int colExame = Integer.parseInt(ImportacaoTabelaPreco.this.textColunaExame.getText());
                int colMaterial = Integer.parseInt(ImportacaoTabelaPreco.this.textColunaMaterial.getText());
                if (colAMB < 4 || colValor < 4 || colAMB == colValor) {
                    Funcoes.mensagem(null, "As colunas AMB e Valor est\u00e3o fora do escopo permitido!", 1);
                    return;
                }
                StringBuilder sql = new StringBuilder();
                TabelaPreco tab = (TabelaPreco)ImportacaoTabelaPreco.this.comboTabelas.getSelectedItem();
                for (int linha = 0; linha < ImportacaoTabelaPreco.this.modeloExames.getRowCount(); ++linha) {
                    String amb = ImportacaoTabelaPreco.this.modeloExames.getValueAt(linha, colAMB).toString();
                    String valor = ImportacaoTabelaPreco.this.modeloExames.getValueAt(linha, colValor).toString().replace(',', '.');
                    String exame = ImportacaoTabelaPreco.this.modeloExames.getValueAt(linha, colExame).toString().trim();
                    String material = ImportacaoTabelaPreco.this.modeloExames.getValueAt(linha, colMaterial).toString();
                    valor = Funcoes.textoVazio(valor) || !Funcoes.isNumeric(valor) ? "null" : Funcoes.limpaDecimal(valor);
                    sql.setLength(0);
                    sql.append("update detalhetabelapreco set dtp_valor = ").append(valor).append(",");
                    sql.append(" dtp_codamb = '").append(amb).append("', ");
                    sql.append(" dtp_proibido = false");
                    sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                    sql.append(" and tpe_codigo = ").append(tab.codigo);
                    sql.append(" and exa_codigo = '").append(exame).append("'");
                    sql.append(" and mco_codigo = ").append(material);
                    try {
                        if (Conexao.executeUpdate(Variaveis.filialPadrao, ImportacaoTabelaPreco.this.st, sql.toString()) > 0) {
                            ImportacaoTabelaPreco.this.textStatus.append("Exa: " + exame + " /Mat: " + material + "  --> Importado com sucesso\n");
                        } else {
                            ImportacaoTabelaPreco.this.textStatus.append("Exa: " + exame + " /Mat: " + material + "  --> Exame/Material N\u00e3o localizado\n");
                        }
                        Conexao.arquivaSQL();
                        continue;
                    }
                    catch (SQLException e) {
                        try {
                            ImportacaoTabelaPreco.this.textErros.append("Exa: " + exame + " /Mat: " + material + "  --> Erro ao importar (" + e.getMessage() + ")\n");
                            Conexao.anulaSQL();
                            continue;
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                Funcoes.mensagem(null, "Importa\u00e7\u00e3o concluida!", 5);
                ImportacaoTabelaPreco.this.renderer.setCorColuna(Color.YELLOW, colAMB);
                ImportacaoTabelaPreco.this.renderer.setCorColuna(Color.YELLOW, colValor);
                ImportacaoTabelaPreco.this.repaint();
            }
        }.start();
    }
}

