/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.laboratorio.DisposeListener;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class FiliaisPermitidas
extends JDialog
implements DisposeListener,
ActionListener {
    private JPanel panel = new JPanel(null);
    private TTextField textCodFilial = new TTextField(5, 1);
    private TTextField textDescFilial = new TTextField();
    private JButton botaoFilial = ComponenteFactory.novoJButton(this, null, null, true);
    private JButton botaoOK = ComponenteFactory.novoJButton("OK", '\u0000', this);
    private JLabel labelFilial = new JLabel("Filial");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Filial"});
    private JTable tabelaFilial = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabelaFilial);
    private JButton botaoSalvar = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton botaoFechar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private boolean ok = false;

    public static FiliaisPermitidas novaInstancia(Component owner) {
        if (owner instanceof Frame) {
            return new FiliaisPermitidas((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new FiliaisPermitidas((Dialog)owner);
        }
        return null;
    }

    public FiliaisPermitidas(Frame owner) {
        super(owner, "Filiais permitidas");
        this.montaTela(owner);
    }

    public FiliaisPermitidas(Dialog owner) {
        super(owner, "Filiais permitidas");
        this.montaTela(owner);
    }

    private void montaTela(Component owner) {
        this.setLayout(new BorderLayout());
        this.textDescFilial.setEditable(false);
        this.textDescFilial.setFocusable(false);
        this.modelo.setColumnSize(new int[]{70, 0}, this.tabelaFilial);
        this.labelFilial.setBounds(new Rectangle(5, 4, 70, 15));
        this.textCodFilial.setBounds(new Rectangle(5, 19, 48, 20));
        this.botaoFilial.setBounds(new Rectangle(54, 19, 20, 20));
        this.textDescFilial.setBounds(new Rectangle(76, 19, 300, 20));
        this.botaoOK.setBounds(new Rectangle(378, 19, 40, 20));
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoFilial.setFocusable(false);
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.botaoSalvar.setBounds(263, 261, 75, 25);
        this.botaoFechar.setBounds(341, 261, 75, 25);
        this.panel.add(this.labelFilial);
        this.panel.add(this.textCodFilial);
        this.panel.add(this.botaoFilial);
        this.panel.add(this.textDescFilial);
        this.panel.add(this.botaoOK);
        this.panel.add(this.scroll);
        this.panel.add(this.botaoSalvar);
        this.panel.add(this.botaoFechar);
        this.add((Component)this.panel, "Center");
        this.setSize(438, 328);
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.setModal(true);
        this.setResizable(false);
        Funcoes.montaEnter((JComponent)this.panel);
        this.textCodFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    FiliaisPermitidas.this.buscaFilial();
                }
            }
        });
        this.tabelaFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Funcoes.mensagem(FiliaisPermitidas.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    FiliaisPermitidas.this.modelo.removeLine(FiliaisPermitidas.this.tabelaFilial.getSelectedRow());
                }
            }
        });
        this.textCodFilial.addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(FiliaisPermitidas.this.textCodFilial.getText())) {
                    Statement st;
                    block6: {
                        st = Conexao.getStatement();
                        try {
                            if (st == null) break block6;
                            ResultSet rs = Conexao.executeQuery(st, "select fil_descricao from filiais_postocoleta where fil_codigo = " + FiliaisPermitidas.this.textCodFilial.getText());
                            if (rs.next()) {
                                FiliaisPermitidas.this.textDescFilial.setText(rs.getString("fil_descricao"));
                                break block6;
                            }
                            FiliaisPermitidas.this.textDescFilial.setText("N\u00e3o cadastrado");
                        }
                        catch (Exception ex) {
                            try {
                                ErrorLogger.mostraMensagem(FiliaisPermitidas.this, ex.getMessage(), ex.getStackTrace(), "FiliaisPermitidas (990)");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                    }
                    Conexao.fecharStatement(st);
                }
            }
        });
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(this, false);
        if (resultado != null) {
            this.textCodFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textCodFilial);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoFechar || e.getSource() == this.botaoSalvar) {
            this.ok = e.getSource() == this.botaoSalvar;
            this.setVisible(false);
        } else if (e.getSource() == this.botaoOK) {
            this.adicionar();
        } else if (e.getSource() == this.botaoFilial) {
            this.buscaFilial();
        }
    }

    private void adicionar() {
        if (!this.textDescFilial.getText().equals("N\u00e3o cadastrado") && !Funcoes.textoVazio(this.textCodFilial.getText()) && this.modelo.localizar(0, this.textCodFilial.getText()) < 0) {
            this.modelo.addLine(new String[]{this.textCodFilial.getText(), this.textDescFilial.getText()});
        }
        this.textCodFilial.clear();
        this.textDescFilial.clear();
        ScreenUtil.requisitarFoco(this.textCodFilial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiliais(ArrayList<Integer> filiais) {
        if (filiais != null && filiais.size() > 0) {
            Statement st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder("select fil_codigo,fil_descricao from filiais_postocoleta where fil_codigo in (");
                this.modelo.clear();
                for (int i = 0; i < filiais.size(); ++i) {
                    buf.append(filiais.get(i));
                    if (i >= filiais.size() - 1) continue;
                    buf.append(",");
                }
                buf.append(") order by fil_codigo");
                ResultSet rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    this.modelo.addLine(new String[]{rs.getString("fil_codigo"), rs.getString("fil_descricao")});
                }
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FiliaisPermitidas (1141)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    public boolean isOK() {
        return this.ok;
    }

    public ArrayList<Integer> getFiliais() {
        ArrayList<Integer> retorno = new ArrayList<Integer>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!Funcoes.isNumeric(this.modelo.getValueAt(i, 0).toString())) continue;
            retorno.add(Integer.parseInt(this.modelo.getValueAt(i, 0).toString()));
        }
        return retorno;
    }
}

