/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.configuracao.DialogoAlteraEstacao;
import jalis.servidor.Mensagem;
import jalis.servidor.SocketEstacao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.HashList;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Estacoes
extends FrmPadrao
implements ActionListener,
ListSelectionListener,
TableCellRenderer {
    private static final String IP = "numeroIP";
    private static final String USR = "loginUsuario";
    private static final String CON = "conectado";
    private static final String VERSAO_JALIS = "versaojalis";
    private static final String VERSAO_JAVA = "versaojava";
    private static final String SQL_UPDATE = "update estacoes set est_descricao = ''{1}'', est_web = {2}, est_expfiliais = {3}, est_integrar = {4}, est_pathintegracao = ''{5}'', est_tempointegrar = {6}, fil_codigo = {7}, est_xmlhospital = ''{8}'', est_integracaohospital = {9} , est_sms = {10}, est_exportaemail = {11}, est_tamanhomensagemweb = {12}, est_tamanhointegracao = {13}, est_aplicativo = {14} where est_codigo = {0}";
    private final JLabel label = new JLabel();
    private JLabel labelDetalhe = new JLabel("");
    private JCheckBox checkConectados = ComponenteFactory.novoJCheckBox("Exibir somente as esta\u00e7\u00f5es conectadas", '\u0000', this);
    private JButton buttonRestaurar = ComponenteFactory.novoJButton("Restaurar backup", 'b', this, null, null, false);
    private JButton buttonDesligar = ComponenteFactory.novoJButton("Desligar", 'D', this, null, null, false);
    private JButton buttonAlterar = ComponenteFactory.novoJButton("Alterar", 'A', this, null, null, false);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_EXPORTA_WEB = 2;
    private static final int COLUNA_EXPORTA_FILIAL = 3;
    private static final int COLUNA_INTEGRAR = 4;
    private static final int COLUNA_INTEGRAR_HOSPITAL = 5;
    private static final int COLUNA_EXPORTA_SMS = 6;
    private static final int COLUNA_EXPORTA_EMAIL = 7;
    private static final int COLUNA_IP = 8;
    private static final int COLUNA_USUARIO = 9;
    private static final int COLUNA_VERSAO_JALIS = 10;
    private static final int COLUNA_VERSAO_JAVA = 11;
    private static final int COLUNA_CONECTADO = 12;
    private Modelo modelo = new Modelo("C\u00f3digo", "est_codigo", "Descri\u00e7\u00e3o", "est_descricao", "Web", "est_web", "Filial", "est_expfiliais", "Integrar", "est_integrar", "Hosp.", "est_integracaohospital", "SMS", "est_sms", "Email", "est_exportaemail", "IP", "numeroIP", "Usu\u00e1rio", "loginUsuario", "Jalis ", "versaojalis", "Java", "versaojava", "Con", "conectado");
    private JTable tabela = new JTable(this.modelo);
    private boolean acessoRestaurar = Acesso.getAcesso(500400003L);
    private boolean acessoDesligar = Acesso.getAcesso(500400002L);
    private boolean acessoAlterar = Acesso.getAcesso(500400001L);
    private Timer timer = new Timer(5000, this);
    private final ImageIcon imgOn = ImagemUtils.carregaImagemJalis("online.gif");
    private boolean ordenandoTabela = false;

    public Estacoes() {
        this.setName("Estacoes");
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Esta\u00e7\u00f5es", "Esta\u00e7\u00f5es cadastradas/logadas no sistema", "configuracoes/config_estacoes.jpg");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "Center");
        panel.setBorder(ScreenUtil.criarBordaVazia());
        this.tabela.setName("tabela");
        this.tabela.setDefaultRenderer(String.class, this);
        this.tabela.setDefaultRenderer(Boolean.class, this);
        this.tabela.getSelectionModel().addListSelectionListener(this);
        this.tabela.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>((TableModel)this.modelo){

            @Override
            public Comparator<?> getComparator(int column) {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 != null && o2 != null) {
                            if (Funcoes.isNumeric(o1.toString()) && Funcoes.isNumeric(o2.toString())) {
                                return new Integer(o1.toString()).compareTo(new Integer(o2.toString()));
                            }
                            return o1.toString().compareTo(o2.toString());
                        }
                        return -1;
                    }
                };
            }
        };
        this.tabela.setRowSorter((RowSorter<? extends TableModel>)sorter);
        this.tabela.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                Estacoes.this.ordenandoTabela = !Estacoes.this.ordenandoTabela;
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Estacoes.this.alterarEstacaoSelecionada();
                }
            }
        });
        JPanel panelDetalhe = new JPanel(new BorderLayout());
        panelDetalhe.setName("panelDetalhe");
        panelDetalhe.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        panelDetalhe.setPreferredSize(new Dimension(20, 20));
        panelDetalhe.setMaximumSize(new Dimension(20, 20));
        panelDetalhe.add((Component)this.labelDetalhe, "Center");
        panel.add((Component)new JScrollPane(this.ajustarColunas(this.tabela)), "Center");
        JPanel jPanel = panel;
        panel = new JPanel(new BorderLayout());
        jPanel.add((Component)panel, "South");
        panel.add((Component)panelDetalhe, "Center");
        JPanel jPanel2 = panel;
        panel = new JPanel(new BorderLayout());
        jPanel2.add((Component)panel, "South");
        panel.add((Component)this.checkConectados, "West");
        JPanel jPanel3 = panel;
        panel = new JPanel(new FlowLayout(2, 3, 3));
        jPanel3.add((Component)panel, "East");
        this.buttonRestaurar.setName("buttonRestaurar");
        panel.add(this.buttonRestaurar);
        this.buttonDesligar.setName("buttonDesligar");
        panel.add(this.buttonDesligar);
        this.buttonAlterar.setName("buttonAlterar");
        panel.add(this.buttonAlterar);
        this.buttonFechar.setName("buttonFechar");
        panel.add(this.buttonFechar);
        this.checkConectados.setName("checkConectados");
        this.checkConectados.setSelected(true);
        this.labelDetalhe.setName("labelDetalhe");
        this.labelDetalhe.setFont(new Font(this.labelDetalhe.getFont().getName(), 0, this.labelDetalhe.getFont().getSize()));
        this.label.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    public static long getModuloAcesso() {
        return 500400000L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.timer) {
            this.carregarEstacoes();
        } else if (o == this.buttonFechar) {
            this.setVisible(false);
        } else if (o == this.buttonDesligar) {
            int[] linhas = this.tabela.getSelectedRows();
            String msn = "Deseja desligar " + (linhas.length == 1 ? "a esta\u00e7\u00e3o selecionada?" : "as esta\u00e7\u00f5es selecionadas?");
            if (Funcoes.mensagem(this, msn, 4) == 0) {
                this.desligarEstacoesSelecionadas(linhas);
                this.atualizarDetalhe();
            }
        } else if (o == this.buttonAlterar) {
            this.alterarEstacaoSelecionada();
        } else if (o == this.checkConectados) {
            this.modelo.filtrarConectados(this.checkConectados.isSelected());
            this.atualizarDetalhe();
        } else if (o == this.buttonRestaurar) {
            this.restaurarConfiguracoesBackup();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] linhas = this.tabela.getSelectedRows();
        this.buttonAlterar.setEnabled(this.acessoAlterar && linhas.length == 1);
        this.buttonDesligar.setEnabled(this.acessoDesligar && this.contemEstacaoConectada(linhas));
        this.buttonRestaurar.setEnabled(this.acessoRestaurar);
    }

    private boolean contemEstacaoConectada(int[] linhas) {
        for (int linha : linhas) {
            Registro reg = this.modelo.getRegistro(this.tabela.getRowSorter().convertRowIndexToModel(linha));
            if (!reg.getBoolean(CON)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.label.setFont(table.getFont());
        this.label.setIcon(null);
        this.label.setHorizontalAlignment(column == 1 ? 2 : 0);
        this.label.setText("");
        this.label.setOpaque(isSelected);
        if (isSelected) {
            this.label.setBackground(table.getSelectionBackground());
        }
        if (column == 2 || column == 3 || column == 4 || column == 5 || column == 6 || column == 12 || column == 7) {
            boolean bol;
            boolean bl = bol = value != null ? (Boolean)value : false;
            if (column == 2 || column == 3 || column == 4 || column == 5 || column == 6 || column == 7) {
                this.label.setText(bol ? "Sim" : "N\u00e3o");
            } else if (bol) {
                this.label.setIcon(this.imgOn);
            }
        } else {
            this.label.setText(value == null ? "" : value.toString());
        }
        return this.label;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.timer.stop();
        }
    }

    private void carregarEstacoes() {
        if (this.ordenandoTabela) {
            return;
        }
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(this.tabela.getRowSorter().getSortKeys());
                HashMap<String, List<String>> conectadas = new HashMap<String, List<String>>();
                SocketEstacao socket = new SocketEstacao(Variaveis.ipBanco, 5000L);
                Mensagem msn = new Mensagem("servidor", "estacoes");
                socket.escreverMensagem(msn);
                msn = socket.lerMensagem();
                if (msn != null && msn.mesmoID("servidor") && msn.mesmaAcao("estacoes")) {
                    for (String est : msn.getItens()) {
                        conectadas.put(est, msn.getList(est));
                    }
                }
                List<String> sels = this.getEstacoesSelecionadas();
                ArrayList<Registro> temp = new ArrayList<Registro>();
                ResultSet res = Conexao.executeQuery(st, "select est_codigo, est_descricao, est_web, est_expfiliais, est_integrar, est_pathintegracao, est_backup, est_tempointegrar, fil_codigo, est_xmlhospital, est_integracaohospital , est_sms, est_exportaemail, est_aplicativo, est_tamanhomensagemweb, est_tamanhointegracao, est_tamanhointegracao from estacoes order by est_codigo");
                while (res.next()) {
                    Registro reg = new Registro();
                    reg.setValor("est_codigo", res.getString("est_codigo"));
                    reg.setValor("est_descricao", res.getString("est_descricao"));
                    reg.setValor("est_web", res.getBoolean("est_web") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_integrar", res.getBoolean("est_integrar") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_expfiliais", res.getBoolean("est_expfiliais") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_backup", !DBUtil.campoNull(res.getString("est_backup")) ? res.getString("est_backup") : "");
                    reg.setValor("est_pathintegracao", !DBUtil.campoNull(res.getString("est_pathintegracao")) ? res.getString("est_pathintegracao") : "1800000");
                    reg.setValor("est_tempointegrar", !DBUtil.campoNull(res.getString("est_tempointegrar")) ? res.getString("est_tempointegrar") : "50000");
                    reg.setValor("fil_codigo", !DBUtil.campoNull(res.getString("fil_codigo")) ? res.getString("fil_codigo") : "-1");
                    reg.setValor("est_xmlhospital", res.getString("est_xmlhospital"));
                    reg.setValor("est_integracaohospital", res.getBoolean("est_integracaohospital") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_sms", res.getBoolean("est_sms") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_exportaemail", res.getBoolean("est_exportaemail") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_aplicativo", res.getBoolean("est_aplicativo") ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor("est_tamanhomensagemweb", !DBUtil.campoNull(res.getString("est_tamanhomensagemweb")) && !Funcoes.textoVazio(res.getString("est_tamanhomensagemweb")) ? res.getString("est_tamanhomensagemweb") : Integer.valueOf(Variaveis.tamanhoMensagemWeb));
                    reg.setValor("est_tamanhointegracao", !DBUtil.campoNull(res.getString("est_tamanhointegracao")) ? res.getString("est_tamanhointegracao") : "512");
                    List list = (List)conectadas.get(reg.getString("est_codigo"));
                    reg.setValor(CON, list != null ? Boolean.TRUE : Boolean.FALSE);
                    reg.setValor(USR, list != null ? list.get(0) : "");
                    reg.setValor(IP, list != null ? this.formatarIP((String)list.get(1)) : "");
                    reg.setValor(VERSAO_JALIS, list != null && list.size() > 2 && list.get(2) != null ? list.get(2) : "");
                    reg.setValor(VERSAO_JAVA, list != null && list.size() > 3 && list.get(3) != null ? list.get(3) : "");
                    temp.add(reg);
                }
                this.modelo.limpar(false);
                this.modelo.addRegistros(temp);
                this.modelo.filtrarConectados(this.checkConectados.isSelected());
                this.setEstacoesSelecionadas(sels);
                while (sortKeys != null && sortKeys.size() > 1) {
                    try {
                        sortKeys.remove(1);
                    }
                    catch (UnsupportedOperationException u) {
                        if (sortKeys.size() <= 0) continue;
                        RowSorter.SortKey chave = (RowSorter.SortKey)sortKeys.get(sortKeys.size() - 1);
                        sortKeys.clear();
                        if (chave == null) continue;
                        sortKeys.add(chave);
                    }
                    catch (Exception exception) {}
                }
                if (sortKeys != null && sortKeys.size() > 0 && sortKeys.size() == 1) {
                    this.tabela.getRowSorter().setSortKeys(sortKeys);
                }
                this.atualizarDetalhe();
            }
            catch (Exception e) {
                this.timer.stop();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void atualizarDetalhe() {
        jalis.servidor.Estacoes est = jalis.servidor.Estacoes.decodificar(ParametrosGerais.getEstacoes());
        StringBuilder buf = new StringBuilder("<html><font size=2>");
        buf.append("Total de esta\u00e7\u00f5es selecionadas: <b>").append(this.modelo.getTotalLinhasFiltradas()).append("</b>");
        buf.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        buf.append("Total de esta\u00e7\u00f5es cadastradas: <b>").append(this.modelo.getTotalLinhas()).append("</b>");
        buf.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        buf.append("Total de esta\u00e7\u00f5es simult&acirc;neas: <b>").append(est.getQuantidadeEstacoes()).append("</b>");
        buf.append("</font></html>");
        this.labelDetalhe.setText(buf.toString());
    }

    private String formatarIP(String ip) {
        int i;
        for (i = 0; i < ip.length() && !Character.isDigit(ip.charAt(i)); ++i) {
        }
        String str = i == ip.length() ? "" : ip.substring(i);
        return str.trim().substring(0, str.indexOf(":") == -1 ? str.length() : str.indexOf(":"));
    }

    private List<String> getEstacoesSelecionadas() {
        HashList<String> estacoes = new HashList<String>();
        for (int linha : this.tabela.getSelectedRows()) {
            Registro reg = this.modelo.getRegistro(this.tabela.getRowSorter().convertRowIndexToModel(linha));
            estacoes.add(reg.getString("est_codigo"));
        }
        return estacoes;
    }

    private void setEstacoesSelecionadas(List<String> estacoes) {
        for (int i = 0; i < this.tabela.getRowCount(); ++i) {
            Registro reg = this.modelo.getRegistro(i);
            if (reg == null || !estacoes.contains(reg.getString("est_codigo"))) continue;
            this.tabela.getSelectionModel().addSelectionInterval(this.tabela.getRowSorter().convertRowIndexToView(i), this.tabela.getRowSorter().convertRowIndexToView(i));
        }
    }

    private void alterarEstacaoSelecionada() {
        DialogoAlteraEstacao dae;
        Statement st = Conexao.getStatement();
        Registro reg = this.modelo.getRegistro(this.tabela.getRowSorter().convertRowIndexToModel(this.tabela.getSelectedRow()));
        if (st != null && reg != null && (dae = DialogoAlteraEstacao.novaInstancia(this.getTopLevelAncestor(), reg)) != null) {
            dae.setVisible(true);
            if (dae.salvar()) {
                try {
                    boolean alterarEstacoes = false;
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update estacoes set ");
                    if (dae.isExportarParaFiliais()) {
                        buf.append(" est_expfiliais = false ");
                        alterarEstacoes = true;
                    }
                    if (dae.isExportarParaWeb()) {
                        buf.append(alterarEstacoes ? "," : "").append(" est_web = false ");
                        alterarEstacoes = true;
                    }
                    if (dae.isExportarIntegracao()) {
                        buf.append(alterarEstacoes ? "," : "").append(" est_integrar = false ");
                        alterarEstacoes = true;
                    }
                    if (dae.isServidorIntegracaoHospital()) {
                        buf.append(alterarEstacoes ? "," : "").append(" est_xmlhospital = null ");
                        alterarEstacoes = true;
                    }
                    if (dae.isExportarSms()) {
                        buf.append(alterarEstacoes ? "," : "").append(" est_sms = false ");
                        alterarEstacoes = true;
                    }
                    if (dae.isExportarEmail()) {
                        buf.append(alterarEstacoes ? "," : "").append(" est_exportaemail = false ");
                        alterarEstacoes = true;
                    }
                    if (dae.isExportarAplicativo()) {
                        buf.append(alterarEstacoes ? "," : "").append(" est_aplicativo = false ");
                        alterarEstacoes = true;
                    }
                    if (alterarEstacoes) {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
                    }
                    Conexao.executeUpdate(Variaveis.filialPadrao, st, MessageFormat.format(SQL_UPDATE, dae.getDados()), true);
                    Conexao.arquivaSQL();
                    this.carregarEstacoes();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            }
        }
    }

    private void desligarEstacoesSelecionadas(int[] linhas) {
        try {
            SocketEstacao socket = new SocketEstacao(Variaveis.ipBanco, 5000L);
            Mensagem m = new Mensagem("conexao", "fechar");
            for (int linha : linhas) {
                Registro reg = this.modelo.getRegistro(this.tabela.getRowSorter().convertRowIndexToModel(linha));
                if (!reg.getBoolean(CON)) continue;
                m.setString("codigoestacao", reg.getString("est_codigo"));
                m.setString("origem", "administrador");
                socket.escreverMensagem(m);
                socket.lerMensagem();
            }
            this.carregarEstacoes();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void restaurarConfiguracoesBackup() {
        Registro reg = this.modelo.getRegistro(this.tabela.getRowSorter().convertRowIndexToModel(this.tabela.getSelectedRow()));
        if (reg != null) {
            String xml = reg.getString("est_backup");
            if (Funcoes.textoVazio(xml)) {
                Funcoes.mensagem(this, "A esta\u00e7\u00e3o n\u00e3o possui backup de configura\u00e7\u00f5es", 1);
                return;
            }
            if (Funcoes.mensagem(this, "A configura\u00e7\u00e3o ser\u00e1 restaurada para a m\u00e1quina atual.\nConfirma a restaura\u00e7\u00e3o das configura\u00e7\u00f5es?", 4) == 0) {
                ParametrosLocais.setXML(xml);
                Funcoes.mensagem(this, "Configura\u00e7\u00f5es restauradas com sucesso!\nReinicie a esta\u00e7\u00e3o para que as configura\u00e7\u00f5es entrem em vigor", 2);
            }
        }
    }

    private JTable ajustarColunas(JTable table) {
        TableColumnModel cols = table.getColumnModel();
        cols.getColumn(0).setMaxWidth(45);
        cols.getColumn(0).setMinWidth(45);
        cols.getColumn(1).setMinWidth(0);
        cols.getColumn(2).setMaxWidth(35);
        cols.getColumn(2).setMinWidth(35);
        cols.getColumn(7).setMinWidth(35);
        cols.getColumn(7).setMaxWidth(35);
        cols.getColumn(3).setMaxWidth(35);
        cols.getColumn(3).setMinWidth(35);
        cols.getColumn(4).setMaxWidth(50);
        cols.getColumn(4).setMinWidth(50);
        cols.getColumn(5).setMaxWidth(35);
        cols.getColumn(5).setMinWidth(35);
        cols.getColumn(6).setMaxWidth(30);
        cols.getColumn(6).setMinWidth(30);
        cols.getColumn(8).setMinWidth(115);
        cols.getColumn(8).setMaxWidth(115);
        cols.getColumn(9).setMinWidth(0);
        cols.getColumn(12).setMaxWidth(25);
        cols.getColumn(12).setMinWidth(25);
        cols.getColumn(10).setMaxWidth(65);
        cols.getColumn(10).setMinWidth(65);
        cols.getColumn(11).setMaxWidth(65);
        cols.getColumn(11).setMinWidth(65);
        return table;
    }

    private class Modelo
    extends ModeloResultSet {
        private ArrayList<Registro> filtrados;

        public Modelo(String ... colunas) {
            super(colunas);
            this.filtrados = new ArrayList();
        }

        @Override
        public void limpar(boolean atualizar) {
            this.filtrados.clear();
            super.limpar(atualizar);
        }

        @Override
        public void addRegistro(Registro reg) {
            this.filtrados.add(reg);
            super.addRegistro(reg);
        }

        @Override
        public void addRegistros(Collection<Registro> regs) {
            this.filtrados.addAll(regs);
            super.addRegistros(regs);
        }

        @Override
        public Registro getRegistro(int indice) {
            if (indice >= 0 && indice < this.filtrados.size()) {
                return this.filtrados.get(indice);
            }
            return null;
        }

        @Override
        public List<Registro> getRegistros(int[] indices) {
            ArrayList<Registro> regs = new ArrayList<Registro>();
            for (int i : indices) {
                Registro reg = this.getRegistro(i);
                if (reg == null) continue;
                regs.add(reg);
            }
            return regs;
        }

        @Override
        public int getRowCount() {
            return this.filtrados.size();
        }

        public void filtrarConectados(boolean filtrar) {
            this.filtrados.clear();
            if (!filtrar) {
                this.filtrados.addAll(this.regs);
            } else {
                for (Registro reg : this.regs) {
                    if (!reg.getBoolean(Estacoes.CON)) continue;
                    this.filtrados.add(reg);
                }
            }
            this.fireTableDataChanged();
        }

        public int getTotalLinhasFiltradas() {
            return this.filtrados.size();
        }

        public int getTotalLinhas() {
            return this.regs.size();
        }
    }
}

