/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.laboratorio.configuracao.Estacao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

class DialogoImprimirDireto
extends JDialog
implements ActionListener {
    private JTextPane textComando = new JTextPane();
    private JComboBox<String> comboImpressora = new JComboBox<String>(Funcoes.getNomeImpressorasLocais(Estacao.TAMANHO_IMPRESSORA, false));
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", this);
    private JButton buttonPadroes = ComponenteFactory.novoJButton("Padr\u00f5es \u25bc", this);

    public DialogoImprimirDireto(JFrame pai) {
        super((Frame)pai, "Imprimir direto");
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(new Dimension(400, 300));
        this.setLocationRelativeTo(this.getParent());
        JPanel panelCentro = new JPanel(new BorderLayout());
        panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.setContentPane(panelCentro);
        JPanel panelCombo = ComponenteFactory.novoJPanelBorderLayout(this.comboImpressora, null, null, null, new JLabel("Impressora:"));
        panelCombo.setMinimumSize(new Dimension(80, 20));
        panelCentro.add((Component)panelCombo, "North");
        panelCentro.add((Component)new JScrollPane(this.textComando), "Center");
        panelCentro.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImprimir, this.buttonFechar), this.buttonPadroes), "South");
        this.buttonImprimir.setEnabled(this.comboImpressora.getItemCount() > 0);
        ScreenUtil.requisitarFoco(this.textComando);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.buttonImprimir) {
            this.imprimir();
        } else if (e.getSource() == this.buttonPadroes) {
            JMenuItem item1 = new JMenuItem("Reset");
            JMenuItem item2 = new JMenuItem("Default");
            JMenuItem item3 = new JMenuItem("Config");
            JPopupMenu popup = new JPopupMenu();
            popup.add(ComponenteFactory.novoJMenuItem("Reset", e1 -> this.textComando.setText("^@")));
            popup.add(ComponenteFactory.novoJMenuItem("Default", e1 -> this.textComando.setText("^default")));
            popup.add(ComponenteFactory.novoJMenuItem("Config", e1 -> this.textComando.setText("S4\nD10\nR184,0\nq464\nQ220,45")));
            popup.add(ComponenteFactory.novoJMenuItem("Calibrar", e1 -> this.textComando.setText("xa\n")));
            popup.show(this.buttonPadroes.getParent(), this.buttonPadroes.getX(), this.buttonPadroes.getY() + this.buttonPadroes.getHeight());
        }
    }

    private void imprimir() {
        if (this.validarExpressao()) {
            PrintService service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(this.comboImpressora.getSelectedItem().toString()));
            if (service == null) {
                ErrorLogger.mostraMensagem(null, "A impressora " + this.comboImpressora.getSelectedItem().toString() + " n\u00e3o foi localizada", null);
            }
            try {
                String comando = this.textComando.getText();
                if (comando.toUpperCase().equals("XA") && !comando.endsWith("\n")) {
                    comando = comando + "\n";
                }
                SimpleDoc doc = new SimpleDoc(comando.getBytes(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                if (service != null) {
                    service.createPrintJob().print(doc, null);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImpressaoMapa: 110");
            }
        }
    }

    private boolean validarExpressao() {
        if (Funcoes.textoVazio(this.textComando.getText())) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 comando para imprimir", 1);
            return false;
        }
        return true;
    }
}

