/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.sistemas.IntegracaoHospital;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configuracao.ObjetoFilial;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DialogoAlteraEstacao
extends JDialog
implements ActionListener {
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JCheckBox checkWeb = new JCheckBox("Exportar resultados para web");
    private JCheckBox checkFiliais = new JCheckBox("Exportar requisi\u00e7\u00f5es entre filiais");
    private JCheckBox checkIntegrar = new JCheckBox("Exportar dados de integra\u00e7\u00e3o");
    private TTextField textTimeoutIntegracao = new TTextField(7, 1);
    private TTextField textTempoIntegracao = new TTextField(7, 1);
    private TTextField textTamanhoMsgExportar = new TTextField(5, 1);
    private JLabel lblTamMsgExp = new JLabel("Tamanho m\u00e1ximo da mensagem:");
    private JComboBox comboIntegracao = new JComboBox();
    private JCheckBox checkIntegracaoHospital = new JCheckBox("Integrar sistema hospitalar");
    private JButton buttonConfigurarIntegracaoHospital = ComponenteFactory.novoJButton("Configurar", this);
    private JTextField textDescricao = new JTextField();
    private JLabel lblTamMaxArquivo = new JLabel("Tam. m\u00e1x:");
    private JLabel lblKb = new JLabel(" ");
    private TTextField textTamMaxArquivo = new TTextField(7, 1);
    private Registro reg;
    private boolean salvar;

    public static DialogoAlteraEstacao novaInstancia(Object pai, Registro reg) {
        if (pai instanceof Frame) {
            return new DialogoAlteraEstacao((Frame)pai, reg);
        }
        if (pai instanceof Dialog) {
            return new DialogoAlteraEstacao((Dialog)pai, reg);
        }
        return null;
    }

    public DialogoAlteraEstacao(Frame pai, Registro reg) {
        super(pai, "Alterando esta\u00e7\u00e3o", true);
        this.reg = reg;
        this.iniciar();
    }

    public DialogoAlteraEstacao(Dialog pai, Registro reg) {
        super(pai, "Alterando esta\u00e7\u00e3o", true);
        this.reg = reg;
        this.iniciar();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IntegracaoHospital integracao;
        Object o = e.getSource();
        if (o == this.checkIntegrar) {
            this.textTimeoutIntegracao.setEnabled(this.checkIntegrar.isSelected());
            this.textTempoIntegracao.setEnabled(this.checkIntegrar.isSelected());
            this.comboIntegracao.setEnabled(this.checkIntegrar.isSelected());
            this.textTamMaxArquivo.setEnabled(this.checkIntegrar.isSelected());
        } else if (o == this.buttonSalvar || o == this.buttonCancelar) {
            if (o == this.buttonSalvar && this.validar()) {
                this.salvar = true;
                this.reg.setValor("est_descricao", this.textDescricao.getText());
                this.reg.setValor("est_web", this.checkWeb.isSelected() ? Boolean.TRUE : Boolean.FALSE);
                this.reg.setValor("est_expfiliais", this.checkFiliais.isSelected() ? Boolean.TRUE : Boolean.FALSE);
                this.reg.setValor("est_integrar", this.checkIntegrar.isSelected() ? Boolean.TRUE : Boolean.FALSE);
                this.reg.setValor("est_pathintegracao", !Funcoes.textoVazio(this.textTimeoutIntegracao.getText()) ? this.textTimeoutIntegracao.getText() : Integer.valueOf(-1));
                this.reg.setValor("est_tempointegrar", !Funcoes.textoVazio(this.textTempoIntegracao.getText()) ? this.textTempoIntegracao.getText() : Integer.valueOf(-1));
                this.reg.setValor("fil_codigo", ((ObjetoFilial)this.comboIntegracao.getSelectedItem()).getCodigo());
                this.reg.setValor("est_integracaohospital", this.checkIntegracaoHospital.isSelected() ? Boolean.TRUE : Boolean.FALSE);
                this.reg.setValor("est_tamanhomensagemweb", !Funcoes.textoVazio(this.textTamanhoMsgExportar.getText()) ? this.textTamanhoMsgExportar.getText() : Integer.valueOf(Variaveis.tamanhoMensagemWeb));
                this.reg.setValor("est_tamanhointegracao", !Funcoes.textoVazio(this.textTamMaxArquivo.getText()) ? this.textTamMaxArquivo.getText() : Integer.valueOf(-1));
                this.dispose();
            } else if (o == this.buttonCancelar) {
                this.dispose();
            }
        } else if (o == this.checkIntegracaoHospital) {
            boolean enabled = this.checkIntegracaoHospital.isSelected() && ParametrosGerais.getProtocoloIntegracaoHospital() != ProtocoloIntegracaoHospital.NENHUM;
            this.buttonConfigurarIntegracaoHospital.setEnabled(enabled);
        } else if (o == this.buttonConfigurarIntegracaoHospital && (integracao = FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), null)) != null) {
            integracao.configurar(Laboratorio.getInstancia(), this.reg.getString("est_xmlhospital"), true);
            this.reg.setValor("est_xmlhospital", integracao.getXML());
        }
    }

    private boolean validar() {
        int tam;
        if (this.checkIntegrar.isSelected() && (Funcoes.textoVazio(this.textTamMaxArquivo.getText()) || Integer.valueOf(this.textTamMaxArquivo.getText()) < 0 || Integer.valueOf(this.textTamMaxArquivo.getText()) > 300)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O tamanho m\u00e1ximo deve ser maior ou igual a 1 e menor ou igual \u00e0 300", 1);
            ScreenUtil.requisitarFoco(this.textTamMaxArquivo);
            return false;
        }
        if (!Funcoes.textoVazio(this.textTamanhoMsgExportar) && this.checkWeb.isSelected() && ((tam = Integer.parseInt(this.textTamanhoMsgExportar.getText())) < 100 || tam > 10240)) {
            Funcoes.mensagem(this, "O tamanho da mensagem deve ser maior ou igual a 100 KB e menor ou igual a 10240 KB", 1);
            ScreenUtil.requisitarFoco(this.textTamanhoMsgExportar);
            return false;
        }
        return true;
    }

    public Object[] getDados() {
        String tamanhoLogWeb = Funcoes.textoVazio(this.reg.getString("est_tamanhomensagemweb")) ? String.valueOf(Variaveis.tamanhoMensagemWeb) : this.reg.getString("est_tamanhomensagemweb");
        return new Object[]{this.reg.getString("est_codigo"), this.reg.getString("est_descricao"), this.reg.getString("est_web"), this.reg.getString("est_expfiliais"), this.reg.getString("est_integrar"), StringUtil.textoDB(Funcoes.retiraStringRepetida(this.reg.getString("est_pathintegracao"))), this.reg.getString("est_tempointegrar"), this.reg.getString("fil_codigo"), this.reg.getString("est_xmlhospital"), this.reg.getBoolean("est_integracaohospital"), this.reg.getString("est_sms"), this.reg.getString("est_exportaemail"), tamanhoLogWeb, this.reg.getString("est_tamanhointegracao"), this.reg.getString("est_aplicativo")};
    }

    public boolean isExportarParaWeb() {
        return this.reg.getBoolean("est_web");
    }

    public boolean isExportarSms() {
        return this.reg.getBoolean("est_sms");
    }

    public boolean isExportarEmail() {
        return this.reg.getBoolean("est_exportaemail");
    }

    public boolean isExportarParaFiliais() {
        return this.reg.getBoolean("est_expfiliais");
    }

    public boolean isExportarAplicativo() {
        return this.reg.getBoolean("est_aplicativo");
    }

    public boolean isExportarIntegracao() {
        return this.reg.getBoolean("est_integrar");
    }

    public boolean isServidorIntegracaoHospital() {
        return this.reg.getString("est_xmlhospital") != null && !Funcoes.textoVazio(this.reg.getString("est_xmlhospital"));
    }

    public boolean salvar() {
        return this.salvar;
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(2, 3, 5));
        this.getContentPane().add((Component)panel, "South");
        panel.add(this.buttonSalvar);
        panel.add(this.buttonCancelar);
        panel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panel, "Center");
        panel.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.weightx = 0.0;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        panel.add((Component)new JLabel("C\u00f3digo"), cons);
        cons.gridx = 1;
        cons.weightx = 0.5;
        panel.add((Component)new JLabel("Descri\u00e7\u00e3o"), cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.weightx = 0.0;
        JTextField text = new JTextField(this.reg.getString("est_codigo"));
        text.setHorizontalAlignment(4);
        text.setEnabled(false);
        panel.add((Component)text, cons);
        this.textDescricao.setBorder(BorderFactory.createTitledBorder(""));
        this.textDescricao.setText(this.reg.getString("est_descricao"));
        cons.gridx = 1;
        cons.weightx = 0.5;
        panel.add((Component)this.textDescricao, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridwidth = 2;
        this.checkWeb.setSelected(this.reg.getBoolean("est_web"));
        panel.add((Component)this.checkWeb, cons);
        JPanel pnlTamMsg = new JPanel();
        pnlTamMsg.add(this.lblTamMsgExp);
        this.textTamanhoMsgExportar.setPreferredSize(new Dimension(60, 20));
        pnlTamMsg.add(this.textTamanhoMsgExportar);
        cons.insets = new Insets(1, 20, 1, 1);
        ++cons.gridy;
        cons.gridwidth = 2;
        cons.fill = 0;
        cons.anchor = 17;
        panel.add((Component)pnlTamMsg, cons);
        ++cons.gridy;
        cons.fill = 1;
        ++cons.gridy;
        cons.insets = new Insets(1, 1, 1, 1);
        this.checkFiliais.setSelected(this.reg.getBoolean("est_expfiliais"));
        panel.add((Component)this.checkFiliais, cons);
        ++cons.gridy;
        this.checkIntegrar.setSelected(this.reg.getBoolean("est_integrar"));
        panel.add((Component)this.checkIntegrar, cons);
        ++cons.gridy;
        JPanel panelTemp = new JPanel(new FlowLayout(0, 0, 1));
        this.textTimeoutIntegracao.setPreferredSize(new Dimension(70, 20));
        this.textTempoIntegracao.setPreferredSize(new Dimension(70, 20));
        this.comboIntegracao.setPreferredSize(new Dimension(220, 20));
        panelTemp.add(new JLabel("Timeout:"));
        panelTemp.add(this.textTimeoutIntegracao);
        panelTemp.add(new JLabel(" segundos"));
        panel.add((Component)panelTemp, cons);
        ++cons.gridy;
        panelTemp = new JPanel(new FlowLayout(0, 0, 1));
        this.textTamMaxArquivo.setPreferredSize(new Dimension(70, 20));
        panelTemp.add(new JLabel("Tempo:"));
        panelTemp.add(this.textTempoIntegracao);
        panelTemp.add(new JLabel(" segundos"));
        JPanel panelAux = new JPanel();
        panelAux.setPreferredSize(new Dimension(25, 20));
        panelTemp.add(panelAux);
        panelTemp.add(this.lblTamMaxArquivo);
        panelTemp.add(this.textTamMaxArquivo);
        panelTemp.add(this.lblKb);
        panel.add((Component)panelTemp, cons);
        cons.gridx = 0;
        ++cons.gridy;
        panelTemp = new JPanel(new FlowLayout(0, 0, 1));
        panelTemp.add(new JLabel("Filial:"));
        panelTemp.add(this.comboIntegracao);
        panel.add((Component)panelTemp, cons);
        ++cons.gridy;
        panelTemp = new JPanel(new FlowLayout(0, 0, 1));
        this.checkIntegracaoHospital.addActionListener(this);
        this.checkIntegracaoHospital.setSelected(this.reg.getBoolean("est_integracaohospital"));
        this.checkIntegracaoHospital.setEnabled(ParametrosGerais.getProtocoloIntegracaoHospital() != ProtocoloIntegracaoHospital.NENHUM);
        this.buttonConfigurarIntegracaoHospital.setEnabled(this.checkIntegracaoHospital.isSelected() && ParametrosGerais.getProtocoloIntegracaoHospital() != ProtocoloIntegracaoHospital.NENHUM);
        panelTemp.add(this.checkIntegracaoHospital);
        panelTemp.add(this.buttonConfigurarIntegracaoHospital);
        panel.add((Component)panelTemp, cons);
        this.preencheFiliais(this.reg.getString("fil_codigo"));
        this.checkIntegrar.setSelected(this.reg.getBoolean("est_integrar"));
        this.textTimeoutIntegracao.setText(this.reg.getString("est_pathintegracao"));
        this.textTempoIntegracao.setText(this.reg.getString("est_tempointegrar"));
        this.textTamMaxArquivo.setText(this.reg.getString("est_tamanhointegracao"));
        this.textTamanhoMsgExportar.setEnabled(this.checkWeb.isSelected());
        this.textTamanhoMsgExportar.setText(this.reg.getString("est_tamanhomensagemweb"));
        this.textTimeoutIntegracao.setEnabled(this.checkIntegrar.isSelected());
        this.textTempoIntegracao.setEnabled(this.checkIntegrar.isSelected());
        this.comboIntegracao.setEnabled(this.checkIntegrar.isSelected());
        this.textTamMaxArquivo.setEnabled(this.checkIntegrar.isSelected());
        this.checkIntegrar.addActionListener(this);
        this.checkIntegracaoHospital.addActionListener(this);
        this.checkWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoAlteraEstacao.this.textTamanhoMsgExportar.setEnabled(DialogoAlteraEstacao.this.checkWeb.isSelected());
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogoAlteraEstacao.this.dispose();
            }
        });
        this.pack();
        this.setSize(new Dimension(370, 335));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheFiliais(String filialSelecionada) {
        Statement st = Conexao.getStatement();
        int selecao = -1;
        try {
            StringBuilder buf = new StringBuilder("select fil_codigo, fil_descricao from filiais_postocoleta order by fil_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.comboIntegracao.removeAllItems();
            while (rs.next()) {
                this.comboIntegracao.addItem(new ObjetoFilial(rs.getString("fil_codigo"), rs.getString("fil_descricao")));
                if (!Funcoes.isNumeric(filialSelecionada) || Integer.parseInt(filialSelecionada) != rs.getInt("fil_codigo")) continue;
                selecao = this.comboIntegracao.getItemCount() - 1;
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Estacoes (603)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        if (selecao > -1) {
            this.comboIntegracao.setSelectedIndex(selecao);
        }
    }
}

