/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Conexao;
import jalis.comum.padroes.FrmPadrao;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ConsultaErroParada
extends FrmPadrao {
    private CardLayout card = new CardLayout();
    private JPanel panelMudanca = new JPanel(this.card);
    private JPanel panelGeral = new JPanel(new GridBagLayout());
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panelEsquerdo = new JPanel(this.grid);
    private JPanel panelDireito = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JLabel labelDataFim = new JLabel("Data final:");
    private JLabel labelDataInicio = new JLabel("Data inicial:");
    private TTextField txtDataInicio = new TTextField(10, 4);
    private TTextField txtDataFim = new TTextField(10, 4);
    private JButton buttonDataInicio = new JButton();
    private JButton buttonDataFim = new JButton();
    private CheckItemFiltro itemUsuario = new CheckItemFiltro("Usu\u00e1rios", "Filtrar", "Filtrando usu\u00e1rios", "");

    public ConsultaErroParada() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConsultaErroParada");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(210, 100));
        Funcoes.criaBarraDescricao(this, "Visualizar log de erros", "Consulta motivos dos erros ocorridos no sistema", "configuracoes/log_erros.jpg");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonFechar);
        this.itemUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{100, 0});
        this.itemUsuario.setColunaHint(1);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('C');
        Funcoes.imagemPesquisa(this.buttonDataInicio);
        Funcoes.imagemPesquisa(this.buttonDataFim);
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataFim.setFocusable(false);
        this.montaFiltros();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaErroParada.this.setVisible(false);
            }
        });
        this.buttonDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaErroParada.this.txtDataInicio, ConsultaErroParada.this.buttonDataInicio, ConsultaErroParada.this.panelGeral, true);
            }
        });
        this.buttonDataFim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaErroParada.this.txtDataFim, ConsultaErroParada.this.buttonDataFim, ConsultaErroParada.this.panelGeral, true);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaErroParada.this.pesquisaErroParada();
            }
        });
    }

    private void pesquisaErroParada() {
        if (!Funcoes.verificaData(this.txtDataInicio.getText()) || !Funcoes.verificaData(this.txtDataFim.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida para consulta", 1);
            this.txtDataInicio.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireito.removeAll();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Statement st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, ConsultaErroParada.this.getSelect());
                    if (rs.next() && rs.first()) {
                        ModeloResultSet modelo = ConsultaErroParada.this.preencheModelo(rs, new String[]{"Data", "data", "Usu\u00e1rio", "usuario", "Motivo", "motivo"});
                        JTable table = new JTable(modelo);
                        table.setAutoCreateRowSorter(true);
                        table.setAutoResizeMode(0);
                        modelo.setTamanhoColunas(table, 125, 70, 260);
                        JScrollPane scroll = new JScrollPane(table);
                        scroll.setPreferredSize(new Dimension(100, 100));
                        ConsultaErroParada.this.panelDireito.add((Component)scroll, "Center");
                    } else {
                        Funcoes.mensagem(ConsultaErroParada.this, "N\u00e3o existe erro para o filtro pesquisado", 2);
                    }
                    ConsultaErroParada.this.panelDireito.revalidate();
                    ConsultaErroParada.this.panelDireito.repaint();
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(ConsultaErroParada.this, e.getMessage(), e.getStackTrace(), "ConsultaErroParada");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        ConsultaErroParada.this.buttonConsultar.setEnabled(true);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    ConsultaErroParada.this.buttonConsultar.setEnabled(true);
                }
                Conexao.fecharStatement(st);
                ConsultaErroParada.this.buttonConsultar.setEnabled(true);
            }
        });
    }

    private ModeloResultSet preencheModelo(ResultSet rs, String[] colunas) {
        ModeloResultSet modelo = new ModeloResultSet(rs, colunas){

            @Override
            public Object getValueAt(int row, int col) {
                Registro reg = this.getRegistro(row);
                if (reg != null && col * 2 + 1 < this.cols.length) {
                    if (reg.getValor(this.cols[col * 2 + 1]) instanceof String && (reg.getValor(this.cols[col * 2 + 1]).toString().indexOf(10) > -1 || reg.getValor(this.cols[col * 2 + 1]).toString().indexOf(13) > -1 || reg.getValor(this.cols[col * 2 + 1]).toString().indexOf(9) > -1)) {
                        return StringUtil.limpaString(reg.getValor(this.cols[col * 2 + 1]).toString(), new String[]{"\n", "\r", "\t"});
                    }
                    if (this.cols[col * 2 + 1].equalsIgnoreCase("Data") && reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                        return Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.stringToDate("yyyy/MM/dd HH:mm:ss.S", reg.getValor(this.cols[col * 2 + 1]).toString()));
                    }
                    return reg.getValor(this.cols[col * 2 + 1]);
                }
                return null;
            }
        };
        return modelo;
    }

    private String getSelect() {
        String[] usuarios;
        StringBuilder buf = new StringBuilder();
        buf.append("select a.err_data as Data,  ");
        buf.append("       err_usuario as Usuario, ");
        buf.append("       err_motivo as Motivo ");
        buf.append("from erroParada a ");
        buf.append(" where ");
        if (Funcoes.verificaData(this.txtDataInicio.getText())) {
            buf.append(" cast(a.err_data as date) >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.txtDataInicio.getText()));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.txtDataFim.getText())) {
            buf.append(" and cast(a.err_data as date) <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.txtDataFim.getText()));
            buf.append("'");
        }
        if ((usuarios = this.itemUsuario.getSelecionados()) != null && usuarios.length > 0) {
            buf.append(" and a.err_usuario in (");
            for (int i = 0; i < usuarios.length; ++i) {
                buf.append("'");
                buf.append(usuarios[i]);
                buf.append("'");
                if (i >= usuarios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    private void montaFiltros() {
        this.montaPanelGeral();
        this.panelMudanca.add((Component)this.panelGeral, "geral");
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        this.constraints.anchor = 18;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelEsquerdo.add((Component)this.panelMudanca, this.constraints);
    }

    public void montaPanelGeral() {
        Dimension dim = new Dimension(70, 20);
        GridBagConstraints c = new GridBagConstraints();
        this.itemUsuario.setPreferredSize(dim);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 18;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panelGeral.add((Component)this.itemUsuario, c);
        c.gridy = 1;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panelGeral.add((Component)this.labelDataInicio, c);
        c.gridy = 2;
        this.panelGeral.add((Component)this.labelDataFim, c);
        c.gridx = 2;
        c.gridy = 1;
        this.buttonDataInicio.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicio.setMinimumSize(new Dimension(20, 20));
        this.panelGeral.add((Component)this.buttonDataInicio, c);
        c.gridy = 2;
        this.buttonDataFim.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFim.setMinimumSize(new Dimension(20, 20));
        this.panelGeral.add((Component)this.buttonDataFim, c);
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.txtDataInicio.setPreferredSize(new Dimension(90, 20));
        this.txtDataInicio.setMinimumSize(new Dimension(90, 20));
        this.panelGeral.add((Component)this.txtDataInicio, c);
        c.gridy = 2;
        this.txtDataFim.setPreferredSize(new Dimension(90, 20));
        this.txtDataFim.setMinimumSize(new Dimension(90, 20));
        this.panelGeral.add((Component)this.txtDataFim, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 3;
        c.weightx = 0.0;
        this.buttonConsultar.setPreferredSize(new Dimension(100, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(100, 20));
        this.panelGeral.add((Component)this.buttonConsultar, c);
        ++c.gridy;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelGeral.add((Component)new JPanel(), c);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0501100000");
    }
}

