/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.configuracao.TelaAjuda;
import jalis.laboratorio.util.SMSUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ConfigurarPortaModem
extends AbstractDialogoOKCancelar {
    private JPanel panelPorta = ComponenteFactory.novoJPanel(new GridBagLayout(), ComponenteFactory.novoTitledEtchedBorder("Op\u00e7\u00f5es Porta"));
    private JLabel labelVelocidade = new JLabel("Velocidade:");
    private JComboBox comboVelocidade = new JComboBox();
    private JLabel labelDataBits = new JLabel("Bits de dados:");
    private JComboBox comboDataBits = new JComboBox();
    private JLabel labelStopBits = new JLabel("Bits de parada:");
    private JComboBox comboStopBits = new JComboBox();
    private JLabel labelParidade = new JLabel("Paridade:");
    private JComboBox comboParidade = new JComboBox();
    private JLabel labelFluxo = new JLabel("Fluxo:");
    private JComboBox comboFluxo = new JComboBox();
    private JLabel labelDelay = new JLabel("Tempo entre cada envio (min.):");
    private JTextField txtDelaySms = ComponenteFactory.novoTTextField(3, 1);
    private JLabel labelLog = new JLabel("Gravar log porta:");
    private JCheckBox checkLog = ComponenteFactory.novoJCheckBox("", null);
    private String xmlConfiguracao = "";
    private Map<String, Integer> configuracao = new HashMap<String, Integer>();
    private Map<Integer, String> configuracaoParity = new HashMap<Integer, String>();
    private JButton buttonAjuda = new JButton("Ajuda");

    public ConfigurarPortaModem(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfigurarPortaModem(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(370, 270));
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Configurar");
        this.setLocationRelativeTo(this.getParent());
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.panelPorta.removeAll();
        this.panelPorta.setSize(new Dimension(330, 350));
        this.getPanelCentral().add(this.panelPorta);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 1;
        c.fill = 1;
        c.weightx = 1.0;
        this.panelPorta.add((Component)this.labelVelocidade, c);
        ++c.gridx;
        this.comboVelocidade.setPreferredSize(new Dimension(120, 20));
        this.comboVelocidade.setMinimumSize(new Dimension(120, 20));
        this.panelPorta.add((Component)this.comboVelocidade, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPorta.add((Component)this.labelDataBits, c);
        ++c.gridx;
        this.comboDataBits.setPreferredSize(new Dimension(100, 20));
        this.comboDataBits.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboDataBits, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPorta.add((Component)this.labelStopBits, c);
        ++c.gridx;
        this.comboStopBits.setPreferredSize(new Dimension(100, 20));
        this.comboStopBits.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboStopBits, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPorta.add((Component)this.labelParidade, c);
        ++c.gridx;
        this.comboParidade.setPreferredSize(new Dimension(100, 20));
        this.comboParidade.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboParidade, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPorta.add((Component)this.labelFluxo, c);
        ++c.gridx;
        this.comboFluxo.setPreferredSize(new Dimension(100, 20));
        this.comboFluxo.setMinimumSize(new Dimension(100, 20));
        this.panelPorta.add((Component)this.comboFluxo, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPorta.add((Component)this.labelDelay, c);
        ++c.gridx;
        this.txtDelaySms.setPreferredSize(new Dimension(80, 20));
        this.txtDelaySms.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.txtDelaySms, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelPorta.add((Component)this.labelLog, c);
        ++c.gridx;
        this.checkLog.setPreferredSize(new Dimension(80, 20));
        this.checkLog.setMinimumSize(new Dimension(80, 20));
        this.panelPorta.add((Component)this.checkLog, c);
        this.buttonAjuda.setDisplayedMnemonicIndex(0);
        this.buttonAjuda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaAjuda telaAjuda = new TelaAjuda(Laboratorio.getInstancia());
                telaAjuda.setText(SMSUtil.ajudaInterfaceModemSms());
                telaAjuda.setVisible(true);
            }
        });
        this.getPanelBotoesEsquerda().add(this.buttonAjuda);
        this.carregaConfiguracoes();
    }

    public String getXmlConfiguracao() {
        StringBuilder xmlConf = new StringBuilder(this.xmlConfiguracao);
        StringUtil.setValor(xmlConf, "velocidade", ((CodString)this.comboVelocidade.getSelectedItem()).getCodigo().toString());
        StringUtil.setValor(xmlConf, "dataBits", ((CodString)this.comboDataBits.getSelectedItem()).toString());
        StringUtil.setValor(xmlConf, "stopBits", ((CodString)this.comboStopBits.getSelectedItem()).toString());
        StringUtil.setValor(xmlConf, "paridade", ((CodString)this.comboParidade.getSelectedItem()).getCodigo().toString());
        StringUtil.setValor(xmlConf, "fluxo", ((CodString)this.comboFluxo.getSelectedItem()).toString());
        StringUtil.setValor(xmlConf, "log", String.valueOf(this.checkLog.isSelected()));
        StringUtil.setValor(xmlConf, "delayEnvioSms", String.valueOf(this.txtDelaySms.getText()));
        return xmlConf.toString();
    }

    public void setXmlConfiguracao(String xmlConfiguracao) {
        if (!Funcoes.textoVazio(xmlConfiguracao) && !Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracao, "fluxo"))) {
            this.xmlConfiguracao = xmlConfiguracao;
            int velocidade = Integer.parseInt(StringUtil.getValor(xmlConfiguracao, "velocidade")) - 1;
            String dataBits = StringUtil.getValor(xmlConfiguracao, "dataBits");
            String stopBits = StringUtil.getValor(xmlConfiguracao, "stopBits");
            String paridade = StringUtil.getValor(xmlConfiguracao, "paridade");
            String fluxo = StringUtil.getValor(xmlConfiguracao, "fluxo");
            String delayEnvioSms = StringUtil.getValor(xmlConfiguracao, "delayEnvioSms");
            String log = StringUtil.getValor(xmlConfiguracao, "log");
            this.comboVelocidade.setSelectedItem(this.comboVelocidade.getItemAt(velocidade < 0 ? 0 : velocidade));
            this.comboDataBits.setSelectedItem(new CodString(Integer.parseInt(dataBits), dataBits));
            this.comboStopBits.setSelectedItem(new CodString(this.configuracao.get(stopBits), stopBits));
            this.comboParidade.setSelectedItem(new CodString(Integer.parseInt(paridade), this.configuracaoParity.get(Integer.parseInt(paridade))));
            this.comboFluxo.setSelectedItem(new CodString(this.configuracao.get(fluxo), fluxo));
            this.txtDelaySms.setText(delayEnvioSms);
            this.checkLog.setSelected(Boolean.parseBoolean(log));
        } else {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("modemSms");
            xml.escrever("velocidade", "");
            xml.escrever("dataBits", "");
            xml.escrever("stopBits", "");
            xml.escrever("paridade", "");
            xml.escrever("fluxo", "");
            xml.escrever("log", "");
            xml.escrever("delayEnvioSms", "20");
            try {
                xml.fechar("modemSms");
                this.xmlConfiguracao = xml.getXML();
            }
            catch (XMLStringBuilderException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ConfigurarPortaModem (2034)");
            }
        }
    }

    private void carregaConfiguracoes() {
        this.comboVelocidade.addItem(new CodString(1, "1200"));
        this.comboVelocidade.addItem(new CodString(2, "2400"));
        this.comboVelocidade.addItem(new CodString(3, "4800"));
        this.comboVelocidade.addItem(new CodString(4, "9600"));
        this.comboVelocidade.addItem(new CodString(5, "19200"));
        this.comboVelocidade.addItem(new CodString(6, "115200"));
        this.comboVelocidade.setSelectedIndex(3);
        this.comboDataBits.addItem(new CodString(5, "5"));
        this.comboDataBits.addItem(new CodString(6, "6"));
        this.comboDataBits.addItem(new CodString(7, "7"));
        this.comboDataBits.addItem(new CodString(8, "8"));
        this.comboDataBits.setSelectedIndex(3);
        this.comboStopBits.addItem(new CodString(1, "1"));
        this.comboStopBits.addItem(new CodString(3, "1.5"));
        this.comboStopBits.addItem(new CodString(2, "2"));
        this.comboStopBits.setSelectedIndex(0);
        this.comboParidade.addItem(new CodString(0, "Nenhuma"));
        this.comboParidade.addItem(new CodString(1, "\u00cdmpar"));
        this.comboParidade.addItem(new CodString(2, "Par"));
        this.comboParidade.setSelectedIndex(0);
        this.comboFluxo.addItem(new CodString(0, "Nenhum"));
        this.comboFluxo.addItem(new CodString(3, "Hardware"));
        this.comboFluxo.addItem(new CodString(12, "Software"));
        this.comboFluxo.setSelectedIndex(0);
        this.configuracao.put("5", 5);
        this.configuracao.put("6", 6);
        this.configuracao.put("7", 7);
        this.configuracao.put("8", 8);
        this.configuracao.put("1", 1);
        this.configuracao.put("1.5", 3);
        this.configuracao.put("2", 2);
        this.configuracaoParity.put(0, "Nenhuma");
        this.configuracaoParity.put(1, "\u00cdmpar");
        this.configuracaoParity.put(2, "Par");
        this.configuracao.put("Nenhum", 0);
        this.configuracao.put("Hardware", 3);
        this.configuracao.put("Software", 12);
    }

    @Override
    protected boolean acaoOk() {
        boolean ok = this.validaCampos();
        return ok;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtDelaySms)) {
            Funcoes.mensagem(this, "Campo de intervalo n\u00e3o preenchido", 2);
            return false;
        }
        int tempo = Integer.parseInt(this.txtDelaySms.getText());
        return true;
    }
}

