/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ConfigurarApiSms
extends AbstractDialogoOKCancelar {
    private JPanel panelConfigApi = this.getPanelCentral();
    private JLabel labelChave = new JLabel("Chave: ");
    private TTextField txtChave = new TTextField();
    private String xmlConfiguracao = "";

    public ConfigurarApiSms(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfigurarApiSms(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(350, 100));
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Configura\u00e7\u00e3o API SMS");
        this.setLocationRelativeTo(this.getParent());
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.panelConfigApi.removeAll();
        this.panelConfigApi.setMinimumSize(new Dimension(350, 150));
        this.panelConfigApi.setSize(new Dimension(350, 150));
        GridBagConstraints c = new GridBagConstraints();
        ++c.gridy;
        c.gridx = 0;
        this.panelConfigApi.add((Component)this.labelChave, c);
        ++c.gridx;
        this.txtChave.setPreferredSize(new Dimension(280, 20));
        this.txtChave.setMinimumSize(new Dimension(280, 20));
        this.panelConfigApi.add((Component)this.txtChave, c);
    }

    @Override
    protected boolean acaoOk() {
        boolean ok = this.validaCampos();
        return ok;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtChave)) {
            Funcoes.mensagem(this, "Campo Chave n\u00e3o preenchido", 2);
            return false;
        }
        return true;
    }

    public String getXmlConfiguracao() {
        StringBuilder xmlConf = new StringBuilder(this.xmlConfiguracao);
        StringUtil.setValor(xmlConf, "keyEnvioSms", this.txtChave.getText());
        return xmlConf.toString();
    }

    public void setXmlConfiguracao(String xmlConfiguracao) {
        if (!Funcoes.textoVazio(xmlConfiguracao)) {
            this.xmlConfiguracao = xmlConfiguracao;
            String chaveEnvioSms = StringUtil.getValor(xmlConfiguracao, "keyEnvioSms");
            this.txtChave.setText(chaveEnvioSms);
        } else {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("apiSms");
            String chaveEnvioSms = StringUtil.getValor(xmlConfiguracao, "keyEnvioSms");
            xml.escrever("keyEnvioSms", chaveEnvioSms);
            try {
                xml.fechar("apiSms");
                this.xmlConfiguracao = xml.getXML();
            }
            catch (XMLStringBuilderException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ConfigurarApiSms (2604)");
            }
        }
    }
}

