/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class ConfiguraIndicacoesPaciente
extends JDialog
implements ActionListener {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_EXCLUIDO = 2;
    JLabel labelIndicacao = new JLabel("Indica\u00e7\u00e3o:");
    TTextField textIndicacao = new TTextField(80, 3);
    JButton buttonOK = ComponenteFactory.novoJButton("Ok", 'O', this);
    ModeloGridTable modeloIndicacao = new ModeloGridTable(new String[]{"C\u00f3digo", "Indica\u00e7\u00e3o"});
    JTable tableIndicacao = new JTable(this.modeloIndicacao);
    JScrollPane scrollIndicacao = new JScrollPane(this.tableIndicacao);
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    ArrayList<String[]> indicacoes = new ArrayList();
    ArrayList<String[]> indicacoesExcluidas = new ArrayList();
    int editando = -1;
    boolean janelaCancelada = true;

    public ConfiguraIndicacoesPaciente(ArrayList<String[]> indicacoes) {
        this.setSize(350, 400);
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.modeloIndicacao.setColumnSize(new int[]{50, 0}, this.tableIndicacao);
        this.setTitle("Indica\u00e7\u00f5es de pacientes");
        this.labelIndicacao.setDisplayedMnemonic('I');
        this.labelIndicacao.setLabelFor(this.textIndicacao);
        this.tableIndicacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfiguraIndicacoesPaciente.this.tableIndicacao.getSelectedRow();
                if (row >= 0 && e.getKeyCode() == 127 && Funcoes.mensagem(null, "Confirma exclus\u00e3o da indica\u00e7\u00e3o", 4) == 0) {
                    ConfiguraIndicacoesPaciente.this.modeloIndicacao.removeLine(row);
                    ConfiguraIndicacoesPaciente.this.getIndicacoes().get((int)row)[2] = Boolean.toString(Boolean.TRUE);
                    ConfiguraIndicacoesPaciente.this.indicacoesExcluidas.add((String[])ConfiguraIndicacoesPaciente.this.getIndicacoes().get(row).clone());
                    ConfiguraIndicacoesPaciente.this.getIndicacoes().remove(row);
                    ConfiguraIndicacoesPaciente.this.textIndicacao.clear();
                    ConfiguraIndicacoesPaciente.this.editando = -1;
                } else if (row >= 0 && e.getKeyCode() == 32) {
                    ConfiguraIndicacoesPaciente.this.textIndicacao.setText(ConfiguraIndicacoesPaciente.this.modeloIndicacao.getValueAt(row, 1).toString());
                    ConfiguraIndicacoesPaciente.this.editando = row;
                }
            }
        });
        this.tableIndicacao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ConfiguraIndicacoesPaciente.this.editando = ConfiguraIndicacoesPaciente.this.tableIndicacao.getSelectedRow();
                    ConfiguraIndicacoesPaciente.this.textIndicacao.setText(ConfiguraIndicacoesPaciente.this.modeloIndicacao.getValueAt(ConfiguraIndicacoesPaciente.this.editando, 1).toString());
                }
            }
        });
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        Container panel = this.getContentPane();
        Funcoes.montaEnter((JComponent)panel);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)this.labelIndicacao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.textIndicacao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        panel.add(this.buttonOK);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)this.scrollIndicacao, c);
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)this.panelBotoes, c);
        this.carregaIndicacoes(indicacoes);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            if (Funcoes.textoVazio(this.textIndicacao.getText())) {
                Funcoes.mensagem(this, "Indica\u00e7\u00e3o deve ser preenchida", 2);
                return;
            }
            int row = this.modeloIndicacao.localizar(1, this.textIndicacao.getText());
            if (row > -1 && this.editando == -1) {
                Funcoes.mensagem(this, "Indica\u00e7\u00e3o j\u00e1 cadastrada.", 2);
                this.textIndicacao.selectAll();
                this.textIndicacao.grabFocus();
                return;
            }
            if (this.editando == -1) {
                this.modeloIndicacao.addLine(new Object[]{"", this.textIndicacao.getText(), ""});
                this.getIndicacoes().add(new String[]{"", this.textIndicacao.getText(), ""});
            } else {
                this.modeloIndicacao.setValueAt(this.textIndicacao.getText(), this.editando, 1);
                this.getIndicacoes().get((int)this.editando)[1] = this.textIndicacao.getText();
            }
            this.textIndicacao.clear();
            this.textIndicacao.grabFocus();
            this.editando = -1;
        } else if (e.getSource() == this.buttonCancelar) {
            this.janelaCancelada = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonSalvar) {
            int i;
            this.indicacoes = new ArrayList();
            for (i = 0; i < this.modeloIndicacao.getRowCount(); ++i) {
                this.indicacoes.add(new String[]{this.modeloIndicacao.getValueAt(i, 0).toString(), this.modeloIndicacao.getValueAt(i, 1).toString(), this.modeloIndicacao.getValueAt(i, 2).toString()});
            }
            for (i = 0; i < this.indicacoesExcluidas.size(); ++i) {
                if (Funcoes.textoVazio(this.indicacoesExcluidas.get(i)[0])) continue;
                this.indicacoes.add((String[])this.indicacoesExcluidas.get(i).clone());
            }
            this.janelaCancelada = false;
            this.setVisible(false);
        }
    }

    private void carregaIndicacoes(ArrayList<String[]> indicacoes) {
        if (indicacoes != null) {
            for (int i = 0; i < indicacoes.size(); ++i) {
                if (indicacoes.get(i)[2].equals(Boolean.toString(Boolean.TRUE))) {
                    this.indicacoesExcluidas.add((String[])indicacoes.get(i).clone());
                    continue;
                }
                this.getIndicacoes().add((String[])indicacoes.get(i).clone());
                this.modeloIndicacao.addLine(new Object[]{indicacoes.get(i)[0], indicacoes.get(i)[1], indicacoes.get(i)[2]});
            }
        }
    }

    public boolean getSalvar() {
        return !this.janelaCancelada;
    }

    public ArrayList<String[]> getIndicacoes() {
        return this.indicacoes;
    }
}

