/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.Tipos;
import jalis.laboratorio.util.BandeirasCartoes;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class ConfiguraBandeirasCartoes
extends JDialog
implements ActionListener {
    private final int COLUNA_BANDEIRA = 0;
    private final int COLUNA_TIPO = 1;
    private final int COLUNA_PRAZO = 2;
    JLabel labelBandeira = new JLabel("Bandeira:");
    JLabel labelTipo = new JLabel("Tipo:");
    JLabel labelPrazo = new JLabel("Prazo (dias):");
    TTextField textBandeira = new TTextField(16, 3);
    TTextField textPrazo = new TTextField(3, 1);
    JComboBox comboTipo = new JComboBox<Object>(new Object[]{Tipos.getTipoCartao("C"), Tipos.getTipoCartao("D")});
    JButton buttonOK = ComponenteFactory.novoJButton("Ok", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    ModeloGridTable modeloBandeiras = new ModeloGridTable(new String[]{"Bandeiras", "Tipo", "Prazo"});
    JTable tableBandeiras = new JTable(this.modeloBandeiras);
    JScrollPane scrollBandeiras = new JScrollPane(this.tableBandeiras);
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    BandeirasCartoes[] bandeiras = null;
    boolean janelaCancelada = true;

    public ConfiguraBandeirasCartoes(BandeirasCartoes[] bandeiras, JFrame owner) {
        this.bandeiras = bandeiras;
        this.setSize(350, 350);
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.setTitle("Bandeiras de cart\u00f5es");
        this.labelBandeira.setDisplayedMnemonic('B');
        this.labelBandeira.setLabelFor(this.textBandeira);
        this.tableBandeiras.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ConfiguraBandeirasCartoes.this.tableBandeiras.getSelectedRow();
                if (row >= 0) {
                    if (e.getKeyCode() == 127) {
                        ConfiguraBandeirasCartoes.this.modeloBandeiras.removeLine(row);
                    } else if (e.getKeyCode() == 32) {
                        ConfiguraBandeirasCartoes.this.textBandeira.setText((String)ConfiguraBandeirasCartoes.this.modeloBandeiras.getValueAt(row, 0));
                        ConfiguraBandeirasCartoes.this.comboTipo.setSelectedItem(ConfiguraBandeirasCartoes.this.modeloBandeiras.getValueAt(row, 1));
                        ConfiguraBandeirasCartoes.this.textPrazo.setText(ConfiguraBandeirasCartoes.this.modeloBandeiras.getValueAt(row, 2).toString());
                        ScreenUtil.requisitarFoco(ConfiguraBandeirasCartoes.this.textBandeira);
                    }
                }
            }
        });
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        Container panel = this.getContentPane();
        Funcoes.montaEnter((JComponent)panel);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)this.labelBandeira, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.fill = 2;
        panel.add((Component)this.textBandeira, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.labelTipo.setDisplayedMnemonic('T');
        panel.add((Component)this.labelTipo, c);
        ++c.gridx;
        this.comboTipo.setPreferredSize(new Dimension(80, 20));
        this.comboTipo.setMinimumSize(new Dimension(80, 20));
        panel.add((Component)this.comboTipo, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        this.labelPrazo.setDisplayedMnemonic('P');
        panel.add((Component)this.labelPrazo, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        this.textPrazo.setPreferredSize(new Dimension(20, 20));
        this.textPrazo.setMinimumSize(new Dimension(20, 20));
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.textPrazo, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panel.add((Component)this.buttonOK, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)this.scrollBandeiras, c);
        this.modeloBandeiras.setColumnSize(new int[]{0, 70, 80}, this.tableBandeiras);
        this.tableBandeiras.getTableHeader().addMouseListener(this.modeloBandeiras);
        ++c.gridy;
        c.gridwidth = 5;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)this.panelBotoes, c);
        this.carregaBandeiras();
        this.modeloBandeiras.ordenarColuna(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            if (Funcoes.textoVazio(this.textBandeira)) {
                Funcoes.mensagem(this, "A bandeira n\u00e3o foi informada.", 2);
                ScreenUtil.requisitarFoco(this.textBandeira);
                return;
            }
            if (Funcoes.textoVazio(this.textPrazo)) {
                Funcoes.mensagem(this, "O prazo de pagamento n\u00e3o foi informado.", 2);
                ScreenUtil.requisitarFoco(this.textPrazo);
                return;
            }
            String bandeiraNovo = this.textBandeira.getText();
            String tipoNovo = this.comboTipo.getSelectedItem().toString();
            Integer prazoNovo = Integer.parseInt(Funcoes.textoVazio(this.textPrazo.getText()) ? "0" : this.textPrazo.getText());
            if (Funcoes.textoVazio(bandeiraNovo)) {
                return;
            }
            boolean adicionado = false;
            for (int i = 0; i < this.modeloBandeiras.getRowCount(); ++i) {
                String auxBandeira = (String)this.modeloBandeiras.getValueAt(i, 0);
                String auxTipo = (String)this.modeloBandeiras.getValueAt(i, 1);
                if (!auxBandeira.equalsIgnoreCase(bandeiraNovo) || !Funcoes.textoVazio(auxTipo) && !auxTipo.equalsIgnoreCase(tipoNovo)) continue;
                this.modeloBandeiras.setValueAt(tipoNovo, i, 1);
                this.modeloBandeiras.setValueAt(prazoNovo, i, 2);
                adicionado = true;
            }
            if (!adicionado) {
                this.modeloBandeiras.addLine(new Object[]{bandeiraNovo, tipoNovo, prazoNovo});
            }
            this.textBandeira.clear();
            this.textBandeira.grabFocus();
        } else if (e.getSource() == this.buttonCancelar) {
            this.janelaCancelada = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonSalvar) {
            this.bandeiras = new BandeirasCartoes[this.modeloBandeiras.getRowCount()];
            for (int i = 0; i < this.modeloBandeiras.getRowCount(); ++i) {
                this.bandeiras[i] = new BandeirasCartoes((String)this.modeloBandeiras.getValueAt(i, 0), Tipos.tipoCartao((String)this.modeloBandeiras.getValueAt(i, 1)), (Integer)this.modeloBandeiras.getValueAt(i, 2));
            }
            this.janelaCancelada = false;
            this.setVisible(false);
        }
    }

    private void carregaBandeiras() {
        if (this.bandeiras != null) {
            for (int i = 0; i < this.bandeiras.length; ++i) {
                BandeirasCartoes aux = this.bandeiras[i];
                if (aux == null) continue;
                this.modeloBandeiras.addLine(new Object[]{aux.getBandeira(), Tipos.getTipoCartao(aux.getOperacao()), aux.getPrazo()});
            }
        }
    }

    public boolean getSalvar() {
        return !this.janelaCancelada;
    }

    public BandeirasCartoes[] getBandeiras() {
        return this.bandeiras;
    }
}

