/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.configuracao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CertificadoDigital
extends AbstractDialogoOKCancelar {
    private JButton botaoSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    private JButton botaoFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton botaoImportar = ComponenteFactory.novoJButton("Importar", 'I', this);
    private JButton botaoRemover = ComponenteFactory.novoJButton("Remover", 'R', this);
    private JButton botaoValidar = ComponenteFactory.novoJButton("Validar", 'V', this);
    private JLabel labelCertificado = new JLabel("Certificado:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelValidade = new JLabel("Validade:");
    private JCheckBox checkImportado = new JCheckBox("Importado");
    private TTextField textSenhaCertificado = new TTextField(50);
    private TTextField textValidade = new TTextField();
    private String textSenhaCertificadoAux;
    private Date dateValidade = null;
    private Date dateValidadeAux = null;
    private byte[] certificado = null;
    private boolean importado;

    public static CertificadoDigital novaInstancia(Component owner, byte[] certificado, String senha, Date dataValidade, boolean importado) {
        if (owner instanceof Frame) {
            return new CertificadoDigital((Frame)owner, certificado, senha, dataValidade, importado);
        }
        if (owner instanceof Dialog) {
            return new CertificadoDigital((Dialog)owner, certificado, senha, dataValidade, importado);
        }
        return null;
    }

    public static CertificadoDigital novaInstancia(Component owner) {
        if (owner instanceof Frame) {
            return new CertificadoDigital((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new CertificadoDigital((Dialog)owner);
        }
        return null;
    }

    public void limpaCampos() {
        this.setCertificado(null);
        this.setImportado(false);
        this.getTextSenhaCertificado().setText("");
        this.getTextValidade().setText("");
        this.setDateValidade(null);
        this.setTextSenhaCertificadoAux("");
        this.setDateValidadeAux(null);
    }

    public CertificadoDigital(Frame owner, byte[] certificado, String senha, Date dataValidade, boolean importado) {
        super(owner, "Importando certificado digital");
        this.certificado = certificado;
        this.getTextSenhaCertificado().setText(senha);
        this.dateValidade = dataValidade;
        this.importado = importado;
        this.getTextValidade().setText(Funcoes.formataData("dd/MM/yyyy", dataValidade));
        this.montaTela(owner);
    }

    public CertificadoDigital(Dialog owner, byte[] certificado, String senha, Date dataValidade, boolean importado) {
        super(owner, "Importando certificado digital");
        this.certificado = certificado;
        this.getTextSenhaCertificado().setText(senha);
        this.dateValidade = dataValidade;
        this.importado = importado;
        this.montaTela(owner);
    }

    public CertificadoDigital(Frame owner) {
        super(owner, "Importando certificado digital");
        this.montaTela(owner);
    }

    public CertificadoDigital(Dialog owner) {
        super(owner, "Importando certificado digital");
        this.montaTela(owner);
    }

    public void montaTela(Component owner) {
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        this.setUsuarioPodeCancelar(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)this.labelCertificado, c);
        ++c.gridx;
        this.botaoImportar.setMinimumSize(new Dimension(90, 25));
        this.botaoImportar.setPreferredSize(new Dimension(90, 25));
        panel.add((Component)this.botaoImportar, c);
        ++c.gridx;
        this.botaoRemover.setMinimumSize(new Dimension(90, 25));
        this.botaoRemover.setPreferredSize(new Dimension(90, 25));
        panel.add((Component)this.botaoRemover, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.checkImportado.setEnabled(false);
        panel.add((Component)this.checkImportado, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelSenha, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.textSenhaCertificado.setMinimumSize(new Dimension(20, 20));
        this.textSenhaCertificado.setPreferredSize(new Dimension(20, 20));
        panel.add((Component)this.textSenhaCertificado, c);
        c.gridx += 3;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.botaoValidar.setMinimumSize(new Dimension(64, 20));
        this.botaoValidar.setPreferredSize(new Dimension(64, 20));
        c.insets = new Insets(1, 1, 0, 1);
        panel.add((Component)this.botaoValidar, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelValidade, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 2;
        this.textValidade.setMinimumSize(new Dimension(83, 20));
        this.textValidade.setPreferredSize(new Dimension(83, 20));
        this.textValidade.setEnabled(false);
        this.textValidade.setFocusable(false);
        panel.add((Component)this.textValidade, c);
        this.setSize(500, 150);
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)panel);
        this.habilitaBotoes();
    }

    @Override
    protected boolean acaoOk() {
        if (null != this.certificado && Funcoes.textoVazio(this.textValidade.getText())) {
            Funcoes.mensagem(this, "A validade do certificado n\u00e3o foi verificada.", 2);
            ScreenUtil.requisitarFoco(this.botaoValidar);
            return false;
        }
        return true;
    }

    private void habilitaBotoes() {
        if (!this.importado) {
            this.botaoRemover.setEnabled(false);
            this.botaoValidar.setEnabled(false);
            this.textSenhaCertificado.setEnabled(false);
            this.checkImportado.setSelected(false);
        } else {
            this.botaoRemover.setEnabled(true);
            this.botaoValidar.setEnabled(true);
            this.textSenhaCertificado.setEnabled(true);
            this.checkImportado.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean valido = true;
        if (e.getSource() == this.botaoImportar) {
            byte[] cert = this.importaCertificado();
            if (cert != null) {
                this.certificado = cert;
                this.botaoValidar.setEnabled(true);
                this.textSenhaCertificado.setEnabled(true);
                this.checkImportado.setSelected(true);
                this.botaoRemover.setEnabled(true);
                this.importado = this.textSenhaCertificado.toString().length() > 0 && this.textValidade.toString().length() > 0 && this.certificado != null;
            }
        } else if (e.getSource() == this.botaoRemover) {
            this.certificado = null;
            this.importado = false;
            this.botaoValidar.setEnabled(false);
            this.textSenhaCertificado.setText("");
            this.textSenhaCertificado.setEnabled(false);
            this.textValidade.setText("");
            this.checkImportado.setSelected(false);
            this.botaoRemover.setEnabled(false);
            this.dateValidade = null;
            this.textSenhaCertificadoAux = "";
            this.dateValidadeAux = null;
        } else if (e.getSource() == this.botaoValidar || e.getSource() == this.buttonOK) {
            valido = this.validarCertificado();
            if (valido) {
                this.textSenhaCertificadoAux = this.textSenhaCertificado.getText();
                this.dateValidadeAux = this.dateValidade;
            }
        } else if (e.getSource() == this.buttonCancelar) {
            this.setUsuarioPodeCancelar(true);
            this.textSenhaCertificado.setText(this.textSenhaCertificadoAux);
            this.dateValidade = this.dateValidadeAux;
            if (this.dateValidade != null) {
                this.textValidade.setText(Funcoes.formataData("dd/MM/yyyy", this.dateValidade));
            }
        }
        if (!valido) {
            return;
        }
        super.actionPerformed(e);
    }

    private boolean validarCertificado() {
        try {
            if (this.certificado == null) {
                return true;
            }
            if (Funcoes.textoVazio(this.textSenhaCertificado.getText())) {
                ScreenUtil.requisitarFoco(this.textSenhaCertificado);
                throw new Exception("");
            }
            Date dataValidade = ResultadosUtil.validarCertificado(this.certificado, this.textSenhaCertificado.getText());
            if (dataValidade != null) {
                this.dateValidade = dataValidade;
                this.textValidade.setText(Funcoes.formataData("dd/MM/yyyy", dataValidade));
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel validar o certificado.\nVerifique se a senha est\u00e1 correta e se o certificado \u00e9 v\u00e1lido.", 2);
                this.textValidade.setText("");
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel validar o certificado.\nVerifique se a senha est\u00e1 correta e se o certificado \u00e9 v\u00e1lido.", 2);
            this.textValidade.setText("");
            return false;
        }
        return true;
    }

    private byte[] importaCertificado() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de certificado", "pfx"));
        if (fileChooser.showOpenDialog(this) == 0) {
            return this.carregaCertificado(fileChooser.getSelectedFile().getAbsolutePath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] carregaCertificado(String caminhoCertificado) {
        try {
            File arquivo = new File(caminhoCertificado);
            FileInputStream fais = null;
            ArrayList<Byte> dados = new ArrayList<Byte>();
            int carac = -1;
            try {
                fais = new FileInputStream(arquivo);
                while ((carac = fais.read()) > -1) {
                    dados.add((byte)carac);
                }
            }
            finally {
                if (fais != null) {
                    fais.close();
                }
            }
            byte[] array = new byte[dados.size()];
            for (int i = 0; i < dados.size(); ++i) {
                array[i] = (Byte)dados.get(i);
            }
            return array;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o certificado.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public JButton getBotaoSalvar() {
        return this.botaoSalvar;
    }

    public void setBotaoSalvar(JButton botaoSalvar) {
        this.botaoSalvar = botaoSalvar;
    }

    public JButton getBotaoFechar() {
        return this.botaoFechar;
    }

    public void setBotaoFechar(JButton botaoFechar) {
        this.botaoFechar = botaoFechar;
    }

    public JButton getBotaoImportar() {
        return this.botaoImportar;
    }

    public void setBotaoImportar(JButton botaoImportar) {
        this.botaoImportar = botaoImportar;
    }

    public JButton getBotaoRemover() {
        return this.botaoRemover;
    }

    public void setBotaoRemover(JButton botaoRemover) {
        this.botaoRemover = botaoRemover;
    }

    public JButton getBotaoValidar() {
        return this.botaoValidar;
    }

    public void setBotaoValidar(JButton botaoValidar) {
        this.botaoValidar = botaoValidar;
    }

    public JLabel getLabelCertificado() {
        return this.labelCertificado;
    }

    public void setLabelCertificado(JLabel labelCertificado) {
        this.labelCertificado = labelCertificado;
    }

    public JLabel getLabelSenha() {
        return this.labelSenha;
    }

    public void setLabelSenha(JLabel labelSenha) {
        this.labelSenha = labelSenha;
    }

    public JLabel getLabelValidade() {
        return this.labelValidade;
    }

    public void setLabelValidade(JLabel labelValidade) {
        this.labelValidade = labelValidade;
    }

    public JCheckBox getCheckImportado() {
        return this.checkImportado;
    }

    public void setCheckImportado(JCheckBox checkImportado) {
        this.checkImportado = checkImportado;
    }

    public TTextField getTextSenhaCertificado() {
        return this.textSenhaCertificado;
    }

    public void setTextSenhaCertificado(TTextField textSenhaCertificado) {
        this.textSenhaCertificado = textSenhaCertificado;
    }

    public TTextField getTextValidade() {
        return this.textValidade;
    }

    public void setTextValidade(TTextField textValidade) {
        this.textValidade = textValidade;
    }

    public String getTextSenhaCertificadoAux() {
        return this.textSenhaCertificadoAux;
    }

    public void setTextSenhaCertificadoAux(String textSenhaCertificadoAux) {
        this.textSenhaCertificadoAux = textSenhaCertificadoAux;
    }

    public Date getDateValidade() {
        return this.dateValidade;
    }

    public void setDateValidade(Date dateValidade) {
        this.dateValidade = dateValidade;
    }

    public Date getDateValidadeAux() {
        return this.dateValidadeAux;
    }

    public void setDateValidadeAux(Date dateValidadeAux) {
        this.dateValidadeAux = dateValidadeAux;
    }

    public byte[] getCertificado() {
        return this.certificado;
    }

    public void setCertificado(byte[] certificado) {
        this.certificado = certificado;
    }

    public boolean isImportado() {
        return this.importado;
    }

    public void setImportado(boolean importado) {
        this.importado = importado;
    }
}

