/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.util.text;

import jalis.laboratorio.cadastro.util.text.HighlightException;
import jalis.util.Funcoes;
import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class TextAreaHighlighter {
    private JTextArea textComp;
    private Highlighter highlighter;
    private boolean achouPalavra;

    public TextAreaHighlighter(JTextArea textComp) {
        this.textComp = textComp;
        this.highlighter = textComp.getHighlighter();
    }

    public boolean update(String texto) throws HighlightException {
        this.highlighter.removeAllHighlights();
        if (Funcoes.textoVazio(texto)) {
            return true;
        }
        this.achouPalavra = false;
        String mensagemDigitada = texto.toUpperCase();
        if (this.temPalavra(mensagemDigitada, this.getText())) {
            this.atualizarPosicaoDoCaret(mensagemDigitada);
            this.realcarPalavra(mensagemDigitada, this.getText());
            this.achouPalavra = true;
        }
        return this.achouPalavra;
    }

    private String[] getPalavras() {
        return this.getText().toUpperCase().split(" ");
    }

    private String getText() {
        return this.textComp.getText().toUpperCase();
    }

    private void realcarPalavra(String mensagemDigitada, String texto) throws HighlightException {
        String textoSendoAnalisado = new String(texto);
        int endTotal = 0;
        while (this.temPalavra(mensagemDigitada, textoSendoAnalisado)) {
            int start = this.inicioParaColorir(mensagemDigitada, textoSendoAnalisado) + endTotal;
            int end = start + mensagemDigitada.length();
            this.realcar(start, end);
            textoSendoAnalisado = new String(texto).substring(end);
            endTotal = end;
        }
    }

    private void realcar(int start, int end) throws HighlightException {
        try {
            this.highlighter.addHighlight(start, end, new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW));
        }
        catch (BadLocationException ex) {
            throw new HighlightException(ex);
        }
    }

    private void atualizarPosicaoDoCaret(String palavra) {
        int location = this.inicioPalavra(palavra.toUpperCase(), this.getText());
        if (location >= 0) {
            this.textComp.setCaretPosition(location);
        }
    }

    private int inicioParaColorir(String palavraDigitada, String palavraDoTexto) {
        return palavraDoTexto.indexOf(palavraDigitada);
    }

    private int inicioPalavra(String palavraDigitada, String palavraDoTexto) {
        return palavraDoTexto.indexOf(palavraDigitada);
    }

    private boolean temPalavra(String palavraDigitada, String palavraDoTexto) {
        return palavraDoTexto.indexOf(palavraDigitada) > -1;
    }
}

