/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.util.situacao;

import jalis.util.Funcoes;

public enum SaudeOcupacional {
    VAZIO("", ""),
    ADMISSIONAL("01", "Admissional"),
    DEMISSIONAL("02", "Demissional"),
    PERIODICO("03", "Peri\u00f3dico"),
    RETORNO_TRABALHO("04", "Retorno ao trabalho"),
    MUDANCA_FUNCAO("05", "Mudan\u00e7a de fun\u00e7\u00e3o"),
    PROMOCAO_SAUDE("06", "Promo\u00e7\u00e3o \u00e0 sa\u00fade");

    private String codigo;
    private String descricao;

    private SaudeOcupacional(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static SaudeOcupacional getSaudeOcupacionalPorCodigo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return null;
        }
        for (SaudeOcupacional so : SaudeOcupacional.values()) {
            if (!codigo.equals(so.getCodigo())) continue;
            return so;
        }
        return null;
    }

    public String toString() {
        if (Funcoes.textoVazio(this.codigo)) {
            return "";
        }
        return this.codigo + "-" + this.descricao;
    }
}

