/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.util.situacao;

import jalis.util.Funcoes;

public enum CoberturaEspecial {
    VAZIO("", ""),
    GESTANTE("01", "Gestante"),
    PRE_OPERATORIO("02", "Pr\u00e9-operat\u00f3rio"),
    POS_OPERATORIO("03", "P\u00f3s-operat\u00f3rio");

    private String codigo;
    private String descricao;

    private CoberturaEspecial(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static CoberturaEspecial getCoberturaEspecialPorCodigo(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            return null;
        }
        for (CoberturaEspecial ce : CoberturaEspecial.values()) {
            if (!codigo.equals(ce.getCodigo())) continue;
            return ce;
        }
        return null;
    }

    public String toString() {
        if (Funcoes.textoVazio(this.codigo)) {
            return "";
        }
        return this.codigo + "-" + this.descricao;
    }
}

