/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.util;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class AvisarReposicaoEstoque
extends AbstractDialogoOKCancelar {
    private static final Integer COLUNA_CODIGO = 0;
    private String titulo;
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio");
    private TTextField textCodUsuario = ComponenteFactory.novoTTextField(20, 3);
    private JLabel labelDescUsuario = ComponenteFactory.novoJLabel("", new Dimension(235, 20), new TitledBorder(""));
    private JButton buttonBuscaUsuario = new JButton();
    private JButton buttonOkUsuario = new JButton("OK");
    private JPanel panelUsuario = new JPanel();
    private JPanel panelTabela = new JPanel();
    private ModeloGridTable modeloUsuarios = new ModeloGridTable(new String[]{"C\u00f3digo", "Usu\u00e1rio"});
    private JTable tabelaUsuarios = new JTable(this.modeloUsuarios);
    private List<MaterialUsuarioVO> listaUsuarios = new ArrayList<MaterialUsuarioVO>();
    private static String tipo;

    public AvisarReposicaoEstoque(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public AvisarReposicaoEstoque(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static AvisarReposicaoEstoque novaInstancia(Window owner, String titulo, String tipoMaterial) {
        tipo = tipoMaterial;
        if (owner instanceof Dialog) {
            return new AvisarReposicaoEstoque((Dialog)((JDialog)owner), titulo);
        }
        if (owner instanceof Frame) {
            return new AvisarReposicaoEstoque((Frame)((JFrame)owner), titulo);
        }
        return null;
    }

    private void iniciar() {
        this.setSize(new Dimension(400, 200));
        this.buttonOK.setText("Salvar");
        this.buttonOK.setMnemonic('S');
        this.buttonCancelar.setText("Fechar");
        this.setLayout(new BorderLayout());
        ScreenUtil.centralizar(this);
        this.buttonBuscaUsuario.setBounds(new Rectangle(167, 49, 20, 20));
        this.buttonBuscaUsuario.setFocusable(false);
        this.buttonBuscaUsuario.setText("");
        Funcoes.imagemPesquisa(this.buttonBuscaUsuario);
        this.panelTabela.setLayout(new BorderLayout());
        this.panelTabela.add((Component)new JScrollPane(this.tabelaUsuarios), "Center");
        this.modeloUsuarios.setColumnSize(new int[]{80, 0}, this.tabelaUsuarios);
        this.add((Component)this.getPanelBotoesDireita(), "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(400, 300));
        this.panelUsuario.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.panelUsuario.add((Component)this.labelUsuario, gbc);
        ++gbc.gridy;
        this.textCodUsuario.setPreferredSize(new Dimension(69, 20));
        this.textCodUsuario.setMinimumSize(new Dimension(60, 20));
        gbc.insets = new Insets(0, 0, 0, 1);
        this.panelUsuario.add((Component)this.textCodUsuario, gbc);
        ++gbc.gridx;
        this.buttonBuscaUsuario.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaUsuario.setMinimumSize(new Dimension(30, 20));
        this.panelUsuario.add((Component)this.buttonBuscaUsuario, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 0, 1, 1);
        this.panelUsuario.add((Component)this.labelDescUsuario, gbc);
        ++gbc.gridx;
        this.buttonOkUsuario.setPreferredSize(new Dimension(50, 20));
        this.buttonOkUsuario.setMinimumSize(new Dimension(50, 20));
        this.panelUsuario.add((Component)this.buttonOkUsuario, gbc);
        this.add((Component)this.panelUsuario, "North");
        this.add((Component)this.panelTabela, "Center");
        this.montaListener();
        ScreenUtil.requisitarFoco(this.textCodUsuario);
    }

    private void montaListener() {
        this.buttonBuscaUsuario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarReposicaoEstoque.this.buscaUsuario();
            }
        });
        this.tabelaUsuarios.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4)) == 0) {
                    String codigoUsuario = (String)AvisarReposicaoEstoque.this.modeloUsuarios.getValueAt(row, COLUNA_CODIGO);
                    AvisarReposicaoEstoque.this.modeloUsuarios.removeLine(row);
                    MaterialUsuarioVO matUsuario = null;
                    for (MaterialUsuarioVO materialUsuarioVO : AvisarReposicaoEstoque.this.listaUsuarios) {
                        if (!materialUsuarioVO.getCodigoUsuario().equals(codigoUsuario) || !materialUsuarioVO.getTipoMaterialUsuario().equals(tipo)) continue;
                        matUsuario = materialUsuarioVO;
                        break;
                    }
                    AvisarReposicaoEstoque.this.listaUsuarios.remove(matUsuario);
                }
            }
        });
        this.buttonBuscaUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AvisarReposicaoEstoque.this.pressioneiF2();
                }
            }
        });
        this.textCodUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AvisarReposicaoEstoque.this.pressioneiF2();
                }
            }
        });
        this.textCodUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (AvisarReposicaoEstoque.this.textCodUsuario.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where  upper(usr_codigo)=upper(" + AvisarReposicaoEstoque.this.textCodUsuario.getTextDBEscape() + ") ");
                        if (rs.next()) {
                            AvisarReposicaoEstoque.this.labelDescUsuario.setText(rs.getString("usr_nome"));
                            AvisarReposicaoEstoque.this.textCodUsuario.setText(rs.getString("usr_codigo"));
                        } else {
                            AvisarReposicaoEstoque.this.labelDescUsuario.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(AvisarReposicaoEstoque.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                    }
                }
            }
        });
        this.buttonOkUsuario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarReposicaoEstoque.this.adicionarUsuario();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AvisarReposicaoEstoque.this.tabelaUsuarios.getRowCount(); ++i) {
                    String usuario = (String)AvisarReposicaoEstoque.this.tabelaUsuarios.getValueAt(i, COLUNA_CODIGO);
                    boolean adicionar = true;
                    for (MaterialUsuarioVO materialUsuarioVO : AvisarReposicaoEstoque.this.listaUsuarios) {
                        if (!usuario.equals(materialUsuarioVO.getCodigoUsuario()) || !tipo.equals(materialUsuarioVO.getTipoMaterialUsuario())) continue;
                        adicionar = !usuario.equals(materialUsuarioVO.getCodigoUsuario()) || !tipo.equals(materialUsuarioVO.getTipoMaterialUsuario());
                        break;
                    }
                    if (!adicionar) continue;
                    MaterialUsuarioVO materialUsuario = new MaterialUsuarioVO();
                    materialUsuario.setCodigoUsuario(usuario);
                    materialUsuario.setTipoMaterialUsuario(tipo);
                    AvisarReposicaoEstoque.this.listaUsuarios.add(materialUsuario);
                }
            }
        });
    }

    private void buscaUsuario() {
        Hashtable resultado = Pesquisas.usuario(this, true);
        if (resultado != null) {
            this.textCodUsuario.setText(resultado.get("usr_codigo").toString());
        }
        this.textCodUsuario.requestFocus();
    }

    private void adicionarUsuario() {
        if (!Funcoes.textoVazio(this.textCodUsuario) && !this.labelDescUsuario.getText().equals("N\u00e3o cadastrado")) {
            if (this.modeloUsuarios.getRowCount() == 0) {
                this.modeloUsuarios.addLine(new Object[]{this.textCodUsuario.getText(), this.labelDescUsuario.getText()});
            } else {
                boolean encontrado = false;
                for (int i = 0; i < this.modeloUsuarios.getRowCount(); ++i) {
                    if (!this.modeloUsuarios.getValueAt(i, COLUNA_CODIGO).equals(this.textCodUsuario.getText())) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.modeloUsuarios.addLine(new Object[]{this.textCodUsuario.getText(), this.labelDescUsuario.getText()});
                }
            }
        }
        this.textCodUsuario.clear();
        this.labelDescUsuario.setText("");
        ScreenUtil.requisitarFoco(this.textCodUsuario);
    }

    public void pressioneiF2() {
        if (this.textCodUsuario.hasFocus()) {
            this.buscaUsuario();
        }
    }

    public List<MaterialUsuarioVO> getListaUsuarios() {
        return this.listaUsuarios;
    }

    public void setListaUsuarios(List<MaterialUsuarioVO> listaUsuarios, String tipo) {
        for (MaterialUsuarioVO materialUsuarioVO : listaUsuarios) {
            this.listaUsuarios.add(materialUsuarioVO);
            if (!materialUsuarioVO.getTipoMaterialUsuario().equals(tipo)) continue;
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select u.usr_codigo, u.usr_nome from usuario u ");
                buf.append("where upper(u.usr_codigo)=upper(");
                buf.append(StringUtil.textoDBEscape(materialUsuarioVO.getCodigoUsuario().toUpperCase()));
                buf.append(") ");
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (!rs.next()) continue;
                this.modeloUsuarios.addLine(new Object[]{rs.getString("usr_codigo"), rs.getString("usr_nome")});
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
            }
        }
    }
}

