/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.util;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.exame.SetorUsuarioVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class AvisarExameRetificado
extends AbstractDialogoOKCancelar {
    private static final Integer COLUNA_CODIGO = 0;
    private String titulo;
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio");
    private TTextField textCodUsuario = ComponenteFactory.novoTTextField(20, 3);
    private JLabel labelDescUsuario = ComponenteFactory.novoJLabel("", new Dimension(235, 20), new TitledBorder(""));
    private JButton buttonBuscaUsuario = new JButton();
    private JButton buttonOkUsuario = new JButton("OK");
    private JPanel panelUsuario = new JPanel();
    private JPanel panelTabela = new JPanel();
    private ModeloGridTable modeloUsuarios = new ModeloGridTable(new String[]{"C\u00f3digo", "Usu\u00e1rio"});
    private JTable tabelaUsuarios = new JTable(this.modeloUsuarios);
    private List<SetorUsuarioVO> listaUsuarios = new ArrayList<SetorUsuarioVO>();
    private static String tipo;

    public AvisarExameRetificado(JFrame pai, String titulo) {
        super((Frame)pai, titulo);
        this.iniciar();
    }

    public static AvisarExameRetificado novaInstancia(Window owner, String titulo) {
        if (owner instanceof Frame) {
            return new AvisarExameRetificado((JFrame)owner, titulo);
        }
        return null;
    }

    private void iniciar() {
        this.setSize(new Dimension(400, 200));
        this.buttonOK.setMnemonic('S');
        this.buttonCancelar.setText("Fechar");
        this.setLayout(new BorderLayout());
        ScreenUtil.centralizar(this);
        this.buttonBuscaUsuario.setBounds(new Rectangle(167, 49, 20, 20));
        this.buttonBuscaUsuario.setFocusable(false);
        this.buttonBuscaUsuario.setText("");
        Funcoes.imagemPesquisa(this.buttonBuscaUsuario);
        this.panelTabela.setLayout(new BorderLayout());
        this.panelTabela.add((Component)new JScrollPane(this.tabelaUsuarios), "Center");
        this.modeloUsuarios.setColumnSize(new int[]{80, 0}, this.tabelaUsuarios);
        this.add((Component)this.getPanelBotoesDireita(), "South");
        this.setPreferredSize(new Dimension(400, 300));
        this.setMinimumSize(new Dimension(400, 300));
        this.panelUsuario.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.panelUsuario.add((Component)this.labelUsuario, gbc);
        ++gbc.gridy;
        this.textCodUsuario.setPreferredSize(new Dimension(69, 20));
        this.textCodUsuario.setMinimumSize(new Dimension(60, 20));
        gbc.insets = new Insets(0, 0, 0, 1);
        this.panelUsuario.add((Component)this.textCodUsuario, gbc);
        ++gbc.gridx;
        this.buttonBuscaUsuario.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaUsuario.setMinimumSize(new Dimension(30, 20));
        this.panelUsuario.add((Component)this.buttonBuscaUsuario, gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 0, 1, 1);
        this.panelUsuario.add((Component)this.labelDescUsuario, gbc);
        ++gbc.gridx;
        this.buttonOkUsuario.setPreferredSize(new Dimension(50, 20));
        this.buttonOkUsuario.setMinimumSize(new Dimension(50, 20));
        this.panelUsuario.add((Component)this.buttonOkUsuario, gbc);
        this.add((Component)this.panelUsuario, "North");
        this.add((Component)this.panelTabela, "Center");
        this.montaListener();
        ScreenUtil.requisitarFoco(this.textCodUsuario);
    }

    private void montaListener() {
        this.buttonBuscaUsuario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarExameRetificado.this.buscaUsuario();
            }
        });
        this.tabelaUsuarios.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4)) == 0) {
                    String codigoUsuario = (String)AvisarExameRetificado.this.modeloUsuarios.getValueAt(row, COLUNA_CODIGO);
                    AvisarExameRetificado.this.modeloUsuarios.removeLine(row);
                    SetorUsuarioVO setorUsuario = null;
                    for (SetorUsuarioVO materialUsuarioVO : AvisarExameRetificado.this.listaUsuarios) {
                        if (!materialUsuarioVO.getCodigoUsuario().equals(codigoUsuario)) continue;
                        setorUsuario = materialUsuarioVO;
                        break;
                    }
                    AvisarExameRetificado.this.listaUsuarios.remove(setorUsuario);
                }
            }
        });
        this.buttonBuscaUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AvisarExameRetificado.this.pressioneiF2();
                }
            }
        });
        this.textCodUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AvisarExameRetificado.this.pressioneiF2();
                }
            }
        });
        this.textCodUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (AvisarExameRetificado.this.textCodUsuario.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where  upper(usr_codigo)=upper(" + AvisarExameRetificado.this.textCodUsuario.getTextDBEscape() + ") ");
                        if (rs.next()) {
                            AvisarExameRetificado.this.labelDescUsuario.setText(rs.getString("usr_nome"));
                            AvisarExameRetificado.this.textCodUsuario.setText(rs.getString("usr_codigo"));
                        } else {
                            AvisarExameRetificado.this.labelDescUsuario.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(AvisarExameRetificado.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                    }
                }
            }
        });
        this.buttonOkUsuario.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvisarExameRetificado.this.adicionarUsuario();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < AvisarExameRetificado.this.tabelaUsuarios.getRowCount(); ++i) {
                    String usuario = (String)AvisarExameRetificado.this.tabelaUsuarios.getValueAt(i, COLUNA_CODIGO);
                    boolean adicionar = true;
                    for (SetorUsuarioVO setorUsuarioVO : AvisarExameRetificado.this.listaUsuarios) {
                        if (!usuario.equals(setorUsuarioVO.getCodigoUsuario())) continue;
                        adicionar = !usuario.equals(setorUsuarioVO.getCodigoUsuario());
                        break;
                    }
                    if (!adicionar) continue;
                    SetorUsuarioVO materialUsuario = new SetorUsuarioVO();
                    materialUsuario.setCodigoUsuario(usuario);
                    AvisarExameRetificado.this.listaUsuarios.add(materialUsuario);
                }
            }
        });
    }

    private void buscaUsuario() {
        Hashtable resultado = Pesquisas.usuario(this, true);
        if (resultado != null) {
            this.textCodUsuario.setText(resultado.get("usr_codigo").toString());
        }
        this.textCodUsuario.requestFocus();
    }

    private void adicionarUsuario() {
        if (!Funcoes.textoVazio(this.textCodUsuario) && !this.labelDescUsuario.getText().equals("N\u00e3o cadastrado")) {
            if (this.modeloUsuarios.getRowCount() == 0) {
                this.modeloUsuarios.addLine(new Object[]{this.textCodUsuario.getText(), this.labelDescUsuario.getText()});
            } else {
                boolean encontrado = false;
                for (int i = 0; i < this.modeloUsuarios.getRowCount(); ++i) {
                    if (!this.modeloUsuarios.getValueAt(i, COLUNA_CODIGO).equals(this.textCodUsuario.getText())) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.modeloUsuarios.addLine(new Object[]{this.textCodUsuario.getText(), this.labelDescUsuario.getText()});
                }
            }
        }
        this.textCodUsuario.clear();
        this.labelDescUsuario.setText("");
        ScreenUtil.requisitarFoco(this.textCodUsuario);
    }

    public void pressioneiF2() {
        if (this.textCodUsuario.hasFocus()) {
            this.buscaUsuario();
        }
    }

    public List<SetorUsuarioVO> getListaUsuarios() {
        return this.listaUsuarios;
    }

    public void setListaUsuarios(List<SetorUsuarioVO> listaUsuarios) {
        for (SetorUsuarioVO materialUsuarioVO : listaUsuarios) {
            this.listaUsuarios.add(materialUsuarioVO);
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select u.usr_codigo, u.usr_nome from usuario u ");
                buf.append("where upper(u.usr_codigo)=upper(");
                buf.append(StringUtil.textoDBEscape(materialUsuarioVO.getCodigoUsuario().toUpperCase()));
                buf.append(") ");
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (!rs.next()) continue;
                this.modeloUsuarios.addLine(new Object[]{rs.getString("usr_codigo"), rs.getString("usr_nome")});
            }
            catch (SQLException e) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
            }
        }
    }
}

