/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.tabelaPreco;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class TabelaPrecoUtil {
    public static Double calculaTotalExameTipoCBHPM(String percentual, String custo, String uco, PorteTabelaCBHPM porte) {
        double valorPercentual = 0.0;
        double valorCusto = 0.0;
        double valorPorte = 0.0;
        double valorUco = 0.0;
        if (Funcoes.isNumeric(percentual)) {
            valorPercentual = Double.parseDouble(Funcoes.limpaDecimal(percentual));
        }
        if (Funcoes.isNumeric(custo)) {
            valorCusto = Double.parseDouble(Funcoes.limpaDecimal(custo));
        }
        if (Funcoes.isNumeric(uco)) {
            valorUco = Double.parseDouble(Funcoes.limpaDecimal(uco));
        }
        valorPorte = porte.getValor();
        int casasDecimais = ParametrosGerais.getCasasPrecoExame();
        RoundingMode arredondamento = ParametrosGerais.getArredondamentoPrecoExame();
        Double calculo = valorPercentual * valorPorte + valorCusto * valorUco;
        BigDecimal resultadoArredondado = new BigDecimal(calculo).setScale(casasDecimais, arredondamento);
        return resultadoArredondado.doubleValue();
    }
}

