/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.tabelaPreco;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.cadastro.tabelaPreco.TabelaPrecoExameUsuarioVO;
import jalis.service.cadastro.TabelaPrecoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class HistoricoPrecos
extends AbstractDialogoOKCancelar {
    private static String TITULO = "Hist\u00f3rico de altera\u00e7\u00f5es";
    private JPanel panelFiltro = new JPanel();
    private JLabel labelFiltro = new JLabel("Filtro:");
    private JLabel labelDataInicio = new JLabel("Data in\u00edcio:");
    private TTextField txtDataInicio = new TTextField(10, 4);
    private JButton bBuscaDataInicio = new JButton();
    private JLabel labelDataFinal = new JLabel("  Data final:");
    private TTextField txtDataFinal = new TTextField(10, 4);
    private JButton bBuscaDataFinal = new JButton();
    private JLabel labelUsuario = new JLabel("  Usu\u00e1rio:");
    private TTextField txtUsuario = new TTextField(20, 3);
    private JButton bFiltrar = new JButton("Filtrar");
    private JPanel panelHistorico = new JPanel();
    private ModeloGridTable modeloHistorico = new ModeloGridTable(new String[]{"Data Altera\u00e7\u00e3o", "Usu\u00e1rio", "Campos Alterados"});
    private JTable tableHistorico = new JTable(this.modeloHistorico);
    private JScrollPane scrollHistorico = new JScrollPane(this.tableHistorico);
    private String codigoTabela;
    private int COLUNA_USUARIO = 1;
    private int COLUNA_CAMPOS_ALTERADOS = 2;

    public static HistoricoPrecos novaInstancia(Component owner, String codigoTabela) {
        if (owner instanceof Dialog) {
            return new HistoricoPrecos((Dialog)owner, TITULO, codigoTabela);
        }
        return new HistoricoPrecos((Frame)owner, TITULO, codigoTabela);
    }

    public HistoricoPrecos(Dialog pai, String titulo, String codigoTabela) {
        super(pai, titulo);
        this.codigoTabela = codigoTabela;
        this.montarTela();
    }

    public HistoricoPrecos(Frame pai, String titulo, String codigoTabela) {
        super(pai, titulo);
        this.codigoTabela = codigoTabela;
        this.montarTela();
    }

    private void montarTela() {
        this.buttonOK.setVisible(false);
        this.buttonCancelar.setText("Fechar");
        this.setSize(new Dimension(700, 300));
        this.setResizable(true);
        ScreenUtil.centralizar(this);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.modeloHistorico.setColumnSize(new int[]{130, 90, 0}, this.tableHistorico);
        this.txtDataInicio.setPreferredSize(new Dimension(80, 20));
        this.txtDataInicio.setMinimumSize(this.txtDataInicio.getPreferredSize());
        this.txtDataFinal.setPreferredSize(new Dimension(80, 20));
        this.txtDataFinal.setMinimumSize(this.txtDataFinal.getPreferredSize());
        this.txtUsuario.setPreferredSize(new Dimension(80, 20));
        this.txtUsuario.setMinimumSize(this.txtUsuario.getPreferredSize());
        this.bBuscaDataInicio.setPreferredSize(new Dimension(20, 20));
        this.bBuscaDataInicio.setFocusable(false);
        Funcoes.imagemPesquisa(this.bBuscaDataInicio);
        this.bBuscaDataFinal.setPreferredSize(new Dimension(20, 20));
        this.bBuscaDataFinal.setFocusable(false);
        Funcoes.imagemPesquisa(this.bBuscaDataFinal);
        this.bFiltrar.setSize(new Dimension(80, 20));
        this.bFiltrar.setMnemonic('F');
        this.panelFiltro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets ioriginal = c.insets;
        Insets ibotao = new Insets(ioriginal.top, 0, ioriginal.bottom, ioriginal.right);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.panelFiltro.add((Component)this.labelDataInicio, c);
        ++c.gridx;
        this.panelFiltro.add((Component)this.txtDataInicio, c);
        ++c.gridx;
        c.insets = ibotao;
        this.panelFiltro.add((Component)this.bBuscaDataInicio, c);
        c.insets = ioriginal;
        ++c.gridx;
        this.panelFiltro.add((Component)this.labelDataFinal, c);
        ++c.gridx;
        this.panelFiltro.add((Component)this.txtDataFinal, c);
        ++c.gridx;
        c.insets = ibotao;
        this.panelFiltro.add((Component)this.bBuscaDataFinal, c);
        c.insets = ioriginal;
        ++c.gridx;
        this.panelFiltro.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelFiltro.add((Component)this.txtUsuario, c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        this.panelFiltro.add((Component)this.bFiltrar, c);
        this.panelFiltro.setBorder(new TitledBorder("Filtro"));
        this.panelHistorico.setLayout(new BorderLayout());
        this.panelHistorico.add((Component)this.scrollHistorico, "Center");
        panelCentro.add((Component)this.panelFiltro, "North");
        panelCentro.add((Component)this.panelHistorico, "Center");
        this.pesquisar();
        this.montaListener();
    }

    private void montaListener() {
        this.bBuscaDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(HistoricoPrecos.this.txtDataInicio, HistoricoPrecos.this.bBuscaDataInicio, HistoricoPrecos.this.panelFiltro, true);
            }
        });
        this.bBuscaDataFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(HistoricoPrecos.this.txtDataFinal, HistoricoPrecos.this.bBuscaDataFinal, HistoricoPrecos.this.panelFiltro, true);
            }
        });
        this.bFiltrar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoricoPrecos.this.pesquisar();
            }
        });
    }

    private void pesquisar() {
        TabelaPrecoService serviceTabelaPreco = new TabelaPrecoService();
        try {
            this.modeloHistorico.clear();
            String dataInicio = Funcoes.textoVazio(this.txtDataInicio.getText()) ? "" : Funcoes.formataData("yyyy-MM-dd", this.txtDataInicio.getText());
            String dataFinal = Funcoes.textoVazio(this.txtDataFinal.getText()) ? "" : Funcoes.formataData("yyyy-MM-dd", this.txtDataFinal.getText());
            List<TabelaPrecoExameUsuarioVO> listaHistorico = serviceTabelaPreco.pesquisarHistorico(Integer.valueOf(Variaveis.filialPadrao), dataInicio, dataFinal, this.txtUsuario.getText(), this.codigoTabela);
            boolean COLUNA_USUARIO_VETOR = false;
            boolean COLUNA_CAMPOS_ALTERADOS_VETOR = true;
            for (TabelaPrecoExameUsuarioVO tabelaPrecoExameUsuario : listaHistorico) {
                this.modeloHistorico.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm:ss", tabelaPrecoExameUsuario.getDataHoraAlteracao()), tabelaPrecoExameUsuario.getCodigoUsuario(), tabelaPrecoExameUsuario.getAlteracao()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int tamanhoColuna(String s) {
        FontMetrics met = this.tableHistorico.getFontMetrics(this.tableHistorico.getFont());
        return met.stringWidth(s) + 15;
    }
}

