/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.tabelaPreco;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoExame;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoUtil;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.util.ExameUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssistenteImportacaoTabelaPrecoDao {
    public static Map<String, Double> getValoresPorte(String filial, String tpeCodigo) {
        HashMap<String, Double> valoresPorte = new HashMap<String, Double>();
        StringBuilder sql = new StringBuilder("select tpp_porte as porte, tpp_valor as valor ");
        sql.append(" from tabelaprecoexamesporte ");
        sql.append(" where fil_codigo = ");
        sql.append(filial);
        sql.append(" and tpe_codigo = ");
        sql.append(tpeCodigo);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                valoresPorte.put(rs.getString("porte"), rs.getDouble("valor"));
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AssistenteImportacaoTabelaPrecoDao");
        }
        return valoresPorte;
    }

    public static void atualizaExames(String filial, String tpeCodigo, boolean isTabelaCBHPM, List<TabelaPrecoExame> exames) {
        for (TabelaPrecoExame exame : exames) {
            StringBuilder sql = new StringBuilder();
            if (isTabelaCBHPM) {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    sql.append("\tupdate detalhetabelaprecometodologia set dtm_percentual = ");
                    sql.append(exame.getPercentualNovo());
                    sql.append("\t, dtm_valor = ");
                    sql.append(exame.getCustoNovo());
                } else {
                    sql.append("\tupdate detalhetabelapreco set dtp_percentual =  ");
                    sql.append(exame.getPercentualNovo());
                    sql.append("\t, dtp_valor = ");
                    sql.append(exame.getCustoNovo());
                }
                sql.append(" where fil_codigo = ");
                sql.append(filial);
                sql.append("and tpe_codigo = ");
                sql.append(tpeCodigo);
                sql.append("and exa_codigo = '");
                sql.append(exame.getCodigoExame());
                sql.append("' and mco_codigo =");
                sql.append(exame.getCodigoMaterial());
            } else {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    sql.append("\tupdate  detalhetabelaprecometodologia  set dtm_valor = ");
                } else {
                    sql.append("\tupdate  detalhetabelapreco set dtp_valor = ");
                }
                sql.append(exame.getValorCHNovo());
                sql.append(" where fil_codigo = ");
                sql.append(filial);
                sql.append("and tpe_codigo = ");
                sql.append(tpeCodigo);
                sql.append("and exa_codigo = '");
                sql.append(exame.getCodigoExame());
                sql.append("' and mco_codigo =");
                sql.append(exame.getCodigoMaterial());
            }
            Statement st = Conexao.getStatement();
            try {
                Conexao.executeUpdate(filial, st, sql.toString(), false);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AssistenteImportacaoTabelaPrecoDao");
            }
        }
    }

    public static List<TabelaPrecoExame> getExamesConfigurados(String filial, String tpeCodigo) {
        ArrayList<TabelaPrecoExame> tabela = new ArrayList<TabelaPrecoExame>();
        StringBuilder sql = new StringBuilder();
        sql.append("select d.exa_codigo as codigoExame, ");
        sql.append(" \td.mco_codigo as codigoMaterial, ");
        sql.append(" \tm.mco_abreviatura as abreviaturaMaterial, ");
        sql.append(" \tex.exa_descricao as descricaoExame, ");
        sql.append(" \ttp.tpp_valor as valorPorte, ");
        sql.append(" \ttp.tpp_porte as porteExame, ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            sql.append(" \td.dtm_percentual as percentualExame, ");
            sql.append(" \td.dtm_valor as valorCH, ");
            sql.append(" \td.dtm_codamb as amb, ");
            sql.append(" d.dtm_proibido as proibido, ");
        } else {
            sql.append(" \td.dtp_percentual as percentualExame, ");
            sql.append(" \td.dtp_valor as valorCH, ");
            sql.append(" \td.dtp_codamb as amb, ");
            sql.append(" d.dtp_proibido as proibido, ");
        }
        sql.append(" \ttpe.tpe_uco as uco ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            sql.append(" from detalhetabelaprecometodologia d  ");
        } else {
            sql.append(" from detalhetabelapreco d  ");
        }
        sql.append("  inner join examematcoleta e on e.fil_codigo = d.fil_codigo and d.exa_codigo = e.exa_codigo  and d.mco_codigo = e.mco_codigo ");
        sql.append("  inner join materialcoleta m  on m.fil_codigo = e.fil_codigo and m.mco_codigo = e.mco_codigo  ");
        sql.append("  inner join exames ex on ex.fil_codigo = d.fil_codigo and ex.exa_codigo = e.exa_codigo ");
        sql.append("  inner join tabelaprecoexames tpe on d.fil_codigo = tpe.fil_codigo and d.tpe_codigo = tpe.tpe_codigo ");
        sql.append("  left join tabelaprecoexamesporte tp on tp.fil_codigo  = d.fil_codigo and tp.tpp_porte = d.tpp_porte and tp.tpe_codigo = d.tpe_codigo ");
        sql.append(" where d.fil_codigo = ");
        sql.append(filial);
        sql.append(" and d.tpe_codigo = ");
        sql.append(tpeCodigo);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                TabelaPrecoExame precoExame = new TabelaPrecoExame();
                precoExame.setCodigoExame(rs.getString("codigoExame"));
                precoExame.setCodigoMaterial(rs.getInt("codigoMaterial"));
                precoExame.setAbreviacaoMaterial(rs.getString("abreviaturaMaterial"));
                precoExame.setCodigoAmb(rs.getString("amb"));
                precoExame.setDescricaoExame(rs.getString("descricaoExame"));
                precoExame.setValorPorte(rs.getDouble("valorPorte"));
                precoExame.setPorteAtual(rs.getString("porteExame"));
                precoExame.setPercentualAtual(rs.getDouble("percentualExame"));
                precoExame.setCustoAtual(rs.getDouble("valorCH"));
                precoExame.setValorCHAtual(rs.getDouble("valorCH"));
                precoExame.setValorUCO(rs.getDouble("uco"));
                PorteTabelaCBHPM p = new PorteTabelaCBHPM(rs.getString("porteExame"), rs.getDouble("valorPorte"));
                precoExame.setTotalAtual(TabelaPrecoUtil.calculaTotalExameTipoCBHPM(String.valueOf(precoExame.getPercentualAtual()), String.valueOf(precoExame.getCustoAtual()), String.valueOf(precoExame.getValorUCO()), p));
                tabela.add(precoExame);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AssistenteImportacaoTabelaPrecoDao");
        }
        return tabela;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PrecosAlterados> buscaDadosPreco(Integer codigoTabelaPreco, boolean isCBHPM) {
        if (codigoTabelaPreco == -1) {
            return new ArrayList<PrecosAlterados>();
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        if (isCBHPM) {
            buf.append("select a.exa_codigo, a.mco_codigo, a.dtp_proibido, a.dtp_valor, a.dtp_codamb, ");
            buf.append("a.dtp_percentual, a.tpp_porte, b.exa_descricao, c.tpp_valor, d.tpe_uco ");
            buf.append("from detalhetabelapreco a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("left join tabelaprecoexamesporte c on a.fil_codigo = c.fil_codigo and a.tpe_codigo = c.tpe_codigo and a.tpp_porte = c.tpp_porte ");
            buf.append("left join tabelaprecoexames d on a.fil_codigo = d.fil_codigo and a.tpe_codigo = d.tpe_codigo ");
            buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.tpe_codigo = ").append(codigoTabelaPreco);
            buf.append(" order by a.exa_codigo, a.mco_codigo");
        } else {
            buf.append("select a.exa_codigo, a.mco_codigo, a.dtp_proibido, a.dtp_valor, a.dtp_codamb, b.exa_descricao ");
            buf.append("from detalhetabelapreco a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.tpe_codigo = ").append(codigoTabelaPreco);
            buf.append(" order by a.exa_codigo, a.mco_codigo");
        }
        ArrayList<PrecosAlterados> precosAlterados = new ArrayList<PrecosAlterados>();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                material.setShowAbreviatura(true);
                if (isCBHPM) {
                    PorteTabelaCBHPM porte = new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor"));
                    double d = TabelaPrecoUtil.calculaTotalExameTipoCBHPM(rs.getString("dtp_percentual"), rs.getString("dtp_valor"), rs.getString("tpe_uco"), porte);
                }
                PrecosAlterados precoAlterado = new PrecosAlterados();
                precoAlterado.setCodigoAMB(rs.getString("dtp_codamb"));
                precoAlterado.setCodigoExame(rs.getString("exa_codigo"));
                if (isCBHPM) {
                    precoAlterado.setValorCusto(rs.getDouble("tpp_valor"));
                    precoAlterado.setPorte(rs.getString("tpp_porte"));
                    precoAlterado.setPercentual(rs.getDouble("dtp_percentual"));
                } else {
                    precoAlterado.setValorCusto(rs.getDouble("dtp_valor"));
                }
                precoAlterado.setProibido(rs.getBoolean("dtp_proibido"));
                precoAlterado.setDescricaoExame(rs.getString("exa_descricao"));
                DadosMaterial materialExame = new DadosMaterial(rs.getInt("mco_codigo"), AssistenteImportacaoTabelaPrecoDao.obterDadosMaterial(rs.getInt("mco_codigo")), false, false);
                precoAlterado.setMaterial(materialExame);
                precosAlterados.add(precoAlterado);
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "AssistenteImportacaoTabelaPrecoDao (194)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return precosAlterados;
    }

    public static String obterDadosMaterial(int codigoMaterial) {
        DadosMaterial dadosMaterial = null;
        try {
            Statement st = Conexao.getStatement();
            dadosMaterial = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, codigoMaterial, st);
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dadosMaterial.getAbreviatura();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PrecosAlterados> buscaDadosPrecoMetodologia(Integer codigoTabelaPreco, boolean isCBHPM) {
        if (codigoTabelaPreco == -1) {
            return new ArrayList<PrecosAlterados>();
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        if (isCBHPM) {
            buf.append("select a.exa_codigo, a.mco_codigo, a.dtm_proibido, a.dtm_valor, a.dtm_codamb, ");
            buf.append("a.dtm_percentual, a.tpp_porte, b.exa_descricao, c.tpp_valor, d.tpe_uco ");
            buf.append("from detalhetabelaprecometodologia a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("left join tabelaprecoexamesporte c on a.fil_codigo = c.fil_codigo and a.tpe_codigo = c.tpe_codigo and a.tpp_porte = c.tpp_porte ");
            buf.append("left join tabelaprecoexames d on a.fil_codigo = d.fil_codigo and a.tpe_codigo = d.tpe_codigo ");
            buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.tpe_codigo = ").append(codigoTabelaPreco);
            buf.append(" order by a.exa_codigo, a.mco_codigo");
        } else {
            buf.append("select a.exa_codigo, a.mco_codigo, a.dtm_proibido, a.dtm_valor, a.dtm_codamb, b.exa_descricao ");
            buf.append("from detalhetabelapreco a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.tpe_codigo = ").append(codigoTabelaPreco);
            buf.append(" order by a.exa_codigo, a.mco_codigo");
        }
        ArrayList<PrecosAlterados> precosAlterados = new ArrayList<PrecosAlterados>();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                material.setShowAbreviatura(true);
                PorteTabelaCBHPM porte = new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor"));
                double total = TabelaPrecoUtil.calculaTotalExameTipoCBHPM(rs.getString("dtm_percentual"), rs.getString("dtm_valor"), rs.getString("tpe_uco"), porte);
                PrecosAlterados precoAlterado = new PrecosAlterados();
                precoAlterado.setCodigoAMB(rs.getString("dtm_codamb"));
                precoAlterado.setCodigoExame(rs.getString("exa_codigo"));
                precoAlterado.setValorCusto(rs.getDouble("tpp_valor"));
                precoAlterado.setPercentual(rs.getDouble("dtm_percentual"));
                precoAlterado.setPorte(rs.getString("tpp_porte"));
                precoAlterado.setProibido(rs.getBoolean("dtm_proibido"));
                precoAlterado.setDescricaoExame(rs.getString("exa_descricao"));
                DadosMaterial materialExame = new DadosMaterial(rs.getInt("mco_codigo"), AssistenteImportacaoTabelaPrecoDao.obterDadosMaterial(rs.getInt("mco_codigo")), false, false);
                precoAlterado.setMaterial(materialExame);
                precosAlterados.add(precoAlterado);
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "AssistenteImportacaoTabelaPrecoDao (194)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return precosAlterados;
    }
}

