/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.tabelaPreco;

import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.tabelaPreco.AssistenteImportacaoTabelaPrecoDao;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoExame;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.excel.Excel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AssistenteImportacaoTabelaPreco
extends FrmPadrao
implements ActionListener {
    private List<TabelaPrecoExame> examesAtualizados = new ArrayList<TabelaPrecoExame>();
    private boolean isTabelaCBHPM = false;
    private JPanel painelCentral = new JPanel(null);
    private JPanel painelBotoes = new JPanel(new FlowLayout(2));
    private JTextField textArquivo = new JTextField();
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private JButton buttonAnterior = ComponenteFactory.novoJButton("Anterior", 'a', this);
    private JButton buttonProximo = ComponenteFactory.novoJButton("Pr\u00f3ximo", 'r', this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[0]);
    private JTable tableTabelaPreco = new JTable(this.modelo);
    private ModeloGridTable modeloModificacoesCBHPM = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "C\u00f3d. AMB", "% atual", "% novo", "Porte atual", "Porte novo", "Custo atual", "Custo novo", "Total atual", "Total novo"});
    private JTable tableModificacoesCBHPM = new JTable(this.modeloModificacoesCBHPM);
    private ModeloGridTable modeloModificacoesCH = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "C\u00f3d. AMB", "Valor atual", "Valor novo"});
    private JTable tableModificacoesCH = new JTable(this.modeloModificacoesCH);
    private JScrollPane scrollPanelCBHPM;
    private JScrollPane scrollPanelCH;
    private JScrollPane scrollPanel;
    private JLabel comp = new JLabel(" Bem-vindo ao assistente para configura\u00e7\u00e3o e importa\u00e7\u00e3o da tabela de pre\u00e7os de exames: ");
    private JLabel labelArquivo = new JLabel("Informe o arquivo que ser\u00e1 importado: ");
    private JLabel labelColunaArquivos = new JLabel("Para cada dado abaixo, informe a sua respectiva coluna no arquivo:");
    private JLabel labelDadosImportados = new JLabel("Dados que ser\u00e3o importados:");
    private JLabel labelCodigoAMB = new JLabel("C\u00f3digo/AMB:");
    private JTextField textCodigoAMB = new JTextField();
    private JLabel labelPercentual = new JLabel("Percentual:");
    private JTextField textPercentual = new JTextField();
    private JLabel labelPorte = new JLabel("Porte:");
    private JTextField textPorte = new JTextField();
    private JLabel labelCusto = new JLabel("Custo:");
    private JTextField textCustos = new JTextField();
    private JLabel labelLinhasImportadas = new JLabel("Importar os dados \u00e0 partir da linha:");
    private TTextField textLinhasImportadas = new TTextField(12, 1);
    private JLabel labelValorCH = new JLabel("Valor CH:");
    private JTextField textValorCH = new JTextField();
    private JButton buttonBuscaArquivos = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private int passoAtivo = 0;
    private String tabelaPreco;
    private String filial;
    private List<TabelaPrecoExame> collect;
    private JDialog modalAssistenteImportacaoTabelaPreco;

    public static AssistenteImportacaoTabelaPreco novaInstancia(JDialog modalAssistenteImportacaoTabelaPreco, boolean isTabelaCBHPM, String filial, String tabelaPreco) {
        return new AssistenteImportacaoTabelaPreco(modalAssistenteImportacaoTabelaPreco, isTabelaCBHPM, filial, tabelaPreco);
    }

    public AssistenteImportacaoTabelaPreco(JDialog modalAssistenteImportacaoTabelaPreco, boolean isTabelaCBHPM, String filial, String tabelaPreco) {
        this.isTabelaCBHPM = isTabelaCBHPM;
        this.filial = filial;
        this.tabelaPreco = tabelaPreco;
        this.modalAssistenteImportacaoTabelaPreco = modalAssistenteImportacaoTabelaPreco;
        this.montarTela();
    }

    private void montarTela() {
        this.setLayout(new BorderLayout());
        this.painelCentral.setFocusable(false);
        this.painelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)this.painelCentral, "Center");
        this.add((Component)this.painelBotoes, "South");
        this.comp.setBounds(5, 25, 800, 20);
        this.labelArquivo.setBounds(5, 150, 800, 20);
        this.buttonBuscaArquivos.setBounds(555, 170, 25, 20);
        this.textArquivo.setSize(new Dimension(550, 20));
        this.textArquivo.setBounds(5, 170, 550, 20);
        this.textArquivo.setEnabled(false);
        this.painelCentral.add(this.comp);
        this.painelCentral.add(this.labelArquivo);
        this.painelCentral.add(this.textArquivo);
        this.painelCentral.add(this.buttonBuscaArquivos);
        this.labelDadosImportados.setBounds(5, 5, 200, 30);
        this.scrollPanel = new JScrollPane(this.tableTabelaPreco);
        this.scrollPanel.setBounds(5, 30, 624, 320);
        this.labelColunaArquivos.setBounds(5, 350, 500, 30);
        this.labelCodigoAMB.setBounds(5, 375, 100, 30);
        this.textCodigoAMB.setBounds(90, 380, 75, 20);
        this.labelPercentual.setBounds(5, 400, 100, 30);
        this.textPercentual.setBounds(90, 405, 75, 20);
        this.labelPorte.setBounds(205, 375, 100, 30);
        this.textPorte.setBounds(255, 380, 75, 20);
        this.labelCusto.setBounds(205, 400, 100, 30);
        this.textCustos.setBounds(255, 405, 75, 20);
        this.labelLinhasImportadas.setBounds(5, 425, 300, 30);
        this.textLinhasImportadas.setBounds(255, 430, 75, 20);
        this.textValorCH.setBounds(90, 405, 75, 20);
        this.labelValorCH.setBounds(5, 400, 100, 30);
        this.scrollPanelCBHPM = new JScrollPane(this.tableModificacoesCBHPM);
        this.scrollPanelCBHPM.setBounds(5, 30, 624, 320);
        this.scrollPanelCH = new JScrollPane(this.tableModificacoesCH);
        this.scrollPanelCH.setBounds(5, 30, 624, 320);
        this.painelCentral.add(this.scrollPanel);
        this.painelCentral.add(this.scrollPanelCH);
        this.painelCentral.add(this.scrollPanelCBHPM);
        this.painelCentral.add(this.labelCodigoAMB);
        this.painelCentral.add(this.labelColunaArquivos);
        this.painelCentral.add(this.labelCusto);
        this.painelCentral.add(this.labelLinhasImportadas);
        this.painelCentral.add(this.labelPercentual);
        this.painelCentral.add(this.labelPorte);
        this.painelCentral.add(this.labelValorCH);
        this.painelCentral.add(this.textCodigoAMB);
        this.painelCentral.add(this.textCustos);
        this.painelCentral.add(this.textLinhasImportadas);
        this.painelCentral.add(this.textPercentual);
        this.painelCentral.add(this.textPorte);
        this.painelCentral.add(this.textValorCH);
        this.painelCentral.add(this.labelDadosImportados);
        this.painelBotoes.add(this.buttonCancelar);
        this.painelBotoes.add(this.buttonAnterior);
        this.painelBotoes.add(this.buttonProximo);
        this.visualizarPrimeiroPasso();
        this.buttonAnterior.setEnabled(false);
        this.buttonProximo.setEnabled(false);
        this.passoAtivo = 1;
        Funcoes.criaBarraDescricao(this, "Importa\u00e7\u00e3o da Tabela de Pre\u00e7os", "Configura\u00e7\u00e3o para importa\u00e7\u00e3o da tabela de pre\u00e7os de exames", "cadastros/cad_tab_preco.jpg");
        this.buttonBuscaArquivos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssistenteImportacaoTabelaPreco.this.getArquivoParaImportacao();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssistenteImportacaoTabelaPreco.this.passoAtivo = 0;
                AssistenteImportacaoTabelaPreco.this.setVisible(false);
                AssistenteImportacaoTabelaPreco.this.modalAssistenteImportacaoTabelaPreco.setVisible(false);
                AssistenteImportacaoTabelaPreco.this.examesAtualizados = new ArrayList();
            }
        });
        this.buttonProximo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AssistenteImportacaoTabelaPreco.this.passoAtivo == 2) {
                    AssistenteImportacaoTabelaPreco.this.buttonProximo.setText("Pr\u00f3ximo");
                    if (Funcoes.textoVazio(AssistenteImportacaoTabelaPreco.this.textCodigoAMB.getText()) || Funcoes.textoVazio(AssistenteImportacaoTabelaPreco.this.textLinhasImportadas.getText()) || !AssistenteImportacaoTabelaPreco.this.isTabelaCBHPM && Funcoes.textoVazio(AssistenteImportacaoTabelaPreco.this.textValorCH.getText()) || AssistenteImportacaoTabelaPreco.this.isTabelaCBHPM && (Funcoes.textoVazio(AssistenteImportacaoTabelaPreco.this.textCustos.getText()) || Funcoes.textoVazio(AssistenteImportacaoTabelaPreco.this.textPercentual.getText()) || Funcoes.textoVazio(AssistenteImportacaoTabelaPreco.this.textPorte.getText()))) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Deve ser informado todos os dados solicitados!", 2);
                    } else {
                        AssistenteImportacaoTabelaPreco.this.passoAtivo++;
                        AssistenteImportacaoTabelaPreco.this.habilitarVisualizacaoPassos();
                    }
                } else if (AssistenteImportacaoTabelaPreco.this.passoAtivo == 3) {
                    if (AssistenteImportacaoTabelaPreco.this.examesAtualizados.stream().anyMatch(a -> !Funcoes.textoVazio(a.getPorteAtual()) && !Funcoes.textoVazio(a.getPorteNovo()) && a.getPorteAtual().equalsIgnoreCase(a.getPorteNovo()))) {
                        if (Funcoes.mensagem(Laboratorio.getInstancia(), "Existem valores com o porte diferente do atual. Deseja atualizar mesmo assim? ", 4) == 0) {
                            AssistenteImportacaoTabelaPreco.this.setVisible(false);
                            AssistenteImportacaoTabelaPreco.this.modalAssistenteImportacaoTabelaPreco.setVisible(false);
                        }
                    } else {
                        AssistenteImportacaoTabelaPreco.this.setVisible(false);
                        AssistenteImportacaoTabelaPreco.this.modalAssistenteImportacaoTabelaPreco.setVisible(false);
                    }
                } else {
                    AssistenteImportacaoTabelaPreco.this.passoAtivo++;
                    AssistenteImportacaoTabelaPreco.this.habilitarVisualizacaoPassos();
                }
            }
        });
        this.buttonAnterior.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssistenteImportacaoTabelaPreco.this.passoAtivo--;
                AssistenteImportacaoTabelaPreco.this.habilitarVisualizacaoPassos();
            }
        });
    }

    private void habilitarVisualizacaoPassos() {
        if (this.passoAtivo == 1) {
            this.visualizarPrimeiroPasso();
        } else if (this.passoAtivo == 2) {
            this.visualizarSegundoPasso();
        } else if (this.passoAtivo == 3) {
            this.visualizarTerceiroPasso();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getArquivoParaImportacao() {
        JFileChooser chooser = new JFileChooser();
        String extensaoXLS = "Arquivo XLS (.xls)";
        String extensaoXLSX = "Arquivo XLSX (.xlsx)";
        String nomeArquivo = "";
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter(extensaoXLSX, "xlsx"));
        chooser.setFileFilter(ComponenteFactory.novoFileFilter(extensaoXLS, "xls"));
        chooser.setFileSelectionMode(0);
        if (chooser.showSaveDialog(chooser) == 0) {
            SplashMensagem splash = SplashMensagem.getInstancia(this.getTopLevelAncestor());
            splash.mostrar("Aguarde... validando as colunas existentes no arquivo...");
            String extensao = chooser.getFileFilter().getDescription().equals(extensaoXLS) ? ".xls" : ".xlsx";
            nomeArquivo = chooser.getSelectedFile().getAbsolutePath();
            this.textArquivo.setText(nomeArquivo);
            File file = new File(chooser.getSelectedFile().getPath());
            try {
                List<List<Object>> xls;
                List<List<Object>> list = xls = extensao.equalsIgnoreCase(".xlsx") ? Excel.lerXlsxAt(file, 0, true) : Excel.lerAt(file, 0);
                if (this.validaQuantidadeColunas(xls)) {
                    int[] tamanho = new int[1];
                    for (int i = 0; i < xls.size(); ++i) {
                        if (i == 0) {
                            this.modelo = new ModeloGridTable(this.getCabecalho(xls.get(i).size()));
                            tamanho = this.getTamanhoColunas(xls.get(i).size());
                        }
                        Object[] valores = new String[xls.get(i).size() + 1];
                        valores[0] = String.valueOf(i);
                        for (int j = 0; j < xls.get(i).size(); ++j) {
                            String valor = xls.get(i).get(j).toString();
                            valores[j + 1] = valor;
                        }
                        this.modelo.addLine(valores);
                    }
                    this.tableTabelaPreco.setModel(this.modelo);
                    this.modelo.setColumnSize(tamanho, this.tableTabelaPreco);
                    this.buttonProximo.setEnabled(true);
                }
            }
            catch (NullPointerException n) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel importar o arquivo informado, verifique as linhas e valores informados nas c\u00e9lulas.\nPode ser necess\u00e1rio criar um novo arquivo.", 2);
            }
            catch (Exception ex) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Falha ao importar o arquivo.\nMensagem: " + ex.getMessage(), 2);
            }
            finally {
                splash.apagar();
            }
        }
    }

    private boolean validaQuantidadeColunas(List<List<Object>> tabela) {
        int colunas = 0;
        for (int i = 0; i < tabela.size(); ++i) {
            if (colunas == 0) {
                colunas = tabela.get(i).size();
            }
            if (colunas == tabela.get(i).size()) continue;
            Funcoes.mensagem(null, "Valores inv\u00e1lidos para importa\u00e7\u00e3o!", 2);
            return false;
        }
        return true;
    }

    private int[] getTamanhoColunas(int size) {
        int[] tamanho = new int[size + 1];
        tamanho[0] = 50;
        for (int i = 0; i < size; ++i) {
            tamanho[i + 1] = 0;
        }
        return tamanho;
    }

    private void visualizarPrimeiroPasso() {
        this.setVisibleElementosPrimeiroPasso(true);
        this.setVisibleElementosSegundoPasso(false);
        this.setVisibleElementosTerceiroPasso(false);
    }

    private void visualizarSegundoPasso() {
        this.setVisibleElementosPrimeiroPasso(false);
        this.setVisibleElementosSegundoPasso(true);
        this.setVisibleElementosTerceiroPasso(false);
    }

    private void visualizarTerceiroPasso() {
        int colunaCH;
        SplashMensagem splash = SplashMensagem.getInstancia(this.getTopLevelAncestor());
        splash.mostrar("Aguarde a importa\u00e7\u00e3o das colunas...");
        int qtdeColunas = this.modelo.getColumnCount();
        int colunaAMB = Funcoes.getPosicaoAlfabeto(this.textCodigoAMB.getText().charAt(0)) + 1;
        int colunaCustos = this.isTabelaCBHPM ? Funcoes.getPosicaoAlfabeto(this.textCustos.getText().charAt(0)) + 1 : -1;
        int colunaPercentual = this.isTabelaCBHPM ? Funcoes.getPosicaoAlfabeto(this.textPercentual.getText().charAt(0)) + 1 : -1;
        int colunaPorte = this.isTabelaCBHPM ? Funcoes.getPosicaoAlfabeto(this.textPorte.getText().charAt(0)) + 1 : -1;
        int n = colunaCH = !this.isTabelaCBHPM ? Funcoes.getPosicaoAlfabeto(this.textValorCH.getText().charAt(0)) + 1 : -1;
        if (this.isTabelaCBHPM && (colunaAMB == 0 || colunaAMB + 1 > qtdeColunas || colunaCustos == 0 || colunaCustos > qtdeColunas || colunaPercentual == 0 || colunaPercentual > qtdeColunas || colunaPorte == 0 || colunaPorte > qtdeColunas) || !this.isTabelaCBHPM && (colunaAMB == 0 || colunaAMB + 1 > qtdeColunas || colunaCH == 0 || colunaCH + 1 > qtdeColunas) || Integer.valueOf(this.textLinhasImportadas.getText()) > this.modelo.getRowCount()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Colunas selecionadas inv\u00e1lidas", 2);
            splash.apagar();
            --this.passoAtivo;
        } else {
            this.setVisibleElementosPrimeiroPasso(false);
            this.setVisibleElementosSegundoPasso(false);
            this.setVisibleElementosTerceiroPasso(true);
            List<TabelaPrecoExame> examesConfigurados = AssistenteImportacaoTabelaPrecoDao.getExamesConfigurados(this.filial, this.tabelaPreco);
            this.examesAtualizados = new ArrayList<TabelaPrecoExame>();
            if (this.isTabelaCBHPM) {
                Map<String, Double> valoresPorte = AssistenteImportacaoTabelaPrecoDao.getValoresPorte(this.filial, this.tabelaPreco);
                this.dadosAImportarCBHPM(examesConfigurados, valoresPorte);
            } else {
                this.dadosAImportarCH(examesConfigurados);
            }
            splash.apagar();
            this.setVisibleElementosTerceiroPasso(true);
        }
    }

    private void dadosAImportarCH(List<TabelaPrecoExame> examesConfigurados) {
        int i;
        this.modeloModificacoesCH.setColumnSize(new int[]{70, 50, 200, 90, 75, 75}, this.tableModificacoesCH);
        this.tableModificacoesCH.setAutoResizeMode(0);
        int colunaAMB = Funcoes.getPosicaoAlfabeto(this.textCodigoAMB.getText().charAt(0)) + 1;
        int colunaValorCH = Funcoes.getPosicaoAlfabeto(this.textValorCH.getText().charAt(0)) + 1;
        boolean numericoNao = false;
        for (i = Integer.valueOf(this.textLinhasImportadas.getText()).intValue(); i < this.tableTabelaPreco.getRowCount(); ++i) {
            String valorCH = this.modelo.getValueAt(i, colunaValorCH).toString();
            if (StringUtil.validaNumero(valorCH)) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), "Coluna de Valor deve ser num\u00e9rica", 2);
            numericoNao = true;
            break;
        }
        if (!numericoNao) {
            examesConfigurados.stream().filter(a -> Funcoes.textoVazio(a.getCodigoAmb())).forEach(semAMB -> this.modeloModificacoesCH.addLine(new Object[]{semAMB.getCodigoExame(), semAMB.getAbreviacaoMaterial(), semAMB.getDescricaoExame(), "", Funcoes.formataDecimal(semAMB.getValorCHAtual()), Funcoes.formataDecimal(semAMB.getValorCHNovo())}));
            for (i = Integer.valueOf(this.textLinhasImportadas.getText()).intValue(); i < this.tableTabelaPreco.getRowCount(); ++i) {
                String codigoAMBArquivo = this.removeMascaraAMB(this.modelo.getValueAt(i, colunaAMB).toString());
                String valorCH = this.modelo.getValueAt(i, colunaValorCH).toString();
                if (Funcoes.textoVazio(codigoAMBArquivo) || Funcoes.textoVazio(valorCH)) continue;
                List examesSalvosAMB = examesConfigurados.stream().filter(a -> a.getCodigoAmb() != null && this.removeMascaraAMB(a.getCodigoAmb()).equalsIgnoreCase(codigoAMBArquivo)).collect(Collectors.toList());
                for (TabelaPrecoExame salvos : examesSalvosAMB) {
                    salvos.setValorCHNovo(new Double(valorCH));
                    this.examesAtualizados.add(salvos);
                    this.modeloModificacoesCH.addLine(new Object[]{salvos.getCodigoExame(), salvos.getAbreviacaoMaterial(), salvos.getDescricaoExame(), salvos.getCodigoAmb(), Funcoes.formataDecimal(salvos.getValorCHAtual()), Funcoes.formataDecimal(salvos.getValorCHNovo())});
                }
            }
        }
    }

    public List<TabelaPrecoExame> getExamesAtualizados() {
        return this.examesAtualizados;
    }

    private void dadosAImportarCBHPM(List<TabelaPrecoExame> examesConfigurados, Map<String, Double> valoresPorte) {
        int i;
        int colunaAMB = Funcoes.getPosicaoAlfabeto(this.textCodigoAMB.getText().charAt(0)) + 1;
        int colunaCustos = Funcoes.getPosicaoAlfabeto(this.textCustos.getText().charAt(0)) + 1;
        int colunaPercentual = Funcoes.getPosicaoAlfabeto(this.textPercentual.getText().charAt(0)) + 1;
        int colunaPorte = Funcoes.getPosicaoAlfabeto(this.textPorte.getText().charAt(0)) + 1;
        this.modeloModificacoesCBHPM.setColumnSize(new int[]{70, 50, 180, 90, 50, 50, 80, 80, 80, 80, 80, 80}, this.tableModificacoesCBHPM);
        this.tableModificacoesCBHPM.setAutoResizeMode(0);
        examesConfigurados.stream().filter(a -> Funcoes.textoVazio(a.getCodigoAmb())).forEach(semAMB -> {
            this.modeloModificacoesCBHPM.addLine(new Object[]{semAMB.getCodigoExame(), semAMB.getAbreviacaoMaterial(), semAMB.getDescricaoExame(), "", Funcoes.formataDecimal(semAMB.getPercentualAtual()), Funcoes.formataDecimal(semAMB.getPercentualNovo()), semAMB.getPorteAtual(), semAMB.getPorteNovo(), Funcoes.formataDecimal(semAMB.getCustoAtual()), Funcoes.formataDecimal(semAMB.getCustoNovo()), Funcoes.formataDecimal(semAMB.getTotalAtual()), Funcoes.formataDecimal(semAMB.getTotalNovo())});
            this.examesAtualizados.add((TabelaPrecoExame)semAMB);
        });
        boolean numericoNao = false;
        for (i = Integer.valueOf(this.textLinhasImportadas.getText()).intValue(); i < this.tableTabelaPreco.getRowCount(); ++i) {
            String valorCH = this.modelo.getValueAt(i, colunaCustos).toString();
            if (StringUtil.validaNumero(valorCH)) continue;
            Funcoes.mensagem(Laboratorio.getInstancia(), "Coluna de Valor deve ser num\u00e9rica", 2);
            numericoNao = true;
        }
        if (!numericoNao) {
            for (i = Integer.valueOf(this.textLinhasImportadas.getText()).intValue(); i < this.tableTabelaPreco.getRowCount(); ++i) {
                String codigoAMBArquivo = this.removeMascaraAMB(this.modelo.getValueAt(i, colunaAMB).toString());
                String valorCusto = this.modelo.getValueAt(i, colunaCustos).toString();
                String valorPercentual = this.modelo.getValueAt(i, colunaPercentual).toString();
                String porte = this.modelo.getValueAt(i, colunaPorte).toString();
                if (Funcoes.textoVazio(codigoAMBArquivo) || Funcoes.textoVazio(valorCusto) || Funcoes.textoVazio(valorPercentual) || Funcoes.textoVazio(porte) || !valoresPorte.containsKey(porte)) continue;
                List examesSalvosAMB = examesConfigurados.stream().filter(a -> this.removeMascaraAMB(a.getCodigoAmb()).equalsIgnoreCase(codigoAMBArquivo)).collect(Collectors.toList());
                for (TabelaPrecoExame salvos : examesSalvosAMB) {
                    salvos.setCustoNovo(Double.valueOf(valorCusto));
                    salvos.setPercentualNovo(Double.valueOf(valorPercentual));
                    salvos.setPorteNovo(porte);
                    salvos.setValorPorteNovo(valoresPorte.get(porte));
                    PorteTabelaCBHPM p = new PorteTabelaCBHPM(salvos.getPorteNovo(), salvos.getValorPorteNovo());
                    salvos.setTotalNovo(TabelaPrecoUtil.calculaTotalExameTipoCBHPM(String.valueOf(salvos.getPercentualNovo()), String.valueOf(salvos.getCustoNovo()), String.valueOf(salvos.getValorUCO()), p));
                    this.examesAtualizados.add(salvos);
                    this.modeloModificacoesCBHPM.addLine(new Object[]{salvos.getCodigoExame(), salvos.getAbreviacaoMaterial(), salvos.getDescricaoExame(), salvos.getCodigoAmb(), Funcoes.formataDecimal(salvos.getPercentualAtual()), Funcoes.formataDecimal(salvos.getPercentualNovo()), salvos.getPorteAtual(), salvos.getPorteNovo(), Funcoes.formataDecimal(salvos.getCustoAtual()), Funcoes.formataDecimal(salvos.getCustoNovo()), Funcoes.formataDecimal(salvos.getTotalAtual()), Funcoes.formataDecimal(salvos.getTotalNovo())});
                }
            }
        }
        this.tableModificacoesCBHPM.setModel(this.modeloModificacoesCBHPM);
    }

    private String removeMascaraAMB(String codigo) {
        return codigo.replace(".", "").replace("-", "");
    }

    private void setVisibleElementosTerceiroPasso(boolean visible) {
        if (this.passoAtivo == 3) {
            this.buttonProximo.setText("Importar");
            this.buttonAnterior.setEnabled(true);
        }
        if (!this.isTabelaCBHPM) {
            this.scrollPanelCBHPM.setVisible(false);
            this.scrollPanelCH.setVisible(visible);
            this.tableModificacoesCBHPM.setVisible(false);
            this.tableModificacoesCH.setVisible(visible);
            this.scrollPanelCH.setBounds(5, 30, 624, 420);
        } else {
            this.scrollPanelCBHPM.setVisible(visible);
            this.scrollPanelCH.setVisible(false);
            this.tableModificacoesCBHPM.setVisible(visible);
            this.tableModificacoesCH.setVisible(false);
            this.scrollPanelCBHPM.setBounds(5, 30, 624, 420);
        }
    }

    private void setVisibleElementosPrimeiroPasso(boolean visible) {
        if (this.passoAtivo == 1) {
            this.buttonProximo.setText("Pr\u00f3ximo");
        }
        this.textArquivo.setVisible(visible);
        this.buttonBuscaArquivos.setVisible(visible);
        this.comp.setVisible(visible);
        this.labelArquivo.setVisible(visible);
    }

    private void setVisibleElementosSegundoPasso(boolean visible) {
        if (this.passoAtivo == 2) {
            this.buttonProximo.setText("Pr\u00f3ximo");
            this.buttonAnterior.setEnabled(true);
        }
        this.scrollPanel.setVisible(visible);
        this.buttonAnterior.setEnabled(visible);
        this.tableTabelaPreco.setVisible(visible);
        this.labelColunaArquivos.setVisible(visible);
        this.labelCodigoAMB.setVisible(visible);
        this.labelColunaArquivos.setVisible(visible);
        this.textCodigoAMB.setVisible(visible);
        this.textLinhasImportadas.setVisible(visible);
        this.labelLinhasImportadas.setVisible(visible);
        this.textLinhasImportadas.setVisible(visible);
        this.labelDadosImportados.setVisible(visible);
        if (!this.isTabelaCBHPM) {
            this.textValorCH.setVisible(visible);
            this.labelValorCH.setVisible(visible);
            this.labelCusto.setVisible(false);
            this.labelPercentual.setVisible(false);
            this.labelPorte.setVisible(false);
            this.textCustos.setVisible(false);
            this.textPercentual.setVisible(false);
            this.textPorte.setVisible(false);
        } else {
            this.labelCusto.setVisible(visible);
            this.labelPercentual.setVisible(visible);
            this.labelPorte.setVisible(visible);
            this.textCustos.setVisible(visible);
            this.textPercentual.setVisible(visible);
            this.textPorte.setVisible(visible);
            this.textValorCH.setVisible(false);
            this.labelValorCH.setVisible(false);
        }
    }

    private String[] getCabecalho(int size) {
        String[] cabecalho = new String[size + 1];
        cabecalho[0] = " ";
        char[] copyOfRangeAlfabeto = Arrays.copyOfRange(Funcoes.alfabeto, 0, size);
        for (int i = 0; i < copyOfRangeAlfabeto.length; ++i) {
            cabecalho[i + 1] = String.valueOf(copyOfRangeAlfabeto[i]);
        }
        return cabecalho;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

