/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.tabelaPreco;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class AssistenteExportacaoTabelaPrecoDao {
    private String filial;
    private String codigoTabela;
    private boolean isCBHPM;
    private boolean ignorarExameBloq;

    public AssistenteExportacaoTabelaPrecoDao(String filial, String tabelaPreco, boolean isCBHPM, boolean ignorarExameBloq) {
        this.filial = filial;
        this.codigoTabela = tabelaPreco;
        this.isCBHPM = isCBHPM;
        this.ignorarExameBloq = ignorarExameBloq;
    }

    protected List<Registro> pegaDadosTabelaPreco() {
        ArrayList<Registro> retornoRs = new ArrayList<Registro>();
        boolean isPrecoMetodologia = ParametrosGerais.getPrecoMetodologia();
        StringBuilder sql = new StringBuilder();
        sql.append("select d.exa_codigo as codigoExame, m.mco_abreviatura as codigoMaterial, e.exa_descricao as descricaoExame, ");
        if (this.isCBHPM) {
            if (isPrecoMetodologia) {
                sql.append("d.dtm_codamb as codigoAMB, d.dtm_valor as valorExame, d.dtm_percentual as percentual, d.tpp_porte as porte, p.tpp_valor as valorPorte, d.dtm_valor as custo, t.tpe_uco as uco ");
                sql.append("from detalhetabelaprecometodologia d ");
                sql.append("inner join tabelaprecoexames t on d.fil_codigo = t.fil_codigo and d.tpe_codigo = t.tpe_codigo ");
                sql.append("left join tabelaprecoexamesporte p on d.fil_codigo = p.fil_codigo and d.tpe_codigo = p.tpe_codigo and d.tpp_porte = p.tpp_porte ");
            } else {
                sql.append("d.dtp_codamb as codigoAMB, d.dtp_valor as valorExame, d.dtp_percentual as percentual, d.tpp_porte as porte, p.tpp_valor as valorPorte, d.dtp_valor as custo, t.tpe_uco as uco ");
                sql.append("from detalhetabelapreco d ");
                sql.append("inner join tabelaprecoexames t on d.fil_codigo = t.fil_codigo and d.tpe_codigo = t.tpe_codigo ");
                sql.append("left join tabelaprecoexamesporte p on d.fil_codigo = p.fil_codigo and d.tpe_codigo = p.tpe_codigo and d.tpp_porte = p.tpp_porte ");
            }
        } else if (isPrecoMetodologia) {
            sql.append("dtm_codamb as codigoAMB, d.dtm_valor as valorExame ");
            sql.append("from detalhetabelaprecometodologia d ");
        } else {
            sql.append("dtp_codamb as codigoAMB, d.dtp_valor as valorExame ");
            sql.append("from detalhetabelapreco d ");
        }
        sql.append(" inner join exames e on d.fil_codigo = e.fil_codigo and d.exa_codigo = e.exa_codigo ");
        sql.append(" inner join materialcoleta m on d.fil_codigo = m.fil_codigo and d.mco_codigo = m.mco_codigo ");
        sql.append(" inner join examematcoleta c on e.fil_codigo = c.fil_codigo and e.exa_codigo = c.exa_codigo and m.mco_codigo = c.mco_codigo ");
        sql.append(" where d.fil_codigo = ").append(this.filial);
        sql.append(" and d.tpe_codigo = ").append(this.codigoTabela);
        if (this.ignorarExameBloq) {
            sql.append(" and e.exa_proibido = false ");
            sql.append(" and c.emc_proibido = false ");
            if (isPrecoMetodologia) {
                sql.append(" and d.dtm_proibido = false ");
            } else {
                sql.append(" and d.dtp_proibido = false ");
            }
        }
        sql.append(" order by d.exa_codigo");
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                retornoRs.add(new Registro(rs));
            }
            st.close();
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retornoRs;
    }
}

