/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.tabelaPreco;

import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.tabelaPreco.AssistenteExportacaoTabelaPrecoDao;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.excel.EscreverArquivoXls;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AssistenteExportacaoTabelaPreco
extends FrmPadrao
implements ActionListener {
    private JDialog modalAssistenteExportacaoTabelaPreco;
    private JLabel comp = new JLabel(" Bem-vindo ao assistente para exporta\u00e7\u00e3o da tabela de pre\u00e7os de exames: ");
    private JPanel painelBotoes = new JPanel(new FlowLayout(2));
    private JLabel labelLocalArquivo = new JLabel("Informe o local e o nome do arquivo: ");
    private JTextField textDiretorioExportacao = new JTextField();
    private JButton buttonBuscaDiretorio = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JPanel painelCentral = new JPanel(null);
    private JCheckBox checkIgnorarExamesBloq = new JCheckBox("Ignorar exames bloqueados");
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'e', this);
    private boolean isTabelaCBHPM = false;
    private String tabelaPreco;
    private String filial;

    public AssistenteExportacaoTabelaPreco(JDialog modalAssistenteImportacaoTabelaPreco, boolean isTabelaCBHPM, String filial, String tabelaPreco) {
        this.isTabelaCBHPM = isTabelaCBHPM;
        this.filial = filial;
        this.tabelaPreco = tabelaPreco;
        this.modalAssistenteExportacaoTabelaPreco = modalAssistenteImportacaoTabelaPreco;
        this.montarTela();
    }

    public static AssistenteExportacaoTabelaPreco novaInstancia(JDialog modalAssistenteImportacaoTabelaPreco, boolean isTabelaCBHPM, String filial, String tabelaPreco) {
        return new AssistenteExportacaoTabelaPreco(modalAssistenteImportacaoTabelaPreco, isTabelaCBHPM, filial, tabelaPreco);
    }

    private void montarTela() {
        this.setLayout(new BorderLayout());
        this.painelCentral.setFocusable(false);
        this.painelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)this.painelCentral, "Center");
        this.add((Component)this.painelBotoes, "South");
        this.comp.setBounds(5, 25, 800, 20);
        this.labelLocalArquivo.setBounds(5, 190, 800, 20);
        this.textDiretorioExportacao.setBounds(5, 215, 550, 20);
        this.buttonBuscaDiretorio.setBounds(555, 215, 25, 20);
        this.checkIgnorarExamesBloq.setBounds(2, 235, 250, 20);
        Funcoes.criaBarraDescricao(this, "Exporta\u00e7\u00e3o da Tabela de Pre\u00e7os", "Configura\u00e7\u00e3o para exporta\u00e7\u00e3o da tabela de pre\u00e7os de exames", "cadastros/cad_tab_preco.jpg");
        this.painelCentral.add(this.comp);
        this.painelCentral.add(this.labelLocalArquivo);
        this.painelCentral.add(this.textDiretorioExportacao);
        this.painelCentral.add(this.buttonBuscaDiretorio);
        this.painelCentral.add(this.checkIgnorarExamesBloq);
        this.painelBotoes.add(this.buttonExportar);
        this.painelBotoes.add(this.buttonCancelar);
        this.textDiretorioExportacao.setEditable(false);
        if (Funcoes.textoVazio(this.textDiretorioExportacao.getText())) {
            this.buttonExportar.setEnabled(false);
        }
        this.buttonBuscaDiretorio.addActionListener(action -> this.getCaminhoExportacao());
        this.buttonExportar.addActionListener(action -> this.exportarExcel(this.isTabelaCBHPM));
        this.buttonCancelar.addActionListener(action -> {
            this.setVisible(false);
            this.modalAssistenteExportacaoTabelaPreco.setVisible(false);
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void getCaminhoExportacao() {
        JFileChooser chooser = new JFileChooser();
        String nomeArquivo = "";
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS (.xls)", "xls"));
        chooser.setFileSelectionMode(0);
        if (chooser.showSaveDialog(chooser) == 0) {
            boolean nomeArquivoContemExtensao = chooser.getSelectedFile().getName().contains(".xlsx") || chooser.getSelectedFile().getName().contains(".xls");
            StringBuilder caminhoNomeArquivo = new StringBuilder();
            caminhoNomeArquivo.append(chooser.getCurrentDirectory().getPath() + "\\" + chooser.getSelectedFile().getName());
            caminhoNomeArquivo.append(nomeArquivoContemExtensao ? "" : ".xls");
            this.textDiretorioExportacao.setText(caminhoNomeArquivo.toString());
            if (!Funcoes.textoVazio(caminhoNomeArquivo.toString())) {
                this.buttonExportar.setEnabled(true);
            }
        }
    }

    private void exportarExcel(Boolean isTabelaCBHPM) {
        SplashMensagem splash = SplashMensagem.getInstancia(this.getTopLevelAncestor());
        splash.mostrar("Aguarde... o arquivo est\u00e1 sendo gerado...");
        AssistenteExportacaoTabelaPrecoDao assistenteExportacaoTabelaPrecoDao = new AssistenteExportacaoTabelaPrecoDao(this.filial, this.tabelaPreco, isTabelaCBHPM, this.checkIgnorarExamesBloq.isSelected());
        List<Registro> resultSetTabelaPreco = assistenteExportacaoTabelaPrecoDao.pegaDadosTabelaPreco();
        EscreverArquivoXls xls = new EscreverArquivoXls();
        try {
            int plan = xls.addAba("Planilha 1");
            int linha = 0;
            if (!resultSetTabelaPreco.isEmpty()) {
                Object[] cabecalho = null;
                cabecalho = isTabelaCBHPM != false ? new Object[]{"Codigo Exame", "Codigo Material", "Descricao Exame", "Codigo AMB", "Percentual (%)", "Porte", "Custo", "Valor Exame"} : new Object[]{"Codigo Exame", "Codigo Material", "Descricao Exame", "Codigo AMB", "Valor"};
                xls.setLinha(plan, linha++, cabecalho);
                for (Registro reg : resultSetTabelaPreco) {
                    Object[] cel = null;
                    cel = isTabelaCBHPM != false ? new Object[]{reg.getValor("codigoexame"), reg.getValor("codigomaterial"), reg.getValor("descricaoexame"), reg.getValor("codigoamb"), reg.getDouble("percentual"), reg.getValor("porte"), reg.getDouble("custo"), this.calculaValorTotal(reg.getString("percentual"), reg.getString("custo"), reg.getString("uco"), reg.getString("porte"), reg.getDouble("valorporte"))} : new Object[]{reg.getValor("codigoexame"), reg.getValor("codigomaterial"), reg.getValor("descricaoexame"), reg.getValor("codigoamb"), reg.getDouble("valorexame")};
                    xls.setLinha(plan, linha++, cel);
                }
                xls.escreverArquivo(this.textDiretorioExportacao.getText());
                splash.apagar();
                Funcoes.mensagem(null, "Tabela de pre\u00e7os exportada com sucesso! \n Caminho: " + this.textDiretorioExportacao.getText(), 5);
                this.setVisible(false);
                this.modalAssistenteExportacaoTabelaPreco.setVisible(false);
            }
        }
        catch (Exception e) {
            splash.apagar();
            Funcoes.mensagem(null, "Erro ao realizar exporta\u00e7\u00e3o da tabela de pre\u00e7o!", 1);
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private Double calculaValorTotal(String percentual, String custo, String uco, String porte, double valorPorte) {
        double valorTotal = 0.0;
        PorteTabelaCBHPM p = new PorteTabelaCBHPM(porte, valorPorte);
        valorTotal = TabelaPrecoUtil.calculaTotalExameTipoCBHPM(percentual, custo, uco, p);
        return valorTotal;
    }
}

