/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.layout;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.layout.AcaoButtonConfiguracaoListener;
import jalis.laboratorio.cadastro.layout.ButtonConfiguracao;
import jalis.laboratorio.cadastro.layout.TiposImpressao;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirTermoConsentimento;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.dao.cadastro.auxiliares.FilialDao;
import jalis.relatorio.Editor;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.impressao.matricial.EditorMapa;
import jalis.util.impressao.matricial.EditorRelatorio;
import jalis.util.impressao.termica.EditorTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Layout
extends FrmCadPadrao
implements AcaoButtonConfiguracaoListener {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JLabel jLabel1 = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtDescricao = new TTextField(80);
    private JLabel jLabel2 = new JLabel("Descri\u00e7\u00e3o:");
    private ButtonConfiguracao configuracaoLaudo = new ButtonConfiguracao("Laudo", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoCapaLaudo = new ButtonConfiguracao("Capa de Laudo", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoMapa = new ButtonConfiguracao("Mapa", TiposImpressao.GRAFICA, TiposImpressao.DIRETA);
    private ButtonConfiguracao configuracaoComprovante = new ButtonConfiguracao("Comprovante", TiposImpressao.GRAFICA, TiposImpressao.DIRETA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoCarteira = new ButtonConfiguracao("Carteira", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoRecibo = new ButtonConfiguracao("Recibo", TiposImpressao.GRAFICA, TiposImpressao.DIRETA);
    private ButtonConfiguracao configuracaoOrcamento = new ButtonConfiguracao("Or\u00e7amento", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoEtqTriagem = new ButtonConfiguracao("Etiqueta de triagem", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoEtqColeta = new ButtonConfiguracao("Etiqueta de coleta", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoCapa = new ButtonConfiguracao("Capa", TiposImpressao.GRAFICA, TiposImpressao.DIRETA);
    private ButtonConfiguracao configuracaoAnexoFaturamento = new ButtonConfiguracao("Anexo de faturamento", TiposImpressao.GRAFICA, TiposImpressao.DIRETA);
    private ButtonConfiguracao configuracaoGeral = new ButtonConfiguracao("Geral", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoAtestadoPaciente = new ButtonConfiguracao("Atestado para paciente", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoAtestadoAcompanhante = new ButtonConfiguracao("Atestado para acompanhante", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoEtqApoio = new ButtonConfiguracao("Etiqueta de apoio", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoLaudoWeb = new ButtonConfiguracao("Laudo Web", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoEtiquetaMaterialEnviado = new ButtonConfiguracao("Etiqueta de material enviado", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoReciboMaterialEnviado = new ButtonConfiguracao("Recibo de material enviado", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoIdentificacaoEstante = new ButtonConfiguracao("Identifica\u00e7\u00e3o de estante", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoIdentificacaoTubo = new ButtonConfiguracao("Identifica\u00e7\u00e3o de tubo", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoEtiquetaLamina = new ButtonConfiguracao("Etiqueta de l\u00e2mina", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoAnexoCobranca = new ButtonConfiguracao("Anexo de cobran\u00e7a", TiposImpressao.GRAFICA, TiposImpressao.DIRETA);
    private ButtonConfiguracao configuracaoProposta = new ButtonConfiguracao("Proposta", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoRecepcaoAmostra = new ButtonConfiguracao("Recep\u00e7\u00e3o de amostras", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoEtiquetaEstoque = new ButtonConfiguracao("Etiqueta de estoque", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoDadosBrutos = new ButtonConfiguracao("Dados brutos", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoIncerteza = new ButtonConfiguracao("Incerteza", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoPesquisaFornecedor = new ButtonConfiguracao("Pesquisa de fornecedor", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoIdentificacaoColeta = new ButtonConfiguracao("Identifica\u00e7\u00e3o de coleta", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoEtiquetaLaudo = new ButtonConfiguracao("Etiqueta de laudo", TiposImpressao.GRAFICA, TiposImpressao.TERMICA);
    private ButtonConfiguracao configuracaoNotificacao = new ButtonConfiguracao("Notifica\u00e7\u00e3o", TiposImpressao.GRAFICA);
    private ButtonConfiguracao configuracaoTermoConsentimento = new ButtonConfiguracao("Termo de consentimento", TiposImpressao.GRAFICA);
    private String perguntasFilial = "";
    private boolean mapaAlterado = false;
    private boolean laudoAlterado = false;
    private boolean laudoWebAlterado = false;
    private boolean capaLaudoAlterada = false;
    private boolean comprovanteAlterado = false;
    private boolean carteiraAlterado = false;
    private boolean reciboAlterado = false;
    private boolean capaAlterado = false;
    private boolean anexoAlterado = false;
    private boolean orcamentoAlterado = false;
    private boolean etqTriAlterado = false;
    private boolean etqColAlterado = false;
    private boolean geralAlterado = false;
    private boolean atPacienteAlterado = false;
    private boolean atAcompanhaAlterado = false;
    private boolean etqApoioAlterado = false;
    private boolean etiquetaMaterialEnviadoAlterado = false;
    private boolean reciboMaterialEnviadoAlterado = false;
    private boolean identificacaoEstanteAlterado = false;
    private boolean identificacaoTuboAlterado = false;
    private boolean etiquetaLaminaAlterado = false;
    private boolean anexoCobrancaAlterado = false;
    private boolean propostaAlterado = false;
    private boolean recepcaoAmostraAlterado = false;
    private boolean etiquetaEstoqueAlterado = false;
    private boolean dadosBrutosAlterado = false;
    private boolean incertezaAlterada = false;
    private boolean pesquisaFornecedor = false;
    private boolean identificacaoColetaAlterada = false;
    private boolean etiquetaLaudoAlterada = false;
    private boolean notificacaoAlterado = false;
    private boolean termoConsentimentoAlterado = false;
    private String retornoParaPesquisa = null;
    private boolean isGerarPDFWeb = false;
    private final ImprimirTermoConsentimento imprimirTermoConsentimento = new ImprimirTermoConsentimento();

    public Layout() {
        try {
            FilialBean filial = (FilialBean)new FilialDao().getBean(Variaveis.filialPadrao);
            this.isGerarPDFWeb = filial.getEnviarPDFWeb() != false || filial.isResultadoStandalone() != false;
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Layout");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setLabelDescricao("Cadastro de modelos de cabe\u00e7alhos e rodap\u00e9 para impress\u00e3o no sistema");
        this.setLabelFormulario("Cadastro de modelos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_layout.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.txtDescricao.setText("");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.painelCentral.setLayout(this.grid);
        this.controlaCampos();
        this.montaTela();
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Layout.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder tmp = new StringBuilder();
                            tmp.append(" select a.lay_descricao ");
                            tmp.append("       ,a.lay_tipolaudo ");
                            tmp.append("       ,a.lay_tipomapa ");
                            tmp.append("       ,a.lay_tipocapa ");
                            tmp.append("       ,a.lay_capa ");
                            tmp.append("       ,a.lay_tipogeral ");
                            tmp.append("       ,a.lay_geral ");
                            tmp.append("       ,a.lay_tipoanexo ");
                            tmp.append("       ,a.lay_anexo ");
                            tmp.append("       ,a.lay_tipocomprovante ");
                            tmp.append("       ,a.lay_tipocarteira ");
                            tmp.append("       ,a.lay_tipoetqtri ");
                            tmp.append("       ,a.lay_tipoetqcol ");
                            tmp.append("       ,a.lay_etqtri ");
                            tmp.append("       ,a.lay_etqcol ");
                            tmp.append("       ,a.lay_tiporecibo ");
                            tmp.append("       ,a.lay_tipoorcamento ");
                            tmp.append("       ,a.lay_recibo ");
                            tmp.append("       ,a.lay_orcamento ");
                            tmp.append("       ,a.lay_cabec ");
                            tmp.append("       ,a.lay_comprovante ");
                            tmp.append("       ,a.lay_tipoatpaciente ");
                            tmp.append("       ,a.lay_tipoatacompanha ");
                            tmp.append("       ,a.lay_tipoetqapoio ");
                            tmp.append("       ,a.lay_atpaciente ");
                            tmp.append("       ,a.lay_atacompanha ");
                            tmp.append("       ,a.lay_etqapoio ");
                            tmp.append("       ,a.lay_carteira ");
                            tmp.append("       ,a.lay_cabecmapa ");
                            tmp.append("       ,b.fil_perguntas ");
                            tmp.append("       ,a.lay_tipolaudoweb ");
                            tmp.append("       ,a.lay_laudoweb ");
                            tmp.append("       ,a.lay_etiquetacaixa ");
                            tmp.append("       ,a.lay_tipoetiquetacaixa ");
                            tmp.append("       ,a.lay_recibocaixa ");
                            tmp.append("       ,a.lay_tiporecibocaixa ");
                            tmp.append("       ,a.lay_tipoetiquetasoroteca ");
                            tmp.append("       ,a.lay_etiquetasoroteca ");
                            tmp.append("       ,a.lay_tipoetiquetatubosoroteca ");
                            tmp.append("       ,a.lay_etiquetatubosoroteca ");
                            tmp.append("       ,a.lay_tipoetiquetalamina ");
                            tmp.append("       ,a.lay_etiquetalamina ");
                            tmp.append("       ,a.lay_tipoanexocobranca ");
                            tmp.append("       ,a.lay_anexocobranca ");
                            tmp.append("       ,a.lay_tipoproposta ");
                            tmp.append("       ,a.lay_proposta ");
                            tmp.append("       ,a.lay_tiporecepcaoamostra ");
                            tmp.append("       ,a.lay_recepcaoamostra ");
                            tmp.append("       ,a.lay_tipoetiquetaestoque ");
                            tmp.append("       ,a.lay_etiquetaestoque ");
                            tmp.append("       ,a.lay_tipodadosbrutos ");
                            tmp.append("       ,a.lay_dadosbrutos ");
                            tmp.append("       ,a.lay_tipoincerteza ");
                            tmp.append("       ,a.lay_incerteza ");
                            tmp.append("\t\t\t ,a.lay_pesquisafornecedor");
                            tmp.append("\t\t\t ,a.lay_tipopesquisafornecedor ");
                            tmp.append("\t\t\t ,a.lay_tipoidentificacaocoleta ");
                            tmp.append("       ,a.lay_identificacaocoleta ");
                            tmp.append("       ,a.lay_capalaudo ");
                            tmp.append("       ,a.lay_tipocapalaudo ");
                            tmp.append("       ,a.lay_tipoetiquetalaudo ");
                            tmp.append("       ,a.lay_etiquetalaudo ");
                            tmp.append("       ,a.lay_notificacao ");
                            tmp.append("       ,a.lay_tipotermoconsentimento ");
                            tmp.append("       ,a.lay_termoconsentimento ");
                            tmp.append("   from layout a ");
                            tmp.append("   left join filiais_postocoleta b on a.fil_codigo = b.fil_codigo ");
                            tmp.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
                            tmp.append("    and a.lay_codigo = ").append(Layout.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, tmp.toString());
                            if (rs != null && rs.next()) {
                                Layout.this.perguntasFilial = rs.getString("fil_perguntas");
                                Layout.this.txtDescricao.setText(rs.getString("lay_descricao"));
                                String tipo = rs.getString("lay_tipolaudo");
                                Layout.this.configuracaoLaudo.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_notificacao");
                                Layout.this.configuracaoNotificacao.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipocapalaudo");
                                Layout.this.configuracaoCapaLaudo.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipomapa");
                                Layout.this.configuracaoMapa.setTipoImpressaoSelecionado(tipo.equals("D") ? TiposImpressao.DIRETA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipocomprovante");
                                Layout.this.configuracaoComprovante.setTipoImpressaoSelecionado(tipo.equals("D") ? TiposImpressao.DIRETA : (tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA), false);
                                tipo = rs.getString("lay_tipocarteira");
                                Layout.this.configuracaoCarteira.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tiporecibo");
                                Layout.this.configuracaoRecibo.setTipoImpressaoSelecionado(tipo.equals("D") ? TiposImpressao.DIRETA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipocapa");
                                Layout.this.configuracaoCapa.setTipoImpressaoSelecionado(tipo.equals("D") ? TiposImpressao.DIRETA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoanexo");
                                Layout.this.configuracaoAnexoFaturamento.setTipoImpressaoSelecionado(tipo.equals("D") ? TiposImpressao.DIRETA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoanexocobranca");
                                Layout.this.configuracaoAnexoCobranca.setTipoImpressaoSelecionado(tipo.equals("D") ? TiposImpressao.DIRETA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoorcamento");
                                Layout.this.configuracaoOrcamento.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoetqtri");
                                Layout.this.configuracaoEtqTriagem.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoetqcol");
                                Layout.this.configuracaoEtqColeta.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipogeral");
                                Layout.this.configuracaoGeral.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoatpaciente");
                                Layout.this.configuracaoAtestadoPaciente.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoatacompanha");
                                Layout.this.configuracaoAtestadoAcompanhante.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoetqapoio");
                                Layout.this.configuracaoEtqApoio.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipolaudoweb");
                                Layout.this.configuracaoLaudoWeb.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = !DBUtil.campoNull(rs.getString("lay_tipoetiquetacaixa")) ? rs.getString("lay_tipoetiquetacaixa") : "T";
                                Layout.this.configuracaoEtiquetaMaterialEnviado.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = !DBUtil.campoNull(rs.getString("lay_tiporecibocaixa")) ? rs.getString("lay_tiporecibocaixa") : "C";
                                Layout.this.configuracaoReciboMaterialEnviado.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = !DBUtil.campoNull(rs.getString("lay_tipoetiquetasoroteca")) ? rs.getString("lay_tipoetiquetasoroteca") : "T";
                                Layout.this.configuracaoIdentificacaoEstante.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = !DBUtil.campoNull(rs.getString("lay_tipoetiquetatubosoroteca")) ? rs.getString("lay_tipoetiquetatubosoroteca") : "T";
                                Layout.this.configuracaoIdentificacaoTubo.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = !DBUtil.campoNull(rs.getString("lay_tipoetiquetalamina")) ? rs.getString("lay_tipoetiquetalamina") : "T";
                                Layout.this.configuracaoEtiquetaLamina.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoproposta");
                                Layout.this.configuracaoProposta.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tiporecepcaoamostra");
                                Layout.this.configuracaoRecepcaoAmostra.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoetiquetaestoque");
                                Layout.this.configuracaoEtiquetaEstoque.setTipoImpressaoSelecionado(tipo != null && tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipodadosbrutos");
                                Layout.this.configuracaoDadosBrutos.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoincerteza");
                                Layout.this.configuracaoIncerteza.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipopesquisafornecedor");
                                Layout.this.configuracaoPesquisaFornecedor.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipoidentificacaocoleta");
                                Layout.this.configuracaoIdentificacaoColeta.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                tipo = !DBUtil.campoNull(rs.getString("lay_tipoetiquetalaudo")) ? rs.getString("lay_tipoetiquetalaudo") : "T";
                                Layout.this.configuracaoEtiquetaLaudo.setTipoImpressaoSelecionado(tipo.equals("T") ? TiposImpressao.TERMICA : TiposImpressao.GRAFICA, false);
                                tipo = rs.getString("lay_tipotermoconsentimento");
                                Layout.this.configuracaoTermoConsentimento.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
                                Layout.this.configuracaoLaudo.setXmlConfiguracao(rs.getString("lay_cabec"));
                                Layout.this.configuracaoCapaLaudo.setXmlConfiguracao(rs.getString("lay_capalaudo"));
                                Layout.this.configuracaoNotificacao.setXmlConfiguracao(rs.getString("lay_notificacao"));
                                Layout.this.configuracaoMapa.setXmlConfiguracao(rs.getString("lay_cabecmapa"));
                                Layout.this.configuracaoComprovante.setXmlConfiguracao(rs.getString("lay_comprovante"));
                                Layout.this.configuracaoCarteira.setXmlConfiguracao(rs.getString("lay_carteira"));
                                Layout.this.configuracaoRecibo.setXmlConfiguracao(rs.getString("lay_recibo"));
                                Layout.this.configuracaoCapa.setXmlConfiguracao(rs.getString("lay_capa"));
                                Layout.this.configuracaoAnexoFaturamento.setXmlConfiguracao(rs.getString("lay_anexo"));
                                Layout.this.configuracaoOrcamento.setXmlConfiguracao(rs.getString("lay_orcamento"));
                                Layout.this.configuracaoEtqTriagem.setXmlConfiguracao(rs.getString("lay_etqtri"));
                                Layout.this.configuracaoEtqColeta.setXmlConfiguracao(rs.getString("lay_etqcol"));
                                Layout.this.configuracaoGeral.setXmlConfiguracao(rs.getString("lay_geral"));
                                Layout.this.configuracaoAtestadoPaciente.setXmlConfiguracao(rs.getString("lay_atpaciente"));
                                Layout.this.configuracaoAtestadoAcompanhante.setXmlConfiguracao(rs.getString("lay_atacompanha"));
                                Layout.this.configuracaoEtqApoio.setXmlConfiguracao(rs.getString("lay_etqapoio"));
                                Layout.this.configuracaoLaudoWeb.setXmlConfiguracao(rs.getString("lay_laudoweb"));
                                Layout.this.configuracaoEtiquetaMaterialEnviado.setXmlConfiguracao(rs.getString("lay_etiquetacaixa"));
                                Layout.this.configuracaoReciboMaterialEnviado.setXmlConfiguracao(rs.getString("lay_recibocaixa"));
                                Layout.this.configuracaoIdentificacaoEstante.setXmlConfiguracao(rs.getString("lay_etiquetasoroteca"));
                                Layout.this.configuracaoIdentificacaoTubo.setXmlConfiguracao(rs.getString("lay_etiquetatubosoroteca"));
                                Layout.this.configuracaoEtiquetaLamina.setXmlConfiguracao(rs.getString("lay_etiquetalamina"));
                                Layout.this.configuracaoAnexoCobranca.setXmlConfiguracao(rs.getString("lay_anexocobranca"));
                                Layout.this.configuracaoProposta.setXmlConfiguracao(rs.getString("lay_proposta"));
                                Layout.this.configuracaoRecepcaoAmostra.setXmlConfiguracao(rs.getString("lay_recepcaoamostra"));
                                Layout.this.configuracaoEtiquetaEstoque.setXmlConfiguracao(rs.getString("lay_etiquetaestoque"));
                                Layout.this.configuracaoDadosBrutos.setXmlConfiguracao(rs.getString("lay_dadosbrutos"));
                                Layout.this.configuracaoIncerteza.setXmlConfiguracao(rs.getString("lay_incerteza"));
                                Layout.this.configuracaoPesquisaFornecedor.setXmlConfiguracao(rs.getString("lay_pesquisafornecedor"));
                                Layout.this.configuracaoIdentificacaoColeta.setXmlConfiguracao(rs.getString("lay_identificacaocoleta"));
                                Layout.this.configuracaoEtiquetaLaudo.setXmlConfiguracao(rs.getString("lay_etiquetalaudo"));
                                Layout.this.configuracaoTermoConsentimento.setXmlConfiguracao(rs.getString("lay_termoconsentimento"));
                                if (!Funcoes.textoVazio(rs.getString("lay_tipotermoconsentimento")) && !Funcoes.textoVazio(rs.getString("lay_termoconsentimento"))) {
                                    Layout.this.configuracaoTermoConsentimento.setVisible(true);
                                }
                                if (Layout.this.getStatus() == 2) {
                                    Layout.this.setStatus(3);
                                }
                                Layout.this.txtCodigo.setEnabled(false);
                            } else if (Layout.this.getStatus() == 3) {
                                Funcoes.mensagem(Layout.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Layout.this.setStatus(1);
                                Layout.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Layout.this, sqlex.getMessage(), sqlex.getStackTrace(), "Layout");
                    }
                }
            }
        });
        this.configuracaoLaudo.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoCapaLaudo.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoNotificacao.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoMapa.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoComprovante.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoCarteira.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoRecibo.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoOrcamento.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtqTriagem.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtqColeta.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoCapa.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoAnexoFaturamento.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoGeral.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoAtestadoPaciente.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoAtestadoAcompanhante.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtqApoio.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoLaudoWeb.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtiquetaMaterialEnviado.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoReciboMaterialEnviado.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoIdentificacaoEstante.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoIdentificacaoTubo.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtiquetaLamina.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoAnexoCobranca.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoProposta.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoRecepcaoAmostra.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtiquetaEstoque.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoDadosBrutos.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoIncerteza.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoPesquisaFornecedor.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoIdentificacaoColeta.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoEtiquetaLaudo.adicionarAcaoButtonConfigurarListener(this);
        this.configuracaoTermoConsentimento.adicionarAcaoButtonConfigurarListener(this);
    }

    private void copiar(ButtonConfiguracao buttonConfiguracao) {
        Hashtable resultado = Pesquisas.layout(this.getTopLevelAncestor(), false);
        String codigo = "";
        if (resultado != null) {
            codigo = resultado.get("lay_codigo").toString();
        }
        if (codigo.trim().length() > 0) {
            Statement st = Conexao.getStatement();
            try {
                if (st != null) {
                    String campo = "lay_cabec";
                    if (buttonConfiguracao == this.configuracaoMapa) {
                        campo = "lay_cabecmapa";
                    } else if (buttonConfiguracao == this.configuracaoCapaLaudo) {
                        campo = "lay_capalaudo";
                    } else if (buttonConfiguracao == this.configuracaoComprovante) {
                        campo = "lay_comprovante";
                    } else if (buttonConfiguracao == this.configuracaoCarteira) {
                        campo = "lay_carteira";
                    } else if (buttonConfiguracao == this.configuracaoRecibo) {
                        campo = "lay_recibo";
                    } else if (buttonConfiguracao == this.configuracaoOrcamento) {
                        campo = "lay_orcamento";
                    } else if (buttonConfiguracao == this.configuracaoEtqTriagem) {
                        campo = "lay_etqtri";
                    } else if (buttonConfiguracao == this.configuracaoEtqColeta) {
                        campo = "lay_etqcol";
                    } else if (buttonConfiguracao == this.configuracaoCapa) {
                        campo = "lay_capa";
                    } else if (buttonConfiguracao == this.configuracaoGeral) {
                        campo = "lay_geral";
                    } else if (buttonConfiguracao == this.configuracaoAnexoFaturamento) {
                        campo = "lay_anexo";
                    } else if (buttonConfiguracao == this.configuracaoAnexoCobranca) {
                        campo = "lay_anexocobranca";
                    } else if (buttonConfiguracao == this.configuracaoAtestadoPaciente) {
                        campo = "lay_atpaciente";
                    } else if (buttonConfiguracao == this.configuracaoAtestadoAcompanhante) {
                        campo = "lay_atacompanha";
                    } else if (buttonConfiguracao == this.configuracaoEtqApoio) {
                        campo = "lay_etqapoio";
                    } else if (buttonConfiguracao == this.configuracaoLaudoWeb) {
                        campo = "lay_laudoweb";
                    } else if (buttonConfiguracao == this.configuracaoEtiquetaMaterialEnviado) {
                        campo = "lay_etiquetacaixa";
                    } else if (buttonConfiguracao == this.configuracaoReciboMaterialEnviado) {
                        campo = "lay_recibocaixa";
                    } else if (buttonConfiguracao == this.configuracaoIdentificacaoEstante) {
                        campo = "lay_etiquetasoroteca";
                    } else if (buttonConfiguracao == this.configuracaoIdentificacaoTubo) {
                        campo = "lay_etiquetatubosoroteca";
                    } else if (buttonConfiguracao == this.configuracaoEtiquetaLamina) {
                        campo = "lay_etiquetalamina";
                    } else if (buttonConfiguracao == this.configuracaoProposta) {
                        campo = "lay_proposta";
                    } else if (buttonConfiguracao == this.configuracaoRecepcaoAmostra) {
                        campo = "lay_recepcaoamostra";
                    } else if (buttonConfiguracao == this.configuracaoEtiquetaEstoque) {
                        campo = "lay_etiquetaestoque";
                    } else if (buttonConfiguracao == this.configuracaoDadosBrutos) {
                        campo = "lay_dadosbrutos";
                    } else if (buttonConfiguracao == this.configuracaoIncerteza) {
                        campo = "lay_incerteza";
                    } else if (buttonConfiguracao == this.configuracaoPesquisaFornecedor) {
                        campo = "lay_pesquisafornecedor";
                    } else if (buttonConfiguracao == this.configuracaoIdentificacaoColeta) {
                        campo = "lay_identificacaocoleta";
                    } else if (buttonConfiguracao == this.configuracaoEtiquetaLaudo) {
                        campo = "lay_etiquetalaudo";
                    } else if (buttonConfiguracao == this.configuracaoNotificacao) {
                        campo = "lay_notificacao";
                    } else if (buttonConfiguracao == this.configuracaoTermoConsentimento) {
                        campo = "lay_termoconsentimento";
                    }
                    ResultSet rs = Conexao.executeQuery(st, "select " + campo + " from layout where fil_codigo = " + Variaveis.filialPadrao + " and lay_codigo=" + codigo);
                    if (rs != null && rs.next()) {
                        buttonConfiguracao.setXmlConfiguracao(rs.getString(campo));
                        this.contemAlterado(buttonConfiguracao);
                    } else if (this.getStatus() == 3) {
                        Funcoes.mensagem(this, "Modelo n\u00e3o localizado", 5);
                    }
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException sqlex) {
                ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "Layout (372)");
            }
        }
    }

    private void montaTela() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.painelCentral.add((Component)this.jLabel1, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.painelCentral.add((Component)this.jLabel2, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.txtCodigo.setPreferredSize(new Dimension(70, 20));
        this.txtCodigo.setMinimumSize(new Dimension(70, 20));
        this.painelCentral.add((Component)this.txtCodigo, this.constraints);
        this.constraints.insets = new Insets(1, 0, 0, 0);
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.painelCentral.add((Component)this.configuracaoLaudo, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 3;
        this.painelCentral.add((Component)this.configuracaoMapa, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 4;
        this.painelCentral.add((Component)this.configuracaoComprovante, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 5;
        this.painelCentral.add((Component)this.configuracaoCarteira, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 6;
        this.painelCentral.add((Component)this.configuracaoRecibo, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 7;
        this.painelCentral.add((Component)this.configuracaoCapa, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 8;
        this.painelCentral.add((Component)this.configuracaoAnexoFaturamento, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 9;
        this.painelCentral.add((Component)this.configuracaoOrcamento, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 10;
        this.painelCentral.add((Component)this.configuracaoEtqTriagem, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 11;
        this.painelCentral.add((Component)this.configuracaoEtqColeta, this.constraints);
        this.constraints.gridy = 12;
        this.painelCentral.add((Component)this.configuracaoGeral, this.constraints);
        this.constraints.gridy = 13;
        this.painelCentral.add((Component)this.configuracaoEtiquetaEstoque, this.constraints);
        this.constraints.gridy = 14;
        this.painelCentral.add((Component)this.configuracaoDadosBrutos, this.constraints);
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.constraints.gridy = 15;
            this.painelCentral.add((Component)this.configuracaoIncerteza, this.constraints);
            this.constraints.gridy = 16;
            this.painelCentral.add((Component)this.configuracaoEtiquetaLaudo, this.constraints);
        } else {
            this.constraints.gridy = 15;
            this.painelCentral.add((Component)this.configuracaoEtiquetaLaudo, this.constraints);
        }
        ++this.constraints.gridy;
        this.painelCentral.add((Component)this.configuracaoTermoConsentimento, this.constraints);
        this.constraints.insets = new Insets(1, 15, 0, 0);
        this.constraints.gridx = 2;
        this.constraints.gridy = 2;
        this.painelCentral.add((Component)this.configuracaoAtestadoPaciente, this.constraints);
        this.constraints.gridy = 3;
        this.painelCentral.add((Component)this.configuracaoAtestadoAcompanhante, this.constraints);
        this.constraints.gridy = 4;
        this.painelCentral.add((Component)this.configuracaoEtqApoio, this.constraints);
        this.constraints.gridy = 5;
        this.painelCentral.add((Component)this.configuracaoLaudoWeb, this.constraints);
        this.constraints.gridy = 6;
        this.painelCentral.add((Component)this.configuracaoEtiquetaMaterialEnviado, this.constraints);
        this.constraints.gridy = 7;
        this.painelCentral.add((Component)this.configuracaoReciboMaterialEnviado, this.constraints);
        this.constraints.gridy = 8;
        this.painelCentral.add((Component)this.configuracaoIdentificacaoEstante, this.constraints);
        this.constraints.gridy = 9;
        this.painelCentral.add((Component)this.configuracaoIdentificacaoTubo, this.constraints);
        this.constraints.gridy = 10;
        this.painelCentral.add((Component)this.configuracaoEtiquetaLamina, this.constraints);
        this.constraints.gridy = 11;
        this.painelCentral.add((Component)this.configuracaoAnexoCobranca, this.constraints);
        this.constraints.gridy = 12;
        this.painelCentral.add((Component)this.configuracaoProposta, this.constraints);
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.constraints.gridy = 13;
            this.painelCentral.add((Component)this.configuracaoRecepcaoAmostra, this.constraints);
            this.constraints.gridy = 14;
        } else {
            this.constraints.gridy = 13;
        }
        this.painelCentral.add((Component)this.configuracaoPesquisaFornecedor, this.constraints);
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.constraints.gridy = 15;
            this.painelCentral.add((Component)this.configuracaoIdentificacaoColeta, this.constraints);
            this.constraints.gridy = 16;
            this.painelCentral.add((Component)this.configuracaoCapaLaudo, this.constraints);
        } else {
            this.constraints.gridy = 14;
            this.painelCentral.add((Component)this.configuracaoCapaLaudo, this.constraints);
        }
        ++this.constraints.gridy;
        this.painelCentral.add((Component)this.configuracaoNotificacao, this.constraints);
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 2;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.painelCentral.add((Component)this.txtDescricao, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 23;
        this.constraints.gridwidth = 3;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.painelCentral.add((Component)new JPanel(), this.constraints);
        JPanel legenda = new JPanel(new GridBagLayout());
        this.constraints.gridx = 0;
        this.constraints.gridy = 24;
        this.constraints.gridwidth = 3;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.painelCentral.add((Component)legenda, this.constraints);
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = 0;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        legenda.add((Component)new JLabel("Impress\u00e3o gr\u00e1fica", TiposImpressao.GRAFICA.getImagem(), 2), this.constraints);
        ++this.constraints.gridx;
        this.constraints.insets = new Insets(1, 20, 1, 1);
        legenda.add((Component)new JLabel("Impress\u00e3o direta", TiposImpressao.DIRETA.getImagem(), 2), this.constraints);
        ++this.constraints.gridx;
        legenda.add((Component)new JLabel("Impress\u00e3o t\u00e9rmica", TiposImpressao.TERMICA.getImagem(), 2), this.constraints);
        ++this.constraints.gridx;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        legenda.add((Component)new JLabel(), this.constraints);
    }

    private int checkTipoImpressao(String tipo) {
        if (tipo == null || tipo.equals("C")) {
            return 1;
        }
        if (tipo.equals("T")) {
            return 2;
        }
        return 0;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Layout.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901001"));
        this.setModuloEdita(Long.parseLong("0101901002"));
        this.setModuloApaga(Long.parseLong("0101901003"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.layout(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("lay_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("layout", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("lay_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaLayout());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Layout");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    private String getTipoImpressao(TiposImpressao tipoSelecionado) {
        if (tipoSelecionado == null || tipoSelecionado == TiposImpressao.DIRETA) {
            return "D";
        }
        if (tipoSelecionado == TiposImpressao.GRAFICA) {
            return "C";
        }
        return "T";
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "layout", true);
                }
                SalvaDados salvar = new SalvaDados("layout", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("lay_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("lay_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("lay_tipolaudo", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoLaudo.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipomapa", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoMapa.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipocomprovante", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoComprovante.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipocarteira", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoCarteira.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetqtri", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtqTriagem.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetqcol", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtqColeta.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tiporecibo", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoRecibo.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoorcamento", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoOrcamento.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipocapa", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoCapa.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoatpaciente", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoAtestadoPaciente.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoatacompanha", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoAtestadoAcompanhante.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetqapoio", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtqApoio.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoanexo", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoAnexoFaturamento.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipogeral", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoGeral.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipolaudoweb", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoLaudoWeb.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetiquetacaixa", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtiquetaMaterialEnviado.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tiporecibocaixa", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoReciboMaterialEnviado.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetiquetasoroteca", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoIdentificacaoEstante.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetiquetatubosoroteca", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoIdentificacaoTubo.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetiquetalamina", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtiquetaLamina.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoanexocobranca", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoAnexoCobranca.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoproposta", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoProposta.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tiporecepcaoamostra", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoRecepcaoAmostra.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetiquetaestoque", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtiquetaEstoque.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipodadosbrutos", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoDadosBrutos.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoincerteza", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoIncerteza.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipopesquisafornecedor", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoPesquisaFornecedor.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoidentificacaocoleta", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoIdentificacaoColeta.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipocapalaudo", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoCapaLaudo.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipoetiquetalaudo", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoEtiquetaLaudo.getTipoImpressaoSelecionado())));
                salvar.adicionaCampo("lay_tipotermoconsentimento", 0, true, false, StringUtil.textoDBEscape(this.getTipoImpressao(this.configuracaoTermoConsentimento.getTipoImpressaoSelecionado())));
                if (this.getStatus() == 2 || this.laudoAlterado) {
                    salvar.adicionaCampo("lay_cabec", 0, true, false, StringUtil.textoDBEscape(this.configuracaoLaudo.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.comprovanteAlterado) {
                    salvar.adicionaCampo("lay_comprovante", 0, true, false, StringUtil.textoDBEscape(this.configuracaoComprovante.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.carteiraAlterado) {
                    salvar.adicionaCampo("lay_carteira", 0, true, false, StringUtil.textoDBEscape(this.configuracaoCarteira.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.reciboAlterado) {
                    salvar.adicionaCampo("lay_recibo", 0, true, false, StringUtil.textoDBEscape(this.configuracaoRecibo.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.orcamentoAlterado) {
                    salvar.adicionaCampo("lay_orcamento", 0, true, false, StringUtil.textoDBEscape(this.configuracaoOrcamento.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.capaAlterado) {
                    salvar.adicionaCampo("lay_capa", 0, true, false, StringUtil.textoDBEscape(this.configuracaoCapa.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etqTriAlterado) {
                    salvar.adicionaCampo("lay_etqtri", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtqTriagem.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etqColAlterado) {
                    salvar.adicionaCampo("lay_etqcol", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtqColeta.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.mapaAlterado) {
                    salvar.adicionaCampo("lay_cabecmapa", 0, true, false, StringUtil.textoDBEscape(this.configuracaoMapa.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.geralAlterado) {
                    salvar.adicionaCampo("lay_geral", 0, true, false, StringUtil.textoDBEscape(this.configuracaoGeral.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.anexoAlterado) {
                    salvar.adicionaCampo("lay_anexo", 0, true, false, StringUtil.textoDBEscape(this.configuracaoAnexoFaturamento.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.atPacienteAlterado) {
                    salvar.adicionaCampo("lay_atpaciente", 0, true, false, StringUtil.textoDBEscape(this.configuracaoAtestadoPaciente.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.atAcompanhaAlterado) {
                    salvar.adicionaCampo("lay_atacompanha", 0, true, false, StringUtil.textoDBEscape(this.configuracaoAtestadoAcompanhante.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etqApoioAlterado) {
                    salvar.adicionaCampo("lay_etqapoio", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtqApoio.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.laudoWebAlterado) {
                    salvar.adicionaCampo("lay_laudoweb", 0, true, false, StringUtil.textoDBEscape(this.configuracaoLaudoWeb.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etiquetaMaterialEnviadoAlterado) {
                    salvar.adicionaCampo("lay_etiquetacaixa", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtiquetaMaterialEnviado.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.reciboMaterialEnviadoAlterado) {
                    salvar.adicionaCampo("lay_recibocaixa", 0, true, false, StringUtil.textoDBEscape(this.configuracaoReciboMaterialEnviado.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.identificacaoEstanteAlterado) {
                    salvar.adicionaCampo("lay_etiquetasoroteca", 0, true, false, StringUtil.textoDBEscape(this.configuracaoIdentificacaoEstante.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.identificacaoTuboAlterado) {
                    salvar.adicionaCampo("lay_etiquetatubosoroteca", 0, true, false, StringUtil.textoDBEscape(this.configuracaoIdentificacaoTubo.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etiquetaLaminaAlterado) {
                    salvar.adicionaCampo("lay_etiquetalamina", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtiquetaLamina.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.anexoCobrancaAlterado) {
                    salvar.adicionaCampo("lay_anexocobranca", 0, true, false, StringUtil.textoDBEscape(this.configuracaoAnexoCobranca.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.propostaAlterado) {
                    salvar.adicionaCampo("lay_proposta", 0, true, false, StringUtil.textoDBEscape(this.configuracaoProposta.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.recepcaoAmostraAlterado) {
                    salvar.adicionaCampo("lay_recepcaoamostra", 0, true, false, StringUtil.textoDBEscape(this.configuracaoRecepcaoAmostra.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etiquetaEstoqueAlterado) {
                    salvar.adicionaCampo("lay_etiquetaestoque", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtiquetaEstoque.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.dadosBrutosAlterado) {
                    salvar.adicionaCampo("lay_dadosbrutos", 0, true, false, StringUtil.textoDBEscape(this.configuracaoDadosBrutos.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.incertezaAlterada) {
                    salvar.adicionaCampo("lay_incerteza", 0, true, false, StringUtil.textoDBEscape(this.configuracaoIncerteza.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.pesquisaFornecedor) {
                    salvar.adicionaCampo("lay_pesquisafornecedor", 0, true, false, StringUtil.textoDBEscape(this.configuracaoPesquisaFornecedor.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.identificacaoColetaAlterada) {
                    salvar.adicionaCampo("lay_identificacaocoleta", 0, true, false, StringUtil.textoDBEscape(this.configuracaoIdentificacaoColeta.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.capaLaudoAlterada) {
                    salvar.adicionaCampo("lay_capalaudo", 0, true, false, StringUtil.textoDBEscape(this.configuracaoCapaLaudo.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.etiquetaLaudoAlterada) {
                    salvar.adicionaCampo("lay_etiquetalaudo", 0, true, false, StringUtil.textoDBEscape(this.configuracaoEtiquetaLaudo.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.notificacaoAlterado) {
                    salvar.adicionaCampo("lay_notificacao", 0, true, false, StringUtil.textoDBEscape(this.configuracaoNotificacao.getXmlConfiguracao()));
                }
                if (this.getStatus() == 2 || this.termoConsentimentoAlterado) {
                    salvar.adicionaCampo("lay_termoconsentimento", 0, true, false, StringUtil.textoDBEscape(this.configuracaoTermoConsentimento.getXmlConfiguracao()));
                }
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaLayout(), "layout", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Layout (949)");
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoLaudo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoMapa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoComprovante.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoCarteira.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoRecibo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoOrcamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtqTriagem.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtqColeta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoCapa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoAnexoFaturamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoGeral.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoAtestadoPaciente.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoAtestadoAcompanhante.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtqApoio.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoLaudoWeb.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtiquetaMaterialEnviado.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoReciboMaterialEnviado.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoIdentificacaoEstante.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoIdentificacaoTubo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtiquetaLamina.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoAnexoCobranca.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoProposta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoRecepcaoAmostra.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtiquetaEstoque.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoDadosBrutos.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoIncerteza.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoPesquisaFornecedor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoIdentificacaoColeta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoCapaLaudo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoEtiquetaLaudo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoNotificacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.configuracaoTermoConsentimento.setVisible(false);
        this.configuracaoTermoConsentimento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.configuracaoLaudo.limpar();
        this.configuracaoMapa.limpar();
        this.configuracaoComprovante.limpar();
        this.configuracaoCarteira.limpar();
        this.configuracaoRecibo.limpar();
        this.configuracaoCapa.limpar();
        this.configuracaoAnexoFaturamento.limpar();
        this.configuracaoOrcamento.limpar();
        this.configuracaoEtqTriagem.limpar();
        this.configuracaoEtqColeta.limpar();
        this.configuracaoGeral.limpar();
        this.configuracaoAtestadoPaciente.limpar();
        this.configuracaoAtestadoAcompanhante.limpar();
        this.configuracaoEtqApoio.limpar();
        this.configuracaoLaudoWeb.limpar();
        this.configuracaoEtiquetaMaterialEnviado.limpar();
        this.configuracaoReciboMaterialEnviado.limpar();
        this.configuracaoIdentificacaoEstante.limpar();
        this.configuracaoIdentificacaoTubo.limpar();
        this.configuracaoEtiquetaLamina.limpar();
        this.configuracaoAnexoCobranca.limpar();
        this.configuracaoProposta.limpar();
        this.configuracaoRecepcaoAmostra.limpar();
        this.configuracaoEtiquetaEstoque.limpar();
        this.configuracaoDadosBrutos.limpar();
        this.configuracaoIncerteza.limpar();
        this.configuracaoPesquisaFornecedor.limpar();
        this.configuracaoIdentificacaoColeta.limpar();
        this.configuracaoCapaLaudo.limpar();
        this.configuracaoEtiquetaLaudo.limpar();
        this.configuracaoNotificacao.limpar();
        this.configuracaoTermoConsentimento.limpar();
        this.perguntasFilial = "";
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901000");
    }

    private String configurar(ButtonConfiguracao buttonConfiguracao, int qtdeExamesCC, int colunasRodapeComprovante) {
        TiposImpressao tipoImpressao = buttonConfiguracao.getTipoImpressaoSelecionado();
        String xml = buttonConfiguracao.getXmlConfiguracao();
        String titulo = "";
        if (!Funcoes.textoVazio(buttonConfiguracao.getText())) {
            titulo = buttonConfiguracao.getText().toLowerCase();
        }
        String retorno = xml;
        if (tipoImpressao == TiposImpressao.GRAFICA) {
            if (this.isDialogConfigurador(buttonConfiguracao)) {
                String[] arrayCamposMapa = this.concatenarPerguntasFilial(Impressao.CAMPOS_MAPA);
                retorno = this.getDadosConfigurados(retorno, buttonConfiguracao, titulo, arrayCamposMapa);
            } else {
                Editor relatorio = new Editor(Laboratorio.getInstancia(), "Configurando " + titulo, true);
                String[] campos = this.getCamposBanco(buttonConfiguracao, qtdeExamesCC, colunasRodapeComprovante);
                if (campos != null) {
                    relatorio.setCamposDoBanco(campos);
                }
                if (this.isComprovante(buttonConfiguracao) || this.isTermoConsentimento(buttonConfiguracao)) {
                    relatorio.setHabilitarQRCode();
                }
                relatorio.setAtributos(xml);
                relatorio.setVisible(true);
                if (relatorio.ok()) {
                    retorno = relatorio.getAtributos();
                }
                relatorio = null;
            }
        } else if (tipoImpressao == TiposImpressao.DIRETA) {
            if (buttonConfiguracao == this.configuracaoMapa) {
                EditorMapa editorMapa = new EditorMapa((Frame)Laboratorio.getInstancia(), "Configurando mapa", true, 1);
                String[] arrayCamposMapa = this.concatenarPerguntasFilial(Impressao.CAMPOS_MAPA);
                editorMapa.setCampoDoBanco(arrayCamposMapa);
                editorMapa.setCabecalhoRodape(xml);
                editorMapa.setVisible(true);
                if (editorMapa.ok()) {
                    retorno = editorMapa.getCabecalhoRodape();
                }
                editorMapa = null;
            } else if (this.isComprovante(buttonConfiguracao) || this.isRecibo(buttonConfiguracao) || this.isAnexoFaturamento(buttonConfiguracao) || this.isCapa(buttonConfiguracao) || this.isAnexoCobranca(buttonConfiguracao)) {
                EditorRelatorio editorRelatorio = new EditorRelatorio(Laboratorio.getInstancia(), "Configurando " + titulo, true);
                String[] camposComprovante = Impressao.getCamposCapa();
                if (this.isComprovante(buttonConfiguracao)) {
                    camposComprovante = Impressao.getCamposComprovante();
                } else if (this.isAnexoFaturamento(buttonConfiguracao)) {
                    camposComprovante = Impressao.getCamposAnexo();
                } else if (this.isRecibo(buttonConfiguracao)) {
                    camposComprovante = Impressao.getCamposRecibo();
                } else if (this.isAnexoCobranca(buttonConfiguracao)) {
                    camposComprovante = Impressao.getCamposAnexoCobranca();
                }
                camposComprovante = this.concatenarPerguntasFilial(camposComprovante);
                editorRelatorio.setCampoDoBanco(camposComprovante);
                editorRelatorio.setCabecalhoRodape(xml);
                editorRelatorio.setVisible(true);
                if (editorRelatorio.ok()) {
                    retorno = editorRelatorio.getCabecalhoRodape();
                }
                editorRelatorio = null;
            }
        } else if (tipoImpressao == TiposImpressao.TERMICA) {
            EditorTermica termica = new EditorTermica(Laboratorio.getInstancia(), "Configurando " + titulo, true);
            termica.setDocumento(xml);
            if (this.isEtqTriagem(buttonConfiguracao)) {
                String[] camposEtqTriagem = this.concatenarPerguntasFilial(Impressao.CAMPOS_ETQ_TRIAGEM);
                termica.setCamposBanco(camposEtqTriagem);
            } else if (this.isEtqColeta(buttonConfiguracao)) {
                String[] camposColeta = this.concatenarPerguntasFilial(Impressao.CAMPOS_ETQ_COLETA);
                termica.setCamposBanco(camposColeta);
            } else if (this.isCarteira(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_CARTEIRA);
            } else if (this.isEtqApoio(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_ETQ_APOIO);
            } else if (this.isEtiquetaMaterialEnviado(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_ETIQUETA_MATERIAL_ENVIADO);
            } else if (this.isIdentificaoEstante(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_IDENTIFICACAO_ESTANTE);
            } else if (this.isIdentificaoTubo(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_IDENTIFICACAO_TUBO);
            } else if (this.isComprovante(buttonConfiguracao)) {
                String[] camposComprovante = this.concatenarPerguntasFilial(Impressao.getCamposComprovante());
                termica.setCamposBanco(camposComprovante);
            } else if (this.isEtiquetaLamina(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_ETIQUETA_LAMINA);
            } else if (this.isEtiquetaEstoque(buttonConfiguracao)) {
                termica.setCamposBanco(Impressao.CAMPOS_ETIQUETA_ESTOQUE);
            } else if (this.isEtiquetaLaudo(buttonConfiguracao)) {
                String[] camposEtqLaudo = this.concatenarPerguntasFilial(Impressao.CAMPOS_ETQ_LAUDO);
                termica.setCamposBanco(camposEtqLaudo);
            }
            termica.setVisible(true);
            if (termica.ok()) {
                retorno = termica.getDocumento();
            }
        }
        this.contemAlterado(buttonConfiguracao);
        return retorno;
    }

    private void contemAlterado(ButtonConfiguracao buttonConfiguracao) {
        if (buttonConfiguracao == this.configuracaoLaudo) {
            this.laudoAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoCapaLaudo) {
            this.capaLaudoAlterada = true;
        } else if (buttonConfiguracao == this.configuracaoMapa) {
            this.mapaAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoComprovante) {
            this.comprovanteAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoCarteira) {
            this.carteiraAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoRecibo) {
            this.reciboAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoOrcamento) {
            this.orcamentoAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoEtqTriagem) {
            this.etqTriAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoEtqColeta) {
            this.etqColAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoCapa) {
            this.capaAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoAnexoFaturamento) {
            this.anexoAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoGeral) {
            this.geralAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoAtestadoPaciente) {
            this.atPacienteAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoAtestadoAcompanhante) {
            this.atAcompanhaAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoEtqApoio) {
            this.etqApoioAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoLaudoWeb) {
            this.laudoWebAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoEtiquetaMaterialEnviado) {
            this.etiquetaMaterialEnviadoAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoReciboMaterialEnviado) {
            this.reciboMaterialEnviadoAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoIdentificacaoEstante) {
            this.identificacaoEstanteAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoIdentificacaoTubo) {
            this.identificacaoTuboAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoEtiquetaLamina) {
            this.etiquetaLaminaAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoAnexoCobranca) {
            this.anexoCobrancaAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoProposta) {
            this.propostaAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoRecepcaoAmostra) {
            this.recepcaoAmostraAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoEtiquetaEstoque) {
            this.etiquetaEstoqueAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoDadosBrutos) {
            this.dadosBrutosAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoIncerteza) {
            this.incertezaAlterada = true;
        } else if (buttonConfiguracao == this.configuracaoPesquisaFornecedor) {
            this.pesquisaFornecedor = true;
        } else if (buttonConfiguracao == this.configuracaoIdentificacaoColeta) {
            this.identificacaoColetaAlterada = true;
        } else if (buttonConfiguracao == this.configuracaoEtiquetaLaudo) {
            this.etiquetaLaudoAlterada = true;
        } else if (buttonConfiguracao == this.configuracaoNotificacao) {
            this.notificacaoAlterado = true;
        } else if (buttonConfiguracao == this.configuracaoTermoConsentimento) {
            this.termoConsentimentoAlterado = true;
        }
    }

    private String[] getCamposBanco(ButtonConfiguracao buttonConfiguracao, int qtdeExamesCC, int colunasRodapeComprovante) {
        String[] campos = null;
        if (this.isComprovante(buttonConfiguracao)) {
            campos = this.concatenarPerguntasFilial(Impressao.getCamposComprovante());
        } else if (this.isRecibo(buttonConfiguracao)) {
            campos = this.concatenarPerguntasFilial(Impressao.getCamposRecibo());
        } else if (this.isCapa(buttonConfiguracao)) {
            campos = this.concatenarPerguntasFilial(Impressao.getCamposCapa());
        } else if (this.isAnexoFaturamento(buttonConfiguracao)) {
            campos = this.concatenarPerguntasFilial(Impressao.getCamposAnexo());
        } else if (this.isAnexoCobranca(buttonConfiguracao)) {
            campos = this.concatenarPerguntasFilial(Impressao.getCamposAnexoCobranca());
        } else if (this.isOrcamento(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ORCAMENTO;
        } else if (this.isCarteira(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_CARTEIRA;
        } else if (this.isEtqColeta(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ETQ_COLETA;
        } else if (this.isEtqTriagem(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ETQ_TRIAGEM;
        } else if (this.isEtqApoio(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ETQ_APOIO;
        } else if (this.isEtiquetaMaterialEnviado(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ETIQUETA_MATERIAL_ENVIADO;
        } else if (this.isReciboMaterialEnviado(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_RECIBO_MATERIAL_ENVIADO;
        } else if (this.isIdentificaoEstante(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_IDENTIFICACAO_ESTANTE;
        } else if (this.isIdentificaoTubo(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_IDENTIFICACAO_TUBO;
        } else if (this.isEtiquetaLamina(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ETIQUETA_LAMINA;
        } else if (this.isProposta(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_PROPOSTA;
        } else if (this.isRecepcaoAmostra(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_RECEPCAO_AMOSTRA;
        } else if (this.isEtiquetaEstoque(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_ETIQUETA_ESTOQUE;
        } else if (this.isIdentificacaoColeta(buttonConfiguracao)) {
            campos = Impressao.CAMPOS_IDENTIFICACAO_COLETA;
        } else if (this.isEtiquetaLaudo(buttonConfiguracao)) {
            campos = this.concatenarPerguntasFilial(Impressao.CAMPOS_ETQ_LAUDO);
        } else if (this.isTermoConsentimento(buttonConfiguracao)) {
            campos = this.getCamposTermoConsentimento(qtdeExamesCC, colunasRodapeComprovante);
        }
        return campos;
    }

    private String[] concatenarPerguntasFilial(String[] campos) {
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(Variaveis.filialPadrao);
        if (perguntasFilial.length > 0) {
            campos = ArraysUtil.concatenar(campos, perguntasFilial);
        }
        return campos;
    }

    private String getDadosConfigurados(String retorno, ButtonConfiguracao buttonConfiguracao, String titulo, String[] arrayCamposMapa) {
        DialogoConfigurador configurador = new DialogoConfigurador((Frame)Laboratorio.getInstancia(), "Configurando " + titulo, true, buttonConfiguracao == this.configuracaoLaudoWeb && this.isGerarPDFWeb);
        configurador.setTipoConfiguracao(0);
        if (this.isCabecalhoRodape(buttonConfiguracao)) {
            configurador.setTipoConfiguracao(1);
        }
        if (this.isLaudo(buttonConfiguracao)) {
            configurador.setHabilitarQRCode();
        }
        if (this.isPossuiAssinatura(buttonConfiguracao)) {
            String[] arrayCampos = ArraysUtil.concatenar(Impressao.CAMPOS_LAUDO, Impressao.getCamposMedicamento());
            arrayCampos = this.concatenarPerguntasFilial(arrayCampos);
            configurador.setCamposBanco(arrayCampos);
            configurador.setCamposAssinatura(Impressao.CAMPOS_ASSINATURA_LAUDO);
        } else if (this.isMapa(buttonConfiguracao)) {
            configurador.setCamposBanco(arrayCamposMapa);
        } else if (this.isAtestado(buttonConfiguracao)) {
            configurador.setCamposBanco(Impressao.CAMPOS_ATESTADO);
        } else if (this.isPesquisaFornecedor(buttonConfiguracao)) {
            configurador.setTipoConfiguracao(0);
            configurador.setAtributosDaPagina(this.configuracaoGeral.getXmlConfiguracao());
        } else if (this.isNotificacao(buttonConfiguracao)) {
            configurador.setTipoConfiguracao(1);
            configurador.setCamposBanco(Impressao.CAMPOS_NOTIFICACAO);
        }
        if (!Funcoes.textoVazio(retorno)) {
            configurador.setAtributos(retorno);
        }
        configurador.setVisible(true);
        if (configurador.ok()) {
            retorno = configurador.getAtributos();
        }
        configurador = null;
        return retorno;
    }

    private String[] getCamposTermoConsentimento(int qtdeExamesCC, int colunasRodapeComprovante) {
        return this.concatenarPerguntasFilial(this.imprimirTermoConsentimento.getCampos(qtdeExamesCC, colunasRodapeComprovante));
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "lay_codigo";
    }

    @Override
    public void novoAlterarPressionado(ButtonConfiguracao button) {
        button.setXmlConfiguracao(this.configurar(button, ParametrosGerais.getQtdeExamesCC(), ParametrosGerais.getColunasRodapeComprovante()));
    }

    @Override
    public void copiarPressionado(ButtonConfiguracao button) {
        this.copiar(button);
    }

    private boolean isPossuiAssinatura(ButtonConfiguracao buttonConfiguracao) {
        return this.isLaudo(buttonConfiguracao) || this.isDadosBrutos(buttonConfiguracao) || this.isIncerteza(buttonConfiguracao) || this.isCapaLaudo(buttonConfiguracao);
    }

    private boolean isCabecalhoRodape(ButtonConfiguracao buttonConfiguracao) {
        return this.isPossuiAssinatura(buttonConfiguracao) || this.isMapa(buttonConfiguracao) || this.isGeral(buttonConfiguracao);
    }

    private boolean isDialogConfigurador(ButtonConfiguracao buttonConfiguracao) {
        return this.isCabecalhoRodape(buttonConfiguracao) || this.isAtestado(buttonConfiguracao) || this.isPesquisaFornecedor(buttonConfiguracao) || this.isNotificacao(buttonConfiguracao);
    }

    private boolean isCapaLaudo(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoCapaLaudo;
    }

    private boolean isNotificacao(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoNotificacao;
    }

    private boolean isPesquisaFornecedor(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoPesquisaFornecedor;
    }

    private boolean isIncerteza(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoIncerteza;
    }

    private boolean isDadosBrutos(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoDadosBrutos;
    }

    private boolean isGeral(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoGeral;
    }

    private boolean isLaudo(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoLaudo || buttonConfiguracao == this.configuracaoLaudoWeb;
    }

    private boolean isAtestado(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoAtestadoPaciente || buttonConfiguracao == this.configuracaoAtestadoAcompanhante;
    }

    private boolean isMapa(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoMapa;
    }

    private boolean isCapa(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoCapa;
    }

    private boolean isAnexoCobranca(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoAnexoCobranca;
    }

    private boolean isRecibo(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoRecibo;
    }

    private boolean isAnexoFaturamento(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoAnexoFaturamento;
    }

    private boolean isComprovante(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoComprovante;
    }

    private boolean isEtiquetaLaudo(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtiquetaLaudo;
    }

    private boolean isIdentificacaoColeta(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoIdentificacaoColeta;
    }

    private boolean isEtiquetaEstoque(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtiquetaEstoque;
    }

    private boolean isRecepcaoAmostra(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoRecepcaoAmostra;
    }

    private boolean isProposta(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoProposta;
    }

    private boolean isEtiquetaLamina(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtiquetaLamina;
    }

    private boolean isIdentificaoTubo(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoIdentificacaoTubo;
    }

    private boolean isIdentificaoEstante(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoIdentificacaoEstante;
    }

    private boolean isReciboMaterialEnviado(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoReciboMaterialEnviado;
    }

    private boolean isEtiquetaMaterialEnviado(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtiquetaMaterialEnviado;
    }

    private boolean isEtqApoio(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtqApoio;
    }

    private boolean isEtqTriagem(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtqTriagem;
    }

    private boolean isEtqColeta(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoEtqColeta;
    }

    private boolean isCarteira(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoCarteira;
    }

    private boolean isOrcamento(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoOrcamento;
    }

    private boolean isTermoConsentimento(ButtonConfiguracao buttonConfiguracao) {
        return buttonConfiguracao == this.configuracaoTermoConsentimento;
    }
}

