/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.layout;

import jalis.laboratorio.cadastro.layout.AcaoButtonConfiguracaoListener;
import jalis.laboratorio.cadastro.layout.TiposImpressao;
import jalis.util.Funcoes;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ButtonConfiguracao
extends JButton {
    private TiposImpressao[] tiposImpressao = null;
    private TiposImpressao tipoImpressaoSelecionado = TiposImpressao.GRAFICA;
    private JPopupMenu menu = new JPopupMenu();
    private JMenu menuTipo = new JMenu("Tipo de impress\u00e3o");
    private JCheckBoxMenuItem itemTipoGrafica = new JCheckBoxMenuItem(TiposImpressao.GRAFICA.getDescricao(), TiposImpressao.GRAFICA.getImagem());
    private JCheckBoxMenuItem itemTipoDireta = new JCheckBoxMenuItem(TiposImpressao.DIRETA.getDescricao(), TiposImpressao.DIRETA.getImagem());
    private JCheckBoxMenuItem itemTipoTermica = new JCheckBoxMenuItem(TiposImpressao.TERMICA.getDescricao(), TiposImpressao.TERMICA.getImagem());
    private JMenuItem itemNovoAlterar = new JMenuItem("Novo/Alterar");
    private JMenuItem itemCopiar = new JMenuItem("Copiar");
    private ArrayList<AcaoButtonConfiguracaoListener> listener = new ArrayList();
    private String xmlConfiguracao = "";
    private String titulo;

    public ButtonConfiguracao(String descricao, TiposImpressao ... tipoImpressao) {
        super(descricao);
        int altura = this.getHeight();
        this.setPreferredSize(new Dimension(250, 25));
        this.setMinimumSize(new Dimension(250, 25));
        this.setMaximumSize(new Dimension(250, 25));
        this.tiposImpressao = tipoImpressao;
        this.setHorizontalTextPosition(4);
        this.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
        this.setHorizontalAlignment(2);
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TiposImpressao.GRAFICA) > -1) {
            this.menuTipo.add(this.itemTipoGrafica);
        }
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TiposImpressao.DIRETA) > -1) {
            this.menuTipo.add(this.itemTipoDireta);
        }
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TiposImpressao.TERMICA) > -1) {
            this.menuTipo.add(this.itemTipoTermica);
        }
        if (this.menuTipo.getPopupMenu().getComponentCount() > 0) {
            this.menu.add(this.menuTipo);
        }
        this.menu.add(this.itemNovoAlterar);
        this.menu.add(this.itemCopiar);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.menu.show(ButtonConfiguracao.this, 0, ButtonConfiguracao.this.getHeight());
            }
        });
        this.itemTipoGrafica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, true);
            }
        });
        this.itemTipoDireta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.setTipoImpressaoSelecionado(TiposImpressao.DIRETA, true);
            }
        });
        this.itemTipoTermica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.setTipoImpressaoSelecionado(TiposImpressao.TERMICA, true);
            }
        });
        this.itemNovoAlterar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AcaoButtonConfiguracaoListener l : ButtonConfiguracao.this.listener) {
                    l.novoAlterarPressionado(ButtonConfiguracao.this);
                }
            }
        });
        this.itemCopiar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AcaoButtonConfiguracaoListener l : ButtonConfiguracao.this.listener) {
                    l.copiarPressionado(ButtonConfiguracao.this);
                }
            }
        });
        this.montaHint();
    }

    public void adicionarAcaoButtonConfigurarListener(AcaoButtonConfiguracaoListener l) {
        if (l != null && !this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void setTipoImpressaoSelecionado(TiposImpressao tipo, boolean perguntarAlteracao) {
        if (perguntarAlteracao && this.tipoImpressaoSelecionado != tipo) {
            int resp = Funcoes.mensagem(this.getTopLevelAncestor(), "Alterar o tipo de impress\u00e3o limpar\u00e1 as configura\u00e7\u00f5es j\u00e1 feitas.\nDeseja alterar?", 4);
            if (resp == 0) {
                this.setXmlConfiguracao("");
            } else {
                if (tipo == TiposImpressao.GRAFICA) {
                    this.itemTipoGrafica.setSelected(false);
                }
                if (tipo == TiposImpressao.DIRETA) {
                    this.itemTipoDireta.setSelected(false);
                }
                if (tipo == TiposImpressao.TERMICA) {
                    this.itemTipoTermica.setSelected(false);
                }
                return;
            }
        }
        this.tipoImpressaoSelecionado = tipo;
        if (this.tipoImpressaoSelecionado.getImagem() != null) {
            this.setIcon(this.tipoImpressaoSelecionado.getImagem());
        }
        this.itemTipoGrafica.setSelected(false);
        this.itemTipoDireta.setSelected(false);
        this.itemTipoTermica.setSelected(false);
        if (tipo == TiposImpressao.GRAFICA) {
            this.itemTipoGrafica.setSelected(true);
        }
        if (tipo == TiposImpressao.DIRETA) {
            this.itemTipoDireta.setSelected(true);
        }
        if (tipo == TiposImpressao.TERMICA) {
            this.itemTipoTermica.setSelected(true);
        }
        this.montaHint();
    }

    public TiposImpressao getTipoImpressaoSelecionado() {
        return this.tipoImpressaoSelecionado;
    }

    public void setXmlConfiguracao(String xml) {
        this.xmlConfiguracao = xml;
        this.montaHint();
    }

    public String getXmlConfiguracao() {
        return this.xmlConfiguracao;
    }

    private void montaHint() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html>Tipo de impress\u00e3o: <b>").append(this.tipoImpressaoSelecionado.getDescricao()).append("</b>");
        if (Funcoes.textoVazio(this.xmlConfiguracao)) {
            buf.append("<br>").append("Sem modelo definido");
        }
        buf.append("</html>");
        this.setToolTipText(buf.toString());
    }

    public void limpar() {
        this.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
        this.setXmlConfiguracao("");
    }
}

