/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.labexterno;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosModelo;
import jalis.laboratorio.cadastro.Desmembrar;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.cadastro.MetodoModelo;
import jalis.laboratorio.cadastro.Modelos;
import jalis.laboratorio.cadastro.labexterno.ConfiguracaoLayoutRendererEditor;
import jalis.laboratorio.cadastro.labexterno.ConfiguracaoPrecoPrazo;
import jalis.laboratorio.cadastro.labexterno.EditarRelacionamentoExame;
import jalis.laboratorio.cadastro.labexterno.IdentificarBloqueado;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.relatorios.cadastros.RelatorioExamesApoiados;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.exame.ExameHistoricoBean;
import jalis.model.bean.cadastro.exame.ExameLayoutMetodoBean;
import jalis.model.bean.cadastro.exame.ExameMatColetaBean;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoBean;
import jalis.model.bean.cadastro.exame.ExameSetorBean;
import jalis.model.bean.cadastro.exame.HistoricoBean;
import jalis.model.bean.cadastro.exame.LayoutBean;
import jalis.model.bean.triagem.RecipienteColetaBean;
import jalis.model.dao.cadastro.exame.ExameMatColetaLabExternoDao;
import jalis.model.vo.cadastro.LayoutVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.ExameSetorVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.HistoricoVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.cadastro.exame.PrazoEntregaVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.ExameHistoricoService;
import jalis.service.cadastro.exame.ExameLayoutMetodoService;
import jalis.service.cadastro.exame.ExameMatColetaLabExternoService;
import jalis.service.cadastro.exame.ExameMatColetaService;
import jalis.service.cadastro.exame.ExameSetorService;
import jalis.service.cadastro.exame.HistoricoService;
import jalis.service.cadastro.exame.LayoutService;
import jalis.service.cadastro.exame.MetodologiaService;
import jalis.service.cadastro.exame.PrazoEntregaService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.triagem.RecipienteColetaService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.postgresql.util.PSQLException;

public class RelacionamentoLabExterno
extends JDialog
implements ActionListener,
FocusListener {
    private static final int COLUNA_SELECAO = 0;
    private static final int COLUNA_EXAME = 1;
    private static final int COLUNA_MATERIAL = 2;
    private static final int COLUNA_DESCRICAO = 3;
    private static final int COLUNA_RELACIONADO = 4;
    private static final int COLUNA_MODELO = 5;
    private static final int COLUNA_IDADE = 6;
    private static final int COLUNA_METODO = 7;
    private static final int COLUNA_LAYOUT = 8;
    private static final int COLUNA_SETOR = 9;
    private static final int COLUNA_PRAZO = 10;
    private static final int COLUNA_PRAZO_LAB_EXT = 11;
    private static final int COLUNA_PRECO_LAB_EXT = 12;
    private static final int COLUNA_BLOQUEADO = 13;
    private static final int COLUNA_PADRAO = 14;
    private static final int COLUNA_CODIGO_SETOR = 15;
    private static final int COLUNA_CODIGO_PRAZO = 16;
    private static final int COLUNA_CODIGO_METODO = 17;
    private static final int COLUNA_CODIGO_LAYOUT = 18;
    private static final int COLUNA_IDADE_FIM = 19;
    private static final int COLUNA_IDADE_INI = 20;
    private static final int COLUNA_IDADE_FIM_TIPO = 21;
    private static final int COLUNA_IDADE_INI_TIPO = 22;
    private static final int COLUNA_CODIGO_MATERIAL = 23;
    private static final int DESMEMBRADOS = 24;
    private static final int TAMANHO = 27;
    private static final int COLUNA_XMLLABEXTERNO = 26;
    private JPanel panelPrincipal = new JPanel(new BorderLayout());
    private JLabel labelCodigo = new JLabel("Exame");
    private JLabel labelMaterial = new JLabel("Material");
    private JLabel labelDescricaoExame = new JLabel();
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JLabel labelDetalheSetor = new JLabel("Setor:");
    private JLabel labelDetalhePrazo = new JLabel("Prazo:");
    private JLabel labelDetalhePrazoLabExterno = new JLabel("Prazo Lab. externo:");
    private JLabel labelDetalhePrecoLabExterno = new JLabel("Pre\u00e7o Lab. externo:");
    private JLabel labelDetalheBloqueado = new JLabel("Bloqueado:");
    private JLabel labelDetalhePadrao = new JLabel("Padr\u00e3o:");
    private JLabel labelDetalheDescSetor = new JLabel();
    private JLabel labelDetalheDescPrazo = new JLabel();
    private JLabel labelDetalheDescPrazoLabExterno = new JLabel();
    private JLabel labelDetalheDescPrecoLabExterno = new JLabel();
    private JLabel labelDetalheDescBloqueado = new JLabel();
    private JLabel labelDetalheDescPadrao = new JLabel();
    private JButton buttonOK = new JButton("OK");
    private JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es");
    private JButton buttonDesmembrar = new JButton("Desmembrar");
    private JButton buttonAlterar = new JButton("Alterar relacionamento");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonPesquisar = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem itemImprimirListagem = new JMenuItem("Imprimir listagem");
    private JMenuItem itemAlterarSetores = new JMenuItem("Alterar setor padr\u00e3o dos exames selecionados");
    private JMenuItem itemAlterarPrazos = new JMenuItem("Alterar prazo de entrega dos exames selecionados");
    private JMenuItem itemDefinirPadrao = new JMenuItem("Definir como laborat\u00f3rio externo padr\u00e3o (exames selecionados)");
    private JMenuItem itemMarcarBloqueado = new JMenuItem("Marcar como exame bloqueado (exames selecionados)");
    private JMenuItem itemDesmarcarBloqueado = new JMenuItem("Desmarcar como exame bloqueado (exames selecionados)");
    private TTextField textCodigo = new TTextField(5);
    private TTextField textLocalizar = new TTextField(100);
    private JComboBox comboMaterial = new JComboBox();
    private String xmlParametrosRelacionamento;
    private Integer setorPadrao;
    private Integer prazoPadrao;
    private Integer metodoPadrao;
    private String codigoLabExterno = null;
    private Protocolo protocolo = null;
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"Sel.", "Exame", "Mat.", "Descri\u00e7\u00e3o", "Relacionado", "Modelo", "Idade", "M\u00e9todo", "Layout"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 8) {
                return ArrayList.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 8;
        }
    };
    private JTable tableExames = new JTable(this.modeloExames);

    public static RelacionamentoLabExterno novaInstancia(String codigoLabExterno, Protocolo protocolo, Window pai, String xmlParametrosRelacionamento) {
        if (pai instanceof Dialog) {
            return new RelacionamentoLabExterno((Dialog)pai, codigoLabExterno, protocolo, xmlParametrosRelacionamento);
        }
        return new RelacionamentoLabExterno((Frame)pai, codigoLabExterno, protocolo, xmlParametrosRelacionamento);
    }

    private RelacionamentoLabExterno(Frame pai, String codigoLabExterno, Protocolo protocolo, String xmlParametrosRelacionamento) {
        super(pai, "Relacionamento de exames com laborat\u00f3rio externo");
        this.codigoLabExterno = codigoLabExterno;
        this.protocolo = protocolo;
        this.xmlParametrosRelacionamento = xmlParametrosRelacionamento;
        this.setorPadrao = StringUtil.getInt(xmlParametrosRelacionamento, "setor");
        this.prazoPadrao = StringUtil.getInt(xmlParametrosRelacionamento, "prazoEntrega");
        this.metodoPadrao = StringUtil.getInt(xmlParametrosRelacionamento, "metodo");
        this.montaTela();
        this.carregaExames();
        this.modeloExames.ordenarColuna(1);
    }

    private RelacionamentoLabExterno(Dialog pai, String codigoLabExterno, Protocolo protocolo, String xmlParametrosRelacionamento) {
        super(pai, "Relacionamento de exames com laborat\u00f3rio externo");
        this.codigoLabExterno = codigoLabExterno;
        this.protocolo = protocolo;
        this.xmlParametrosRelacionamento = xmlParametrosRelacionamento;
        this.setorPadrao = StringUtil.getInt(xmlParametrosRelacionamento, "setor");
        this.prazoPadrao = StringUtil.getInt(xmlParametrosRelacionamento, "prazoEntrega");
        this.metodoPadrao = StringUtil.getInt(xmlParametrosRelacionamento, "metodo");
        this.montaTela();
        this.carregaExames();
    }

    private void carregaExames() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.lae_codigo, a.fil_codigo, a.exa_codigo, a.mco_codigo, h.exa_descricao, b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo,  ");
            buf.append(" e.lay_descricao, b.ela_padrao, a.met_codigo, d.met_descricao,  ");
            buf.append("  a.ele_valorexame, a.ele_bloqueado, a.ele_padrao, a.ele_diasprazo, f.prz_codigo, g.prz_descricao, a.ele_xmllabexterno,");
            buf.append(" i.mco_abreviatura, k.set_descricao, k.set_codigo, g.prz_codigo ");
            buf.append(" from examematcoletalabexterno a ");
            buf.append(" left join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo  ");
            buf.append(" join examelayoutmetodo c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and b.lay_codigo = c.lay_codigo and a.met_codigo = c.met_codigo ");
            buf.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and a.met_codigo = d.met_codigo ");
            buf.append(" left join layout e on a.fil_codigo = e.fil_codigo and b.lay_codigo = e.lay_codigo ");
            buf.append(" left join examematcoleta f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.mco_codigo = f.mco_codigo ");
            buf.append(" left join prazoentrega g on a.fil_codigo = g.fil_codigo and f.prz_codigo = g.prz_codigo ");
            buf.append(" left join exames h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo ");
            buf.append(" left join materialcoleta i on a.fil_codigo = i.fil_codigo and a.mco_codigo = i.mco_codigo ");
            buf.append(" left join examesetor j on a.fil_codigo = j.fil_codigo and a.exa_codigo = j.exa_codigo and j.ese_default ");
            buf.append(" left join setores k on a.fil_codigo = k.fil_codigo and k.set_codigo = j.set_codigo ");
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.lae_codigo = ").append(this.codigoLabExterno);
            buf.append(" order by a.exa_codigo, b.mco_codigo, a.met_codigo ");
            Statement st = Conexao.getStatement();
            ResultSet rsExames = Conexao.executeQuery(st, buf.toString());
            Statement stMetodos = Conexao.getStatement();
            if (rsExames != null) {
                while (rsExames.next()) {
                    String descricaoExameLabExterno = "";
                    if (!Funcoes.textoVazio(rsExames.getString("ele_xmllabexterno"))) {
                        descricaoExameLabExterno = this.validaCampoDescricaoLabExterno(rsExames.getString("ele_xmllabexterno"));
                    }
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("fil_codigo", rsExames.getString("fil_codigo"));
                    params.put("lae_codigo", rsExames.getString("lae_codigo"));
                    params.put("exa_codigo", rsExames.getString("exa_codigo"));
                    params.put("mco_codigo", rsExames.getString("mco_codigo"));
                    ArrayList interfaceDesmembraLabExterno = new ExameMatColetaLabExternoService().obterExameDesmembradoLabExterno(params);
                    Object[] exame = this.adicionaObjeto(Boolean.FALSE, rsExames.getString("exa_codigo"), rsExames.getString("mco_abreviatura"), rsExames.getString("exa_descricao"), descricaoExameLabExterno, rsExames.getString("lay_descricao"), rsExames.getString("met_descricao"), rsExames.getString("set_descricao"), rsExames.getString("prz_descricao"), rsExames.getInt("ele_diasprazo"), !Funcoes.textoVazio(rsExames.getString("ele_valorexame")) ? rsExames.getString("ele_valorexame") : "", rsExames.getBoolean("ele_bloqueado"), rsExames.getBoolean("ele_padrao"), rsExames.getInt("set_codigo"), rsExames.getInt("prz_codigo"), rsExames.getInt("met_codigo"), rsExames.getInt("lay_codigo"), rsExames.getInt("ela_idadefim"), rsExames.getInt("ela_idadeini"), rsExames.getString("ela_idadefimtipo"), rsExames.getString("ela_idadeinitipo"), rsExames.getString("mco_codigo"), rsExames.getString("ele_xmllabexterno"), interfaceDesmembraLabExterno);
                    this.modeloExames.addLine(exame);
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private String validaCampoDescricaoLabExterno(String xml) {
        String descricaoExameLabExterno = StringUtil.getValor(xml, "descricaoExame");
        if (this.validaNome(xml, descricaoExameLabExterno, "descricao-exame")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "descricao-exame");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "ds_exame")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "ds_exame");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "nome")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "nome");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "descricao")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "descricao");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "codigoExame")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "codigoExame");
        }
        return descricaoExameLabExterno;
    }

    private boolean validaNome(String xml, String descricaoExameLabExterno, String tag) {
        return Funcoes.textoVazio(descricaoExameLabExterno) && !Funcoes.textoVazio(StringUtil.getValor(xml, tag));
    }

    private Object[] adicionaObjeto(Boolean selecionado, String codExame, String abrMaterial, String descExame, String descExameRelacionado, String descLayout, String descMetodo, String descSetor, String descPrazo, int prazoLabExt, String precoLabExString, Boolean bloqueado, Boolean padrao, int codSetor, int codPrazo, int codMetodo, int codLayout, int idadeFim, int idadeIni, String idadeFimTipo, String idadeIniTipo, String codMaterial, String xmlLabExterno, ArrayList desmembrados) throws SQLException {
        String faixaIdade = this.formataFaixaIdade(idadeIni, idadeIniTipo, idadeFim, idadeFimTipo);
        Object[] exame = new Object[27];
        exame[0] = selecionado;
        exame[1] = codExame;
        exame[2] = abrMaterial;
        exame[3] = descExame;
        exame[4] = descExameRelacionado;
        exame[5] = descLayout;
        exame[6] = faixaIdade;
        exame[7] = descMetodo;
        exame[8] = new ArrayList();
        exame[9] = descSetor;
        exame[10] = descPrazo;
        exame[11] = prazoLabExt;
        exame[12] = precoLabExString;
        exame[13] = bloqueado;
        exame[14] = padrao;
        exame[15] = codSetor;
        exame[16] = codPrazo;
        exame[17] = codMetodo;
        exame[18] = codLayout;
        exame[19] = idadeFim;
        exame[20] = idadeIni;
        exame[21] = idadeFimTipo;
        exame[22] = idadeIniTipo;
        exame[23] = codMaterial;
        exame[26] = xmlLabExterno;
        exame[24] = desmembrados;
        return exame;
    }

    private String formataFaixaIdade(int i, String idadeIniTipo, int j, String idadeFimTipo) {
        StringBuilder faixaIdade = new StringBuilder();
        faixaIdade.append(i);
        faixaIdade.append(idadeIniTipo).append(" - ");
        faixaIdade.append(j);
        faixaIdade.append(idadeFimTipo);
        return faixaIdade.toString();
    }

    private void montaTela() {
        this.setSize(900, 450);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().add(this.panelPrincipal);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.panelPrincipal.setBorder(ScreenUtil.criarBordaVazia());
        this.tableExames.setRowHeight(this.tableExames.getRowHeight() + 3);
        this.tableExames.setDefaultRenderer(ArrayList.class, new ConfiguracaoLayoutRendererEditor(this));
        this.tableExames.setDefaultRenderer(Object.class, new IdentificarBloqueado(0, 8, 13));
        this.tableExames.setDefaultEditor(ArrayList.class, new ConfiguracaoLayoutRendererEditor(this));
        this.modeloExames.setColumnSize(new int[]{25, 60, 40, 0, 0, 90, 90, 0, 60}, this.tableExames);
        this.tableExames.repaint();
        this.menuOpcoes.add(this.itemImprimirListagem);
        this.menuOpcoes.add(this.itemAlterarSetores);
        this.menuOpcoes.add(this.itemAlterarPrazos);
        this.menuOpcoes.add(this.itemDefinirPadrao);
        this.menuOpcoes.add(new JSeparator());
        this.menuOpcoes.add(this.itemMarcarBloqueado);
        this.menuOpcoes.add(this.itemDesmarcarBloqueado);
        JPanel panelCadastro = new JPanel(new GridBagLayout());
        this.panelPrincipal.add((Component)panelCadastro, "North");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 1, 0, 0);
        this.labelCodigo.setDisplayedMnemonic('E');
        this.labelCodigo.setLabelFor(this.textCodigo);
        panelCadastro.add((Component)this.labelCodigo, c);
        c.gridx = 3;
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.comboMaterial);
        panelCadastro.add((Component)this.labelMaterial, c);
        ++c.gridy;
        c.gridx = 0;
        this.textCodigo.setUpperCase(true);
        this.textCodigo.setPreferredSize(new Dimension(90, 21));
        panelCadastro.add((Component)this.textCodigo, c);
        ++c.gridx;
        panelCadastro.add((Component)this.buttonPesquisar, c);
        ++c.gridx;
        c.weightx = 3.0;
        c.fill = 2;
        this.labelDescricaoExame.setPreferredSize(new Dimension(20, 20));
        this.labelDescricaoExame.setBorder(new TitledBorder(""));
        panelCadastro.add((Component)this.labelDescricaoExame, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.comboMaterial.setPreferredSize(new Dimension(50, 20));
        panelCadastro.add((Component)this.comboMaterial, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonOK.setMnemonic('O');
        this.buttonOK.setPreferredSize(new Dimension(55, 20));
        panelCadastro.add((Component)this.buttonOK, c);
        JPanel panelLista = new JPanel(new GridBagLayout());
        this.panelPrincipal.add((Component)panelLista, "Center");
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.panelPrincipal.add((Component)panelBotoes, "South");
        this.montaPanelExames(panelLista);
        this.buttonOpcoes.setMnemonic('O');
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonOpcoes), "West");
        this.buttonFechar.setMnemonic('F');
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonFechar), "East");
        Funcoes.montaEnter((JComponent)this.getContentPane());
        this.montaListeners();
        ScreenUtil.centralizar(this);
    }

    private void montaListeners() {
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.textCodigo.addFocusListener(this);
        ScreenUtil.requisitarFoco(this.textCodigo);
        this.buttonOpcoes.addActionListener(this);
        this.buttonAlterar.addActionListener(this);
        this.buttonDesmembrar.addActionListener(this);
        this.buttonFechar.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.itemImprimirListagem.addActionListener(this);
        this.itemDefinirPadrao.addActionListener(this);
        this.itemAlterarPrazos.addActionListener(this);
        this.itemAlterarSetores.addActionListener(this);
        this.itemMarcarBloqueado.addActionListener(this);
        this.itemDesmarcarBloqueado.addActionListener(this);
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int colunaOrdenacao = RelacionamentoLabExterno.this.modeloExames.getColunaOrdenacao();
                int row = -1;
                row = colunaOrdenacao == 1 ? RelacionamentoLabExterno.this.modeloExames.localizarParcial(RelacionamentoLabExterno.this.modeloExames.getColunaOrdenacao(), RelacionamentoLabExterno.this.textLocalizar.getText()) : RelacionamentoLabExterno.this.modeloExames.localizarContendo(RelacionamentoLabExterno.this.modeloExames.getColunaOrdenacao(), RelacionamentoLabExterno.this.textLocalizar.getText());
                if (row >= 0) {
                    RelacionamentoLabExterno.this.tableExames.getSelectionModel().setSelectionInterval(row, row);
                    Rectangle rect = RelacionamentoLabExterno.this.tableExames.getCellRect(row, 0, true);
                    RelacionamentoLabExterno.this.tableExames.scrollRectToVisible(rect);
                } else {
                    RelacionamentoLabExterno.this.tableExames.getSelectionModel().clearSelection();
                }
            }
        });
        this.textCodigo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getSource() == RelacionamentoLabExterno.this.textCodigo && e.getKeyCode() == 113) {
                    RelacionamentoLabExterno.this.buttonPesquisar.doClick();
                }
            }
        });
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RelacionamentoLabExterno.this.atualizaDetalhes();
                this.controlaBotaoAlterarRelacionamento();
            }

            private void controlaBotaoAlterarRelacionamento() {
                RelacionamentoLabExterno.this.buttonAlterar.setEnabled(RelacionamentoLabExterno.this.tableExames.getSelectedRow() >= 0);
                RelacionamentoLabExterno.this.buttonDesmembrar.setEnabled(RelacionamentoLabExterno.this.tableExames.getSelectedRow() >= 0);
            }
        });
    }

    private void montaPanelExames(JPanel panelLista) {
        panelLista.setBorder(new TitledBorder("Exames"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 1, 0, 0);
        JScrollPane scrollExames = new JScrollPane(this.tableExames);
        scrollExames.setPreferredSize(new Dimension(0, 180));
        panelLista.add((Component)scrollExames, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        JPanel panelDetalhes = new JPanel(new GridBagLayout());
        panelDetalhes.setBorder(new TitledBorder("Detalhes do relacionamento"));
        panelLista.add((Component)panelDetalhes, c);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 17;
        JPanel panelPesquisar = new JPanel(new GridBagLayout());
        panelPesquisar.setBorder(new TitledBorder(""));
        panelLista.add((Component)panelPesquisar, c);
        this.montaPanelDetalhes(panelDetalhes);
        this.montaPanelLocalizar(panelPesquisar);
    }

    private void montaPanelDetalhes(JPanel panelDetalhes) {
        Insets insetLabel = new Insets(1, 1, 1, 0);
        Insets insetDescricao = new Insets(1, 0, 1, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = insetLabel;
        panelDetalhes.add((Component)this.labelDetalheSetor, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = insetDescricao;
        this.labelDetalheDescSetor.setBorder(new TitledBorder(""));
        this.labelDetalheDescSetor.setPreferredSize(new Dimension(240, 20));
        this.labelDetalheDescSetor.setMinimumSize(new Dimension(240, 20));
        panelDetalhes.add((Component)this.labelDetalheDescSetor, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = insetLabel;
        panelDetalhes.add((Component)this.labelDetalhePrazoLabExterno, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = insetDescricao;
        this.labelDetalheDescPrazoLabExterno.setBorder(new TitledBorder(""));
        this.labelDetalheDescPrazoLabExterno.setPreferredSize(new Dimension(70, 20));
        this.labelDetalheDescPrazoLabExterno.setMinimumSize(new Dimension(70, 20));
        panelDetalhes.add((Component)this.labelDetalheDescPrazoLabExterno, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = insetLabel;
        panelDetalhes.add((Component)this.labelDetalhePadrao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = insetLabel;
        c.gridwidth = 0;
        this.labelDetalheDescPadrao.setBorder(new TitledBorder(""));
        this.labelDetalheDescPadrao.setPreferredSize(new Dimension(70, 20));
        this.labelDetalheDescPadrao.setMinimumSize(new Dimension(70, 20));
        panelDetalhes.add((Component)this.labelDetalheDescPadrao, c);
        ++c.gridx;
        c.anchor = 13;
        panelDetalhes.add((Component)this.buttonDesmembrar, c);
        c.anchor = 17;
        c.insets = insetLabel;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panelDetalhes.add((Component)this.labelDetalhePrazo, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = insetDescricao;
        this.labelDetalheDescPrazo.setBorder(new TitledBorder(""));
        this.labelDetalheDescPrazo.setPreferredSize(new Dimension(240, 20));
        this.labelDetalheDescPrazo.setMinimumSize(new Dimension(240, 20));
        panelDetalhes.add((Component)this.labelDetalheDescPrazo, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = insetLabel;
        panelDetalhes.add((Component)this.labelDetalhePrecoLabExterno, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = insetDescricao;
        this.labelDetalheDescPrecoLabExterno.setBorder(new TitledBorder(""));
        this.labelDetalheDescPrecoLabExterno.setPreferredSize(new Dimension(70, 20));
        this.labelDetalheDescPrecoLabExterno.setMinimumSize(new Dimension(70, 20));
        panelDetalhes.add((Component)this.labelDetalheDescPrecoLabExterno, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.insets = insetLabel;
        panelDetalhes.add((Component)this.labelDetalheBloqueado, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.insets = insetDescricao;
        this.labelDetalheDescBloqueado.setBorder(new TitledBorder(""));
        this.labelDetalheDescBloqueado.setPreferredSize(new Dimension(70, 20));
        this.labelDetalheDescBloqueado.setMinimumSize(new Dimension(70, 20));
        panelDetalhes.add((Component)this.labelDetalheDescBloqueado, c);
        c.gridx += 2;
        c.anchor = 13;
        c.insets = insetLabel;
        this.buttonAlterar.setMnemonic('A');
        this.buttonDesmembrar.setMnemonic('D');
        this.buttonAlterar.setEnabled(false);
        this.buttonDesmembrar.setEnabled(false);
        panelDetalhes.add((Component)this.buttonAlterar, c);
    }

    private void montaPanelLocalizar(JPanel panelPesquisar) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 0, 1);
        this.labelLocalizar.setDisplayedMnemonic('L');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        panelPesquisar.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.textLocalizar.setMinimumSize(new Dimension(20, 20));
        panelPesquisar.add((Component)this.textLocalizar, c);
    }

    protected void atualizaDetalhes() {
        int row = this.tableExames.getSelectedRow();
        if (row >= 0) {
            String setor = (String)this.modeloExames.getValueAt(row, 9);
            String prazo = (String)this.modeloExames.getValueAt(row, 10);
            String prazoLab = this.modeloExames.getValueAt(row, 11).toString();
            String precoLab = (String)this.modeloExames.getValueAt(row, 12);
            Boolean bloqueado = (Boolean)this.modeloExames.getValueAt(row, 13);
            Boolean padrao = (Boolean)this.modeloExames.getValueAt(row, 14);
            this.labelDetalheDescSetor.setText(setor);
            this.labelDetalheDescPrazo.setText(prazo);
            this.labelDetalheDescPrazoLabExterno.setText(prazoLab);
            this.labelDetalheDescPrecoLabExterno.setText(Funcoes.formataDecimal(Double.parseDouble(Funcoes.limpaDecimal(precoLab)), 4));
            this.labelDetalheDescBloqueado.setText(bloqueado != false ? "Sim" : "N\u00e3o");
            this.labelDetalheDescPadrao.setText(padrao != false ? "Sim" : "N\u00e3o");
        }
    }

    private void configurarProtocolo() {
        if (Funcoes.textoVazio(this.textCodigo)) {
            Funcoes.mensagem(this, "O exame deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return;
        }
        if (this.comboMaterial.getSelectedItem() == null) {
            Funcoes.mensagem(this, "O material de coleta deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboMaterial);
            return;
        }
        int row = this.modeloExames.localizarAvancado(new int[]{1, 2}, new String[]{this.textCodigo.getText(), ((DadosMaterial)this.comboMaterial.getSelectedItem()).getAbreviatura()});
        if (row > -1) {
            this.tableExames.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollToVisible(this.tableExames, row);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return;
        }
        DadosMaterial dadosMaterial = (DadosMaterial)this.comboMaterial.getSelectedItem();
        ExameMatColetaBean exaMat = null;
        Set listaRecipientes = null;
        try {
            exaMat = (ExameMatColetaBean)new ExameMatColetaService().getBean(Variaveis.filialPadrao, this.textCodigo.getText().toUpperCase(), String.valueOf(dadosMaterial.getCodigo()));
            StringBuilder buf = new StringBuilder();
            buf.append("where fil_codigo = '").append(exaMat.getFilial().getCodigo()).append("'");
            buf.append("  and exa_codigo = '").append(exaMat.getExame().getCodigo()).append("'");
            buf.append("  and mco_codigo = ").append(exaMat.getMaterial().getCodigo());
            listaRecipientes = new RecipienteColetaService().load(buf.toString());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return;
        }
        try {
            String labExternoEmUso = new ExameMatColetaLabExternoService().verificaHaAssociacaoExameMaterialLabExternoMetodologia(exaMat, this.metodoPadrao, Integer.parseInt(this.codigoLabExterno));
            MetodologiaVO metodologia = (MetodologiaVO)new MetodologiaService().getVO(Variaveis.filialPadrao, this.metodoPadrao.toString());
            if (!Funcoes.textoVazio(labExternoEmUso)) {
                Funcoes.mensagem(this, "O laborat\u00f3rio externo \"" + labExternoEmUso + "\" est\u00e1 associado \u00e0 metodologia \"" + metodologia.getDescricao() + "\".\nAltere a metodologia do laborat\u00f3rio externo associado ou utilize outra metodologia.", 2);
                ScreenUtil.requisitarFoco(this.textCodigo);
                return;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar se j\u00e1 h\u00e1 um laborat\u00f3rio externo associado \u00e0 metodologia padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        Protocolo protocolo = this.protocolo;
        AbstractConfigurador c = FabricaConfigurador.novoConfigurador(this, protocolo, this.codigoLabExterno);
        if (c != null && exaMat.getXmlLabExterno() != null && this.modeloExames.getRowCount() > 0) {
            HashMap<String, String> recipientes = new HashMap<String, String>();
            if (listaRecipientes != null) {
                for (RecipienteColetaBean rec : listaRecipientes) {
                    if (rec == null || rec.getRecipiente() == null) continue;
                    recipientes.put(rec.getRecipiente().getCodigo().toString(), rec.getRecipiente().getDescricao());
                }
                c.setRecipientes(recipientes);
            }
        }
        if (c != null) {
            c.setVisible(true);
            if (c.getOK()) {
                ConfiguracaoPrecoPrazo configuraPrecoPrazo;
                boolean exigirJejum = exaMat.isObrigaPeso();
                boolean exigirDUM = exaMat.isObrigaDum();
                boolean exigirPeso = exaMat.isObrigaPeso();
                boolean exigirAltura = exaMat.isObrigaAltura();
                boolean exigirVolume = exaMat.isObrigaVolume();
                boolean exigirTempoDiurese = exaMat.isObrigaTempoDiurese();
                boolean exigirMedicamento = exaMat.isObrigaMedicamento();
                if (c.exigeAltura() && !exaMat.isObrigaAltura().booleanValue()) {
                    exigirAltura = c.exigeAltura();
                }
                if (c.exigePeso() && !exaMat.isObrigaPeso().booleanValue()) {
                    exigirPeso = c.exigePeso();
                }
                if (c.exigeTempoDiurese() && !exaMat.isObrigaTempoDiurese().booleanValue()) {
                    exigirTempoDiurese = c.exigeTempoDiurese();
                }
                if (c.exigeVolumeDiurese() && !exaMat.isObrigaVolume().booleanValue()) {
                    exigirVolume = c.exigeVolumeDiurese();
                }
                if (c.exigeJejum() && !exaMat.isSolicitarJejum().booleanValue()) {
                    exigirJejum = c.exigeJejum();
                }
                if (c.exigeDUM() && !exaMat.isObrigaDum().booleanValue()) {
                    exigirDUM = c.exigeDUM();
                }
                if (c.exigeMedicamento() && !exaMat.isObrigaMedicamento().booleanValue()) {
                    exigirMedicamento = c.exigeMedicamento();
                }
                if ((configuraPrecoPrazo = ConfiguracaoPrecoPrazo.novaInstancia(this, "Informe o pre\u00e7o e prazo")) != null) {
                    configuraPrecoPrazo.setVisible(true);
                    if (configuraPrecoPrazo.getOK()) {
                        try {
                            SetorVO setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, String.valueOf(this.setorPadrao));
                            PrazoEntregaVO prazo = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, String.valueOf(this.prazoPadrao));
                            Boolean examePadrao = Boolean.TRUE;
                            examePadrao = RelacionamentoLabExterno.verificaExamePadrao(exaMat.getExame().getCodigo(), exaMat.getMaterial().getCodigo(), this.codigoLabExterno);
                            Integer prazoLabExt = Funcoes.isNumeric(configuraPrecoPrazo.getPrazo()) ? Integer.parseInt(configuraPrecoPrazo.getPrazo()) : 0;
                            Double precoLabExt = Funcoes.isNumeric(configuraPrecoPrazo.getPreco()) ? Double.parseDouble(configuraPrecoPrazo.getPreco()) : new Double("0");
                            DadosModelo modelo = RelacionamentoLabExterno.buscaModelo(exaMat, this.metodoPadrao);
                            RelacionamentoLabExterno.insereExameMatLabExterno(exaMat, c.getXML(), prazoLabExt, precoLabExt, examePadrao, this.metodoPadrao, this.codigoLabExterno);
                            for (int i = 0; i < modelo.getCountModelos(); ++i) {
                                Modelos model = modelo.getModelos(i);
                                for (int j = 0; j < model.getCountMetodoModelo(); ++j) {
                                    MetodoModelo metodo = model.getMetodoModelo(j);
                                    HashMap<String, String> params = new HashMap<String, String>();
                                    params.put("fil_codigo", exaMat.getExame().getFilial().getCodigo().toString());
                                    params.put("lae_codigo", this.codigoLabExterno);
                                    params.put("exa_codigo", exaMat.getExame().getCodigo());
                                    params.put("mco_codigo", exaMat.getMaterial().getCodigo().toString());
                                    ArrayList interfaceDesmembraLabExterno = new ExameMatColetaLabExternoService().obterExameDesmembradoLabExterno(params);
                                    if (setor == null || prazo == null) {
                                        StringBuilder buf = new StringBuilder();
                                        buf.append(" select st.set_codigo, mt.prz_codigo from exames ex ");
                                        buf.append(" join examematcoleta mt on ex.fil_codigo = mt.fil_codigo and ex.exa_codigo = mt.exa_codigo ");
                                        buf.append(" join examesetor st on st.fil_codigo = ex.fil_codigo and st.exa_codigo = ex.exa_Codigo  ");
                                        buf.append(" where ex.fil_codigo = ").append(exaMat.getExame().getFilial().getCodigo().toString());
                                        buf.append(" and ex.exa_codigo = '").append(exaMat.getExame().getCodigo()).append("'");
                                        buf.append(" and mt.mco_codigo = ").append(exaMat.getMaterial().getCodigo().toString());
                                        buf.append("  ");
                                        buf.append("  ");
                                        Statement st = Conexao.getStatement();
                                        ResultSet rsExame = Conexao.executeQuery(st, buf.toString());
                                        if (rsExame.next()) {
                                            if (setor == null) {
                                                setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, String.valueOf(rsExame.getInt("set_codigo")));
                                            }
                                            if (prazo == null) {
                                                prazo = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, String.valueOf(rsExame.getInt("prz_codigo")));
                                            }
                                        }
                                    }
                                    Object[] exame = this.adicionaObjeto(Boolean.FALSE, exaMat.getExame().getCodigo(), exaMat.getMaterial().getAbreviatura(), exaMat.getExame().getDescricao(), FabricaConfigurador.getDescricaoExameSelecionado(protocolo, this.codigoLabExterno, c.getXML()), model.getDescricao(), metodo.getDescricaoMetodo(), setor != null ? setor.getDescricao() : "", prazo.getDescricao(), prazoLabExt, String.valueOf(precoLabExt), Boolean.FALSE, examePadrao, setor.getCodigo(), prazo.getCodigo(), metodo.getCodigoMetodo(), model.getCodigo(), model.getIdadeMax(), model.getIdadeMin(), model.getTipoIdadeMax(), model.getTipoIdadeMin(), String.valueOf(exaMat.getMaterial().getCodigo()), null, interfaceDesmembraLabExterno);
                                    this.modeloExames.addLine(exame);
                                    this.limparCampos();
                                    row = this.tableExames.getRowCount() - 1;
                                    this.tableExames.getSelectionModel().setSelectionInterval(row, row);
                                    TableUtil.scrollToVisible(this.tableExames, row);
                                    ExameMatColetaVO exameMatVO = (ExameMatColetaVO)new ExameMatColetaService().getVO(Variaveis.filialPadrao, String.valueOf(exaMat.getExame().getCodigo()), String.valueOf(exaMat.getMaterial().getCodigo()));
                                    this.alterarSetor(exameMatVO, setor.getCodigo());
                                    this.alterarPrazo(exameMatVO, prazo.getCodigo());
                                    this.alterarMetodoPadraoExameMaterial(exaMat, this.metodoPadrao);
                                }
                            }
                            new ExameMatColetaService().atualizaCamposObrigatoriosExameMaterial(exaMat, ParametrosGerais.getCopiaExame(), exigirAltura, exigirPeso, exigirTempoDiurese, exigirJejum, exigirDUM, exigirMedicamento);
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                        }
                    }
                }
            }
        }
        ScreenUtil.requisitarFoco(this.textCodigo);
    }

    private void limparCampos() {
        this.textCodigo.setText("");
        this.textLocalizar.setText("");
        this.labelDescricaoExame.setText("");
    }

    private void alterarMetodoPadraoExameMaterial(ExameMatColetaBean exaMat, Integer metodoPadrao) {
        try {
            new ExameMatColetaService().alteraMetodoPadraoExameMaterial((ExameMatColetaVO)exaMat.toVO(), metodoPadrao, ParametrosGerais.getCopiaExame());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar a metodologia padr\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    public static void insereExameMatLabExterno(ExameMatColetaBean exaMat, String xml, int prazoLabExt, Double valorExame, Boolean padrao, Integer metodoPadrao, String codigoLabExterno) throws Exception {
        ExameMatColetaLabExternoBean bean = new ExameMatColetaLabExternoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(new Integer(Variaveis.filialPadrao));
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setCodigo(metodoPadrao);
        metodo.setFilial(filial);
        metodo.setDescricao("");
        LabExternoVO labexterno = new LabExternoVO();
        labexterno.setCodigo(Integer.parseInt(codigoLabExterno));
        labexterno.setFilial(filial);
        bean.setFilial(filial);
        bean.setExame(exaMat.getExame());
        bean.setDiasprazo(prazoLabExt);
        bean.setLaboratorioExterno(labexterno);
        bean.setMatColeta(exaMat.getMaterial());
        bean.setMetodologia(metodo);
        bean.setPadrao(padrao);
        bean.setValorExame(valorExame);
        bean.setXmlLabExterno(xml);
        bean.setBloqueado(false);
        new ExameMatColetaLabExternoService().delete(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
        new ExameMatColetaLabExternoService().insert(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
    }

    private boolean atualizaExameMatLabExterno(String xml, String codigoExame, int codigoMaterial, Integer prazoLabExt, Double precoLabExt, boolean padrao, boolean bloqueado, boolean padraoAlterado) {
        FilialVO filial = new FilialVO();
        filial.setCodigo(new Integer(Variaveis.filialPadrao));
        ExameVO exameVO = new ExameVO();
        exameVO.setFilial(filial);
        exameVO.setCodigo(codigoExame);
        MaterialColetaVO materialVO = new MaterialColetaVO();
        materialVO.setFilial(filial);
        materialVO.setCodigo(codigoMaterial);
        LabExternoVO labexterno = new LabExternoVO();
        labexterno.setCodigo(Integer.parseInt(this.codigoLabExterno));
        labexterno.setFilial(filial);
        ExameMatColetaLabExternoBean bean = new ExameMatColetaLabExternoBean();
        bean.setFilial(filial);
        bean.setExame(exameVO);
        bean.setMatColeta(materialVO);
        bean.setLaboratorioExterno(labexterno);
        bean.setDiasprazo(prazoLabExt);
        bean.setValorExame(precoLabExt);
        bean.setPadrao(padrao);
        bean.setBloqueado(bloqueado);
        bean.setXmlLabExterno(xml);
        boolean naoHaOutroLabExterno = false;
        try {
            new ExameMatColetaLabExternoService().update(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
            ExameMatColetaVO exameMatColetaVO = new ExameMatColetaVO();
            exameMatColetaVO.setFilial(filial);
            exameMatColetaVO.setExame(exameVO);
            exameMatColetaVO.setMaterial(materialVO);
            if (padraoAlterado) {
                if (!padrao) {
                    naoHaOutroLabExterno = new ExameMatColetaLabExternoService().verificaExameMaterialTemLabExternoPadrao(exameMatColetaVO, Integer.parseInt(this.codigoLabExterno), Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
                } else {
                    new ExameMatColetaLabExternoService().setLaboratorioExternoPadraoExameMaterial(exameMatColetaVO, Integer.parseInt(this.codigoLabExterno), Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
                }
            }
            Conexao.arquivaSQL();
            return naoHaOutroLabExterno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar as informa\u00e7\u00f5es do examematcoletalabexterno.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    public static Boolean verificaExamePadrao(String exame, int material, String codigoLabExterno) throws Exception {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append(" and lae_codigo <> ").append(codigoLabExterno);
        where.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
        where.append(" and mco_codigo = ").append(material);
        where.append(" and coalesce(ele_padrao, false) ");
        Set exames = new ExameMatColetaLabExternoService().loadVO(where.toString());
        return exames.isEmpty();
    }

    public void configurarLaudo(int row) {
        try {
            String modelo = this.pegaModelo(row);
            ExameMatColetaLabExternoBean exameLabExt = this.pegaExameLabExt(row);
            if (exameLabExt != null && Funcoes.textoVazio(exameLabExt.getXmlLabExterno())) {
                String mensagem = "O relacionamento com o exame do laborat\u00f3rio externo n\u00e3o foi encontrado.\nO relacionamento \u00e9 necess\u00e1rio para alterar o layout do exame.\nDeseja relacionar o exame?";
                String xml = null;
                String nomeExame = "";
                Integer metodo = (Integer)this.modeloExames.getValueAt(row, 17);
                if (Funcoes.mensagem(this, mensagem, 4) == 0) {
                    xml = this.configurarProtocoloLaudo(exameLabExt.getExame().getCodigo(), this.protocolo, exameLabExt.getMatColeta().getCodigo().toString(), this.codigoLabExterno, metodo, this.setorPadrao, this.prazoPadrao);
                    if (!Funcoes.textoVazio(xml) && xml.contains("descricao") && Funcoes.textoVazio(nomeExame = StringUtil.getValor(xml, "descricao")) && xml.contains("descricao-exame")) {
                        nomeExame = StringUtil.getValor(xml, "descricao-exame");
                    }
                } else {
                    return;
                }
                this.modeloExames.setValueAt(nomeExame, row, 4);
                if (!Funcoes.textoVazio(xml)) {
                    exameLabExt.setXmlLabExterno(xml);
                } else {
                    return;
                }
            }
            String codExameLabExterno = "";
            String xmlExameLabExterno = "";
            if (exameLabExt != null) {
                xmlExameLabExterno = exameLabExt.getXmlLabExterno();
                codExameLabExterno = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(this.protocolo, this.codigoLabExterno, xmlExameLabExterno);
            }
            String codigoExame = this.modeloExames.getValueAt(row, 1).toString();
            String nomeExame = this.modeloExames.getValueAt(row, 3).toString();
            String codigoMaterial = this.modeloExames.getValueAt(row, 23).toString();
            String codigoLayout = this.modeloExames.getValueAt(row, 18).toString();
            String idadeIni = this.modeloExames.getValueAt(row, 20).toString();
            String idadeFim = this.modeloExames.getValueAt(row, 19).toString();
            String idadeIniTipo = this.modeloExames.getValueAt(row, 22).toString();
            String idadeFimTipo = this.modeloExames.getValueAt(row, 21).toString();
            String codigoMetodo = this.modeloExames.getValueAt(row, 17).toString();
            String tags = this.getTags(codigoExame);
            ArrayList listaExamesDesm = (ArrayList)this.modeloExames.getValueAt(row, 24);
            DialogoConfigurador configurador = new DialogoConfigurador(this, "Configurando modelo [" + codigoExame + " - " + nomeExame + "]", true, false, this.protocolo, this.codigoLabExterno, codExameLabExterno, xmlExameLabExterno);
            configurador.setTipoConfiguracao(0);
            configurador.setExameLabExterno(this.protocolo, this.codigoLabExterno, codExameLabExterno, xmlExameLabExterno, listaExamesDesm, Integer.parseInt(codigoMaterial));
            if (!Funcoes.textoVazio(tags)) {
                configurador.setTags(tags);
            }
            String[] perguntasFilialRequisicao = null;
            String perguntasFilial = this.obtemPerguntasFilial();
            String perguntas = this.obtemPerguntas(row);
            String xmlCabecalhoExame = this.obtemXmlCabecalhoExame(row);
            Map<String, Map<String, String>> historicos = this.carregarHistoricosExame(row);
            if (historicos.isEmpty() || historicos.get("historicoporcodigo").isEmpty()) {
                historicos = this.carregarHistoricos();
            }
            if (!Funcoes.textoVazio(perguntasFilial)) {
                Digitacao dig = new Digitacao();
                dig.carregarCampos(perguntasFilial, true);
                Map<String, Object> perguntasRequisicao = Resultado.getCamposResultado(dig.getResultado());
                perguntasFilialRequisicao = perguntasRequisicao.keySet().toArray(new String[perguntasRequisicao.size()]);
            }
            if (perguntasFilialRequisicao != null) {
                configurador.setCamposBanco(ArraysUtil.concatenar(ArraysUtil.concatenar(Impressao.CAMPOS_EXAME, Impressao.getCamposMedicamento()), perguntasFilialRequisicao));
            } else {
                configurador.setCamposBanco(ArraysUtil.concatenar(Impressao.CAMPOS_EXAME, Impressao.getCamposMedicamento()));
            }
            configurador.setCamposAssinatura(Impressao.CAMPOS_ASSINATURA_LAUDO);
            configurador.setFormatacaoExterna(perguntas);
            configurador.setImpressoraPadraoSistema(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraLaudo")));
            if (!Funcoes.textoVazio(xmlCabecalhoExame)) {
                configurador.setAtributosDaPagina(xmlCabecalhoExame);
                configurador.setCabecalhoImpressaoSistema(xmlCabecalhoExame);
            }
            configurador.setHistoricos(historicos);
            configurador.setAtributos(modelo);
            configurador.setAtributosDaPagina(xmlCabecalhoExame);
            configurador.setVisible(true);
            if (configurador.ok()) {
                String atributos = "";
                if (configurador.contemConfiguracao()) {
                    atributos = configurador.getAtributos();
                    this.salvaFormatoLayout(atributos, codigoExame, codigoMaterial, codigoLayout, idadeIni, idadeFim, idadeIniTipo, idadeFimTipo, codigoMetodo);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel pegar o modelo\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void salvaFormatoLayout(String atributos, String codigoExame, String codigoMaterial, String codigoLayout, String idadeIni, String idadeFim, String idadeIniTipo, String idadeFimTipo, String codigoMetodo) throws Exception {
        ExameLayoutMetodoService service = new ExameLayoutMetodoService();
        ExameLayoutMetodoBean bean = new ExameLayoutMetodoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        MaterialColetaVO matColeta = new MaterialColetaVO();
        matColeta.setCodigo(Integer.parseInt(codigoMaterial));
        matColeta.setFilial(filial);
        matColeta.setDescricao("");
        ExameVO exame = new ExameVO();
        exame.setCodigo(codigoExame);
        exame.setFilial(filial);
        exame.setDescricao("");
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setCodigo(Integer.parseInt(codigoMetodo));
        metodo.setFilial(filial);
        metodo.setDescricao("");
        LayoutVO layout = new LayoutVO();
        layout.setFilial(filial);
        layout.setCodigo(Integer.parseInt(codigoLayout));
        layout.setDescricao("");
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setLayout(layout);
        bean.setMatColeta(matColeta);
        bean.setMetodologia(metodo);
        bean.setFormato(atributos);
        bean.setIdadeInicial(Integer.parseInt(idadeIni));
        bean.setIdadeFim(Integer.parseInt(idadeFim));
        bean.setIdadeInicioTipo(idadeIniTipo);
        bean.setIdadeFimTipo(idadeFimTipo);
        service.update(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
        Conexao.arquivaSQL();
    }

    private Map<String, Map<String, String>> carregarHistoricosExame(int row) throws Exception {
        HashMap<String, Map<String, String>> historicos = new HashMap<String, Map<String, String>>();
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(this.modeloExames.getValueAt(row, 1).toString()));
        Set exaHistoricos = new ExameHistoricoService().load(where.toString());
        HashMap<String, String> his = new HashMap<String, String>();
        HashMap<String, String> mne = new HashMap<String, String>();
        for (ExameHistoricoBean exame : exaHistoricos) {
            HistoricoVO histo = exame.getHistorico();
            if (histo == null) continue;
            his.put(String.valueOf(histo.getCodigo()), histo.getDescricao());
            if (Funcoes.textoVazio(histo.getMnemonico())) continue;
            mne.put(histo.getMnemonico(), histo.getDescricao());
        }
        historicos.put("historicoporcodigo", his);
        historicos.put("historicopormnemonico", mne);
        return historicos;
    }

    private Map<String, Map<String, String>> carregarHistoricos() throws Exception {
        HashMap<String, Map<String, String>> historicos = new HashMap<String, Map<String, String>>();
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        Set historicosBean = new HistoricoService().load(where.toString());
        HashMap<String, String> his = new HashMap<String, String>();
        HashMap<String, String> mne = new HashMap<String, String>();
        for (HistoricoBean hist : historicosBean) {
            his.put(hist.getCodigo().toString(), hist.getDescricao());
            if (Funcoes.textoVazio(hist.getMnemonico())) continue;
            mne.put(hist.getMnemonico(), hist.getDescricao());
        }
        historicos.put("historicoporcodigo", his);
        historicos.put("historicopormnemonico", mne);
        return historicos;
    }

    private String obtemXmlCabecalhoExame(int row) throws Exception {
        LayoutBean layout = (LayoutBean)new LayoutService().get(Variaveis.filialPadrao, this.modeloExames.getValueAt(row, 18).toString());
        return layout.getCabecalhoLaudo();
    }

    private String obtemPerguntasFilial() throws Exception {
        FilialBean filial = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
        return filial.getPerguntas();
    }

    private String obtemPerguntas(int row) throws Exception {
        ExameMatColetaBean exameMat = (ExameMatColetaBean)new ExameMatColetaService().getBean(Variaveis.filialPadrao, this.modeloExames.getValueAt(row, 1).toString(), this.modeloExames.getValueAt(row, 23).toString());
        return exameMat.getPergunta();
    }

    private String pegaModelo(int row) throws Exception {
        String filialPadrao = Variaveis.filialPadrao;
        String codigoExame = this.modeloExames.getValueAt(row, 1).toString();
        String codigoMaterial = this.modeloExames.getValueAt(row, 23).toString();
        String codigoMetodo = this.modeloExames.getValueAt(row, 17).toString();
        String codigoLayout = this.modeloExames.getValueAt(row, 18).toString();
        String idadeFim = this.modeloExames.getValueAt(row, 19).toString();
        String idadeIni = this.modeloExames.getValueAt(row, 20).toString();
        String idadeFimTipo = this.modeloExames.getValueAt(row, 21).toString();
        String idadeIniTipo = this.modeloExames.getValueAt(row, 22).toString();
        String formato = this.pegaModelo(filialPadrao, codigoExame, codigoMaterial, codigoMetodo, codigoLayout, idadeFim, idadeIni, idadeFimTipo, idadeIniTipo);
        return formato;
    }

    private String pegaModelo(String filialPadrao, String codigoExame, String codigoMaterial, String codigoMetodo, String codigoLayout, String idadeFim, String idadeIni, String idadeFimTipo, String idadeIniTipo) throws Exception {
        String formato;
        block1: {
            ExameLayoutMetodoBean exameLayoutMetodoBean;
            formato = "";
            StringBuilder where = new StringBuilder();
            where.append(" where fil_codigo = ").append(filialPadrao);
            where.append(" and exa_codigo=").append(StringUtil.textoDBEscape(codigoExame));
            where.append(" and mco_codigo=").append(codigoMaterial);
            where.append(" and met_codigo=").append(codigoMetodo);
            where.append(" and lay_codigo = ").append(codigoLayout);
            where.append(" and ela_idadefim = ").append(idadeFim);
            where.append(" and ela_idadeini = ").append(idadeIni);
            where.append(" and ela_idadefimtipo = ").append(StringUtil.textoDBEscape(idadeFimTipo));
            where.append(" and ela_idadeinitipo = ").append(StringUtil.textoDBEscape(idadeIniTipo));
            Set layout = new ExameLayoutMetodoService().load(where.toString());
            if (layout.isEmpty()) break block1;
            Iterator iterator = layout.iterator();
            while (iterator.hasNext() && Funcoes.textoVazio(formato = (exameLayoutMetodoBean = (ExameLayoutMetodoBean)iterator.next()).getFormato())) {
            }
        }
        return formato;
    }

    private ExameMatColetaLabExternoBean pegaExameLabExt(int row) throws Exception {
        Iterator iterator;
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append(" and lae_codigo = ").append(this.codigoLabExterno);
        where.append(" and exa_codigo=").append(StringUtil.textoDBEscape(this.modeloExames.getValueAt(row, 1).toString()));
        where.append(" and mco_codigo=").append(this.modeloExames.getValueAt(row, 23));
        where.append(" and met_codigo=").append(this.modeloExames.getValueAt(row, 17));
        Set exame = new ExameMatColetaLabExternoService().load(where.toString());
        if (!exame.isEmpty() && (iterator = exame.iterator()).hasNext()) {
            ExameMatColetaLabExternoBean exameMatColetaLabExterno = (ExameMatColetaLabExternoBean)iterator.next();
            return exameMatColetaLabExterno;
        }
        return null;
    }

    private void buscaExame() {
        if (!Funcoes.textoVazio(this.textCodigo.getText())) {
            this.textCodigo.clear();
        }
        this.comboMaterial.grabFocus();
        Hashtable resultado = Pesquisas.exameAMB(this, Variaveis.filialPadrao, false, true);
        if (resultado != null) {
            this.textCodigo.setText(resultado.get("exa_codigo").toString());
            int codMaterial = Integer.parseInt(resultado.get("mco_codigo").toString());
            this.buscaDescricaoExame();
            for (int i = 0; i < this.comboMaterial.getItemCount(); ++i) {
                DadosMaterial mat = (DadosMaterial)this.comboMaterial.getItemAt(i);
                if (mat.getCodigo() != codMaterial) continue;
                this.comboMaterial.setSelectedIndex(i);
                break;
            }
            this.comboMaterial.grabFocus();
        } else {
            this.textCodigo.grabFocus();
        }
    }

    private void buscaDescricaoExame() {
        block5: {
            if (!Funcoes.textoVazio(this.textCodigo.getText())) {
                try {
                    Statement st = Conexao.getStatement();
                    if (st == null) break block5;
                    ResultSet rs = Conexao.executeQuery(st, "select exa_descricao from exames where fil_codigo=" + Variaveis.filialPadrao + " and upper(exa_codigo)=upper('" + this.textCodigo.getTextDB() + "')");
                    if (rs.next()) {
                        ExameUtil.carregarMateriaisColeta(this.textCodigo.getText(), Variaveis.filialPadrao, this.comboMaterial);
                        this.labelDescricaoExame.setText(rs.getString("exa_descricao"));
                        break block5;
                    }
                    this.labelDescricaoExame.setText("N\u00e3o cadastrado");
                    Funcoes.mensagem(this, "Exame n\u00e3o localizado", 1);
                    ScreenUtil.requisitarFoco(this.textCodigo);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel encontrar o exame.\n" + ex.getMessage(), ex.getStackTrace());
                }
            } else {
                this.labelDescricaoExame.setText("");
            }
        }
    }

    private String getTags(String exame) {
        try {
            Statement st = Conexao.getStatement();
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, "select tag_nome from tagsresultadoanterior where fil_codigo=" + Variaveis.filialPadrao + " and upper(exa_codigo)=upper('" + exame + "')");
                StringBuilder tags = new StringBuilder();
                if (rs.next()) {
                    tags.append(rs.getString("tag_nome"));
                    while (rs.next()) {
                        tags.append(";").append(rs.getString("tag_nome"));
                    }
                    return tags.toString();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel encontrar o exame.\n" + ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }

    public static DadosModelo buscaModelo(ExameMatColetaBean matBean, Integer metodoPadrao) throws Exception {
        MetodologiaVO metodo = (MetodologiaVO)new MetodologiaService().getVO(Variaveis.filialPadrao, String.valueOf(metodoPadrao));
        StringBuilder buf = new StringBuilder();
        buf.append("select a.lay_codigo, a.ela_idadeini, a.ela_idadefim, a.ela_idadeinitipo, a.ela_idadefimtipo, b.lay_descricao, a.ela_padrao, ");
        buf.append(" a.exa_codigo, a.mco_codigo, a.lay_codigo ");
        buf.append(" from examelayout a ");
        buf.append("left join layout b on a.fil_codigo = b.fil_codigo and a.lay_codigo=b.lay_codigo ");
        buf.append("where a.fil_codigo=");
        buf.append(matBean.getFilial().getCodigo());
        buf.append(" and a.exa_codigo=").append(StringUtil.textoDBEscape(matBean.getExame().getCodigo()));
        buf.append(" and a.mco_codigo=").append(matBean.getMaterial().getCodigo());
        buf.append("order by a.lay_codigo ");
        Statement st = Conexao.getStatement();
        ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
        DadosModelo dados = null;
        Statement stMetodos = Conexao.getStatement();
        if (rsLayout != null) {
            dados = new DadosModelo();
            while (rsLayout.next()) {
                buf.delete(0, buf.length());
                buf.append("select a.met_codigo, b.met_descricao, a.elm_formato, a.elm_mapa, a.elm_normal, a.elm_exportartexto, a.elm_dadosbrutos ");
                buf.append("from examelayoutmetodo a ");
                buf.append("left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo ");
                buf.append("where a.fil_codigo = ").append(matBean.getFilial().getCodigo());
                buf.append(" and a.exa_codigo=").append(StringUtil.textoDBEscape(matBean.getExame().getCodigo()));
                buf.append(" and a.mco_codigo=").append(matBean.getMaterial().getCodigo());
                buf.append(" and a.met_codigo=").append(metodoPadrao);
                buf.append(" and a.lay_codigo = ");
                buf.append(rsLayout.getString("lay_codigo"));
                buf.append(" and a.ela_idadefim = ");
                buf.append(rsLayout.getString("ela_idadefim"));
                buf.append(" and a.ela_idadeini = ");
                buf.append(rsLayout.getString("ela_idadeini"));
                buf.append(" and a.ela_idadefimtipo = '");
                buf.append(rsLayout.getString("ela_idadefimtipo"));
                buf.append("' and a.ela_idadeinitipo = '");
                buf.append(rsLayout.getString("ela_idadeinitipo"));
                buf.append("' order by a.met_codigo ");
                ResultSet rsMetodos = Conexao.executeQuery(stMetodos, buf.toString());
                ArrayList<MetodoModelo> metodos = new ArrayList<MetodoModelo>();
                while (rsMetodos.next()) {
                    metodos.add(new MetodoModelo(rsMetodos.getInt("met_codigo"), rsMetodos.getString("met_descricao"), rsMetodos.getString("elm_formato"), rsMetodos.getString("elm_mapa"), rsMetodos.getString("elm_normal"), rsMetodos.getString("elm_exportartexto"), rsMetodos.getString("elm_dadosbrutos"), null));
                }
                if (metodos.isEmpty()) {
                    metodos.add(RelacionamentoLabExterno.insereMetodModelo(metodo, rsLayout));
                }
                dados.addModelos(rsLayout.getInt("lay_codigo"), rsLayout.getString("lay_descricao"), rsLayout.getInt("ela_idadeini"), rsLayout.getString("ela_idadeinitipo"), rsLayout.getInt("ela_idadefim"), rsLayout.getString("ela_idadefimtipo"), rsLayout.getBoolean("ela_padrao"), metodos);
                rsMetodos.close();
            }
        }
        if (rsLayout != null) {
            rsLayout.close();
        }
        Conexao.fecharStatement(stMetodos);
        return dados;
    }

    public static MetodoModelo insereMetodModelo(MetodologiaVO metodologia, ResultSet rs) throws Exception {
        ExameLayoutMetodoBean bean = new ExameLayoutMetodoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(new Integer(Variaveis.filialPadrao));
        filial.setDescricao("");
        MaterialColetaVO material = new MaterialColetaVO();
        material.setCodigo(rs.getInt("mco_codigo"));
        material.setFilial(filial);
        material.setDescricao("");
        ExameVO exame = new ExameVO();
        exame.setCodigo(rs.getString("exa_codigo"));
        exame.setFilial(filial);
        exame.setDescricao("");
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setCodigo(metodologia.getCodigo());
        metodo.setFilial(filial);
        metodo.setDescricao("");
        LayoutVO layout = new LayoutVO();
        layout.setFilial(filial);
        layout.setCodigo(rs.getInt("lay_codigo"));
        layout.setDescricao("");
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setDadosBrutos("");
        bean.setExportarTexto("");
        bean.setFormato("");
        bean.setIdadeFim(rs.getInt("ela_idadefim"));
        bean.setIdadeFimTipo(rs.getString("ela_idadefimtipo"));
        bean.setIdadeInicial(rs.getInt("ela_idadeini"));
        bean.setIdadeInicioTipo(rs.getString("ela_idadeinitipo"));
        bean.setLayout(layout);
        bean.setMatColeta(material);
        bean.setMetodologia(metodo);
        bean.setNormal("");
        new ExameLayoutMetodoService().insert(bean, null, Variaveis.filialPadrao, null);
        return new MetodoModelo(metodologia.getCodigo(), metodologia.getDescricao(), "", "", "", "", "", null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOpcoes) {
            this.validaItensOpcoes();
            Dimension dim = this.menuOpcoes.getPreferredSize();
            this.menuOpcoes.show(this.buttonOpcoes.getParent(), this.buttonOpcoes.getX(), this.buttonOpcoes.getY() - dim.height - 1);
        } else if (e.getSource() == this.itemImprimirListagem) {
            this.imprimirListagem();
        } else if (e.getSource() == this.itemDefinirPadrao) {
            this.definirPadrao(this.getListaExamesMateriaisSelecionados());
            this.atualizaPadraoGrid();
        } else if (e.getSource() == this.itemAlterarPrazos) {
            this.alterarPrazos(this.getListaExamesMateriaisSelecionados(), this.prazoPadrao);
            this.atualizaPrazoGrid();
        } else if (e.getSource() == this.itemAlterarSetores) {
            this.alterarSetores(this.getListaCodigosExamesSelecionados(), this.setorPadrao);
            this.atualizaSetorGrid();
        } else if (e.getSource() == this.itemMarcarBloqueado || e.getSource() == this.itemDesmarcarBloqueado) {
            this.definirBloqueado(this.getListaExamesMateriaisSelecionados(), e.getSource() == this.itemMarcarBloqueado);
            this.atualizaBloqueioGrid(e.getSource() == this.itemMarcarBloqueado);
        } else if (e.getSource() == this.buttonPesquisar) {
            this.buscaExame();
        } else if (e.getSource() == this.buttonAlterar) {
            this.alterarRelacionamentoExame(false);
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonOK) {
            this.configurarProtocolo();
        } else if (e.getSource() == this.buttonDesmembrar) {
            this.configurarDesmembrado();
        }
    }

    private void configurarDesmembrado() {
        int row = this.tableExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        Integer setor = (Integer)this.modeloExames.getValueAt(row, 15);
        Integer prazo = (Integer)this.modeloExames.getValueAt(row, 16);
        Integer prazoLab = (Integer)this.modeloExames.getValueAt(row, 11);
        String precoLab = (String)this.modeloExames.getValueAt(row, 12);
        Boolean bloqueado = (Boolean)this.modeloExames.getValueAt(row, 13);
        Boolean padrao = (Boolean)this.modeloExames.getValueAt(row, 14);
        Integer metodo = (Integer)this.modeloExames.getValueAt(row, 17);
        String material = (String)this.modeloExames.getValueAt(row, 23);
        String exameSelecionado = (String)this.modeloExames.getValueAt(row, 1);
        String exameRelacionado = (String)this.modeloExames.getValueAt(row, 4);
        String descricaoExame = (String)this.modeloExames.getValueAt(row, 3);
        ArrayList interfaceDesmembraLabExterno = (ArrayList)this.modeloExames.getValueAt(row, 24);
        Desmembrar desmembrar = new Desmembrar((Dialog)this, "[" + descricaoExame + "]", true, true);
        desmembrar.setCodigoLabExterno(this.codigoLabExterno);
        desmembrar.setCodigoInterfaceamentoPai(-1);
        desmembrar.setExames(interfaceDesmembraLabExterno);
        desmembrar.setExamePai(exameSelecionado);
        desmembrar.setVisible(true);
        InterfaceDesmembrar filho = null;
        try {
            if (desmembrar.isOK()) {
                ArrayList lista = desmembrar.getExames();
                this.modeloExames.setValueAt(lista, row, 24);
                Statement statement = Conexao.getStatement();
                SalvaDados salvar = new SalvaDados("examematcoletalabextdesm", 1);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.setTabela("examematcoletalabextdesm");
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDBEscape(exameSelecionado));
                salvar.adicionaCampo("mco_codigo", 2, false, true, material);
                salvar.adicionaCampo("lae_codigo", 2, false, true, this.codigoLabExterno);
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaExame());
                salvar = new SalvaDados("examematcoletalabextdesm", 0);
                for (int k = 0; k < lista.size(); ++k) {
                    filho = (InterfaceDesmembrar)lista.get(k);
                    salvar.limpar();
                    salvar.setTabela("examematcoletalabextdesm");
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("exa_kodigo", 0, false, true, filho.getCodigo());
                    salvar.adicionaCampo("exa_codigo", 0, false, true, exameSelecionado);
                    salvar.adicionaCampo("mco_kodigo", 2, false, true, filho.getMaterial().getCodigo());
                    salvar.adicionaCampo("mco_codigo", 2, false, true, material);
                    salvar.adicionaCampo("lae_codigo", 2, false, true, this.codigoLabExterno);
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaExame());
                }
                Conexao.arquivaSQL();
            }
        }
        catch (Exception ex) {
            this.trataExcecaoDesmembramento(filho, ex);
        }
    }

    private void trataExcecaoDesmembramento(InterfaceDesmembrar filho, Exception ex) {
        if (ex.getCause() instanceof PSQLException) {
            PSQLException exception = (PSQLException)ex.getCause();
            String erroSql = exception.getSQLState();
            if (erroSql != null && erroSql.equals("IFKNE")) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                StringBuilder msg = new StringBuilder();
                msg.append("Exame adicionado como desmembrado: [").append(filho.getCodigo());
                msg.append("], deve ser configurado para o laborat\u00f3rio externo: [");
                msg.append(this.codigoLabExterno).append("] antes de ser associado.");
                Funcoes.mensagem(Laboratorio.getInstancia(), msg.toString(), 2);
            } else {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
        } else {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void atualizaPadraoGrid() {
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            this.modeloExames.setValueAt(true, i, 14);
        }
        this.atualizaDetalhes();
    }

    private void atualizaBloqueioGrid(boolean bloquear) {
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            this.modeloExames.setValueAt(bloquear, i, 13);
        }
        this.atualizaDetalhes();
    }

    private void atualizaPrazoGrid() {
        PrazoEntregaVO prazoVO = null;
        Integer codigoPrazo = null;
        codigoPrazo = this.prazoPadrao == null || this.prazoPadrao == 0 ? (Integer)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 16) : this.prazoPadrao;
        try {
            prazoVO = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, Integer.toString(codigoPrazo));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do prazo de entrega.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            this.modeloExames.setValueAt(prazoVO.getCodigo(), i, 16);
            this.modeloExames.setValueAt(prazoVO.getDescricao(), i, 10);
        }
        this.atualizaDetalhes();
    }

    private void atualizaSetorGrid() {
        SetorVO setorVO = null;
        Integer codigoSetor = null;
        codigoSetor = this.setorPadrao == null || this.setorPadrao == 0 ? (Integer)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 15) : this.setorPadrao;
        try {
            setorVO = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, Integer.toString(codigoSetor));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do setor.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            this.modeloExames.setValueAt(setorVO.getCodigo(), i, 15);
            this.modeloExames.setValueAt(setorVO.getDescricao(), i, 9);
        }
        this.atualizaDetalhes();
    }

    private void validaItensOpcoes() {
        boolean enabled;
        boolean bl = enabled = this.getListaCodigosExamesSelecionados().size() > 0;
        if (this.setorPadrao == null || this.setorPadrao == 0) {
            this.itemAlterarSetores.setEnabled(false);
        } else {
            this.itemAlterarSetores.setEnabled(enabled);
        }
        if (this.prazoPadrao == null || this.prazoPadrao == 0) {
            this.itemAlterarPrazos.setEnabled(false);
        } else {
            this.itemAlterarPrazos.setEnabled(enabled);
        }
        this.itemDefinirPadrao.setEnabled(enabled);
    }

    private void definirPadrao(HashSet<ExameMatColetaVO> listaExameMaterial) {
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameMatColetaLabExternoService serviceExameMaterialLabExterno = new ExameMatColetaLabExternoService();
        for (ExameMatColetaVO exameMaterial : listaExameMaterial) {
            try {
                serviceExameMaterialLabExterno.setLaboratorioExternoPadraoExameMaterial(exameMaterial, Integer.parseInt(this.codigoLabExterno), Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel definir o laborat\u00f3rio externo padr\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void definirBloqueado(HashSet<ExameMatColetaVO> listaExameMaterial, boolean situacao) {
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameMatColetaLabExternoService serviceExameMaterialLabExterno = new ExameMatColetaLabExternoService();
        for (ExameMatColetaVO exameMaterial : listaExameMaterial) {
            try {
                serviceExameMaterialLabExterno.setMudarSituacaoBloqueadoLaboratorioExterno(exameMaterial, Integer.parseInt(this.codigoLabExterno), situacao, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "Erro ao alterar a situa\u00e7\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel finalizar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void alterarPrazos(HashSet<ExameMatColetaVO> listaExameMaterial, Integer prazo) {
        if (listaExameMaterial == null || listaExameMaterial.size() == 0) {
            return;
        }
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameMatColetaService serviceExameMaterial = new ExameMatColetaService();
        for (ExameMatColetaVO exameMaterial : listaExameMaterial) {
            try {
                if (prazo == null || prazo == 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select  mt.prz_codigo  from exames ex ");
                    buf.append(" join examematcoleta mt on ex.fil_codigo = mt.fil_codigo and ex.exa_codigo = mt.exa_codigo ");
                    buf.append(" where ex.fil_codigo = ").append(exameMaterial.getExame().getFilial().getCodigo().toString());
                    buf.append(" and ex.exa_codigo = '").append(exameMaterial.getExame().getCodigo()).append("'");
                    buf.append(" and mt.mco_codigo = ").append(exameMaterial.getMaterial().getCodigo().toString());
                    buf.append("  ");
                    buf.append("  ");
                    Statement st = Conexao.getStatement();
                    PrazoEntregaVO prazoVO = null;
                    try {
                        ResultSet rsExame = Conexao.executeQuery(st, buf.toString());
                        if (rsExame.next()) {
                            prazoVO = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, String.valueOf(rsExame.getInt("prz_codigo")));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (prazoVO != null) {
                        prazo = prazoVO.getCodigo();
                    }
                }
                serviceExameMaterial.alteraPrazoExameMaterial(exameMaterial, prazo, filiaisAutoCopia);
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel alterar o prazo do exame.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void alterarPrazo(ExameMatColetaVO exameMatVO, Integer prazo) {
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameMatColetaService serviceExameMaterial = new ExameMatColetaService();
        try {
            serviceExameMaterial.alteraPrazoExameMaterial(exameMatVO, prazo, filiaisAutoCopia);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel alterar o prazo do exame.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void alterarSetores(HashSet<String> lista, Integer setor) {
        if (lista == null || lista.size() == 0) {
            return;
        }
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameSetorService serviceExameSetor = new ExameSetorService();
        ExameSetorVO setorPadraoAnterior = null;
        block14: for (String exame : lista) {
            ArrayList<ExameSetorVO> listaSetoresExame = null;
            if (setor == null || setor == 0) {
                StringBuilder buf = new StringBuilder();
                buf.append(" select st.set_codigo from exames ex ");
                buf.append(" join examesetor st on st.fil_codigo = ex.fil_codigo and st.exa_codigo = ex.exa_Codigo  ");
                buf.append(" where ex.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and ex.exa_codigo = '").append(exame).append("'");
                buf.append("  ");
                buf.append("  ");
                Statement st = Conexao.getStatement();
                SetorVO setorVo = null;
                try {
                    ResultSet rsExame = Conexao.executeQuery(st, buf.toString());
                    if (rsExame.next()) {
                        setorVo = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, String.valueOf(rsExame.getInt("set_codigo")));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (setorVo != null) {
                    setor = setorVo.getCodigo();
                }
            }
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("exa_codigo", exame);
            try {
                listaSetoresExame = serviceExameSetor.getSetoresExameVO(chaves);
            }
            catch (Exception e2) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os setores do exame.\n" + e2.getMessage(), e2.getStackTrace());
                return;
            }
            for (ExameSetorVO exaVO : listaSetoresExame) {
                if (!exaVO.getPadrao().booleanValue()) continue;
                setorPadraoAnterior = exaVO;
                continue block14;
            }
        }
        try {
            for (String exame : lista) {
                serviceExameSetor.removeSetorPadraoExame(Variaveis.filialPadrao, exame, filiaisAutoCopia);
            }
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException exame) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover o setor padr\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        for (String exame : lista) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            ExameVO exameVO = new ExameVO();
            exameVO.setFilial(filialVO);
            exameVO.setCodigo(exame);
            SetorVO setorVO = new SetorVO();
            setorVO.setFilial(filialVO);
            setorVO.setCodigo(setor);
            ExameSetorBean exameBean = new ExameSetorBean();
            exameBean.setFilial(filialVO);
            exameBean.setExame(exameVO);
            if (setorPadraoAnterior != null) {
                exameBean.setImprimirEtqColeta(setorPadraoAnterior.getImprimirEtqColeta());
                exameBean.setImprimirEtqTriagem(setorPadraoAnterior.getImprimirEtqTriagem());
                exameBean.setImprimirMapa(setorPadraoAnterior.getImprimirMapa());
                exameBean.setPadrao(setorPadraoAnterior.getPadrao());
            } else {
                exameBean.setImprimirEtqColeta(false);
                exameBean.setImprimirEtqTriagem(false);
                exameBean.setImprimirMapa(false);
                exameBean.setPadrao(true);
            }
            exameBean.setSetor(setorVO);
            try {
                serviceExameSetor.delete(exameBean, 2, Variaveis.filialPadrao, filiaisAutoCopia);
                serviceExameSetor.insert(exameBean, 0, Variaveis.filialPadrao, filiaisAutoCopia);
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir o setor padr\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void alterarSetor(ExameMatColetaVO exameMatVO, Integer setor) {
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameSetorService serviceExameSetor = new ExameSetorService();
        ExameSetorVO setorPadraoAnterior = null;
        ArrayList<ExameSetorVO> listaSetoresExame = null;
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("exa_codigo", exameMatVO.getExame().getCodigo());
        try {
            listaSetoresExame = serviceExameSetor.getSetoresExameVO(chaves);
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os setores do exame.\n" + e2.getMessage(), e2.getStackTrace());
            return;
        }
        for (ExameSetorVO exaVO : listaSetoresExame) {
            if (!exaVO.getPadrao().booleanValue()) continue;
            setorPadraoAnterior = exaVO;
            break;
        }
        try {
            serviceExameSetor.removeSetorPadraoExame(Variaveis.filialPadrao, exameMatVO.getExame().getCodigo(), filiaisAutoCopia);
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException exaVO) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel remover o setor padr\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        ExameVO exameVO = new ExameVO();
        exameVO.setFilial(filialVO);
        exameVO.setCodigo(exameMatVO.getExame().getCodigo());
        SetorVO setorVO = new SetorVO();
        setorVO.setFilial(filialVO);
        setorVO.setCodigo(setor);
        ExameSetorBean exameBean = new ExameSetorBean();
        exameBean.setFilial(filialVO);
        exameBean.setExame(exameVO);
        if (setorPadraoAnterior != null) {
            exameBean.setImprimirEtqColeta(setorPadraoAnterior.getImprimirEtqColeta());
            exameBean.setImprimirEtqTriagem(setorPadraoAnterior.getImprimirEtqTriagem());
            exameBean.setImprimirMapa(setorPadraoAnterior.getImprimirMapa());
            exameBean.setPadrao(setorPadraoAnterior.getPadrao());
        } else {
            exameBean.setImprimirEtqColeta(false);
            exameBean.setImprimirEtqTriagem(false);
            exameBean.setImprimirMapa(false);
            exameBean.setPadrao(true);
        }
        exameBean.setSetor(setorVO);
        try {
            serviceExameSetor.delete(exameBean, 2, Variaveis.filialPadrao, filiaisAutoCopia);
            serviceExameSetor.insert(exameBean, 0, Variaveis.filialPadrao, filiaisAutoCopia);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel inserir o setor padr\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel commitar as altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private HashSet<String> getListaCodigosExamesSelecionados() {
        HashSet<String> listaRetorno = new HashSet<String>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            listaRetorno.add(this.modeloExames.getValueAt(i, 1).toString());
        }
        return listaRetorno;
    }

    private HashSet<ExameMatColetaVO> getListaExamesMateriaisSelecionados() {
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        HashSet<ExameMatColetaVO> listaRetorno = new HashSet<ExameMatColetaVO>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            listaRetorno.add(this.getExameMatColetaVO(i));
        }
        return listaRetorno;
    }

    private void imprimirListagem() {
        RelatorioExamesApoiados relatorio = new RelatorioExamesApoiados();
        relatorio.imprimirPressionado(Integer.parseInt(this.codigoLabExterno));
        JDialog aux = new JDialog(Laboratorio.getInstancia(), "Listagem dos exames configurados para apoio", true);
        aux.setSize(700, 600);
        aux.setContentPane(relatorio);
        ScreenUtil.centralizar(aux);
        aux.setVisible(true);
    }

    private String configurarProtocoloLaudo(String exame, Protocolo protocolo, String material, String codigoLabExterno, Integer metodoPadrao, Integer setorPadrao, Integer prazoPadrao) {
        if (Funcoes.textoVazio(exame)) {
            Funcoes.mensagem(this, "O exame deve ser informado.", 2);
            return null;
        }
        AbstractConfigurador c = FabricaConfigurador.novoConfigurador(this, protocolo, codigoLabExterno);
        Set listaRecipientes = null;
        ExameMatColetaLabExternoBean exaMatLabExterno = null;
        ExameMatColetaBean exaMat = null;
        if (exaMat == null) {
            try {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", Variaveis.filialPadrao);
                chaves.put("exa_codigo", exame);
                chaves.put("mco_codigo", material);
                chaves.put("lae_codigo", codigoLabExterno);
                exaMatLabExterno = (ExameMatColetaLabExternoBean)new ExameMatColetaLabExternoDao().getBean(chaves);
                exaMat = (ExameMatColetaBean)new ExameMatColetaService().getBean(exaMatLabExterno.getFilial().getCodigo().toString(), exaMatLabExterno.getExame().getCodigo(), exaMatLabExterno.getMatColeta().getCodigo().toString());
                StringBuilder buf = new StringBuilder();
                buf.append("where fil_codigo = '").append(exaMat.getFilial().getCodigo()).append("'");
                buf.append("  and exa_codigo = '").append(exaMat.getExame().getCodigo()).append("'");
                buf.append("  and mco_codigo = ").append(material);
                listaRecipientes = new RecipienteColetaService().load(buf.toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
        if (c != null && exaMat.getXmlLabExterno() != null) {
            HashMap<String, String> recipientes = new HashMap<String, String>();
            if (listaRecipientes != null) {
                for (RecipienteColetaBean rec : listaRecipientes) {
                    if (rec == null || rec.getRecipiente() == null) continue;
                    recipientes.put(rec.getRecipiente().getCodigo().toString(), rec.getRecipiente().getDescricao());
                }
                c.setRecipientes(recipientes);
            }
        }
        if (exaMatLabExterno != null && !Funcoes.textoVazio(exaMatLabExterno.getXmlLabExterno())) {
            c.setXML(exaMatLabExterno.getXmlLabExterno());
        }
        if (c != null) {
            c.setVisible(true);
            if (c.getOK()) {
                ConfiguracaoPrecoPrazo configuraPrecoPrazo;
                boolean exigirJejum = exaMat.isObrigaPeso();
                boolean exigirDUM = exaMat.isObrigaDum();
                boolean exigirPeso = exaMat.isObrigaPeso();
                boolean exigirAltura = exaMat.isObrigaAltura();
                boolean exigirVolume = exaMat.isObrigaVolume();
                boolean exigirTempoDiurese = exaMat.isObrigaTempoDiurese();
                boolean exigirMedicamento = exaMat.isObrigaMedicamento();
                if (c.exigeAltura() && !exaMat.isObrigaAltura().booleanValue()) {
                    exigirAltura = c.exigeAltura();
                }
                if (c.exigePeso() && !exaMat.isObrigaPeso().booleanValue()) {
                    exigirPeso = c.exigePeso();
                }
                if (c.exigeTempoDiurese() && !exaMat.isObrigaTempoDiurese().booleanValue()) {
                    exigirTempoDiurese = c.exigeTempoDiurese();
                }
                if (c.exigeVolumeDiurese() && !exaMat.isObrigaVolume().booleanValue()) {
                    exigirVolume = c.exigeVolumeDiurese();
                }
                if (c.exigeJejum() && !exaMat.isSolicitarJejum().booleanValue()) {
                    exigirJejum = c.exigeJejum();
                }
                if (c.exigeDUM() && !exaMat.isObrigaDum().booleanValue()) {
                    exigirDUM = c.exigeDUM();
                }
                if (c.exigeMedicamento() && !exaMat.isObrigaMedicamento().booleanValue()) {
                    exigirMedicamento = c.exigeMedicamento();
                }
                if ((configuraPrecoPrazo = ConfiguracaoPrecoPrazo.novaInstancia(this, "Informe o pre\u00e7o e prazo")) != null) {
                    configuraPrecoPrazo.setVisible(true);
                    if (configuraPrecoPrazo.getOK()) {
                        try {
                            SetorVO setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, String.valueOf(setorPadrao));
                            PrazoEntregaVO prazo = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, String.valueOf(prazoPadrao));
                            Boolean examePadrao = Boolean.TRUE;
                            examePadrao = RelacionamentoLabExterno.verificaExamePadrao(exaMat.getExame().getCodigo(), exaMat.getMaterial().getCodigo(), this.codigoLabExterno);
                            Integer prazoLabExt = Funcoes.isNumeric(configuraPrecoPrazo.getPrazo()) ? Integer.parseInt(configuraPrecoPrazo.getPrazo()) : 0;
                            Double precoLabExt = Funcoes.isNumeric(configuraPrecoPrazo.getPreco()) ? Double.parseDouble(configuraPrecoPrazo.getPreco()) : new Double("0");
                            DadosModelo modelo = RelacionamentoLabExterno.buscaModelo(exaMat, metodoPadrao);
                            RelacionamentoLabExterno.insereExameMatLabExterno(exaMat, c.getXML(), prazoLabExt, precoLabExt, examePadrao, metodoPadrao, this.codigoLabExterno);
                            new ExameMatColetaService().atualizaCamposObrigatoriosExameMaterial(exaMat, ParametrosGerais.getCopiaExame(), exigirAltura, exigirPeso, exigirTempoDiurese, exigirJejum, exigirDUM, exigirMedicamento);
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                        }
                    }
                }
                try {
                    new ExameMatColetaService().atualizaCamposObrigatoriosExameMaterial(exaMat, ParametrosGerais.getCopiaExame(), exigirAltura, exigirPeso, exigirTempoDiurese, exigirJejum, exigirDUM, exigirMedicamento);
                    Conexao.arquivaSQL();
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                return c.getXML();
            }
        }
        return null;
    }

    private String alterarRelacionamentoExame(boolean isAlterandoLayout) {
        int row = this.tableExames.getSelectedRow();
        if (row < 0) {
            return null;
        }
        Integer setor = (Integer)this.modeloExames.getValueAt(row, 15);
        Integer prazo = (Integer)this.modeloExames.getValueAt(row, 16);
        Integer prazoLab = (Integer)this.modeloExames.getValueAt(row, 11);
        String precoLab = (String)this.modeloExames.getValueAt(row, 12);
        Boolean bloqueado = (Boolean)this.modeloExames.getValueAt(row, 13);
        Boolean padrao = (Boolean)this.modeloExames.getValueAt(row, 14);
        Integer metodo = (Integer)this.modeloExames.getValueAt(row, 17);
        String material = (String)this.modeloExames.getValueAt(row, 23);
        String exameSelecionado = (String)this.modeloExames.getValueAt(row, 1);
        String exameRelacionado = (String)this.modeloExames.getValueAt(row, 4);
        String xmlLabExterno = (String)this.modeloExames.getValueAt(row, 26);
        EditarRelacionamentoExame janelaEdicao = EditarRelacionamentoExame.novaInstancia(this);
        janelaEdicao.setDados(exameRelacionado, exameSelecionado, setor, prazo, prazoLab, precoLab, bloqueado, padrao, metodo, this.codigoLabExterno, material, this.protocolo);
        janelaEdicao.abrirRelacionamento(isAlterandoLayout);
        janelaEdicao.setVisible(true);
        if (janelaEdicao.getOK()) {
            HashSet<String> exame;
            SetorVO novoSetor = janelaEdicao.getSetor();
            PrazoEntregaVO novoPrazo = janelaEdicao.getPrazo();
            Integer novoPrazoLab = janelaEdicao.getPrazoLabExterno();
            String novoPrecoLab = janelaEdicao.getPrecoLabExterno();
            boolean novoBloqueado = janelaEdicao.getBloqueado();
            boolean novoPadrao = janelaEdicao.getPadrao();
            ExameMatColetaVO exaMatColVo = this.getExameMatColetaVO(row);
            if (novoSetor.getCodigo().intValue() != setor.intValue()) {
                exame = new HashSet<String>();
                exame.add(this.modeloExames.getValueAt(row, 1).toString());
                this.alterarSetores(exame, novoSetor.getCodigo());
            }
            if (novoPrazo.getCodigo().intValue() != prazo.intValue()) {
                exame = new HashSet();
                exame.add((String)((Object)exaMatColVo));
                this.alterarPrazos(exame, novoPrazo.getCodigo());
            }
            AbstractConfigurador c = FabricaConfigurador.novoConfigurador(this, this.protocolo, this.codigoLabExterno);
            String aux = c.getXML();
            boolean naoHaOutroLabExterno = false;
            if (isAlterandoLayout || novoBloqueado != bloqueado || novoPadrao != padrao || novoPrazoLab.intValue() != prazoLab.intValue() || !novoPrecoLab.equalsIgnoreCase(precoLab)) {
                naoHaOutroLabExterno = this.atualizaExameMatLabExterno(xmlLabExterno, this.modeloExames.getValueAt(row, 1).toString(), Integer.parseInt(this.modeloExames.getValueAt(row, 23).toString()), novoPrazoLab, Double.parseDouble(Funcoes.limpaDecimal(novoPrecoLab)), novoPadrao, novoBloqueado, novoPadrao != padrao);
            }
            String xml = janelaEdicao.getXML();
            String nomeExameApoio = "";
            if (!Funcoes.textoVazio(xml) && xml != null && xml.contains("descricao")) {
                nomeExameApoio = StringUtil.getValor(xml, "descricao");
            }
            if (Funcoes.textoVazio(nomeExameApoio) && xml != null && xml.contains("descricao-exame")) {
                nomeExameApoio = StringUtil.getValor(xml, "descricao-exame");
            }
            if (Funcoes.textoVazio(nomeExameApoio)) {
                nomeExameApoio = exameRelacionado;
            }
            this.modeloExames.setValueAt(novoSetor.getCodigo(), row, 15);
            this.modeloExames.setValueAt(novoSetor.getDescricao(), row, 9);
            this.modeloExames.setValueAt(novoPrazo.getCodigo(), row, 16);
            this.modeloExames.setValueAt(novoPrazo.getDescricao(), row, 10);
            this.modeloExames.setValueAt(nomeExameApoio, row, 4);
            this.modeloExames.setValueAt(novoPrazoLab, row, 11);
            this.modeloExames.setValueAt(novoPrecoLab, row, 12);
            this.modeloExames.setValueAt(naoHaOutroLabExterno ? true : novoBloqueado, row, 13);
            this.modeloExames.setValueAt(novoPadrao, row, 14);
            this.atualizaDetalhes();
            return xml;
        }
        return null;
    }

    private ExameMatColetaVO getExameMatColetaVO(int row) {
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        ExameVO exameVO = new ExameVO();
        exameVO.setFilial(filialVO);
        exameVO.setCodigo(this.modeloExames.getValueAt(row, 1).toString());
        MaterialColetaVO materialVO = new MaterialColetaVO();
        materialVO.setFilial(filialVO);
        materialVO.setCodigo(Integer.parseInt(this.modeloExames.getValueAt(row, 23).toString()));
        ExameMatColetaVO exameMaterialVO = new ExameMatColetaVO();
        exameMaterialVO.setFilial(filialVO);
        exameMaterialVO.setExame(exameVO);
        exameMaterialVO.setMaterial(materialVO);
        return exameMaterialVO;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.textCodigo && this.textCodigo.getText().length() > 0) {
            this.textCodigo.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textCodigo) {
            this.buscaDescricaoExame();
        }
    }

    public void copiaLaudo(int selectedRow) {
        Hashtable resultado = ExameMatCol.pesquisaLayout(this);
        String codigo = "";
        String material = "";
        String metodo = "";
        String layout = "";
        String idadeIni = "";
        String idadeIniTipo = "";
        String idadeFim = "";
        String idadeFimTipo = "";
        if (resultado != null) {
            codigo = resultado.get("exa_codigo").toString();
            material = resultado.get("mco_codigo").toString();
            layout = resultado.get("lay_codigo").toString();
            idadeIni = resultado.get("ela_idadeini").toString();
            idadeIniTipo = resultado.get("ela_idadeinitipo").toString();
            idadeFim = resultado.get("ela_idadefim").toString();
            idadeFimTipo = resultado.get("ela_idadefimtipo").toString();
            metodo = resultado.get("met_codigo").toString();
        }
        if (!Funcoes.textoVazio(codigo)) {
            try {
                this.salvaCopiaModelo(selectedRow, codigo, material, metodo, layout, idadeIni, idadeIniTipo, idadeFim, idadeFimTipo);
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel copiar modelo" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void salvaCopiaModelo(int row, String codigoExame, String material, String metodo, String layout, String idadeIni, String idadeIniTipo, String idadeFim, String idadeFimTipo) throws Exception {
        String formato = this.pegaModelo(Variaveis.filialPadrao, codigoExame, material, metodo, layout, idadeFim, idadeIni, idadeFimTipo, idadeIniTipo);
        String filialPadrao = Variaveis.filialPadrao;
        String codExame = this.modeloExames.getValueAt(row, 1).toString();
        String codMaterial = this.modeloExames.getValueAt(row, 23).toString();
        String codMetodo = this.modeloExames.getValueAt(row, 17).toString();
        String codLayout = this.modeloExames.getValueAt(row, 18).toString();
        String idadeFim2 = this.modeloExames.getValueAt(row, 19).toString();
        String idadeIni2 = this.modeloExames.getValueAt(row, 20).toString();
        String idadeFimTipo2 = this.modeloExames.getValueAt(row, 21).toString();
        String idadeIniTipo2 = this.modeloExames.getValueAt(row, 22).toString();
        this.salvaFormatoLayout(formato, codExame, codMaterial, codLayout, idadeIni2, idadeFim2, idadeIniTipo2, idadeFimTipo2, codMetodo);
    }
}

