/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.labexterno;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosModelo;
import jalis.laboratorio.cadastro.labexterno.RelacionamentoLabExterno;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.bean.cadastro.exame.ExameMatColetaBean;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoBean;
import jalis.model.bean.triagem.RecipienteColetaBean;
import jalis.model.dao.cadastro.exame.ExameMatColetaLabExternoDao;
import jalis.model.vo.cadastro.exame.PrazoEntregaVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.exame.ExameMatColetaService;
import jalis.service.cadastro.exame.PrazoEntregaService;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.triagem.RecipienteColetaService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class EditarRelacionamentoExame
extends AbstractDialogoOKCancelar
implements FocusListener,
KeyListener {
    private TTextField txtSetor = ComponenteFactory.novoTTextField(5, 1);
    private TTextField txtPrazo = ComponenteFactory.novoTTextField(5, 1);
    private TTextField txtPrecoLab = new TTextField(15, 2, 4);
    private TTextField txtPrazoLab = ComponenteFactory.novoTTextField(3, 1);
    private JLabel lblSetor = ComponenteFactory.novoJLabel("Setor:", 'S', this.txtSetor);
    private JLabel lblPrazo = ComponenteFactory.novoJLabel("Prazo:", 'P', this.txtPrazo);
    private JLabel lblRelacionado = ComponenteFactory.novoJLabel("Relacionamento:", null);
    private JLabel lblDescSetor = ComponenteFactory.novoJLabel("", new Dimension(50, 20));
    private JLabel lblDescPrazo = ComponenteFactory.novoJLabel("", new Dimension(50, 20));
    private JLabel lblPrecoLab = ComponenteFactory.novoJLabel("Pre\u00e7o lab. externo:", 'e', this.txtPrecoLab);
    private JLabel lblPrazoLab = ComponenteFactory.novoJLabel("Prazo lab. externo:", 'a', this.txtPrazoLab);
    private JLabel lblExameRelacionado = ComponenteFactory.novoJLabel("", new Dimension(50, 20));
    private JButton btnBuscaSetor = ComponenteFactory.novoJButton(this, true);
    private JButton btnBuscaPrazo = ComponenteFactory.novoJButton(this, true);
    private JButton btnAlterarRelacionamento;
    private JCheckBox checkBloqueado;
    private JCheckBox checkPadrao;
    private String xml;
    private String xmlSelecionado;
    private String exame;
    private Protocolo protocolo;
    private String material;
    private String codigoLabExterno;
    private Integer metodoPadrao;
    private SetorVO setor;
    private PrazoEntregaVO prazo;
    private String descricao;
    private boolean isAbrir;

    private EditarRelacionamentoExame(Dialog pai) {
        super(pai, "Alterar relacionamento");
        new ComponenteFactory();
        this.btnAlterarRelacionamento = ComponenteFactory.novoJButton("Alterar", this);
        this.checkBloqueado = ComponenteFactory.novoJCheckBox("Bloqueado", 'b');
        this.checkPadrao = ComponenteFactory.novoJCheckBox("Padr\u00e3o", 'd');
        this.xmlSelecionado = null;
        this.exame = null;
        this.protocolo = null;
        this.material = null;
        this.codigoLabExterno = null;
        this.metodoPadrao = -1;
        this.setor = null;
        this.prazo = null;
        this.descricao = null;
        this.isAbrir = false;
        this.montaTela();
        if (this.isVisible()) {
            this.btnAlterarRelacionamento.doClick();
        }
    }

    private EditarRelacionamentoExame(Frame pai) {
        super(pai, "Alterar relacionamento");
        new ComponenteFactory();
        this.btnAlterarRelacionamento = ComponenteFactory.novoJButton("Alterar", this);
        this.checkBloqueado = ComponenteFactory.novoJCheckBox("Bloqueado", 'b');
        this.checkPadrao = ComponenteFactory.novoJCheckBox("Padr\u00e3o", 'd');
        this.xmlSelecionado = null;
        this.exame = null;
        this.protocolo = null;
        this.material = null;
        this.codigoLabExterno = null;
        this.metodoPadrao = -1;
        this.setor = null;
        this.prazo = null;
        this.descricao = null;
        this.isAbrir = false;
        this.montaTela();
        if (this.isVisible()) {
            this.btnAlterarRelacionamento.doClick();
        }
    }

    public static EditarRelacionamentoExame novaInstancia(Window owner) {
        if (owner instanceof JDialog) {
            return new EditarRelacionamentoExame((JDialog)owner);
        }
        return new EditarRelacionamentoExame((JFrame)owner);
    }

    private void montaTela() {
        this.setSize(470, 250);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setUsuarioPodeCancelar(false);
        TitledBorder border = new TitledBorder("");
        ScreenUtil.setBorda(new JComponent[]{this.lblDescSetor}, border);
        ScreenUtil.setBorda(new JComponent[]{this.lblDescPrazo}, border);
        Dimension d = new Dimension(75, 20);
        this.txtSetor.setPreferredSize(d);
        this.txtPrazo.setPreferredSize(d);
        this.txtSetor.setMinimumSize(d);
        this.txtPrazo.setMinimumSize(d);
        this.txtSetor.addFocusListener(this);
        this.txtPrazo.addFocusListener(this);
        this.txtSetor.addKeyListener(this);
        this.txtPrazo.addKeyListener(this);
        d = new Dimension(80, 20);
        this.txtPrecoLab.setPreferredSize(d);
        this.txtPrazoLab.setPreferredSize(d);
        this.txtPrecoLab.setMinimumSize(d);
        this.txtPrazoLab.setMinimumSize(d);
        Dimension dBusca = new Dimension(20, 20);
        this.btnBuscaSetor.setPreferredSize(dBusca);
        this.btnBuscaPrazo.setPreferredSize(dBusca);
        this.btnBuscaSetor.setMinimumSize(dBusca);
        this.btnBuscaPrazo.setMinimumSize(dBusca);
        Insets insetEsquerda = new Insets(1, 1, 0, 0);
        Insets insetDireita = new Insets(1, 0, 0, 1);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = insetEsquerda;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.getPanelCentral().add((Component)this.lblSetor, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtSetor, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.getPanelCentral().add((Component)this.btnBuscaSetor, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        this.lblDescSetor.setMinimumSize(dBusca);
        this.getPanelCentral().add((Component)this.lblDescSetor, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = insetEsquerda;
        this.getPanelCentral().add((Component)this.lblPrazo, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtPrazo, c);
        ++c.gridx;
        c.insets = insetDireita;
        this.getPanelCentral().add((Component)this.btnBuscaPrazo, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        this.lblDescPrazo.setMinimumSize(dBusca);
        this.getPanelCentral().add((Component)this.lblDescPrazo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.getPanelCentral().add((Component)this.lblRelacionado, c);
        c.gridx += 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.lblExameRelacionado.setBorder(new TitledBorder(""));
        this.lblExameRelacionado.setMinimumSize(new Dimension(20, 20));
        this.btnAlterarRelacionamento.setMargin(new Insets(0, 0, 0, 0));
        this.btnAlterarRelacionamento.setMnemonic('A');
        this.btnAlterarRelacionamento.setPreferredSize(new Dimension(60, 20));
        this.getPanelCentral().add((Component)this.lblExameRelacionado, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.getPanelCentral().add((Component)this.btnAlterarRelacionamento, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = insetEsquerda;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 17;
        c.gridwidth = 2;
        this.getPanelCentral().add((Component)this.lblPrazoLab, c);
        c.gridx += 2;
        c.insets = insetDireita;
        this.getPanelCentral().add((Component)this.txtPrazoLab, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = insetEsquerda;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 17;
        c.gridwidth = 2;
        this.getPanelCentral().add((Component)this.lblPrecoLab, c);
        c.gridx += 2;
        c.insets = insetDireita;
        this.getPanelCentral().add((Component)this.txtPrecoLab, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.getPanelCentral().add((Component)this.checkPadrao, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.getPanelCentral().add((Component)this.checkBloqueado, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.fill = 1;
        this.getPanelCentral().add((Component)new JPanel(), c);
        ScreenUtil.requisitarFoco(this.txtSetor);
        ScreenUtil.centralizar(this);
    }

    private void preencheCampos(String xml) {
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "setor"))) {
            this.preencheCampos(StringUtil.getValor(xml, "setor"), this.txtSetor, this.lblDescSetor);
            this.buscaSetor();
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "prazoEntrega"))) {
            this.preencheCampos(StringUtil.getValor(xml, "prazoEntrega"), this.txtPrazo, this.lblDescPrazo);
            this.buscaPrazo();
        }
    }

    private void preencheCampos(String codigo, TTextField campoTexto, JLabel label) {
        campoTexto.setText(codigo);
        label.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok) {
                this.acaoCancelar();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                this.dispose();
            }
        } else if (o == this.btnBuscaSetor) {
            this.lblDescSetor.setText("");
            this.buscaDados(this.txtSetor, this.lblDescSetor, Pesquisas.setor(this, true), new String[]{"set_codigo", "set_descricao"});
        } else if (o == this.btnBuscaPrazo) {
            this.lblDescPrazo.setText("");
            this.buscaDados(this.txtPrazo, this.lblDescPrazo, Pesquisas.prazoEntrega(this, true), new String[]{"prz_codigo", "prz_descricao"});
        } else if (o == this.btnAlterarRelacionamento) {
            if (Funcoes.textoVazio(this.txtPrazo)) {
                Funcoes.mensagem(this, "Nenhum m\u00e9todo foi selecionado.", 2);
                ScreenUtil.requisitarFoco(this.txtPrazo);
                return;
            }
            if (Funcoes.textoVazio(this.txtSetor)) {
                Funcoes.mensagem(this, "Nenhum setor foi selecionado.", 2);
                ScreenUtil.requisitarFoco(this.txtSetor);
                return;
            }
            this.configurarProtocolo(this.exame, this.protocolo, this.material, this.codigoLabExterno, this.metodoPadrao, Integer.parseInt(this.txtSetor.getText()), Integer.parseInt(this.txtPrazo.getText()));
        }
    }

    private void configurarProtocolo(String exame, Protocolo protocolo, String material, String codigoLabExterno, Integer metodoPadrao, Integer setorPadrao, Integer prazoPadrao) {
        if (Funcoes.textoVazio(exame)) {
            Funcoes.mensagem(this, "O exame deve ser informado.", 2);
            return;
        }
        AbstractConfigurador c = FabricaConfigurador.novoConfigurador(this, protocolo, codigoLabExterno);
        Set listaRecipientes = null;
        ExameMatColetaLabExternoBean exaMatLabExterno = null;
        ExameMatColetaBean exaMat = null;
        if (exaMat == null) {
            try {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", Variaveis.filialPadrao);
                chaves.put("exa_codigo", exame);
                chaves.put("mco_codigo", material);
                chaves.put("lae_codigo", codigoLabExterno);
                exaMatLabExterno = (ExameMatColetaLabExternoBean)new ExameMatColetaLabExternoDao().getBean(chaves);
                exaMat = (ExameMatColetaBean)new ExameMatColetaService().getBean(exaMatLabExterno.getFilial().getCodigo().toString(), exaMatLabExterno.getExame().getCodigo(), exaMatLabExterno.getMatColeta().getCodigo().toString());
                StringBuilder buf = new StringBuilder();
                buf.append("where fil_codigo = '").append(exaMat.getFilial().getCodigo()).append("'");
                buf.append("  and exa_codigo = '").append(exaMat.getExame().getCodigo()).append("'");
                buf.append("  and mco_codigo = ").append(material);
                listaRecipientes = new RecipienteColetaService().load(buf.toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
        if (c != null && exaMat.getXmlLabExterno() != null) {
            HashMap<String, String> recipientes = new HashMap<String, String>();
            if (listaRecipientes != null) {
                for (RecipienteColetaBean rec : listaRecipientes) {
                    if (rec == null || rec.getRecipiente() == null) continue;
                    recipientes.put(rec.getRecipiente().getCodigo().toString(), rec.getRecipiente().getDescricao());
                }
                c.setRecipientes(recipientes);
            }
        }
        if (exaMatLabExterno != null && !Funcoes.textoVazio(exaMatLabExterno.getXmlLabExterno())) {
            c.setXML(exaMatLabExterno.getXmlLabExterno());
        }
        if (c != null) {
            c.setVisible(true);
            if (c.getOK()) {
                this.xmlSelecionado = c.getXML();
                String descricaoSelecionado = StringUtil.getValor(this.xmlSelecionado, "descricao");
                if (!Funcoes.textoVazio(this.xmlSelecionado) && Funcoes.textoVazio(descricaoSelecionado) && this.xmlSelecionado.contains("descricao-exame")) {
                    descricaoSelecionado = StringUtil.getValor(this.xmlSelecionado, "descricao-exame");
                }
                if (Funcoes.textoVazio(descricaoSelecionado)) {
                    descricaoSelecionado = StringUtil.getValor(this.xmlSelecionado, "ds_exame");
                }
                boolean exigirJejum = exaMat.isObrigaPeso();
                boolean exigirDUM = exaMat.isObrigaDum();
                boolean exigirPeso = exaMat.isObrigaPeso();
                boolean exigirAltura = exaMat.isObrigaAltura();
                boolean exigirVolume = exaMat.isObrigaVolume();
                boolean exigirTempoDiurese = exaMat.isObrigaTempoDiurese();
                boolean exigirMedicamento = exaMat.isObrigaMedicamento();
                if (c.exigeAltura() && !exaMat.isObrigaAltura().booleanValue()) {
                    exigirAltura = c.exigeAltura();
                }
                if (c.exigePeso() && !exaMat.isObrigaPeso().booleanValue()) {
                    exigirPeso = c.exigePeso();
                }
                if (c.exigeTempoDiurese() && !exaMat.isObrigaTempoDiurese().booleanValue()) {
                    exigirTempoDiurese = c.exigeTempoDiurese();
                }
                if (c.exigeVolumeDiurese() && !exaMat.isObrigaVolume().booleanValue()) {
                    exigirVolume = c.exigeVolumeDiurese();
                }
                if (c.exigeJejum() && !exaMat.isSolicitarJejum().booleanValue()) {
                    exigirJejum = c.exigeJejum();
                }
                if (c.exigeDUM() && !exaMat.isObrigaDum().booleanValue()) {
                    exigirDUM = c.exigeDUM();
                }
                if (c.exigeMedicamento() && !exaMat.isObrigaMedicamento().booleanValue()) {
                    exigirMedicamento = c.exigeMedicamento();
                }
                try {
                    SetorVO setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, String.valueOf(setorPadrao));
                    Boolean examePadrao = Boolean.TRUE;
                    examePadrao = RelacionamentoLabExterno.verificaExamePadrao(exaMat.getExame().getCodigo(), exaMat.getMaterial().getCodigo(), this.codigoLabExterno);
                    Integer prazoLabExt = Funcoes.isNumeric(this.txtPrazoLab.getText()) ? Integer.parseInt(this.txtPrazoLab.getText()) : 0;
                    Double precoLabExt = Funcoes.isNumeric(this.txtPrecoLab.getText()) ? Double.parseDouble(this.txtPrecoLab.getText()) : new Double("0");
                    boolean temRelacionamento = this.verificaRelacionamentoDesm(exaMat);
                    DadosModelo modelo = RelacionamentoLabExterno.buscaModelo(exaMat, metodoPadrao);
                    if (temRelacionamento) {
                        RelacionamentoLabExterno.insereExameMatLabExterno(exaMat, c.getXML(), prazoLabExt, precoLabExt, examePadrao, metodoPadrao, this.codigoLabExterno);
                        this.lblExameRelacionado.setText(descricaoSelecionado);
                        new ExameMatColetaService().atualizaCamposObrigatoriosExameMaterial(exaMat, ParametrosGerais.getCopiaExame(), exigirAltura, exigirPeso, exigirTempoDiurese, exigirJejum, exigirDUM, exigirMedicamento);
                        Conexao.arquivaSQL();
                    }
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    private boolean verificaRelacionamentoDesm(ExameMatColetaBean exaMat) {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        String exame = exaMat.getExame().getCodigo();
        sql.append("select exa_codigo from examematcoletalabextdesm");
        sql.append(" where exa_kodigo = '").append(exame).append("'");
        try {
            String tmp;
            ResultSet res = Conexao.executeQuery(st, sql);
            if (res.next() && !Funcoes.textoVazio(tmp = res.getString("exa_codigo"))) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O registro n\u00e3o pode ser alterado pois \u00e9 desmembrado do exame " + tmp.toString() + ".", 2);
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void buscaPrazo() {
        if (Funcoes.textoVazio(this.txtPrazo)) {
            this.lblDescPrazo.setText("");
            return;
        }
        try {
            this.prazo = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, this.txtPrazo.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do prazo de entrega.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (this.prazo != null) {
            this.lblDescPrazo.setText(this.prazo.getDescricao());
        } else {
            this.lblDescPrazo.setText("N\u00e3o cadastrado");
            this.txtPrazo.requestFocus();
        }
    }

    private void buscaSetor() {
        if (Funcoes.textoVazio(this.txtSetor)) {
            this.lblDescSetor.setText("");
            return;
        }
        try {
            this.setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, this.txtSetor.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do setor.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (this.setor != null) {
            this.lblDescSetor.setText(this.setor.getDescricao());
        } else {
            this.lblDescSetor.setText("N\u00e3o cadastrado");
            this.txtSetor.requestFocus();
        }
    }

    private void buscaDados(TTextField text, JLabel lbl, Hashtable resultado, String[] camposBanco) {
        if (resultado != null) {
            text.setText(resultado.get(camposBanco[0]).toString());
            lbl.setText(resultado.get(camposBanco[1]).toString());
        }
    }

    @Override
    @Deprecated
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.txtSetor) {
            this.buscaSetor();
        } else if (e.getSource() == this.txtPrazo) {
            this.buscaPrazo();
        }
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.txtPrazo && e.getKeyCode() == 113) {
            this.buscaDados(this.txtPrazo, this.lblDescPrazo, Pesquisas.prazoEntrega(this, true), new String[]{"prz_codigo", "prz_descricao"});
        } else if (e.getSource() == this.txtSetor && e.getKeyCode() == 113) {
            this.buscaDados(this.txtSetor, this.lblDescSetor, Pesquisas.setor(this, true), new String[]{"set_codigo", "set_descricao"});
        }
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }

    @Override
    protected boolean acaoOk() {
        if (this.validaCampos()) {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.escrever("setor", this.txtSetor.getText());
            xml.escrever("prazoEntrega", this.txtPrazo.getText());
            this.xml = xml.toString();
            return true;
        }
        return false;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtSetor.getText())) {
            Funcoes.mensagem(this, "Setor n\u00e3o selecionado", 2);
            this.txtSetor.requestFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtPrazo.getText())) {
            Funcoes.mensagem(this, "Prazo n\u00e3o selecionado", 2);
            this.txtPrazo.requestFocus();
            return false;
        }
        if (this.checkPadrao.isSelected() && this.checkBloqueado.isSelected()) {
            Funcoes.mensagem(this, "Laborat\u00f3rio externo n\u00e3o pode ser marcado como padr\u00e3o e bloqueado ao mesmo tempo", 2);
            this.checkPadrao.requestFocus();
            return false;
        }
        return true;
    }

    public void setDados(String relacionado, String exame, Integer setor, Integer prazo, Integer prazoLab, String precoLab, Boolean bloqueado, Boolean padrao, Integer metodo, String codigoLabExterno, String material, Protocolo protocolo) {
        this.txtSetor.setText(setor.toString());
        this.buscaSetor();
        this.txtPrazo.setText(prazo.toString());
        this.buscaPrazo();
        this.metodoPadrao = metodo;
        this.codigoLabExterno = codigoLabExterno;
        this.material = material;
        this.protocolo = protocolo;
        this.exame = exame;
        this.lblExameRelacionado.setText(relacionado);
        if (prazoLab != null) {
            this.txtPrazoLab.setText(prazoLab.toString());
        }
        if (precoLab != null) {
            this.txtPrecoLab.setText(Funcoes.formataDecimal(Double.parseDouble(Funcoes.limpaDecimal(precoLab)), 4));
        }
        this.checkPadrao.setSelected(padrao);
        this.checkBloqueado.setSelected(bloqueado);
    }

    public SetorVO getSetor() {
        SetorVO setor = new SetorVO();
        setor.setCodigo(Integer.parseInt(this.txtSetor.getText()));
        setor.setDescricao(this.lblDescSetor.getText());
        return setor;
    }

    public PrazoEntregaVO getPrazo() {
        PrazoEntregaVO prazo = new PrazoEntregaVO();
        prazo.setCodigo(Integer.parseInt(this.txtPrazo.getText()));
        prazo.setDescricao(this.lblDescPrazo.getText());
        return prazo;
    }

    public Integer getPrazoLabExterno() {
        if (Funcoes.textoVazio(this.txtPrazoLab)) {
            return null;
        }
        return Integer.parseInt(this.txtPrazoLab.getText());
    }

    public String getPrecoLabExterno() {
        if (Funcoes.textoVazio(this.txtPrecoLab)) {
            return null;
        }
        return this.txtPrecoLab.getText();
    }

    public boolean getPadrao() {
        return this.checkPadrao.isSelected();
    }

    public boolean getBloqueado() {
        return this.checkBloqueado.isSelected();
    }

    public String getXML() {
        return this.xmlSelecionado;
    }

    public void abrirRelacionamento(boolean isAbrir) {
        this.isAbrir = isAbrir;
    }
}

