/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.labexterno;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.cadastro.exame.PrazoEntregaVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.cadastro.exame.MetodologiaService;
import jalis.service.cadastro.exame.PrazoEntregaService;
import jalis.service.cadastro.exame.SetorService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class ConfiguracaoParametroRelacionamento
extends AbstractDialogoOKCancelar
implements FocusListener,
KeyListener {
    public static final String TAG_PARAMETROS_RELACIONAMENTO = "paramrelacionamento";
    public static final String TAG_METODO = "metodo";
    public static final String TAG_SETOR = "setor";
    public static final String TAG_PRAZO_ENTREGA = "prazoEntrega";
    private String xml;
    private TTextField txtMetodo = ComponenteFactory.novoTTextField(5, 1);
    private TTextField txtSetor = ComponenteFactory.novoTTextField(5, 1);
    private TTextField txtPrazo = ComponenteFactory.novoTTextField(5, 1);
    private JLabel lblMetodo = ComponenteFactory.novoJLabel("M\u00e9todo:", 'M', this.txtMetodo);
    private JLabel lblSetor = ComponenteFactory.novoJLabel("Setor:", 'S', this.txtSetor);
    private JLabel lblPrazo = ComponenteFactory.novoJLabel("Prazo:", 'P', this.txtPrazo);
    private JLabel lblDescMetodo = ComponenteFactory.novoJLabel("", new Dimension(50, 20));
    private JLabel lblDescSetor = ComponenteFactory.novoJLabel("", new Dimension(50, 20));
    private JLabel lblDescPrazo = ComponenteFactory.novoJLabel("", new Dimension(50, 20));
    private JButton btnBuscaMetodo = ComponenteFactory.novoJButton(this, true);
    private JButton btnBuscaSetor = ComponenteFactory.novoJButton(this, true);
    private JButton btnBuscaPrazo = ComponenteFactory.novoJButton(this, true);
    private SetorVO setor = null;

    private ConfiguracaoParametroRelacionamento(Dialog pai) {
        super(pai, "Configura\u00e7\u00e3o de Par\u00e2metros de Relacionamento");
        this.montaTela();
    }

    private ConfiguracaoParametroRelacionamento(Frame pai) {
        super(pai, "Configura\u00e7\u00e3o de Par\u00e2metros de Relacionamento");
        this.montaTela();
    }

    public static ConfiguracaoParametroRelacionamento novaInstancia(Window owner) {
        if (owner instanceof JDialog) {
            return new ConfiguracaoParametroRelacionamento((JDialog)owner);
        }
        return new ConfiguracaoParametroRelacionamento((JFrame)owner);
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
        this.preencheCampos(xml);
    }

    private void montaTela() {
        this.setSize(420, 145);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setUsuarioPodeCancelar(false);
        TitledBorder border = new TitledBorder("");
        ScreenUtil.setBorda(new JComponent[]{this.lblDescMetodo, this.lblDescSetor, this.lblDescPrazo}, border);
        Dimension d = new Dimension(69, 20);
        this.txtMetodo.setPreferredSize(d);
        this.txtSetor.setPreferredSize(d);
        this.txtPrazo.setPreferredSize(d);
        this.txtMetodo.setMinimumSize(d);
        this.txtSetor.setMinimumSize(d);
        this.txtPrazo.setMinimumSize(d);
        this.txtMetodo.addFocusListener(this);
        this.txtSetor.addFocusListener(this);
        this.txtPrazo.addFocusListener(this);
        this.txtMetodo.addKeyListener(this);
        this.txtSetor.addKeyListener(this);
        this.txtPrazo.addKeyListener(this);
        Dimension dBusca = new Dimension(20, 20);
        this.btnBuscaMetodo.setPreferredSize(dBusca);
        this.btnBuscaSetor.setPreferredSize(dBusca);
        this.btnBuscaPrazo.setPreferredSize(dBusca);
        this.btnBuscaMetodo.setMinimumSize(dBusca);
        this.btnBuscaSetor.setMinimumSize(dBusca);
        this.btnBuscaPrazo.setMinimumSize(dBusca);
        Insets iLeft = new Insets(1, 1, 1, 1);
        Insets iCenter = new Insets(1, 0, 1, 0);
        Insets iRight = new Insets(1, 0, 1, 1);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = iLeft;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.lblMetodo, c);
        c.insets = iCenter;
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtMetodo, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.btnBuscaMetodo, c);
        ++c.gridx;
        c.weighty = 0.0;
        c.weightx = 2.0;
        c.insets = iRight;
        this.getPanelCentral().add((Component)this.lblDescMetodo, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = iLeft;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.lblSetor, c);
        c.insets = iCenter;
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtSetor, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.btnBuscaSetor, c);
        ++c.gridx;
        c.weighty = 0.0;
        c.weightx = 2.0;
        c.insets = iRight;
        this.getPanelCentral().add((Component)this.lblDescSetor, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = iLeft;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        this.getPanelCentral().add((Component)this.lblPrazo, c);
        c.insets = iCenter;
        ++c.gridx;
        this.getPanelCentral().add((Component)this.txtPrazo, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)this.btnBuscaPrazo, c);
        ++c.gridx;
        c.weighty = 0.0;
        c.weightx = 2.0;
        c.insets = iRight;
        this.getPanelCentral().add((Component)this.lblDescPrazo, c);
        ++c.gridx;
        ScreenUtil.requisitarFoco(this.txtMetodo);
        ScreenUtil.centralizar(this);
    }

    private void preencheCampos(String xml) {
        if (Funcoes.textoVazio(xml)) {
            return;
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAG_METODO))) {
            this.preencheCampos(StringUtil.getValor(xml, TAG_METODO), this.txtMetodo, this.lblDescMetodo);
            this.buscaMetodo();
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAG_SETOR))) {
            this.preencheCampos(StringUtil.getValor(xml, TAG_SETOR), this.txtSetor, this.lblDescSetor);
            this.buscaSetor();
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAG_PRAZO_ENTREGA))) {
            this.preencheCampos(StringUtil.getValor(xml, TAG_PRAZO_ENTREGA), this.txtPrazo, this.lblDescPrazo);
            this.buscaPrazo();
        }
    }

    private void preencheCampos(String codigo, TTextField campo, JLabel label) {
        campo.setText(codigo);
        label.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok) {
                this.acaoCancelar();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                this.dispose();
            }
        } else if (o == this.btnBuscaMetodo) {
            this.lblDescMetodo.setText("");
            this.buscaDados(this.txtMetodo, this.lblDescMetodo, Pesquisas.metodologia(this, true), new String[]{"met_codigo", "met_descricao"});
        } else if (o == this.btnBuscaSetor) {
            this.lblDescSetor.setText("");
            this.buscaDados(this.txtSetor, this.lblDescSetor, Pesquisas.setor(this, true), new String[]{"set_codigo", "set_descricao"});
        } else if (o == this.btnBuscaPrazo) {
            this.lblDescPrazo.setText("");
            this.buscaDados(this.txtPrazo, this.lblDescPrazo, Pesquisas.prazoEntrega(this, true), new String[]{"prz_codigo", "prz_descricao"});
        }
    }

    private void buscaPrazo() {
        if (Funcoes.textoVazio(this.txtPrazo)) {
            this.lblDescPrazo.setText("");
            return;
        }
        PrazoEntregaVO prazo = null;
        try {
            prazo = (PrazoEntregaVO)new PrazoEntregaService().getVO(Variaveis.filialPadrao, this.txtPrazo.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do prazo de entrega.\n" + e.getMessage(), e.getStackTrace());
        }
        if (prazo != null) {
            this.lblDescPrazo.setText(prazo.getDescricao());
        } else {
            this.lblDescPrazo.setText("N\u00e3o cadastrado");
            this.txtPrazo.requestFocus();
        }
    }

    private void buscaSetor() {
        if (Funcoes.textoVazio(this.txtSetor)) {
            this.lblDescSetor.setText("");
            return;
        }
        try {
            this.setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, this.txtSetor.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do setor.\n" + e.getMessage(), e.getStackTrace());
        }
        if (this.setor != null) {
            this.lblDescSetor.setText(this.setor.getDescricao());
        } else {
            this.lblDescSetor.setText("N\u00e3o cadastrado");
            this.txtSetor.requestFocus();
        }
    }

    private void buscaMetodo() {
        if (Funcoes.textoVazio(this.txtMetodo)) {
            this.lblDescMetodo.setText("");
            return;
        }
        MetodologiaVO met = null;
        try {
            met = (MetodologiaVO)new MetodologiaService().getVO(Variaveis.filialPadrao, this.txtMetodo.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da metodologia.\n" + e.getMessage(), e.getStackTrace());
        }
        if (met != null) {
            this.lblDescMetodo.setText(met.getDescricao());
        } else {
            this.lblDescMetodo.setText("N\u00e3o cadastrado");
            this.txtMetodo.requestFocus();
        }
    }

    private void buscaDados(TTextField text, JLabel lbl, Hashtable resultado, String[] camposBanco) {
        if (text != null && lbl != null && resultado != null && camposBanco != null) {
            text.setText(resultado.get(camposBanco[0]).toString());
            lbl.setText(resultado.get(camposBanco[1]).toString());
        }
    }

    @Override
    @Deprecated
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.txtMetodo) {
            this.buscaMetodo();
        } else if (e.getSource() == this.txtSetor) {
            this.buscaSetor();
        } else if (e.getSource() == this.txtPrazo) {
            this.buscaPrazo();
        }
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.txtMetodo && e.getKeyCode() == 113) {
            this.buscaDados(this.txtMetodo, this.lblDescMetodo, Pesquisas.metodologia(this, true), new String[]{"met_codigo", "met_descricao"});
        } else if (e.getSource() == this.txtPrazo && e.getKeyCode() == 113) {
            this.buscaDados(this.txtPrazo, this.lblDescPrazo, Pesquisas.prazoEntrega(this, true), new String[]{"prz_codigo", "prz_descricao"});
        } else if (e.getSource() == this.txtSetor && e.getKeyCode() == 113) {
            this.buscaDados(this.txtSetor, this.lblDescSetor, Pesquisas.setor(this, true), new String[]{"set_codigo", "set_descricao"});
        }
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }

    @Override
    protected boolean acaoOk() {
        if (this.validaCampos()) {
            XMLStringBuilder xml = new XMLStringBuilder();
            try {
                xml.abrir(TAG_PARAMETROS_RELACIONAMENTO);
                xml.escrever(TAG_METODO, this.txtMetodo.getText());
                xml.escrever(TAG_SETOR, this.txtSetor.getText());
                xml.escrever(TAG_PRAZO_ENTREGA, this.txtPrazo.getText());
                xml.fechar(TAG_PARAMETROS_RELACIONAMENTO);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel criar XML das configura\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
                return false;
            }
            this.xml = xml.toString();
            return true;
        }
        return false;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtMetodo.getText())) {
            Funcoes.mensagem(this, "M\u00e9todo n\u00e3o selecionado", 2);
            this.txtMetodo.requestFocus();
            return false;
        }
        if (this.lblDescMetodo.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "M\u00e9todo selecionado n\u00e3o cadastrado.", 2);
            return false;
        }
        return true;
    }
}

