/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.labexterno;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.exame.AlteradorExame;
import jalis.laboratorio.cadastro.exame.ExameMaterial;
import jalis.laboratorio.cadastro.exame.externo.ExameLaboratorioExternoService;
import jalis.laboratorio.cadastro.exame.externo.LaboratorioExternoException;
import jalis.laboratorio.cadastro.exame.preco.TabelaPrecoExames;
import jalis.laboratorio.cadastro.util.callback.OKObserver;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ConfiguracaoExamesLaboratorioExterno {
    private final JDialog tela;
    private final ExameLaboratorioExternoService service = new ExameLaboratorioExternoService();
    private HashSet<ExameMaterial> alterados;
    private List<ExameMaterial> exames;
    private final TabelaPrecoExames tabelaExame;
    private final AlteradorExame alterador = new AlteradorExame();
    private JCheckBox checkBoxIgnorarMaterial = new JCheckBox("Alterar o pre\u00e7o do exame ignorando material", false);
    private JButton buttonOk = this.criarButton("OK", 50, 20, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfiguracaoExamesLaboratorioExterno.this.alterados.removeAll(ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.getAlterados(ConfiguracaoExamesLaboratorioExterno.this.exames));
            ConfiguracaoExamesLaboratorioExterno.this.alterados.addAll(ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.getAlterados(ConfiguracaoExamesLaboratorioExterno.this.exames));
            ConfiguracaoExamesLaboratorioExterno.this.tela.setVisible(false);
        }
    });
    private JButton buttonCancelar = this.criarButton("Cancelar", 50, 20, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfiguracaoExamesLaboratorioExterno.this.tela.setVisible(false);
        }
    });

    private JButton criarButton(String nome, int largura, int altura, ActionListener l) {
        return ComponenteFactory.novoJButton(nome, l);
    }

    public ConfiguracaoExamesLaboratorioExterno(Integer filial, Integer codigoLaboratorioExterno, HashSet<ExameMaterial> alterados) {
        this.tela = new JDialog((Frame)Laboratorio.getInstancia(), "Alterar pre\u00e7os exames");
        this.tela.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.alterados = alterados;
        this.tabelaExame = new TabelaPrecoExames(filial, codigoLaboratorioExterno);
        this.carregarExames(filial, codigoLaboratorioExterno);
        this.tabelaExame.atualizarRegistros(alterados);
        this.tela.setPreferredSize(new Dimension(682, 584));
        this.tela.setMinimumSize(new Dimension(682, 584));
        this.tela.setLocationRelativeTo(Laboratorio.getInstancia());
        this.tela.setLayout(new GridBagLayout());
        this.buttonCancelar.setMnemonic('C');
        this.buttonOk.setMnemonic('O');
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 4;
        this.tela.add((Component)this.alterador.getPanel(), c);
        c.gridx = 0;
        c.gridy += 4;
        this.tela.add((Component)this.tabelaExame.getPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets.left = 5;
        c.insets.top = 0;
        c.insets.bottom = 5;
        c.insets.right = 0;
        this.checkBoxIgnorarMaterial.setMnemonic('M');
        this.tela.add((Component)this.checkBoxIgnorarMaterial, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.anchor = 13;
        JPanel panelOkCancela = new JPanel();
        panelOkCancela.add(this.buttonOk);
        panelOkCancela.add(this.buttonCancelar);
        this.tela.add((Component)panelOkCancela, c);
        this.tela.setResizable(false);
        this.tela.setVisible(true);
        this.alterador.addOkFunction(new OKObserver(){

            @Override
            public void run() {
                ExameMaterial exame = ConfiguracaoExamesLaboratorioExterno.this.alterador.getExame();
                this.atualizarRegistro(exame);
                ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.verificaOrdenacao();
            }

            private void atualizarRegistro(ExameMaterial exame) {
                if (ConfiguracaoExamesLaboratorioExterno.this.checkBoxIgnorarMaterial.isSelected()) {
                    ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.atualizarRegistroIgnorandoMaterial(exame);
                } else {
                    ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.atualizarRegistro(exame);
                }
            }
        });
        this.tabelaExame.addMouseListenerTabela(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int col = ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.getTabela().columnAtPoint(e.getPoint());
                    ConfiguracaoExamesLaboratorioExterno.this.tabelaExame;
                    if (col != 6) {
                        JTable tabela = ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.getTabela();
                        int linha = tabela.getSelectedRow();
                        ModeloGridTable model = (ModeloGridTable)tabela.getModel();
                        ExameMaterial exame = (ExameMaterial)model.getLineValue(linha)[0];
                        ConfiguracaoExamesLaboratorioExterno.this.alterador.atualizar(exame);
                    }
                }
            }
        });
        this.tabelaExame.addKeyListenerTabela(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ExameMaterial exame = ConfiguracaoExamesLaboratorioExterno.this.tabelaExame.getExameLinhaSelecionada();
                    ConfiguracaoExamesLaboratorioExterno.this.alterador.atualizar(exame);
                }
            }
        });
    }

    private void carregarExames(Integer filial, Integer codigoLaboratorioExterno) {
        try {
            this.exames = this.service.buscarTodos(filial, codigoLaboratorioExterno);
            if (this.exames.isEmpty()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o existem exames configurados para o laborat\u00f3rio de apoio selecionado", 2);
                return;
            }
            this.tabelaExame.adicionarRegistros(this.exames);
        }
        catch (LaboratorioExternoException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
        }
    }
}

