/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.interfaceamento.consulta.dao;

import jalis.comum.Conexao;
import jalis.laboratorio.cadastro.interfaceamento.consulta.ConsultaLogException;
import jalis.laboratorio.cadastro.interfaceamento.consulta.LogComunicacaoInterface;
import jalis.laboratorio.cadastro.interfaceamento.consulta.LogRegistroInterface;
import jalis.laboratorio.cadastro.interfaceamento.consulta.dao.ConsultaLogDao;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ConsultaLogDaoImpl
implements ConsultaLogDao {
    private static final Date DATE_MAXIMA = ConsultaLogDaoImpl.dateMaxima();
    private static final Date DATE_MINIMA = ConsultaLogDaoImpl.dateMinima();
    protected static final String[] campos = new String[]{"lin_codigo", "fil_codigo", "int_codigo", "lin_datahora", "lin_operacao"};
    public static final String TABLE = "loginterface";

    private static Date dateMaxima() {
        Calendar cal = Calendar.getInstance();
        cal.set(5874897, 1, 1);
        return cal.getTime();
    }

    private static Date dateMinima() {
        Calendar cal = Calendar.getInstance();
        cal.set(-4712, 1, 1);
        return cal.getTime();
    }

    private static final String getSqlBuscarRegistros() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select int_codigo, lin_codigo, fil_codigo, lin_datahora");
        sql.append(" from ").append(TABLE);
        return sql.toString();
    }

    private static final String getSqlBuscarDadosComunicacao() {
        StringBuilder sql = new StringBuilder();
        sql.append(" select lin_operacao ");
        sql.append(" from ").append(TABLE);
        return sql.toString();
    }

    @Override
    public List<LogRegistroInterface> buscarRegistros(Integer codigoFilial, Integer codigoInterface, Date inicio, Date fim) throws ConsultaLogException {
        ArrayList<LogRegistroInterface> logsConsultados = new ArrayList<LogRegistroInterface>();
        if (inicio == null) {
            inicio = DATE_MINIMA;
        }
        if (fim == null) {
            fim = DATE_MAXIMA;
        }
        ResultSet rs = this.consultarRegistros(codigoFilial, codigoInterface, inicio, fim);
        try {
            while (rs.next()) {
                LogRegistroInterface log = this.extrairLogRegistroInterface(rs);
                logsConsultados.add(log);
            }
        }
        catch (SQLException e) {
            throw new ConsultaLogException(e);
        }
        return logsConsultados;
    }

    private LogRegistroInterface extrairLogRegistroInterface(ResultSet rs) throws SQLException {
        Integer id = rs.getInt("lin_codigo");
        Integer filial = rs.getInt("fil_codigo");
        Integer interfacemanto = rs.getInt("int_codigo");
        Timestamp data = rs.getTimestamp("lin_datahora");
        LogRegistroInterface log = new LogRegistroInterface(filial, interfacemanto, id, data);
        return log;
    }

    private ResultSet consultarRegistros(Integer codigoFilial, Integer codigoInterface, Date inicio, Date fim) throws ConsultaLogException {
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder(ConsultaLogDaoImpl.getSqlBuscarRegistros());
        sql.append(" where fil_codigo = ? ");
        sql.append(" and int_codigo = ? ");
        sql.append(" and cast(lin_datahora as date) >=  ? and cast(lin_datahora as date) <=  ?");
        sql.append(" order by lin_datahora asc ");
        PreparedStatement pr = Conexao.getPreparedStatement(sql.toString());
        try {
            pr.setInt(1, codigoFilial);
            pr.setInt(2, codigoInterface);
            pr.setDate(3, this.formatarData(inicio));
            pr.setDate(4, this.formatarData(fim));
            rs = Conexao.executeQuery(pr);
        }
        catch (NumberFormatException | SQLException e) {
            throw new ConsultaLogException(e);
        }
        return rs;
    }

    private java.sql.Date formatarData(Date data) {
        java.sql.Date formatado = new java.sql.Date(data.getTime());
        return formatado;
    }

    @Override
    public LogComunicacaoInterface buscarDadosComunicacao(Integer filial, Integer codigoLog) throws ConsultaLogException {
        StringBuilder sql = new StringBuilder(ConsultaLogDaoImpl.getSqlBuscarDadosComunicacao());
        sql.append(" where fil_codigo = ? ");
        sql.append(" and lin_codigo = ? ");
        PreparedStatement pr = Conexao.getPreparedStatement(sql.toString());
        try {
            pr.setInt(1, filial);
            pr.setInt(2, codigoLog);
            ResultSet rs = Conexao.executeQuery(pr);
            if (!rs.next()) {
                return new LogComunicacaoInterface("");
            }
            return new LogComunicacaoInterface(rs.getString("lin_operacao"));
        }
        catch (NumberFormatException | SQLException e) {
            throw new ConsultaLogException(e);
        }
    }
}

