/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.interfaceamento.consulta;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.interfaceamento.consulta.ConsultaLogException;
import jalis.laboratorio.cadastro.interfaceamento.consulta.LogComunicacaoInterface;
import jalis.laboratorio.cadastro.interfaceamento.consulta.LogRegistroInterface;
import jalis.laboratorio.cadastro.interfaceamento.consulta.dao.ConsultaLogDao;
import jalis.laboratorio.cadastro.interfaceamento.consulta.dao.ConsultaLogDaoImpl;
import jalis.laboratorio.cadastro.util.text.HighlightException;
import jalis.laboratorio.cadastro.util.text.TextAreaHighlighter;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ConsultaLog {
    private static final int LARGURA_CAMPO_PADRAO = 120;
    private static final int LARGURA_LUPA = 20;
    private static final int LARGURA_CAMPO_DATA = 100;
    private static final int ALTURA_PADRAO = 23;
    private TTextField campoDataInicial;
    private TTextField campoDataFinal;
    private JLabel labelDataInicial;
    private JLabel labelDataFinal;
    private JTextArea campoComunicacao;
    private JLabel labelLocalizar;
    private JTextField campoLocalizar;
    private TextAreaHighlighter highlight;
    private JButton botaoFechar;
    private ModeloGridTable modeloRegistros;
    private ConsultaLogDao dao;
    private final JDialog frame;
    private final Component pai;
    private final Integer codigoInterface;
    private JButton botaoConsultar = new JButton("Consultar");
    private JButton botaoDataInicial = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Funcoes.mostraData(ConsultaLog.this.campoDataInicial, ConsultaLog.this.botaoDataInicial, (JPanel)ConsultaLog.this.campoDataInicial.getParent(), true);
        }
    }, true);
    private JButton botaoDataFinal = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Funcoes.mostraData(ConsultaLog.this.campoDataFinal, ConsultaLog.this.botaoDataFinal, (JPanel)ConsultaLog.this.campoDataFinal.getParent(), true);
        }
    }, true);
    private JTable tableRegistros;
    private JScrollPane scrollComunicacao;

    public static ConsultaLog abrirTela(Integer codigoInterface, String nomeInterface) {
        return new ConsultaLog(Laboratorio.getInstancia(), codigoInterface, nomeInterface);
    }

    private ConsultaLog(Component pai, Integer codigoInterface, String nomeInterface) {
        this.pai = pai;
        this.frame = new JDialog();
        this.frame.setModal(true);
        this.codigoInterface = codigoInterface;
        this.dao = new ConsultaLogDaoImpl();
        this.montarTela(nomeInterface);
        this.frame.setResizable(true);
        this.frame.setVisible(true);
    }

    private void montarTela(String nomeInterface) {
        this.criarComponentes();
        this.frame.setLocation(this.pai.getLocationOnScreen());
        this.frame.setLayout(new BorderLayout());
        this.frame.setTitle("Consulta log " + nomeInterface);
        this.frame.add((Component)this.intanciarPanelFiltro(), "North");
        this.frame.add((Component)this.intanciarPanelRegistros(), "West");
        this.frame.add((Component)this.intanciarPanelComunicacao(), "Center");
        this.frame.add((Component)this.intanciarPanelFechar(), "South");
        this.frame.setSize(new Dimension(720, 500));
        this.frame.setLocationRelativeTo(this.pai);
    }

    private void criarComponentes() {
        this.campoDataInicial = new TTextField(10, 4);
        this.campoDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaLog.this.botaoDataInicial.doClick();
                }
            }
        });
        this.campoDataFinal = new TTextField(10, 4);
        this.campoDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaLog.this.botaoDataFinal.doClick();
                }
            }
        });
        this.labelDataInicial = new JLabel("Data Inicial:");
        this.labelDataFinal = new JLabel("Data Final:");
        this.campoComunicacao = new JTextArea();
        this.labelLocalizar = new JLabel("Localizar:");
        this.campoLocalizar = new JTextField();
        this.highlight = new TextAreaHighlighter(this.campoComunicacao);
        this.botaoFechar = new JButton("Fechar");
        this.botaoFechar.setMnemonic('F');
        this.modeloRegistros = new ModeloGridTable(new String[]{"Data"});
        this.botaoConsultar = new JButton("Consultar");
        this.botaoDataInicial = ComponenteFactory.novoJButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaLog.this.campoDataInicial, ConsultaLog.this.botaoDataInicial, (JPanel)ConsultaLog.this.campoDataInicial.getParent(), true);
            }
        }, true);
        this.botaoDataFinal = ComponenteFactory.novoJButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaLog.this.campoDataFinal, ConsultaLog.this.botaoDataFinal, (JPanel)ConsultaLog.this.campoDataFinal.getParent(), true);
            }
        }, true);
    }

    private JPanel intanciarPanelFechar() {
        JPanel panelFechar = new JPanel(new GridBagLayout());
        this.botaoFechar.setPreferredSize(new Dimension(75, 23));
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaLog.this.frame.dispose();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 13;
        constraints.weightx = 1.0;
        constraints.insets.right = 5;
        constraints.insets.bottom = 5;
        constraints.insets.top = 5;
        panelFechar.add((Component)this.botaoFechar, constraints);
        Funcoes.montaEnter((JComponent)panelFechar);
        return panelFechar;
    }

    private JPanel intanciarPanelComunicacao() {
        JPanel panelComunicacao = new JPanel(new GridBagLayout());
        this.campoComunicacao.setEditable(false);
        this.scrollComunicacao = new JScrollPane(this.campoComunicacao);
        panelComunicacao.setBorder(BorderFactory.createTitledBorder("Comunica\u00e7\u00e3o"));
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.gridx = 0;
        contraints.gridy = 0;
        contraints.gridwidth = 10;
        contraints.weightx = 1.0;
        contraints.weighty = 1.0;
        contraints.fill = 1;
        contraints.anchor = 18;
        panelComunicacao.add((Component)this.scrollComunicacao, contraints);
        ++contraints.gridy;
        contraints.weightx = 0.0;
        contraints.weighty = 0.0;
        contraints.gridwidth = 1;
        panelComunicacao.add((Component)this.labelLocalizar, contraints);
        ++contraints.gridx;
        contraints.gridwidth = 9;
        panelComunicacao.add((Component)this.campoLocalizar, contraints);
        this.campoLocalizar.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                try {
                    if (ConsultaLog.this.highlight.update(ConsultaLog.this.campoLocalizar.getText())) {
                        ConsultaLog.this.campoLocalizar.setBackground(Color.white);
                    } else {
                        ConsultaLog.this.campoLocalizar.setBackground(Color.red);
                    }
                }
                catch (HighlightException e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
                }
            }
        });
        Funcoes.montaEnter((JComponent)panelComunicacao);
        return panelComunicacao;
    }

    private JPanel intanciarPanelRegistros() {
        JPanel panelRegistros = new JPanel();
        this.tableRegistros = new JTable(this.modeloRegistros){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
                if (rowIndex > -1) {
                    ConsultaLog.this.carregarPanelComunicacao(rowIndex);
                    ConsultaLog.this.campoLocalizar.setText("");
                }
            }
        };
        JScrollPane scroll = new JScrollPane(this.tableRegistros);
        this.modeloRegistros.setColumnSize(new int[]{0}, this.tableRegistros);
        scroll.setPreferredSize(new Dimension(160, 345));
        panelRegistros.setLayout(new BorderLayout());
        panelRegistros.setBorder(BorderFactory.createTitledBorder("Registros"));
        panelRegistros.add((Component)scroll, "Center");
        Funcoes.montaEnter((JComponent)panelRegistros);
        return panelRegistros;
    }

    private void carregarPanelComunicacao(int linha) {
        this.campoComunicacao.setText("");
        LogRegistroInterface registro = (LogRegistroInterface)this.modeloRegistros.getValueAt(linha, 0);
        LogComunicacaoInterface logComunicacao = null;
        try {
            logComunicacao = this.dao.buscarDadosComunicacao(registro.getfilial(), registro.getId());
        }
        catch (ConsultaLogException e) {
            ErrorLogger.mostraMensagem(this.frame, "Erro ao buscar Dados Comunicacao\n\n" + e.getMessage(), e.getStackTrace());
        }
        if (logComunicacao != null) {
            this.campoComunicacao.setText(logComunicacao.getLog());
        }
    }

    private JPanel intanciarPanelFiltro() {
        JPanel panelFiltro = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        panelFiltro.setBorder(BorderFactory.createTitledBorder("Filtros"));
        this.intanciarCamposFiltro();
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 20, 8, 0);
        panelFiltro.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        panelFiltro.add((Component)this.labelDataInicial, constraints);
        constraints.insets = new Insets(3, 5, 8, 0);
        ++constraints.gridx;
        panelFiltro.add((Component)this.campoDataInicial, constraints);
        constraints.insets = new Insets(3, 0, 8, 0);
        ++constraints.gridx;
        panelFiltro.add((Component)this.botaoDataInicial, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(3, 20, 8, 0);
        panelFiltro.add((Component)this.labelDataFinal, constraints);
        constraints.insets = new Insets(3, 5, 8, 0);
        ++constraints.gridx;
        panelFiltro.add((Component)this.campoDataFinal, constraints);
        constraints.insets = new Insets(3, 0, 8, 0);
        ++constraints.gridx;
        panelFiltro.add((Component)this.botaoDataFinal, constraints);
        constraints.insets = new Insets(3, 5, 8, 0);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panelFiltro.add((Component)this.botaoConsultar, constraints);
        Funcoes.montaEnter((JComponent)panelFiltro);
        return panelFiltro;
    }

    private void intanciarCamposFiltro() {
        Dimension dimensoesCampoData = new Dimension(100, 23);
        this.campoDataInicial.setPreferredSize(dimensoesCampoData);
        Dimension dimensoesLupa = new Dimension(20, 23);
        this.botaoDataInicial.setPreferredSize(dimensoesLupa);
        Funcoes.imagemPesquisa(this.botaoDataInicial);
        this.campoDataFinal.setPreferredSize(dimensoesCampoData);
        this.botaoDataFinal.setPreferredSize(dimensoesLupa);
        this.botaoConsultar.setPreferredSize(new Dimension(90, 23));
        this.botaoConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaLog.this.acaoConsultar();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acaoConsultar() {
        try {
            SplashMensagem splash = SplashMensagem.getInstancia(this.frame);
            try {
                splash.mostrar("Consultando");
                this.limpaTela();
                if (this.datasEstaoVazias()) {
                    return;
                }
                if (this.datasSaoInvalidas()) {
                    return;
                }
                if (!this.dataInicialVazia() && !this.dataFinalVazia() && this.dataFinalMaiorQueInicial()) {
                    this.mostrarErro("A data inicial n\u00e3o pode ser maior do que a data final.");
                    this.campoDataInicial.grabFocus();
                    return;
                }
                Date inicio = this.criarDate(this.campoDataInicial.getText());
                Date fim = this.criarDate(this.campoDataFinal.getText());
                List<LogRegistroInterface> registros = this.dao.buscarRegistros(Integer.valueOf(Variaveis.filialPadrao), this.codigoInterface, inicio, fim);
                this.carregarRegistrosNoModelo(registros);
            }
            catch (ParseException pa) {
                this.mostrarErro("Data informada incorretamente.");
            }
            finally {
                splash.apagar();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.frame, "N\u00e3o foi poss\u00edvel buscar registro\n\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private boolean dataInicialVazia() {
        return Funcoes.textoVazio(this.campoDataInicial.getText());
    }

    private boolean dataFinalVazia() {
        return Funcoes.textoVazio(this.campoDataFinal.getText());
    }

    private void mostrarErro(String mensagem) {
        Funcoes.mensagem(this.frame, mensagem, 1);
    }

    private boolean datasSaoInvalidas() {
        return !this.campoDataInicial.isConteudoValido() || !this.campoDataFinal.isConteudoValido();
    }

    private boolean dataFinalMaiorQueInicial() {
        return this.campoDataInicial.getData().after(this.campoDataFinal.getData());
    }

    private boolean datasEstaoVazias() {
        return this.dataInicialVazia() && this.dataFinalVazia();
    }

    private void limpaTela() {
        this.modeloRegistros.clear();
        this.campoComunicacao.setText("");
        this.campoLocalizar.setText("");
    }

    private void carregarRegistrosNoModelo(List<LogRegistroInterface> registros) {
        for (LogRegistroInterface registro : registros) {
            this.modeloRegistros.addLine(new Object[]{registro});
        }
    }

    private Date criarDate(String text) throws ParseException {
        if (Funcoes.textoVazio(text)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyy");
        Date data = new Date();
        data = format.parse(text);
        return data;
    }
}

