/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.exame.preco.calculo;

import jalis.laboratorio.cadastro.exame.ExameMaterial;
import jalis.laboratorio.cadastro.exame.preco.calculo.AlteradorExameException;
import jalis.laboratorio.cadastro.exame.preco.calculo.AlteradorPercentual;
import jalis.laboratorio.cadastro.exame.preco.calculo.regra.AumentarValor;
import jalis.laboratorio.cadastro.exame.preco.calculo.regra.DiminuirValor;
import jalis.laboratorio.cadastro.exame.preco.calculo.regra.RegraDePercentual;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AlteradorPercentualService {
    public static final int AUMENTAR = 0;
    public static final int DIMINUIR = 1;
    private final HashSet<ExameMaterial> alterados = new HashSet();
    private AlteradorPercentual tela;
    private RegraDePercentual regra;

    private Double arredondarCentavos(ExameMaterial exame) {
        return Math.round(exame.getValor());
    }

    public HashSet<ExameMaterial> getExames() {
        return this.alterados;
    }

    public HashSet<ExameMaterial> abrirTela(List<ExameMaterial> exames, int tipoAlterador) throws AlteradorExameException {
        this.tela = new AlteradorPercentual();
        this.alterados.clear();
        this.regra = AlteradorPercentualService.criarRegra(tipoAlterador);
        this.tela.addOkActionListener(this.criarActionListener(exames));
        this.tela.abrir();
        return this.alterados;
    }

    public static RegraDePercentual criarRegra(int tipoAlterador) throws AlteradorExameException {
        switch (tipoAlterador) {
            case 0: {
                return new AumentarValor();
            }
            case 1: {
                return new DiminuirValor();
            }
        }
        throw new AlteradorExameException("Tipo de alterador de percentual n\u00e3o foi encontrado");
    }

    private ActionListener criarActionListener(final List<ExameMaterial> exames) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AlteradorPercentualService.this.tela.getPercentual().isNaN()) {
                    return;
                }
                if (AlteradorPercentualService.this.tela.apenasSelecionados()) {
                    List selecioandos = AlteradorPercentualService.this.getExamesSelecionados(exames);
                    AlteradorPercentualService.this.alterados.addAll(selecioandos);
                } else {
                    AlteradorPercentualService.this.alterados.addAll(exames);
                }
                for (ExameMaterial exame : AlteradorPercentualService.this.alterados) {
                    Double resultado = AlteradorPercentualService.this.regra.executar(exame.getValor(), AlteradorPercentualService.this.tela.getPercentual());
                    exame.setValor(resultado);
                    if (!AlteradorPercentualService.this.tela.arredondarCentavos()) continue;
                    Double valArredondado = AlteradorPercentualService.this.arredondarCentavos(exame);
                    exame.setValor(valArredondado);
                }
            }
        };
    }

    private List<ExameMaterial> getExamesSelecionados(List<ExameMaterial> exames) {
        ArrayList<ExameMaterial> selecionados = new ArrayList<ExameMaterial>();
        for (ExameMaterial exame : exames) {
            if (!exame.isSelecionado().booleanValue()) continue;
            selecionados.add(exame);
        }
        return selecionados;
    }
}

