/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.exame.preco.calculo;

import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AlteradorPercentual {
    private JDialog tela;
    private JLabel labelPercentual = this.criarLabel("Percentual:", 140, 20);
    private JTextField fieldPercentual = this.criarField(130, 22);
    private JCheckBox checkBoxArredondarCentavos = this.criarCheckBox("Arredondar centavos ao calcular percentual", false, 335, 22);
    private JCheckBox checkBoxAtualizarSelecionados = this.criarCheckBox("Atualizar apenas exames selecionados", false, 335, 22);
    private JButton buttonOk = this.criarBotao("OK", 60, 25);
    private JButton buttonCancelar = this.criarBotao("Cancelar", 95, 25);

    public AlteradorPercentual() {
        this.tela = this.criarTela();
    }

    private JCheckBox criarCheckBox(String nome, Boolean selecionado, int largura, int altura) {
        JCheckBox box = new JCheckBox(nome, (boolean)selecionado);
        Dimension size = new Dimension(largura, altura);
        box.setMinimumSize(size);
        box.setSize(size);
        return box;
    }

    private JButton criarBotao(String nome, int largura, int altura) {
        JButton botao = new JButton(nome);
        Dimension size = new Dimension(largura, altura);
        botao.setPreferredSize(size);
        botao.setMinimumSize(size);
        return botao;
    }

    private TTextField criarField(int largura, int altura) {
        TTextField field = new TTextField(50, 2, 4, true);
        Dimension size = new Dimension(largura, altura);
        field.setPreferredSize(size);
        field.setMinimumSize(size);
        return field;
    }

    private JLabel criarLabel(String nome, int largura, int altura) {
        JLabel label = new JLabel(nome);
        Dimension size = new Dimension(largura, altura);
        label.setPreferredSize(size);
        label.setMinimumSize(size);
        return label;
    }

    private JDialog criarTela() {
        JDialog tela = new JDialog(Laboratorio.getInstancia(), "Percentual", true);
        tela.setResizable(false);
        tela.setMinimumSize(new Dimension(335, 155));
        tela.setLocationRelativeTo(Laboratorio.getInstancia());
        tela.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        c.insets.left = 7;
        tela.add((Component)this.labelPercentual, c);
        c.insets.bottom = 3;
        c.gridy += 2;
        tela.add((Component)this.fieldPercentual, c);
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets.bottom = 0;
        tela.add((Component)this.checkBoxArredondarCentavos, c);
        ++c.gridy;
        tela.add((Component)this.checkBoxAtualizarSelecionados, c);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridx = -1;
        tela.add((Component)this.buttonOk, c);
        c.insets.right = 5;
        c.weightx = 0.0;
        tela.add((Component)this.buttonCancelar, c);
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlteradorPercentual.this.fechar();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlteradorPercentual.this.fechar();
            }
        });
        Funcoes.montaEnter((JComponent)tela.getContentPane());
        return tela;
    }

    public void addOkActionListener(ActionListener actionListener) {
        this.buttonOk.addActionListener(actionListener);
    }

    public void fechar() {
        this.tela.setVisible(false);
    }

    public Double getPercentual() {
        String text = this.fieldPercentual.getText();
        if (Funcoes.textoVazio(text)) {
            return new Double(0.0);
        }
        return Double.valueOf(text);
    }

    public boolean arredondarCentavos() {
        return this.checkBoxArredondarCentavos.isSelected();
    }

    public boolean apenasSelecionados() {
        return this.checkBoxAtualizarSelecionados.isSelected();
    }

    public void abrir() {
        this.tela.setVisible(true);
    }
}

