/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.exame.preco;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.exame.ExameMaterial;
import jalis.laboratorio.cadastro.exame.preco.calculo.AlteradorExameException;
import jalis.laboratorio.cadastro.exame.preco.calculo.AlteradorPercentualService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TabelaPrecoExames {
    private static final Dimension SIZE = new Dimension(0, 408);
    private static final String[] COLUNAS = new String[]{"C\u00f3digo", "Mat.", "Exame", "Exame apoio", "Prazo", "Valor", "Bloq."};
    public static final String COL_NAME_CODIGO = "C\u00f3digo";
    public static final String COL_NAME_MATERIAL = "Mat.";
    public static final String COL_NAME_EXAME = "Exame";
    public static final String COL_NAME_EXAME_APOIO = "Exame apoio";
    public static final String COL_NAME_PRAZO = "Prazo";
    public static final String COL_NAME_VALOR = "Valor";
    public static final String COL_NAME_BLOQUEADO = "Bloq.";
    private static final int[] TAMANHO_COLUNAS = new int[]{72, 40, 0, 100, 60, 50, 40};
    public static final int COL_CODIGO = 0;
    public static final int COL_MATERIAL = 1;
    public static final int COL_EXAME = 2;
    public static final int COL_EXAME_APOIO = 3;
    public static final int COL_PRAZO = 4;
    public static final int COL_VALOR = 5;
    public static final int COL_BLOQUEADO = 6;
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final JTable tabela = this.criarTabela();
    private final JScrollPane scroll = new JScrollPane(this.tabela);
    private final JLabel labelLocalizar = new JLabel("Localizar:");
    private final JTextField fieldLocalizar = new JTextField();
    private AlteradorPercentualService service = new AlteradorPercentualService();
    private final JButton buttonAumentar = this.criarButton("Aumentar percentual", 50, 20, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TabelaPrecoExames.this.acaoAlterarPercentual(0);
        }
    });
    private final JButton buttonDiminuir = this.criarButton("Diminuir percentual", 12, 20, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TabelaPrecoExames.this.acaoAlterarPercentual(1);
        }
    });
    private HashSet<ExameMaterial> alterados = new HashSet();

    private void acaoAlterarPercentual(int tipo) {
        this.abrirTelaPercentual(tipo);
        HashSet<ExameMaterial> exames = this.service.getExames();
        this.atualizarRegistros(exames);
        this.verificaOrdenacao();
    }

    public void verificaOrdenacao() {
        int col = this.getModelo().getColunaOrdenacao();
        if (col >= 0) {
            this.ordenarTable(col);
            this.ordenarTable(col);
        }
    }

    private List<ExameMaterial> buscarExames() {
        ModeloGridTable modelo = (ModeloGridTable)this.tabela.getModel();
        ArrayList<ExameMaterial> exames = new ArrayList<ExameMaterial>();
        for (int line = 0; line < modelo.getRowCount(); ++line) {
            HashMap<String, Object> hash = modelo.getLine(line);
            ExameMaterial exame = (ExameMaterial)hash.get(COL_NAME_CODIGO);
            boolean isSelecionado = this.tabela.isCellSelected(line, 6);
            exame.setSelecionado(isSelecionado);
            exames.add(exame);
        }
        return exames;
    }

    private JButton criarButton(String nome, int largura, int altura, ActionListener l) {
        return ComponenteFactory.novoJButton(nome, l);
    }

    public TabelaPrecoExames(Integer filial, Integer labexterno) {
        this.scroll.setMinimumSize(SIZE);
        int x = 0;
        int y = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        this.addToPanel(this.scroll, x, y, 0, 2, insets);
        this.labelLocalizar.setDisplayedMnemonic('L');
        this.labelLocalizar.setLabelFor(this.fieldLocalizar);
        this.addToPanel(this.labelLocalizar, x, ++y, 0, 1, insets);
        insets.left = 60;
        this.addToPanel(this.fieldLocalizar, x, y, 1, 2, insets);
        insets.left = 0;
        x = 0;
        this.addToPanel(this.buttonAumentar, 0, ++y, 1, 1, insets);
        this.addToPanel(this.buttonDiminuir, ++x, y, 1, 1, insets);
        this.fieldLocalizar.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ModeloGridTable modelo = TabelaPrecoExames.this.getModelo();
                int coluna = modelo.getColunaOrdenacao();
                if (coluna < 0) {
                    return;
                }
                for (int linha = 0; linha < modelo.getRowCount(); ++linha) {
                    String valor = modelo.getValueAt(linha, coluna).toString();
                    String valLocalizar = TabelaPrecoExames.this.fieldLocalizar.getText();
                    if (Funcoes.textoVazio(valLocalizar) || !valor.toUpperCase().contains(valLocalizar.toUpperCase())) continue;
                    TabelaPrecoExames.this.tabela.setRowSelectionInterval(linha, linha);
                    TabelaPrecoExames.this.tabela.scrollRectToVisible(new Rectangle(TabelaPrecoExames.this.tabela.getCellRect(linha, 0, true)));
                }
            }
        });
    }

    private void addToPanel(JComponent comp, int x, int y, int weightx, int gridwidth, Insets insets) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.gridx = x;
        c.gridy = y;
        c.weightx = weightx;
        c.gridwidth = gridwidth;
        c.insets = insets;
        this.panel.add((Component)comp, c);
    }

    private void abrirTelaPercentual(int tipo) {
        List<ExameMaterial> exames = this.buscarExames();
        try {
            this.service.abrirTela(exames, tipo);
        }
        catch (AlteradorExameException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
        }
    }

    private JTable criarTabela() {
        ModeloGridTable modelo = new ModeloGridTable(COLUNAS){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 6) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }
        };
        final JTable tabela = new JTable(modelo);
        tabela.setMinimumSize(SIZE);
        modelo.setColumnSize(TAMANHO_COLUNAS, tabela);
        tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int col;
                if (e.getButton() == 1 && e.getClickCount() == 1 && this.isColBloqueado(col = tabela.columnAtPoint(e.getPoint()))) {
                    TabelaPrecoExames.this.trocarValorColunaBloqueado();
                }
            }

            private boolean isColBloqueado(int col) {
                return col == 6;
            }
        });
        tabela.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colum;
                if (e.getButton() == 1 && e.getClickCount() == 1 && (colum = tabela.columnAtPoint(e.getPoint())) != 6) {
                    ModeloGridTable modelo = (ModeloGridTable)tabela.getModel();
                    modelo.ordenarColuna(colum);
                }
            }
        });
        return tabela;
    }

    private void ordenarTable(int colun) {
        ModeloGridTable modelo = (ModeloGridTable)this.tabela.getModel();
        modelo.ordenarColuna(colun);
    }

    private void trocarValorColunaBloqueado() {
        ModeloGridTable modelo = (ModeloGridTable)this.tabela.getModel();
        int linha = this.tabela.getSelectedRow();
        modelo.setValueAt(!this.isBloqueado(linha), linha, 6);
        ExameMaterial exameTabela = this.getExameLinha(linha);
        exameTabela.setBloqueado(this.isBloqueado(linha));
        this.setExameNaLinha(exameTabela, linha);
        this.atualizarRegistro(exameTabela);
    }

    public boolean isBloqueado(int linha) {
        ModeloGridTable modelo = (ModeloGridTable)this.tabela.getModel();
        return (Boolean)modelo.getValueAt(linha, 6);
    }

    public JTable getTabela() {
        return this.tabela;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void adicionarRegistro(ExameMaterial exame) {
        ModeloGridTable modelo = this.getModelo();
        modelo.addLine(exame.toObject());
        modelo.ordenarColuna(0);
    }

    public void adicionarRegistros(Collection<ExameMaterial> exames) {
        for (ExameMaterial exame : exames) {
            ModeloGridTable modelo = this.getModelo();
            modelo.addLine(exame.toObject());
            modelo.ordenarColuna(0);
        }
    }

    private ModeloGridTable getModelo() {
        return (ModeloGridTable)this.tabela.getModel();
    }

    public void atualizarRegistro(ExameMaterial exame) {
        if (exame != null) {
            ModeloGridTable modelo = this.getModelo();
            for (int linha = 0; linha < modelo.getRowCount(); ++linha) {
                if (!this.exameEqualsLinha(exame, linha)) continue;
                this.atualizarExameNaLinha(exame, linha);
                if (this.alterados.contains(exame)) {
                    this.alterados.remove(exame);
                }
                this.alterados.add(exame);
                return;
            }
        }
    }

    private boolean exameEqualsLinha(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        return exame.equals((ExameMaterial)modelo.getLineValue(linha)[0]);
    }

    private boolean codigoExameEqualsLinha(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        ExameMaterial outro = (ExameMaterial)modelo.getLineValue(linha)[0];
        return exame.getCodigo().equalsIgnoreCase(outro.getCodigo());
    }

    public void atualizarRegistroIgnorandoMaterial(ExameMaterial exame) {
        if (exame != null) {
            for (int linha = 0; linha < this.getNumeroDeLinhas(); ++linha) {
                if (!this.codigoExameEqualsLinha(exame, linha)) continue;
                this.atualizarExameNaLinha(exame, linha);
                this.alterados.add(this.getExameLinha(linha));
            }
        }
    }

    private void atualizarExameNaLinha(ExameMaterial exame, int linha) {
        this.setPrazoNaLinha(exame, linha);
        this.setValorNaLinha(exame, linha);
        this.setValorBloqueado(exame, linha);
    }

    private void setValorBloqueado(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        modelo.setValueAt(exame.getBloqueado(), linha, 6);
        ExameMaterial exameTabela = this.getExameLinha(linha);
        exameTabela.setBloqueado(exame.getBloqueado());
        this.setExameNaLinha(exameTabela, linha);
    }

    private int getNumeroDeLinhas() {
        return this.getModelo().getRowCount();
    }

    private void setValorNaLinha(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        modelo.setValueAt(exame.getValorString(), linha, 5);
        ExameMaterial exameTabela = this.getExameLinha(linha);
        exameTabela.setValor(exame.getValor());
        this.setExameNaLinha(exameTabela, linha);
    }

    private void setPrazoNaLinha(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        modelo.setValueAt(exame.getPrazo(), linha, 4);
        ExameMaterial exameTabela = this.getExameLinha(linha);
        exameTabela.setPrazo(exame.getPrazo());
        this.setExameNaLinha(exameTabela, linha);
    }

    private void setExameNaLinha(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        modelo.setValueAt(exame, linha, 0);
    }

    private ExameMaterial getExameLinha(int linha) {
        ModeloGridTable modelo = this.getModelo();
        return (ExameMaterial)modelo.getValueAt(linha, 0);
    }

    private void setCodigoNaLInha(ExameMaterial exame, int linha) {
        ModeloGridTable modelo = this.getModelo();
        modelo.setValueAt(exame, linha, 0);
    }

    private String getCodigoTabela(int linha) {
        ModeloGridTable modelo = this.getModelo();
        return modelo.getLineValue(linha)[0].toString();
    }

    private String getMaterialTabela(int linha) {
        ModeloGridTable modelo = this.getModelo();
        return modelo.getLineValue(linha)[1].toString();
    }

    private String getExameApoioTabela(int linha) {
        ModeloGridTable modelo = this.getModelo();
        return modelo.getLineValue(linha)[3].toString();
    }

    private Boolean getBloqueadoTabela(int linha) {
        ModeloGridTable modelo = this.getModelo();
        Boolean bloqueado = Boolean.valueOf(modelo.getLineValue(linha)[6].toString());
        return bloqueado;
    }

    private String getExameTabela(int linha) {
        ModeloGridTable modelo = this.getModelo();
        return modelo.getLineValue(linha)[2].toString();
    }

    public void atualizarRegistros(HashSet<ExameMaterial> exames) {
        for (ExameMaterial exame : exames) {
            this.atualizarRegistro(exame);
        }
    }

    public void limpar() {
        this.getModelo().clear();
    }

    public void removerRegistro(ExameMaterial exame) {
        if (exame != null) {
            ModeloGridTable modelo = this.getModelo();
            for (int linha = 0; linha < modelo.getRowCount(); ++linha) {
                if (!exame.equals(modelo.getLineValue(linha))) continue;
                modelo.removeLine(linha);
            }
        }
    }

    public void addMouseListenerTabela(MouseListener l) {
        this.tabela.addMouseListener(l);
    }

    public void addKeyListenerTabela(KeyListener l) {
        this.tabela.addKeyListener(l);
    }

    public ExameMaterial getExameLinhaSelecionada() {
        int linha = this.tabela.getSelectedRow();
        ModeloGridTable modelo = (ModeloGridTable)this.tabela.getModel();
        ExameMaterial exame = (ExameMaterial)modelo.getLineValue(linha)[0];
        return exame;
    }

    public Set<ExameMaterial> getAlterados(List<ExameMaterial> exames) {
        return new HashSet<ExameMaterial>(this.alterados);
    }

    private boolean verificaAlteracao(ExameMaterial exame, ExameMaterial exameTabela) {
        return !exame.getValor().equals(exameTabela.getValor()) || !exame.getPrazo().equals(exameTabela.getPrazo()) || !exame.getBloqueado().equals(exameTabela.getBloqueado());
    }
}

