/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.exame.externo;

import jalis.comum.Conexao;
import jalis.laboratorio.cadastro.exame.ExameMaterial;
import jalis.laboratorio.cadastro.exame.externo.LaboratorioExternoException;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ExameLaboratorioExternoDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExameMaterial> buscarTodos(Integer filial, Integer labExterno) throws LaboratorioExternoException {
        ArrayList<ExameMaterial> exames = new ArrayList<ExameMaterial>();
        StringBuilder sql = new StringBuilder();
        sql.append("select lae.exa_codigo as exame, lae.mco_codigo as material, mat.mco_abreviatura as abreviatura, exa.exa_descricao as descricao, lae.ele_xmllabexterno as xml, lae.ele_diasprazo as prazo, lae.ele_valorexame as valor, lae.ele_bloqueado as bloqueado ");
        sql.append("from examematcoletalabexterno  lae ");
        sql.append("inner join exames exa on lae.exa_codigo = exa.exa_codigo and lae.fil_codigo = exa.fil_codigo ");
        sql.append("inner join materialcoleta mat on lae.fil_codigo = mat.fil_codigo and lae.mco_codigo = mat.mco_codigo ");
        sql.append("where lae.fil_codigo = ? ");
        sql.append("and lae.lae_codigo = ? ");
        PreparedStatement pr = Conexao.getPreparedStatement(sql.toString());
        try {
            pr.setInt(1, filial);
            pr.setInt(2, labExterno);
            try (ResultSet rs = null;){
                rs = pr.executeQuery();
                while (rs.next()) {
                    ExameMaterial exameMaterial = new ExameMaterial(filial, labExterno, rs.getString("exame"), rs.getInt("material"), rs.getString("abreviatura"), rs.getString("descricao"), this.getCodExameApoio(rs.getString("xml")), rs.getInt("prazo"), rs.getDouble("valor"), rs.getBoolean("bloqueado"));
                    exames.add(exameMaterial);
                }
            }
        }
        catch (SQLException e) {
            throw new LaboratorioExternoException(e);
        }
        return exames;
    }

    private String getCodExameApoio(String xml) {
        String codExameApoio = "";
        if (!Funcoes.textoVazio(xml)) {
            codExameApoio = StringUtil.getValor(xml, "codigo-exame");
            if (Funcoes.textoVazio(codExameApoio)) {
                codExameApoio = StringUtil.getValor(xml, "codigo");
            }
            if (Funcoes.textoVazio(codExameApoio)) {
                codExameApoio = StringUtil.getValor(xml, "cd_exame");
            }
            if (Funcoes.textoVazio(codExameApoio)) {
                codExameApoio = StringUtil.getValor(xml, "codigoExame");
            }
            if (Funcoes.textoVazio(codExameApoio)) {
                codExameApoio = StringUtil.getValor(xml, "mnemonico");
            }
        }
        return codExameApoio;
    }

    public void atualizar(ExameMaterial exame) throws LaboratorioExternoException {
        String sql = "update examematcoletalabexterno set ele_diasprazo = ? , ele_valorexame =  ?, ele_bloqueado = ? where fil_codigo = ? and exa_codigo = ? and mco_codigo = ? and lae_codigo = ? ";
        PreparedStatement pr = Conexao.getPreparedStatement(sql);
        try {
            pr.setInt(1, exame.getPrazo());
            pr.setDouble(2, exame.getValor());
            pr.setBoolean(3, exame.getBloqueado());
            pr.setInt(4, exame.getFilial());
            pr.setString(5, exame.getCodigo());
            pr.setInt(6, exame.getMaterial());
            pr.setInt(7, exame.getLabExterno());
            if (pr.execute()) {
                Conexao.arquivaSQL();
            }
        }
        catch (SQLException e) {
            throw new LaboratorioExternoException("N\u00e3o foi poss\u00edvel atualiar exame\nExame: " + exame.getCodigo(), e);
        }
    }
}

