/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.exame;

import jalis.laboratorio.cadastro.exame.preco.DecimalFormatter;

public class ExameMaterial {
    private Boolean bloqueado;
    private Double valor;
    private Integer prazo;
    private String exameApoio;
    private String exameDescricao;
    private Integer material;
    private String abreviaturaMaterial;
    private String codigo;
    private boolean selecionado = false;
    private DecimalFormatter decimal = new DecimalFormatter();
    private Integer filial;
    private Integer labExterno;

    public ExameMaterial(Integer filial, Integer labExterno, String codigo, Integer material, String abreviaturaMaterial, String exameDescricao, String exameApoio, Integer prazo, Double valor, Boolean bloqueado) {
        this.filial = filial;
        this.labExterno = labExterno;
        this.codigo = codigo;
        this.material = material;
        this.abreviaturaMaterial = abreviaturaMaterial;
        this.exameDescricao = exameDescricao;
        this.exameApoio = exameApoio;
        this.prazo = prazo;
        this.valor = valor;
        this.bloqueado = bloqueado;
    }

    public Object[] toObject() {
        return new Object[]{this, this.abreviaturaMaterial, this.exameDescricao, this.exameApoio, this.prazo, this.decimal.format(this.valor), this.bloqueado};
    }

    public String toString() {
        return this.codigo.toString();
    }

    public boolean equals(Object[] obj) {
        return obj[0].equals(this.codigo) && obj[1].equals(this.material);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExameMaterial other = (ExameMaterial)obj;
        if (this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo)) {
            return false;
        }
        return !(this.material == null ? other.material != null : !this.material.equals(other.material));
    }

    public Boolean isSelecionado() {
        return this.selecionado;
    }

    public void setSelecionado(boolean selecionado) {
        this.selecionado = selecionado;
    }

    public Boolean getBloqueado() {
        return this.bloqueado;
    }

    public Double getValor() {
        return this.valor;
    }

    public String getValorString() {
        return this.decimal.format(this.valor);
    }

    public Integer getPrazo() {
        return this.prazo;
    }

    public String getExameApoio() {
        return this.exameApoio;
    }

    public String getExameDescricao() {
        return this.exameDescricao;
    }

    public Integer getMaterial() {
        return this.material;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public DecimalFormatter getDecimal() {
        return this.decimal;
    }

    public Integer getFilial() {
        return this.filial;
    }

    public Integer getLabExterno() {
        return this.labExterno;
    }

    public String getAbreviaturaMaterial() {
        return this.abreviaturaMaterial;
    }

    public void setAbreviaturaMaterial(String abreviatura) {
        this.abreviaturaMaterial = abreviatura;
    }

    public void setFilial(Integer filial) {
        this.filial = filial;
    }

    public void setLabExterno(Integer labExterno) {
        this.labExterno = labExterno;
    }

    public void setBloqueado(Boolean bloqueado) {
        this.bloqueado = bloqueado;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setPrazo(Integer prazo) {
        this.prazo = prazo;
    }

    public void setExameApoio(String exameApoio) {
        this.exameApoio = exameApoio;
    }

    public void setExameDescricao(String exameDescricao) {
        this.exameDescricao = exameDescricao;
    }

    public void setMaterial(Integer material) {
        this.material = material;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setDecimal(DecimalFormatter decimal) {
        this.decimal = decimal;
    }
}

