/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.exame;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.exame.ExameMaterial;
import jalis.laboratorio.cadastro.exame.preco.DecimalFormatter;
import jalis.laboratorio.cadastro.util.callback.OKObserver;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AlteradorExame {
    private static final int ALTURA_CAMPO = 18;
    private static final int ESPESSURA_LABEL = 16;
    private static final int ESPESSURA_CAMPO = 21;
    private static final int ALTURA_LABEL = 0;
    private final JLabel labelCodigo = this.criarLabel("C\u00f3digo", 80);
    private final JLabel labelMaterial = this.criarLabel("Mat.", 50);
    private final JLabel labelExame = this.criarLabel("Exame", 50);
    private final JLabel labelPrazo = this.criarLabel("Prazo", 50);
    private final JLabel labelValor = this.criarLabel("Valor", 50);
    private final JTextField fieldCodigo = this.criarField(76, false);
    private final JTextField fieldMaterial = this.criarField(44, false);
    private final JTextField fieldExame = this.criarField(355, false);
    private final JTextField fieldPrazo = this.criarFieldNumber(60, false);
    private final JTextField fieldValor = this.criarFieldFlutuante(90, false);
    private final JButton buttonOk = this.criarButtonOk(40);
    private final JPanel panel = this.criar();
    private ExameMaterial exame;
    private final List<OKObserver> observers = new ArrayList<OKObserver>();

    private JPanel criar() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        panel.add((Component)this.labelCodigo, c);
        ++c.gridx;
        panel.add((Component)this.labelMaterial, c);
        ++c.gridx;
        panel.add((Component)this.labelExame, c);
        ++c.gridx;
        panel.add((Component)this.labelPrazo, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.labelValor, c);
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        panel.add((Component)this.fieldCodigo, c);
        c.weighty = 0.0;
        ++c.gridx;
        panel.add((Component)this.fieldMaterial, c);
        ++c.gridx;
        panel.add((Component)this.fieldExame, c);
        ++c.gridx;
        panel.add((Component)this.fieldPrazo, c);
        ++c.gridx;
        panel.add((Component)this.fieldValor, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.buttonOk, c);
        Funcoes.montaEnter((JComponent)panel);
        return panel;
    }

    private JTextField criarField(int largura, boolean editable) {
        JTextField field = new JTextField();
        field.setEditable(editable);
        Dimension size = new Dimension(largura, 21);
        field.setPreferredSize(size);
        field.setMinimumSize(size);
        return field;
    }

    private JTextField criarFieldFlutuante(int largura, boolean editable) {
        TTextField field = new TTextField(10, 2, 4);
        field.setEditable(editable);
        Dimension size = new Dimension(largura, 21);
        field.setPreferredSize(size);
        field.setMinimumSize(size);
        return field;
    }

    private JTextField criarFieldNumber(int largura, boolean editable) {
        TTextField field = new TTextField(3, 1, 2);
        field.setEditable(editable);
        Dimension size = new Dimension(largura, 21);
        field.setPreferredSize(size);
        field.setMinimumSize(size);
        return field;
    }

    private JButton criarButtonOk(int largura) {
        JButton botao = ComponenteFactory.novoJButton("OK", null);
        Dimension size = new Dimension(largura, 21);
        botao.setPreferredSize(size);
        botao.setMinimumSize(size);
        botao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AlteradorExame.this.acaoOk();
                }
            }
        });
        botao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlteradorExame.this.acaoOk();
            }
        });
        return botao;
    }

    private void acaoOk() {
        if (Funcoes.textoVazio(this.fieldCodigo)) {
            return;
        }
        if (Funcoes.textoVazio(this.fieldPrazo.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Prazo invalido", 2);
            return;
        }
        if (Funcoes.textoVazio(this.fieldValor.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Valor invalido", 2);
            return;
        }
        Integer prazo = Integer.valueOf(this.fieldPrazo.getText());
        this.exame.setPrazo(prazo);
        Double valor = Double.valueOf(this.fieldValor.getText());
        this.exame.setValor(valor);
        this.runObservers();
        this.setEnable(false);
        this.limpaCampos();
    }

    protected void limpaCampos() {
        this.fieldCodigo.setText("");
        this.fieldExame.setText("");
        this.fieldMaterial.setText("");
        this.fieldPrazo.setText("");
        this.fieldValor.setText("");
    }

    private JLabel criarLabel(String nome, int largura) {
        JLabel label = new JLabel(nome);
        label.setPreferredSize(new Dimension(largura, 16));
        return label;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void addOkFunction(OKObserver l) {
        this.observers.add(l);
    }

    private void runObservers() {
        for (OKObserver o : this.observers) {
            o.run();
        }
    }

    public void atualizar(ExameMaterial exame) {
        this.exame = exame;
        this.fieldCodigo.setText(exame.getCodigo());
        this.fieldMaterial.setText(exame.getAbreviaturaMaterial());
        this.fieldExame.setText(exame.getExameDescricao());
        this.fieldPrazo.setText(String.valueOf(exame.getPrazo()));
        DecimalFormatter decimal = new DecimalFormatter("#0.0000");
        this.fieldValor.setText(decimal.format(exame.getValor()).replace('.', ','));
        this.setEnable(true);
        this.fieldPrazo.grabFocus();
    }

    private void setEnable(Boolean enable) {
        this.fieldPrazo.setEnabled(enable);
        this.fieldValor.setEnabled(enable);
        this.fieldPrazo.setEditable(enable);
        this.fieldValor.setEditable(enable);
    }

    public ExameMaterial getExame() {
        return this.exame;
    }
}

