/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador.whatsapp;

import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ComponenteUtils;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextFieldTelefone;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class TelefonesResumo
extends AbstractDialogoOKCancelar {
    private TTextFieldTelefone textFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    private JButton buttonOKFone = ComponenteFactory.novoJButton("OK", 'O', this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Celular"});
    private JTable tabela = new JTable(this.modelo);

    public static TelefonesResumo novaInstancia(Window owner) {
        if (owner instanceof Frame) {
            return new TelefonesResumo((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new TelefonesResumo((Dialog)owner);
        }
        return null;
    }

    public TelefonesResumo(Frame owner) {
        super(owner, "Telefones");
        this.montaTela();
    }

    public TelefonesResumo(Dialog owner) {
        super(owner, "Telefones");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(250, 300));
        this.setLocationRelativeTo(this.getParent());
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        JLabel labelCelular = new JLabel("Celular:");
        labelCelular.setDisplayedMnemonic('e');
        labelCelular.setLabelFor(this.textFone);
        p.add((Component)labelCelular, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textFone.setPreferredSize(new Dimension(70, 20));
        this.textFone.setMinimumSize(new Dimension(70, 20));
        p.add((Component)this.textFone, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonOKFone.setPreferredSize(new Dimension(40, 20));
        this.buttonOKFone.setMinimumSize(new Dimension(40, 20));
        this.buttonOKFone.setMaximumSize(new Dimension(40, 20));
        p.add((Component)this.buttonOKFone, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        p.add((Component)new JScrollPane(this.tabela), c);
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && TelefonesResumo.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(TelefonesResumo.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    TelefonesResumo.this.modelo.removeLine(TelefonesResumo.this.tabela.getSelectedRow());
                }
            }
        });
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.textFone);
        ScreenUtil.requisitarFoco(this.textFone);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKFone) {
            if (!Funcoes.textoVazio(StringUtil.limpaString(this.textFone.getText(), new String[]{"(", ")", "-"})) && this.modelo.localizar(0, this.textFone.getText()) < 0) {
                this.modelo.addLine(new String[]{this.textFone.getText()});
            }
            this.textFone.clear();
            ScreenUtil.requisitarFoco(this.textFone);
        } else {
            super.actionPerformed(e);
        }
    }

    public void setTelefones(String valores) {
        this.modelo.clear();
        if (!Funcoes.textoVazio(valores)) {
            String[] v;
            for (String s : v = valores.split(";")) {
                this.modelo.addLine(new String[]{s});
            }
        }
    }

    public String getTelefones() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(this.modelo.getValueAt(i, 0));
        }
        return buf.toString();
    }

    @Override
    public boolean acaoOk() {
        return true;
    }
}

