/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador.whatsapp;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.configurador.DiaTituloFraseDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.ConfiguradorModeloWhatsApp;
import jalis.laboratorio.cadastro.configurador.whatsapp.MensagemWhatsAppDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.TemplateDTO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class DialogoFraseDiasAgendamentoWhatsApp
extends AbstractDialogoOKCancelar {
    private TTextField textDias = new TTextField(3, 1);
    private TTextField textModelo = new TTextField(3000);
    private JButton buttonModelo = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("OK", this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Dias"});
    private JTable table = new JTable(this.modelo);
    private static final String MENSAGEM_CONFIGURADA = "Mensagem configurada!";
    private static final int COLUNA_DIA = 0;
    private static final int COLUNA_MODELO = 1;
    private transient MensagemWhatsAppDTO mensagemDTO;
    private String jsonTemplate;
    private int linhaAlterando = -1;

    public DialogoFraseDiasAgendamentoWhatsApp(Dialog pai, String titulo, MensagemWhatsAppDTO mensagemDTO) {
        super(pai, titulo);
        this.setMensagemDTO(mensagemDTO);
        this.montaTela(pai);
    }

    public DialogoFraseDiasAgendamentoWhatsApp(Frame pai, String titulo, MensagemWhatsAppDTO mensagemDTO) {
        super(pai, titulo);
        this.setMensagemDTO(mensagemDTO);
        this.montaTela(pai);
    }

    public static DialogoFraseDiasAgendamentoWhatsApp novaInstancia(Object pai, MensagemWhatsAppDTO mensagemDTO) {
        if (pai instanceof Frame) {
            return new DialogoFraseDiasAgendamentoWhatsApp((Frame)pai, "Configurar modelo", mensagemDTO);
        }
        return new DialogoFraseDiasAgendamentoWhatsApp((Dialog)pai, "Configurar modelo", mensagemDTO);
    }

    public void setMensagemDTO(MensagemWhatsAppDTO mensagemDTO) {
        this.mensagemDTO = mensagemDTO;
    }

    private void montaTela(Component pai) {
        this.setSize(300, 300);
        this.setLocationRelativeTo(pai);
        this.setResizable(false);
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets.right = 5;
        this.getPanelCentral().add((Component)new JLabel(" Modelo:"), c);
        c.insets.right = 0;
        ++c.gridx;
        c.weightx = 0.0;
        this.textModelo.setEditable(false);
        this.textModelo.setPreferredSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textModelo, c);
        c.insets.top = 1;
        c.gridx = 0;
        c.gridy = 1;
        this.getPanelCentral().add((Component)new JLabel(" Dias:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textDias.setPreferredSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textDias, c);
        c.insets.top = 0;
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 0.0;
        c.insets.left = 1;
        this.buttonModelo.setPreferredSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonModelo, c);
        ++c.gridy;
        this.buttonAdicionar.setPreferredSize(new Dimension(40, 20));
        this.getPanelCentral().add((Component)this.buttonAdicionar, c);
        c.gridwidth = 4;
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets.top = 2;
        this.getPanelCentral().add((Component)new JScrollPane(this.table), c);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    DialogoFraseDiasAgendamentoWhatsApp.this.removerLinha(DialogoFraseDiasAgendamentoWhatsApp.this.table.getSelectedRow());
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textDias);
    }

    public String getJsonTemplate() {
        return this.jsonTemplate;
    }

    @Override
    protected boolean acaoOk() {
        if (this.table.getRowCount() == 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Dias n\u00e3o configurados.", 2);
            return false;
        }
        this.modeloFraseDiferente(this.jsonTemplate);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAdicionar) {
            this.adicionarDia();
        } else if (e.getSource() == this.buttonModelo) {
            this.configurarModelo();
        } else {
            super.actionPerformed(e);
        }
    }

    private void configurarModelo() {
        ConfiguradorModeloWhatsApp configurador = ConfiguradorModeloWhatsApp.novaInstancia(this, this.mensagemDTO, this.jsonTemplate);
        if (null != configurador) {
            configurador.setVisible(true);
            if (configurador.getOK()) {
                TemplateDTO template = configurador.getTemplate();
                this.setMensagemAvisoDias(template != null ? template.toString() : null);
            }
        }
    }

    private void adicionarDia() {
        String dia = this.textDias.getText();
        if (Funcoes.textoVazio(dia)) {
            Funcoes.mensagem(this, "Dia n\u00e3o configurado", 1);
            ScreenUtil.requisitarFoco(this.textDias);
            return;
        }
        if (!Funcoes.isNumeric(dia)) {
            Funcoes.mensagem(this, "Dia incorreto", 1);
            ScreenUtil.requisitarFoco(this.textDias);
            return;
        }
        if (Funcoes.textoVazio(this.textModelo)) {
            Funcoes.mensagem(this, "Modelo n\u00e3o configurado", 1);
            ScreenUtil.requisitarFoco(this.textModelo);
            return;
        }
        boolean adicionado = this.diaJaAdicionado(dia);
        if (adicionado && this.linhaAlterando == -1) {
            Funcoes.mensagem(this, "Dia j\u00e1 adicionado", 2);
            ScreenUtil.requisitarFoco(this.textDias);
            return;
        }
        if (this.linhaAlterando > -1 && adicionado) {
            this.modelo.setValueAt(this.jsonTemplate, this.linhaAlterando, 1);
            this.modeloFraseDiferente(this.jsonTemplate);
        } else {
            this.modelo.addLine(new String[]{StringUtil.removeZerosEsquerda(this.textDias.getText()), this.jsonTemplate});
            this.modeloFraseDiferente(this.jsonTemplate);
        }
        this.modelo.ordenarColuna(0, 1);
        this.limparCampos();
    }

    private void limparCampos() {
        this.textDias.clear();
        this.textDias.setEnabled(true);
        this.linhaAlterando = -1;
        this.table.clearSelection();
        ScreenUtil.requisitarFoco(this.textDias);
    }

    private boolean diaJaAdicionado(String dia) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String d = this.modelo.getValueAt(i, 0).toString();
            if (Integer.parseInt(dia) != Integer.parseInt(d)) continue;
            return true;
        }
        return false;
    }

    private void modeloFraseDiferente(String fraseModelo) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String frase = this.modelo.getValueAt(i, 1).toString();
            this.modelo.setValueAt(fraseModelo, i, 1);
        }
    }

    private void editarItem(int linha) {
        if (linha > -1) {
            this.linhaAlterando = linha;
            this.textDias.setText(this.modelo.getValueAt(linha, 0).toString());
            this.jsonTemplate = this.modelo.getValueAt(linha, 1).toString();
            String mensagem = Funcoes.textoVazio(this.jsonTemplate) ? "" : MENSAGEM_CONFIGURADA;
            this.textModelo.setText(mensagem);
            this.textDias.setEnabled(false);
        }
    }

    private void removerLinha(int linha) {
        if (linha > -1 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.modelo.removeLine(linha);
        }
    }

    public List<DiaTituloFraseDTO> getDias() {
        ArrayList<DiaTituloFraseDTO> retorno = new ArrayList<DiaTituloFraseDTO>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            DiaTituloFraseDTO dto = new DiaTituloFraseDTO();
            dto.setDia(Integer.parseInt(this.modelo.getValueAt(i, 0).toString()));
            dto.setFrase(this.modelo.getValueAt(i, 1).toString());
            retorno.add(dto);
        }
        return retorno;
    }

    public void setDias(List<DiaTituloFraseDTO> dias) {
        this.modelo.clear();
        for (DiaTituloFraseDTO dto : dias) {
            this.modelo.addLine(new String[]{String.valueOf(dto.getDia()), dto.getFrase()});
        }
    }

    public void setMensagemAvisoDias(String fraseAviso) {
        if (!Funcoes.textoVazio(fraseAviso)) {
            this.textModelo.setText(MENSAGEM_CONFIGURADA);
        }
        this.jsonTemplate = fraseAviso;
    }
}

