/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador.whatsapp;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.configurador.DiaTituloFraseDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.CampoTituloFraseDias;
import jalis.laboratorio.cadastro.configurador.whatsapp.ConfiguradorModeloWhatsApp;
import jalis.laboratorio.cadastro.configurador.whatsapp.DialogoFraseDiasAgendamentoWhatsApp;
import jalis.laboratorio.cadastro.configurador.whatsapp.MensagemWhatsAppDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.RetornoTemplate;
import jalis.laboratorio.cadastro.configurador.whatsapp.TelefonesResumo;
import jalis.laboratorio.util.WebUtils;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfiguradorWhatsapp
extends JDialog
implements ActionListener {
    private static final String HH_MM = "HH:mm";
    private static final String BUTTONS = "buttons";
    private static final String MENSAGEM_CONFIGURADA_COM_SUCESSO = "Mensagem configurada com sucesso!";
    private static final String MENSAGEM_SELECIONE_OS_CAMPOS = "Selecione os campos que ser\u00e3o apresentados na mensagem";
    private JPanel panelCentral = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JCheckBox checkAniversario = ComponenteFactory.novoJCheckBox("Enviar mensagem de anivers\u00e1rio", this);
    private TTextField txtFraseAniversario = new TTextField(3000);
    private JButton buttonCamposAniversario = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkResultados = ComponenteFactory.novoJCheckBox("Enviar mensagem de aviso resultados prontos", this);
    private JCheckBox checkAgruparMultiguia = ComponenteFactory.novoJCheckBox("Agrupar requisi\u00e7\u00f5es multiguias", 'A', this);
    private TTextField txtFraseResultado = new TTextField(3000);
    private JButton buttonCamposResultado = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkSenhaWeb = ComponenteFactory.novoJCheckBox("Enviar mensagem com a senha web", this);
    private TTextField txtFraseSenhaWeb = new TTextField(3000);
    private JButton buttonCamposSenhaWeb = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkRecoleta = ComponenteFactory.novoJCheckBox("Enviar mensagem com aviso de recoleta de material", this);
    private TTextField txtFraseRecoleta = new TTextField(3000);
    private JButton buttonCamposRecoleta = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkResumoFinanceiro = ComponenteFactory.novoJCheckBox("Enviar mensagem de resumo financeiro", this);
    private TTextField textFonesResumoFinanceiro = new TTextField(3000);
    private JButton buttonFonesResumoFinanceiro = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configure os telefones que podem receber mensagens de resumo financeiro");
    private JCheckBox checkRequisicao = ComponenteFactory.novoJCheckBox("Enviar mensagem de requisi\u00e7\u00e3o", this);
    private TTextField textFraseRequisicao = new TTextField(3000);
    private JButton buttonCamposRequisicao = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkAgendamento = ComponenteFactory.novoJCheckBox("Enviar mensagem do agendamento", this);
    private TTextField textFraseAgendamento = new TTextField(3000);
    private JButton buttonCamposAgendamento = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkAvisoAgendamento = ComponenteFactory.novoJCheckBox("Enviar mensagem de aviso de agendamento", this);
    private CampoTituloFraseDias textFraseAvisoAgendamento = new CampoTituloFraseDias();
    private JButton buttonAvisoAgendamento = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar dias para mensagens");
    private TTextField textHoraEnviarWhatsAppResumo = new TTextField(5, 6);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private TTextField textHoraEnvioWhatsAppAniversario = new TTextField(5, 6);
    private TTextField textHoraEnvioWhatsAppAgendamento = new TTextField(5, 6);
    private JLabel labelHoraAniversario = new JLabel("Hor\u00e1rio para enviar mensagem de anivers\u00e1rio:");
    private JLabel labelHoraAgendamento = new JLabel("Hor\u00e1rio para enviar mensagem de agendamento:");
    private boolean ok = false;
    private String filial = "";
    private transient List<DiaTituloFraseDTO> frasesWhatsappDiasAgendamento = null;
    private JPopupMenu menuCampos = new JPopupMenu();
    private String templateAniversario;
    private String templateResultadoPronto;
    private String templateSenha;
    private String templateAvisoRecoleta;
    private String templateRequisicao;
    private String templateAgendamento;
    private static final String URL = "https://api.lode.com.br/v1/whatsapp/consultaTemplate";
    protected static final String[] CAMPOS_DISPONIVEIS = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "nomeSocialPaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "dataEntregaPrevistaRequisicao", "horaEntregaPrevistaRequisicao", "codigoPacienteWeb", "dataAgenda", "horaAgenda", "descricaoFilial", "enderecoFilial", "telefoneFilial", "chaveAcessoRequisicao"};

    public ConfiguradorWhatsapp(Frame owner) {
        super(owner, "Dados WhatsApp");
        this.montaTela();
    }

    private void montaTela() {
        ScreenUtil.centralizar(this);
        this.setLayout(new BorderLayout());
        this.setSize(710, 500);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentral.add(this.txtFraseAniversario);
        this.txtFraseAniversario.setEditable(false);
        this.panelCentral.add(this.txtFraseResultado);
        this.txtFraseResultado.setEditable(false);
        this.panelCentral.add(this.txtFraseSenhaWeb);
        this.txtFraseSenhaWeb.setEditable(false);
        this.panelCentral.add(this.txtFraseRecoleta);
        this.txtFraseRecoleta.setEditable(false);
        this.panelCentral.add(this.textFraseRequisicao);
        this.textFraseRequisicao.setEditable(false);
        this.panelCentral.add(this.textFraseAgendamento);
        this.textFraseAgendamento.setEditable(false);
        this.panelCentral.add(this.textFraseAvisoAgendamento);
        this.textFraseAvisoAgendamento.setEditable(false);
        this.panelCentral.add(this.checkAniversario);
        this.panelCentral.add(this.checkResultados);
        this.panelCentral.add(this.checkAgruparMultiguia);
        this.panelCentral.add(this.checkSenhaWeb);
        this.panelCentral.add(this.checkRecoleta);
        this.panelCentral.add(this.checkRequisicao);
        this.panelCentral.add(this.checkAgendamento);
        this.panelCentral.add(this.checkAvisoAgendamento);
        this.panelCentral.add(this.buttonCamposAniversario);
        this.panelCentral.add(this.buttonCamposResultado);
        this.panelCentral.add(this.buttonCamposSenhaWeb);
        this.panelCentral.add(this.buttonCamposRecoleta);
        this.panelCentral.add(this.buttonCamposRequisicao);
        this.panelCentral.add(this.buttonCamposAgendamento);
        this.panelCentral.add(this.buttonAvisoAgendamento);
        this.panelCentral.add(this.textHoraEnvioWhatsAppAgendamento);
        this.panelCentral.add(this.checkResumoFinanceiro);
        this.panelCentral.add(this.textFonesResumoFinanceiro);
        this.panelCentral.add(this.buttonFonesResumoFinanceiro);
        this.panelCentral.add(this.textHoraEnviarWhatsAppResumo);
        this.panelCentral.add(this.textHoraInicial);
        this.panelCentral.add(this.textHoraFinal);
        this.panelCentral.add(this.textHoraEnvioWhatsAppAniversario);
        this.checkAniversario.setBounds(new Rectangle(5, 12, 300, 15));
        this.txtFraseAniversario.setBounds(new Rectangle(8, 30, 652, 20));
        this.buttonCamposAniversario.setBounds(new Rectangle(660, 30, 20, 20));
        this.buttonCamposAniversario.setFocusable(false);
        this.checkResultados.setBounds(new Rectangle(5, 52, 300, 15));
        this.checkAgruparMultiguia.setBounds(new Rectangle(305, 52, 300, 15));
        this.txtFraseResultado.setBounds(new Rectangle(8, 70, 652, 20));
        this.buttonCamposResultado.setBounds(new Rectangle(660, 70, 20, 20));
        this.buttonCamposResultado.setFocusable(false);
        this.checkSenhaWeb.setBounds(new Rectangle(5, 92, 300, 15));
        this.txtFraseSenhaWeb.setBounds(new Rectangle(8, 110, 652, 20));
        this.buttonCamposSenhaWeb.setBounds(new Rectangle(660, 110, 20, 20));
        this.buttonCamposSenhaWeb.setFocusable(false);
        this.checkRecoleta.setBounds(new Rectangle(5, 132, 360, 15));
        this.txtFraseRecoleta.setBounds(new Rectangle(8, 150, 652, 20));
        this.buttonCamposRecoleta.setBounds(new Rectangle(660, 150, 20, 20));
        this.buttonCamposRecoleta.setFocusable(false);
        this.checkResumoFinanceiro.setBounds(new Rectangle(5, 172, 360, 15));
        this.textFonesResumoFinanceiro.setBounds(new Rectangle(8, 190, 652, 20));
        this.buttonFonesResumoFinanceiro.setBounds(new Rectangle(660, 190, 20, 20));
        this.buttonFonesResumoFinanceiro.setFocusable(false);
        this.checkRequisicao.setBounds(new Rectangle(5, 212, 360, 15));
        this.textFraseRequisicao.setBounds(new Rectangle(8, 230, 652, 20));
        this.buttonCamposRequisicao.setBounds(new Rectangle(660, 230, 20, 20));
        this.buttonCamposRequisicao.setFocusable(false);
        this.checkAgendamento.setBounds(new Rectangle(5, 252, 360, 15));
        this.textFraseAgendamento.setBounds(new Rectangle(8, 268, 652, 20));
        this.buttonCamposAgendamento.setBounds(new Rectangle(660, 268, 20, 20));
        this.buttonCamposAgendamento.setFocusable(false);
        this.checkAvisoAgendamento.setBounds(new Rectangle(5, 292, 360, 15));
        this.textFraseAvisoAgendamento.setBounds(new Rectangle(8, 308, 652, 20));
        this.textFraseAvisoAgendamento.setEditable(false);
        this.buttonAvisoAgendamento.setBounds(new Rectangle(660, 308, 20, 20));
        this.buttonAvisoAgendamento.setFocusable(false);
        this.labelHoraAgendamento.setBounds(new Rectangle(5, 330, 300, 20));
        this.panelCentral.add(this.labelHoraAgendamento);
        this.textHoraEnvioWhatsAppAgendamento.setBounds(300, 330, 70, 20);
        this.textHoraEnvioWhatsAppAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
        this.textFonesResumoFinanceiro.setEditable(false);
        JLabel lab1 = new JLabel("Hor\u00e1rio para gerar o resumo financeiro:");
        lab1.setBounds(new Rectangle(5, 352, 260, 20));
        this.panelCentral.add(lab1);
        this.textHoraEnviarWhatsAppResumo.setBounds(300, 352, 70, 20);
        this.textHoraEnviarWhatsAppResumo.setEnabled(this.checkResumoFinanceiro.isSelected());
        this.labelHoraAniversario.setBounds(new Rectangle(5, 374, 300, 20));
        this.textHoraEnvioWhatsAppAniversario.setEnabled(this.checkAniversario.isSelected());
        this.panelCentral.add(this.labelHoraAniversario);
        this.textHoraEnvioWhatsAppAniversario.setBounds(300, 374, 70, 20);
        JLabel lab = new JLabel("Hora inicial:");
        lab.setBounds(new Rectangle(5, 396, 90, 20));
        this.panelCentral.add(lab);
        this.textHoraInicial.setBounds(82, 396, 70, 20);
        JLabel lab2 = new JLabel("Hora final:");
        lab2.setBounds(new Rectangle(235, 396, 80, 20));
        this.panelCentral.add(lab2);
        this.textHoraFinal.setBounds(300, 396, 70, 20);
        for (String c : CAMPOS_DISPONIVEIS) {
            JMenuItem item = new JMenuItem(c);
            this.menuCampos.add(item);
            item.addActionListener(this);
        }
    }

    private void configurarModelo(TipoTemplate tipoModelo, String template) {
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Aguarde... Carregando template.");
        MensagemWhatsAppDTO dto = this.carregarModeloTexto(tipoModelo);
        splash.apagar();
        if (!Funcoes.textoVazio(dto.getRetornoJsonErro())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), dto.getRetornoJsonErro(), 2);
        } else {
            ConfiguradorModeloWhatsApp diag = ConfiguradorModeloWhatsApp.novaInstancia(this, dto, template);
            if (null != diag) {
                diag.setVisible(true);
                if (diag.getOK() && !diag.getCancelado()) {
                    String templateDiag = diag.getTemplate() != null ? diag.getTemplate().toString() : null;
                    this.setTemplateMensagem(templateDiag, tipoModelo);
                }
            }
        }
    }

    private void setTemplateMensagem(String template, TipoTemplate tipoModelo) {
        String templateJson = template;
        switch (tipoModelo) {
            case ANIVERSARIO: {
                this.setFraseAniversario(templateJson);
                break;
            }
            case RESULTADO_PRONTO: {
                this.setFraseResultados(templateJson);
                break;
            }
            case SENHA: {
                this.setFraseSenhaWeb(templateJson);
                break;
            }
            case AVISO_RECOLETA: {
                this.setFraseRecoleta(templateJson);
                break;
            }
            case REQUISICAO: {
                this.setFraseRequisicao(templateJson);
                break;
            }
            case NOVO_AGENDAMENTO: {
                this.setFraseAgendamento(templateJson);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCamposAniversario) {
            this.configurarModelo(TipoTemplate.ANIVERSARIO, this.templateAniversario);
        } else if (e.getSource() == this.buttonCamposResultado) {
            this.configurarModelo(TipoTemplate.RESULTADO_PRONTO, this.templateResultadoPronto);
        } else if (e.getSource() == this.buttonCamposSenhaWeb) {
            this.configurarModelo(TipoTemplate.SENHA, this.templateSenha);
        } else if (e.getSource() == this.buttonCamposRecoleta) {
            this.configurarModelo(TipoTemplate.AVISO_RECOLETA, this.templateAvisoRecoleta);
        } else if (e.getSource() == this.buttonCamposRequisicao) {
            this.configurarModelo(TipoTemplate.REQUISICAO, this.templateRequisicao);
        } else if (e.getSource() == this.checkAniversario) {
            this.txtFraseAniversario.setEnabled(this.checkAniversario.isSelected());
            this.buttonCamposAniversario.setEnabled(this.checkAniversario.isSelected());
            this.textHoraEnvioWhatsAppAniversario.setEnabled(this.checkAniversario.isSelected());
        } else if (e.getSource() == this.checkResultados) {
            this.checkAgruparMultiguia.setEnabled(this.checkResultados.isSelected());
            this.txtFraseResultado.setEnabled(this.checkResultados.isSelected());
            this.buttonCamposResultado.setEnabled(this.checkResultados.isSelected());
        } else if (e.getSource() == this.checkSenhaWeb) {
            this.txtFraseSenhaWeb.setEnabled(this.checkSenhaWeb.isSelected());
            this.buttonCamposSenhaWeb.setEnabled(this.checkSenhaWeb.isSelected());
        } else if (e.getSource() == this.checkRecoleta) {
            this.txtFraseRecoleta.setEnabled(this.checkRecoleta.isSelected());
            this.buttonCamposRecoleta.setEnabled(this.checkRecoleta.isSelected());
        } else if (e.getSource() == this.checkRequisicao) {
            this.textFraseRequisicao.setEnabled(this.checkRequisicao.isSelected());
            this.buttonCamposRequisicao.setEnabled(this.checkRequisicao.isSelected());
        } else if (e.getSource() == this.checkResumoFinanceiro) {
            this.textFonesResumoFinanceiro.setEnabled(this.checkResumoFinanceiro.isSelected());
            this.buttonFonesResumoFinanceiro.setEnabled(this.checkResumoFinanceiro.isSelected());
            this.textHoraEnviarWhatsAppResumo.setEnabled(this.checkResumoFinanceiro.isSelected());
        } else if (e.getSource() == this.checkAgendamento) {
            this.textFraseAgendamento.setEnabled(this.checkAgendamento.isSelected());
            this.buttonCamposAgendamento.setEnabled(this.checkAgendamento.isSelected());
        } else if (e.getSource() == this.checkAvisoAgendamento) {
            this.textFraseAvisoAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
            this.buttonAvisoAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
            this.textHoraEnvioWhatsAppAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
        } else if (e.getSource() == this.buttonFonesResumoFinanceiro) {
            this.configurarResumo();
        } else if (e.getSource() == this.buttonAvisoAgendamento) {
            this.configuraAvisosWhatsApp(TipoTemplate.AVISO_AGENDAMENTO);
        } else if (e.getSource() == this.buttonCamposAgendamento) {
            this.configurarModelo(TipoTemplate.NOVO_AGENDAMENTO, this.templateAgendamento);
        } else if (e.getSource() == this.buttonSalvar) {
            this.ok = this.validaCampos();
            this.setVisible(!this.ok);
        }
    }

    private void configurarResumo() {
        TelefonesResumo fo = TelefonesResumo.novaInstancia(this);
        if (fo != null) {
            fo.setTelefones(this.textFonesResumoFinanceiro.getText());
            fo.setVisible(true);
            if (fo.getOK()) {
                this.textFonesResumoFinanceiro.setText(fo.getTelefones());
            }
        }
    }

    private boolean validaCampos() {
        if (this.checkAniversario.isSelected() && Funcoes.textoVazio(this.txtFraseAniversario.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem de anivers\u00e1rio n\u00e3o configurada.", 2);
            this.txtFraseAniversario.selectAll();
            this.txtFraseAniversario.grabFocus();
            return false;
        }
        if (this.checkResultados.isSelected() && Funcoes.textoVazio(this.txtFraseResultado.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem de resultados n\u00e3o configurada.", 2);
            this.txtFraseResultado.selectAll();
            this.txtFraseResultado.grabFocus();
            return false;
        }
        if (this.checkSenhaWeb.isSelected() && Funcoes.textoVazio(this.txtFraseSenhaWeb.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem de senha web n\u00e3o configurada.", 2);
            this.txtFraseSenhaWeb.selectAll();
            this.txtFraseSenhaWeb.grabFocus();
            return false;
        }
        if (this.checkRecoleta.isSelected() && Funcoes.textoVazio(this.txtFraseRecoleta.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem de recoleta n\u00e3o configurada.", 2);
            this.txtFraseRecoleta.selectAll();
            this.txtFraseRecoleta.grabFocus();
            return false;
        }
        if (this.checkRequisicao.isSelected() && Funcoes.textoVazio(this.textFraseRequisicao.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem de requisi\u00e7\u00e3o n\u00e3o configurada.", 2);
            this.textFraseRequisicao.selectAll();
            this.textFraseRequisicao.grabFocus();
            return false;
        }
        if (this.checkAgendamento.isSelected() && Funcoes.textoVazio(this.textFraseAgendamento.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem do agendamento n\u00e3o configurada.", 2);
            this.textFraseAgendamento.selectAll();
            this.textFraseAgendamento.grabFocus();
            return false;
        }
        if (this.checkResumoFinanceiro.isSelected() && Funcoes.textoVazio(this.textFonesResumoFinanceiro.getText())) {
            Funcoes.mensagem(this, "Nenhum telefone para enviar a mensagem de resumo financeiro foi informado.", 2);
            return false;
        }
        if (this.checkResumoFinanceiro.isSelected() && !Funcoes.textoVazio(this.textHoraEnviarWhatsAppResumo.getText()) && !Funcoes.verificaHora(this.textHoraEnviarWhatsAppResumo.getText())) {
            Funcoes.mensagem(this, "Hora para enviar resumo financeiro incorreta.", 2);
            this.textHoraEnviarWhatsAppResumo.selectAll();
            this.textHoraEnviarWhatsAppResumo.grabFocus();
            return false;
        }
        if (this.checkResumoFinanceiro.isSelected() && Funcoes.verificaHora(this.textHoraEnviarWhatsAppResumo.getText()) && Funcoes.verificaHora(this.textHoraInicial.getText()) && Funcoes.verificaHora(this.textHoraFinal.getText()) && (Funcoes.comparaHora(this.textHoraEnviarWhatsAppResumo.getText(), this.textHoraInicial.getText()) < 0 || Funcoes.comparaHora(this.textHoraEnviarWhatsAppResumo.getText(), this.textHoraFinal.getText()) > 0)) {
            Funcoes.mensagem(this, "A hora informada para gerar o resumo financeiro esta fora do intervalo de hor\u00e1rio para enviar mensagem.", 2);
            this.textHoraEnviarWhatsAppResumo.selectAll();
            this.textHoraEnviarWhatsAppResumo.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraInicial.getText()) && !Funcoes.verificaHora(this.textHoraInicial.getText())) {
            Funcoes.mensagem(this, "Hora inicial incorreta.", 2);
            this.textHoraInicial.selectAll();
            this.textHoraInicial.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraFinal.getText()) && !Funcoes.verificaHora(this.textHoraFinal.getText())) {
            Funcoes.mensagem(this, "Hora final incorreta.", 2);
            this.textHoraFinal.selectAll();
            this.textHoraFinal.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraEnvioWhatsAppAniversario.getText()) && !Funcoes.verificaHora(this.textHoraEnvioWhatsAppAniversario.getText())) {
            Funcoes.mensagem(this, "Hora para envio de mensagem de anivers\u00e1rio incorreta.", 2);
            this.textHoraEnvioWhatsAppAniversario.selectAll();
            this.textHoraEnvioWhatsAppAniversario.grabFocus();
            return false;
        }
        if (this.checkAvisoAgendamento.isSelected() && !Funcoes.textoVazio(this.textFraseAvisoAgendamento.getText()) && Funcoes.textoVazio(this.textHoraEnvioWhatsAppAgendamento.getText())) {
            Funcoes.mensagem(this, "Hora para envio mensagem de agendamento n\u00e3o configurada.", 2);
            return false;
        }
        if (this.checkAvisoAgendamento.isSelected() && Funcoes.textoVazio(this.textFraseAvisoAgendamento.getText())) {
            Funcoes.mensagem(this, "Frase para mensagem de aviso de agendamento n\u00e3o configurada.", 2);
            this.textFraseAvisoAgendamento.selectAll();
            this.textFraseAvisoAgendamento.grabFocus();
            return false;
        }
        return true;
    }

    private void configuraAvisosWhatsApp(TipoTemplate tipoModelo) {
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Aguarde... Carregando template.");
        MensagemWhatsAppDTO dto = this.carregarModeloTexto(tipoModelo);
        splash.apagar();
        if (!Funcoes.textoVazio(dto.getRetornoJsonErro())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), dto.getRetornoJsonErro(), 2);
        } else {
            DialogoFraseDiasAgendamentoWhatsApp diag = DialogoFraseDiasAgendamentoWhatsApp.novaInstancia(this, dto);
            if (null != diag) {
                List<DiaTituloFraseDTO> frasesAgendamento = this.getFrasesWhatsappDiasAgendamento();
                diag.setMensagemAvisoDias(!frasesAgendamento.isEmpty() ? frasesAgendamento.get(0).getFrase() : null);
                diag.setDias(frasesAgendamento);
                diag.setVisible(true);
                if (diag.getOK()) {
                    String jsonTemplate = diag.getJsonTemplate();
                    this.textFraseAvisoAgendamento.limparDias();
                    for (DiaTituloFraseDTO d : diag.getDias()) {
                        if (!Funcoes.textoVazio(jsonTemplate)) {
                            d.setFrase(jsonTemplate);
                        }
                        this.textFraseAvisoAgendamento.adicionarDias(d);
                    }
                    this.setFrasesWhatsappDiasAgendamento(diag.getDias());
                }
            }
        }
    }

    public MensagemWhatsAppDTO carregarModeloTexto(TipoTemplate tipoModelo) {
        MensagemWhatsAppDTO mensagemDTO = new MensagemWhatsAppDTO();
        try {
            JSONObject jsonRetorno;
            RetornoTemplate template = this.solicitarTemplate(tipoModelo);
            JSONObject jSONObject = jsonRetorno = template.jsonErroRetorno != null ? template.jsonErroRetorno : null;
            if (jsonRetorno != null && !Funcoes.textoVazio(jsonRetorno.getString("message"))) {
                mensagemDTO.setRetornoJsonErro(jsonRetorno.getString("message"));
            }
            mensagemDTO.setTitulo(this.buscaMensagem(template.jsonParsed, "HEADER"));
            mensagemDTO.setMensagem(this.buscaMensagem(template.jsonParsed, "BODY"));
            mensagemDTO.setRodape(this.buscaMensagem(template.jsonParsed, "FOOTER"));
            mensagemDTO.setLink(this.buscaMensagem(template.jsonParsed, "BUTTONS"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mensagemDTO;
    }

    private String buscaMensagem(JSONObject json, String parte) throws JSONException {
        if (null == json || json.getJSONArray("data").length() == 0) {
            return "";
        }
        JSONArray array = json.getJSONArray("data");
        JSONArray componentes = (JSONArray)array.getJSONObject(0).get("components");
        if (null != componentes) {
            for (int i = 0; i < componentes.length(); ++i) {
                JSONObject componente = componentes.getJSONObject(i);
                if (!this.validaComponente(parte, componente)) continue;
                if (this.isKeyButton(componente)) {
                    return componente.getJSONArray(BUTTONS).getJSONObject(0).getString("text");
                }
                return componente.getString("text");
            }
        }
        return "";
    }

    private boolean validaComponente(String parte, JSONObject componente) throws JSONException {
        return null != componente && componente.has("type") && componente.getString("type").equals(parte);
    }

    private boolean isKeyButton(JSONObject json) throws JSONException {
        return null != json && json.has(BUTTONS) && json.getJSONArray(BUTTONS).length() > 0 && json.getJSONArray(BUTTONS).getJSONObject(0).has("text");
    }

    private RetornoTemplate solicitarTemplate(TipoTemplate tipo) throws IOException, URISyntaxException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        HttpUriRequest request;
        RetornoTemplate retorno = new RetornoTemplate();
        String codigoCliente = String.valueOf(ParametrosGerais.getCodigoCliente());
        String codigoUnidade = Funcoes.preencheZero(this.filial, 3);
        URIBuilder uri = new URIBuilder(URL, StandardCharsets.UTF_8).addParameter("codigoCliente", codigoCliente).addParameter("codigoUnidade", codigoUnidade).addParameter("template", tipo.name().toLowerCase());
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(WebUtils.buildRequestConfig(60)).setSSLSocketFactory((LayeredConnectionSocketFactory)WebUtils.construirSSL()).build();
        CloseableHttpResponse response = client.execute(request = RequestBuilder.get((URI)uri.build()).addHeader("Authorization", "Bearer da39a3ee5e6b4b0d3255bfef95601890afd80709").build());
        if (null == response || response.getStatusLine().getStatusCode() == 404) {
            retorno.ok = false;
            retorno.mensagem = "N\u00e3o foi poss\u00edvel comunicar com o servidor de templates";
        } else if (response.getStatusLine().getStatusCode() != 200) {
            retorno.ok = false;
            retorno.mensagem = "Falha ao comunicar com o servidor de templates, status: " + response.getStatusLine().getStatusCode();
            try {
                retorno.jsonErroRetorno = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8"));
            }
            catch (IOException | ParseException | JSONException throwable) {}
        } else if (response.getEntity() == null || response.getEntity().getContentLength() == 0L) {
            retorno.ok = false;
            retorno.mensagem = "N\u00e3o foi poss\u00edvel interpretar a mensagem rececida";
        } else {
            retorno.json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            try {
                retorno.jsonParsed = new JSONObject(retorno.json);
            }
            catch (JSONException e) {
                retorno.ok = false;
                retorno.mensagem = "Falha ao processar o retorno da template";
            }
        }
        return retorno;
    }

    public List<DiaTituloFraseDTO> getFrasesWhatsappDiasAgendamento() {
        return this.frasesWhatsappDiasAgendamento;
    }

    public void setFrasesWhatsappDiasAgendamento(List<DiaTituloFraseDTO> frasesWhatsappDiasAgendamento) {
        this.frasesWhatsappDiasAgendamento = frasesWhatsappDiasAgendamento;
    }

    public boolean ok() {
        return this.ok;
    }

    public boolean isAniversario() {
        return this.checkAniversario.isSelected();
    }

    public void setAniversario(boolean aniversario) {
        this.checkAniversario.setSelected(aniversario);
        this.txtFraseAniversario.setEnabled(aniversario);
        this.buttonCamposAniversario.setEnabled(aniversario);
        this.textHoraEnvioWhatsAppAniversario.setEnabled(aniversario);
    }

    public String getFraseAniversario() {
        return this.templateAniversario;
    }

    public void setFraseAniversario(String fraseAniversario) {
        if (!Funcoes.textoVazio(fraseAniversario)) {
            this.txtFraseAniversario.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
        this.templateAniversario = fraseAniversario;
    }

    public boolean isResultado() {
        return this.checkResultados.isSelected();
    }

    public void setResultado(boolean resultado) {
        this.checkResultados.setSelected(resultado);
        this.checkAgruparMultiguia.setEnabled(resultado);
        this.txtFraseResultado.setEnabled(resultado);
        this.buttonCamposResultado.setEnabled(resultado);
    }

    public boolean isAgruparMultiguia() {
        return this.checkAgruparMultiguia.isSelected();
    }

    public void setAgruparMultiguia(boolean agrupar) {
        this.checkAgruparMultiguia.setSelected(agrupar);
    }

    public String getFraseResultado() {
        return this.templateResultadoPronto;
    }

    public void setFraseResultados(String fraseResultado) {
        if (!Funcoes.textoVazio(fraseResultado)) {
            this.txtFraseResultado.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
        this.templateResultadoPronto = fraseResultado;
    }

    public boolean isSenhaWeb() {
        return this.checkSenhaWeb.isSelected();
    }

    public void setSenhaWeb(boolean senhaWeb) {
        this.checkSenhaWeb.setSelected(senhaWeb);
        this.txtFraseSenhaWeb.setEnabled(senhaWeb);
        this.buttonCamposSenhaWeb.setEnabled(senhaWeb);
    }

    public String getFraseSenhaWeb() {
        return this.templateSenha;
    }

    public void setFraseSenhaWeb(String fraseSenhaWeb) {
        if (!Funcoes.textoVazio(fraseSenhaWeb)) {
            this.txtFraseSenhaWeb.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
        this.templateSenha = fraseSenhaWeb;
    }

    public boolean isRecoleta() {
        return this.checkRecoleta.isSelected();
    }

    public void setRecoleta(boolean recoleta) {
        this.checkRecoleta.setSelected(recoleta);
        this.txtFraseRecoleta.setEnabled(recoleta);
        this.buttonCamposRecoleta.setEnabled(recoleta);
    }

    public String getFraseRecoleta() {
        return this.templateAvisoRecoleta;
    }

    public void setFraseRecoleta(String fraseRecoleta) {
        if (!Funcoes.textoVazio(fraseRecoleta)) {
            this.txtFraseRecoleta.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
        this.templateAvisoRecoleta = fraseRecoleta;
    }

    public boolean isResumoFinanceiro() {
        return this.checkResumoFinanceiro.isSelected();
    }

    public void setResumoFinanceiro(boolean resumo) {
        this.checkResumoFinanceiro.setSelected(resumo);
        this.textFonesResumoFinanceiro.setEnabled(resumo);
        this.buttonFonesResumoFinanceiro.setEnabled(resumo);
        this.textHoraEnviarWhatsAppResumo.setEnabled(resumo);
    }

    public String getFonesResumoFinanceiro() {
        return this.textFonesResumoFinanceiro.getText();
    }

    public void setFonesResumoFinanceiro(String fones) {
        this.textFonesResumoFinanceiro.setText(fones);
    }

    public void setHoraAgendamento(Date hora) {
        if (hora != null) {
            this.textHoraEnvioWhatsAppAgendamento.setText(Funcoes.formataData(HH_MM, hora));
        } else {
            this.textHoraEnvioWhatsAppAgendamento.clear();
        }
    }

    public void setHoraInicial(Date hora) {
        if (hora != null) {
            this.textHoraInicial.setText(Funcoes.formataData(HH_MM, hora));
        } else {
            this.textHoraInicial.clear();
        }
    }

    public void setHoraFinal(Date hora) {
        if (hora != null) {
            this.textHoraFinal.setText(Funcoes.formataData(HH_MM, hora));
        } else {
            this.textHoraFinal.clear();
        }
    }

    public void setHoraWhatsAppEnvioAniversario(Date hora) {
        if (hora != null) {
            this.textHoraEnvioWhatsAppAniversario.setText(Funcoes.formataData(HH_MM, hora));
        } else {
            this.textHoraEnvioWhatsAppAniversario.clear();
        }
    }

    public Date getHoraInicial() {
        if (Funcoes.verificaHora(this.textHoraInicial.getText())) {
            return Funcoes.stringToTime(this.textHoraInicial.getText());
        }
        return null;
    }

    public Date getHoraFinal() {
        if (Funcoes.verificaHora(this.textHoraFinal.getText())) {
            return Funcoes.stringToTime(this.textHoraFinal.getText());
        }
        return null;
    }

    public Date getHoraAgendamento() {
        if (Funcoes.verificaHora(this.textHoraEnvioWhatsAppAgendamento.getText())) {
            return Funcoes.stringToTime(this.textHoraEnvioWhatsAppAgendamento.getText());
        }
        return null;
    }

    public Date getHoraWhatsAppEnvioAniversario() {
        if (Funcoes.verificaHora(this.textHoraEnvioWhatsAppAniversario.getText())) {
            return Funcoes.stringToTime(this.textHoraEnvioWhatsAppAniversario.getText());
        }
        return null;
    }

    public Date getHoraEnviarWhatsAppResumoFinanceiro() {
        if (Funcoes.verificaHora(this.textHoraEnviarWhatsAppResumo.getText())) {
            return Funcoes.stringToTime(this.textHoraEnviarWhatsAppResumo.getText());
        }
        return null;
    }

    public void setHoraEnviarWhatsAppResumoFinanceiro(Date hora) {
        if (hora != null) {
            this.textHoraEnviarWhatsAppResumo.setText(Funcoes.formataData(HH_MM, hora));
        } else {
            this.textHoraEnviarWhatsAppResumo.clear();
        }
    }

    public boolean isRequisicao() {
        return this.checkRequisicao.isSelected();
    }

    public boolean isAgendamento() {
        return this.checkAgendamento.isSelected();
    }

    public boolean isAvisoAgendamento() {
        return this.checkAvisoAgendamento.isSelected();
    }

    public void setRequisicao(boolean ativar) {
        this.checkRequisicao.setSelected(ativar);
        this.textFraseRequisicao.setEnabled(ativar);
        this.buttonCamposRequisicao.setEnabled(ativar);
    }

    public void setAgendamento(boolean ativar) {
        this.checkAgendamento.setSelected(ativar);
        this.textFraseAgendamento.setEnabled(ativar);
        this.buttonCamposAgendamento.setEnabled(ativar);
    }

    public void setAvisoAgendamento(boolean ativar) {
        this.checkAvisoAgendamento.setSelected(ativar);
        this.textFraseAvisoAgendamento.setEnabled(ativar);
        this.buttonAvisoAgendamento.setEnabled(ativar);
        this.textHoraEnvioWhatsAppAgendamento.setEnabled(ativar);
    }

    public void setTextAvisoWhatsAppAgendamento(List<Integer> diasConfigurados) {
        StringBuilder dias = new StringBuilder();
        if (!diasConfigurados.isEmpty()) {
            for (Integer d : diasConfigurados) {
                dias.append(String.valueOf(d) + "; ");
            }
            this.textFraseAvisoAgendamento.setText(dias.toString());
        } else {
            this.textFraseAvisoAgendamento.setText("");
        }
    }

    public String getFraseRequisicao() {
        return this.templateRequisicao;
    }

    public void setFraseRequisicao(String fraseRequisicao) {
        if (!Funcoes.textoVazio(fraseRequisicao)) {
            this.textFraseRequisicao.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
        this.templateRequisicao = fraseRequisicao;
    }

    public String getFraseAgendamento() {
        return this.templateAgendamento;
    }

    public void setFraseAgendamento(String fraseRequisicao) {
        if (!Funcoes.textoVazio(fraseRequisicao)) {
            this.textFraseAgendamento.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
        this.templateAgendamento = fraseRequisicao;
    }

    public String getFilial() {
        return this.filial;
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }

    static enum TipoTemplate {
        ANIVERSARIO,
        RESULTADO_PRONTO,
        SENHA,
        AVISO_RECOLETA,
        RESUMO_FINANCEIRO,
        REQUISICAO,
        NOVO_AGENDAMENTO,
        AVISO_AGENDAMENTO;

    }
}

