/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador.whatsapp;

import jalis.comum.ConstantesGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.configurador.whatsapp.ConfiguradorWhatsapp;
import jalis.laboratorio.cadastro.configurador.whatsapp.MensagemWhatsAppDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.BodyDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.ButtonsDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.CampoDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.FooterDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.HeaderDTO;
import jalis.laboratorio.cadastro.configurador.whatsapp.dto.TemplateDTO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

public class ConfiguradorModeloWhatsApp
extends AbstractDialogoOKCancelar {
    private static final String BODY = "BODY";
    private static final String BUTTONS = "BUTTONS";
    private static final String FOOTER = "FOOTER";
    private static final String HEADER = "HEADER";
    private JButton btnCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private TTextField textCabecalho = new TTextField(3000);
    private JTextPane textMensagem = new JTextPane();
    private JScrollPane scrollMensagem = new JScrollPane(this.textMensagem);
    private TTextField textRodape = new TTextField(3000);
    private TTextField textLink = new TTextField(3000);
    private JPanel panelCampos = new JPanel();
    JPanel panelEsquerda = new JPanel(null);
    JPanel panelDireita = new JPanel(null);
    private static final String MENSAGEM_SELECIONE_OS_CAMPOS = "Selecione os campos que ser\u00e3o apresentados na mensagem";
    private TTextField campoParaAdicionar = null;
    private JPopupMenu menuCampos = new JPopupMenu();
    private Map<String, String> camposConfiguracao = new HashMap<String, String>();
    public static final String REGEX_START = Pattern.quote("{{");
    public static final String REGEX_END = Pattern.quote("}}");
    public static final Pattern PATTERN = Pattern.compile(REGEX_START + "(.*?)" + REGEX_END);
    private boolean possuiLink = false;
    private Map<String, String> todosCamposConfiguracao = new HashMap<String, String>();
    private List<Component> listaTotalComponent = new ArrayList<Component>();
    private transient MensagemWhatsAppDTO mensagemDTO;
    private String jsonTemplate;
    private transient TemplateDTO template = new TemplateDTO();

    public ConfiguradorModeloWhatsApp(Dialog pai, String titulo, MensagemWhatsAppDTO mensagemDTO, String jsonTemplate) {
        super(pai, titulo);
        this.setMensagemDto(mensagemDTO);
        this.setJsonTemplate(jsonTemplate);
        this.montaTela(pai);
    }

    public ConfiguradorModeloWhatsApp(Frame pai, String titulo, MensagemWhatsAppDTO mensagemDTO, String jsonTemplate) {
        super(pai, titulo);
        this.setMensagemDto(mensagemDTO);
        this.setJsonTemplate(jsonTemplate);
        this.montaTela(pai);
    }

    public static ConfiguradorModeloWhatsApp novaInstancia(Object pai, MensagemWhatsAppDTO mensagemDTO, String jsonTemplate) {
        if (pai instanceof Frame) {
            return new ConfiguradorModeloWhatsApp((Frame)pai, "Configurar modelo", mensagemDTO, jsonTemplate);
        }
        return new ConfiguradorModeloWhatsApp((Dialog)pai, "Configurar modelo", mensagemDTO, jsonTemplate);
    }

    public MensagemWhatsAppDTO getMensagemDto() {
        return this.mensagemDTO;
    }

    public void setMensagemDto(MensagemWhatsAppDTO mensagemDto) {
        this.mensagemDTO = mensagemDto;
    }

    public TemplateDTO getTemplate() {
        return this.template;
    }

    public void setTemplate(TemplateDTO template) {
        this.template = template;
    }

    public String getJsonTemplate() {
        return this.jsonTemplate;
    }

    public void setJsonTemplate(String jsonTemplate) {
        this.jsonTemplate = jsonTemplate;
        this.setTemplate(TemplateDTO.parse(jsonTemplate));
    }

    private void montaTela(Component pai) {
        ScreenUtil.centralizar(this);
        this.setSize(910, 510);
        this.setLocationRelativeTo(pai);
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(ScreenUtil.criarBordaVazia());
        this.panelDireita = new JPanel(new GridBagLayout());
        this.panelDireita.setPreferredSize(new Dimension(600, 415));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 3.0;
        this.panelDireita.add((Component)new JLabel("Cabe\u00e7alho:"), c);
        ++c.gridy;
        this.textCabecalho.setEditable(false);
        this.textCabecalho.setPreferredSize(new Dimension(150, 20));
        this.panelDireita.add((Component)this.textCabecalho, c);
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.panelDireita.add((Component)new JLabel("Mensagem:"), c);
        ++c.gridy;
        this.textMensagem.setEditable(false);
        this.possuiLink = !Funcoes.textoVazio(this.mensagemDTO.getLink());
        this.textMensagem.setPreferredSize(new Dimension(150, this.possuiLink ? 275 : 300));
        this.scrollMensagem.setPreferredSize(new Dimension(150, this.possuiLink ? 275 : 300));
        this.panelDireita.add((Component)this.scrollMensagem, c);
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.insets.top = 1;
        this.panelDireita.add((Component)new JLabel("Rodap\u00e9:"), c);
        c.insets.top = 0;
        ++c.gridy;
        this.textRodape.setEditable(false);
        this.textRodape.setPreferredSize(new Dimension(150, 20));
        this.panelDireita.add((Component)this.textRodape, c);
        if (this.possuiLink) {
            c.weighty = 0.0;
            c.gridx = 0;
            ++c.gridy;
            c.insets.top = 1;
            this.panelDireita.add((Component)new JLabel("Link:"), c);
            c.insets.top = 0;
            ++c.gridy;
            this.textLink.setEditable(false);
            this.textLink.setPreferredSize(new Dimension(150, 20));
            this.panelDireita.add((Component)this.textLink, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        this.getPanelCentral().add((Component)this.panelDireita, c);
        ++c.gridx;
        c.fill = 11;
        c.insets.left = 20;
        this.getPanelCentral().add((Component)this.panelEsquerda, c);
        for (String campo : ConfiguradorWhatsapp.CAMPOS_DISPONIVEIS) {
            JMenuItem item = new JMenuItem(campo);
            this.menuCampos.add(item);
            item.addActionListener(this);
        }
        this.getBotaoCancelar().setVisible(false);
        this.getPanelBotoesDireita().add(this.btnCancelar);
        this.btnCancelar.addActionListener(e -> {
            if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                this.setTemplate(TemplateDTO.parse(this.jsonTemplate));
                this.dispose();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setUsuarioPodeCancelar(false);
        this.preencheCampos();
        ScreenUtil.requisitarFoco(this.textMensagem);
        this.panelEsquerda.setLayout(new FlowLayout());
        this.panelEsquerda.setPreferredSize(new Dimension(250, 400));
        this.montaListeners();
        this.verificaCamposConfiguracao();
    }

    private void montaListeners() {
        this.textCabecalho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.exibePanelCampos(ConfiguradorModeloWhatsApp.this.textCabecalho, ConfiguradorModeloWhatsApp.HEADER);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.preecheMapCampos();
            }
        });
        this.textMensagem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.exibePanelCamposMensagem(ConfiguradorModeloWhatsApp.this.textMensagem);
                ((JTextPane)e.getSource()).setBackground(ConstantesGerais.COR_FUNDO);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((JTextPane)e.getSource()).setBackground(Color.white);
                ConfiguradorModeloWhatsApp.this.preecheMapCampos();
            }
        });
        this.textRodape.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.exibePanelCampos(ConfiguradorModeloWhatsApp.this.textRodape, ConfiguradorModeloWhatsApp.FOOTER);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.preecheMapCampos();
            }
        });
        this.textLink.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.exibePanelCampos(ConfiguradorModeloWhatsApp.this.textLink, ConfiguradorModeloWhatsApp.BUTTONS);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorModeloWhatsApp.this.preecheMapCampos();
            }
        });
    }

    private void verificaCamposConfiguracao() {
        Matcher matcher = PATTERN.matcher(this.textMensagem.getText());
        ArrayList<String> campos = new ArrayList<String>();
        campos.addAll(this.getCampos(matcher));
        if (this.possuiLink) {
            matcher = PATTERN.matcher(this.textLink.getText());
            campos.addAll(this.getCampos(matcher));
        }
        for (String campo : campos) {
            boolean isLink = campo.equalsIgnoreCase("Link");
            this.totalCampos(campo, isLink);
        }
    }

    private void totalCampos(String campo, boolean isLink) {
        TTextField text = new TTextField(3000);
        if (!isLink) {
            List<CampoDTO> camposConfigurados = this.getValorCampoConfigurado(BODY);
            for (CampoDTO campoDto : camposConfigurados) {
                if (!campoDto.getCampo().equalsIgnoreCase(campo)) continue;
                text.setText(campoDto.getValor());
            }
            this.todosCamposConfiguracao.put("BODY|" + campo, text.getText());
        } else {
            List<CampoDTO> camposConfigurados = this.getValorCampoConfigurado(BUTTONS);
            for (CampoDTO campoDto : camposConfigurados) {
                if (!campoDto.getCampo().equalsIgnoreCase(campo)) continue;
                text.setText(campoDto.getValor());
            }
            this.todosCamposConfiguracao.put("BUTTONS|" + campo, text.getText());
        }
    }

    private void preecheMapCampos() {
        List<Component> components = Arrays.asList(this.panelCampos.getComponents());
        for (Component comp : components) {
            if (!(comp instanceof TTextField)) continue;
            this.camposConfiguracao.put(comp.getName(), ((TTextField)comp).getText());
        }
    }

    private void preencheCampos() {
        this.textCabecalho.setText(this.mensagemDTO.getCabecalho());
        this.textMensagem.setText(this.mensagemDTO.getMensagem());
        this.textRodape.setText(this.mensagemDTO.getRodape());
        this.textLink.setText(this.mensagemDTO.getLink() + " {{Link}}");
    }

    private void exibePanelCampos(TTextField textField, String tipo) {
        this.panelCampos.setVisible(false);
        this.adicionaCampos(textField.getText().contains("{{"), textField.getText(), tipo);
    }

    private void exibePanelCamposMensagem(JTextPane textArea) {
        this.panelCampos.setVisible(false);
        this.adicionaCampos(textArea.getText().contains("{{"), textArea.getText(), BODY);
    }

    private void adicionaCampos(boolean possuiCampos, String texto, String tipo) {
        this.panelCampos.removeAll();
        this.panelCampos.setBorder(new TitledBorder("Campos"));
        this.panelCampos.setVisible(true);
        if (possuiCampos) {
            this.adicionaCamposConfiguracao(texto, tipo);
        } else {
            this.panelCampos.setPreferredSize(new Dimension(250, 70));
            this.panelCampos.setLayout(new GridLayout(1, 1));
            JTextArea avisoCampos = new JTextArea("Nenhum campo dispon\u00edvel para\nconfigura\u00e7\u00e3o.");
            avisoCampos.setEditable(false);
            this.panelCampos.add(avisoCampos);
        }
        this.panelEsquerda.add(this.panelCampos);
    }

    private void adicionaCamposConfiguracao(String texto, String tipo) {
        Matcher matcher = PATTERN.matcher(texto);
        List<String> campos = this.getCampos(matcher);
        this.panelCampos.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.gridy = 0;
        int contator = 0;
        for (String campo : campos) {
            c.gridx = 0;
            c.gridy = contator;
            this.panelCampos.add((Component)new JLabel("{{" + campo + "}}:"), c);
            ++c.gridx;
            c.weightx = 0.0;
            boolean isLink = campo.equalsIgnoreCase("link");
            final TTextField text = this.preencheCampos(tipo, campo, isLink);
            final Map<String, String> camposConfiguracao2 = this.camposConfiguracao;
            this.panelCampos.add((Component)text, c);
            c.insets.top = 0;
            c.gridx = 3;
            c.gridy = contator++;
            c.weightx = 0.0;
            c.insets.left = 0;
            if (!isLink) {
                JButton buttonCampo = ComponenteFactory.novoJButton("...", (ActionListener)this, MENSAGEM_SELECIONE_OS_CAMPOS);
                buttonCampo.setName("campo" + campo);
                this.montaListenerBotao(buttonCampo, text);
                buttonCampo.setPreferredSize(new Dimension(20, 20));
                this.panelCampos.add((Component)buttonCampo, c);
            } else {
                text.setEditable(true);
                text.setPreferredSize(new Dimension(193, 20));
                text.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        camposConfiguracao2.put(text.getName(), text.getText());
                        ConfiguradorModeloWhatsApp.this.converteParaDTO(camposConfiguracao2);
                    }
                });
            }
            this.camposConfiguracao = camposConfiguracao2;
        }
        int tamanho = contator == 0 ? 50 : 20 * contator + 30;
        this.panelCampos.setPreferredSize(new Dimension(250, tamanho));
        if (this.panelCampos.getComponents() != null) {
            this.listaTotalComponent.addAll(Arrays.asList(this.panelCampos.getComponents()));
        }
    }

    private TTextField preencheCampos(String tipo, String campo, boolean isLink) {
        TTextField text = new TTextField(3000);
        List<CampoDTO> camposConfigurados = this.getValorCampoConfigurado(tipo);
        text.setEditable(false);
        text.setPreferredSize(new Dimension(isLink ? 175 : 188, 20));
        text.setName(tipo + "|" + campo);
        for (CampoDTO campoDto : camposConfigurados) {
            if (!campoDto.getCampo().equalsIgnoreCase(campo)) continue;
            text.setText(campoDto.getValor());
        }
        this.camposConfiguracao.put(text.getName(), text.getText());
        return text;
    }

    private List<CampoDTO> getValorCampoConfigurado(String tipo) {
        if (this.template == null) {
            return Collections.emptyList();
        }
        switch (tipo) {
            case "HEADER": {
                return this.template.getHeader().getCampos();
            }
            case "BODY": {
                return this.template.getBody().getCampos();
            }
            case "FOOTER": {
                return this.template.getFooter().getCampos();
            }
            case "BUTTONS": {
                return this.template.getButtons().getCampos();
            }
        }
        return Collections.emptyList();
    }

    private List<String> getCampos(Matcher matcher) {
        ArrayList<String> campos = new ArrayList<String>();
        while (matcher.find()) {
            campos.add(matcher.group(1));
        }
        return campos;
    }

    private void montaListenerBotao(JButton button, TTextField text) {
        button.addActionListener(action -> {
            this.campoParaAdicionar = text;
            this.menuCampos.show(button.getParent(), button.getX(), button.getY() + button.getHeight());
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            try {
                this.campoParaAdicionar.setText("");
                String texto = "[" + ((JMenuItem)e.getSource()).getText() + "]";
                this.campoParaAdicionar.getDocument().insertString(this.campoParaAdicionar.getCaretPosition(), texto, null);
                this.camposConfiguracao.put(this.campoParaAdicionar.getName(), this.campoParaAdicionar.getText());
                this.converteParaDTO(this.camposConfiguracao);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean validaCampos(Map<String, String> campos) {
        if (campos.isEmpty()) {
            Funcoes.mensagem(this, "Finalize a configura\u00e7\u00e3o dos campos antes de contiuar.", 2);
            return false;
        }
        for (Map.Entry<String, String> campo : campos.entrySet()) {
            if (!Funcoes.textoVazio(campo.getValue())) continue;
            Funcoes.mensagem(this, "Finalize a configura\u00e7\u00e3o dos campos antes de contiuar.", 2);
            return false;
        }
        return true;
    }

    @Override
    protected boolean acaoOk() {
        Map<String, String> campos = this.todosCamposConfiguracao;
        for (Component comp : this.listaTotalComponent) {
            if (!(comp instanceof TTextField)) continue;
            campos.put(comp.getName(), ((TTextField)comp).getText());
        }
        boolean ok = this.validaCampos(campos);
        if (ok) {
            this.converteParaDTO(campos);
        }
        return ok;
    }

    private void converteParaDTO(Map<String, String> campos) {
        this.template = this.template == null ? new TemplateDTO() : this.template;
        this.template.setHeader(this.getConfiguracaoHeader(campos));
        this.template.setBody(this.getConfiguracaoBody(campos));
        this.template.setFooter(this.getConfiguracaoFooter(campos));
        this.template.setButtons(this.getConfiguracaoButtons(campos));
    }

    private HeaderDTO getConfiguracaoHeader(Map<String, String> campos) {
        HeaderDTO header = new HeaderDTO();
        ArrayList<CampoDTO> camposDTO = new ArrayList<CampoDTO>();
        if (campos != null) {
            for (Map.Entry<String, String> campo : campos.entrySet()) {
                String[] idCampo = campo.getKey().split("\\|");
                if (!idCampo[0].equalsIgnoreCase(HEADER)) continue;
                CampoDTO campoDTO = new CampoDTO();
                campoDTO.setCampo(idCampo[1]);
                campoDTO.setValor(campo.getValue());
                camposDTO.add(campoDTO);
            }
        }
        header.setCampos(camposDTO);
        return header;
    }

    private BodyDTO getConfiguracaoBody(Map<String, String> campos) {
        BodyDTO body = new BodyDTO();
        ArrayList<CampoDTO> camposDTO = new ArrayList<CampoDTO>();
        if (campos != null) {
            for (Map.Entry<String, String> campo : campos.entrySet()) {
                String[] idCampo = campo.getKey().split("\\|");
                if (!idCampo[0].equalsIgnoreCase(BODY)) continue;
                CampoDTO campoDTO = new CampoDTO();
                campoDTO.setCampo(idCampo[1]);
                campoDTO.setValor(campo.getValue());
                camposDTO.add(campoDTO);
            }
        }
        body.setCampos(camposDTO);
        return body;
    }

    private FooterDTO getConfiguracaoFooter(Map<String, String> campos) {
        FooterDTO footer = new FooterDTO();
        ArrayList<CampoDTO> camposDTO = new ArrayList<CampoDTO>();
        if (campos != null) {
            for (Map.Entry<String, String> campo : campos.entrySet()) {
                String[] idCampo = campo.getKey().split("\\|");
                if (!idCampo[0].equalsIgnoreCase(FOOTER)) continue;
                CampoDTO campoDTO = new CampoDTO();
                campoDTO.setCampo(idCampo[1]);
                campoDTO.setValor(campo.getValue());
                camposDTO.add(campoDTO);
            }
        }
        footer.setCampos(camposDTO);
        return footer;
    }

    private ButtonsDTO getConfiguracaoButtons(Map<String, String> campos) {
        ButtonsDTO buttons = new ButtonsDTO();
        ArrayList<CampoDTO> camposDTO = new ArrayList<CampoDTO>();
        if (campos != null) {
            for (Map.Entry<String, String> campo : campos.entrySet()) {
                String[] idCampo = campo.getKey().split("\\|");
                if (!idCampo[0].equalsIgnoreCase(BUTTONS)) continue;
                CampoDTO campoDTO = new CampoDTO();
                campoDTO.setCampo(idCampo[1]);
                campoDTO.setValor(campo.getValue());
                camposDTO.add(campoDTO);
            }
        }
        buttons.setCampos(camposDTO);
        return buttons;
    }
}

