/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.configurador.ConfiguradorAplicativoNovo;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class DialogoTituloFrasePushApp
extends AbstractDialogoOKCancelar {
    private TTextField textTitulo = new TTextField(300);
    private TTextField textFrase = new TTextField(3000);
    private JButton buttonCamposTitulo = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JButton buttonCamposFrase = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JPopupMenu menuCampos = new JPopupMenu();
    private TTextField campoParaAdicionar = null;

    public DialogoTituloFrasePushApp(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public DialogoTituloFrasePushApp(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public static DialogoTituloFrasePushApp novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoTituloFrasePushApp((Frame)pai, "Configurar t\u00edtulos/frases");
        }
        return new DialogoTituloFrasePushApp((Dialog)pai, "Configurar t\u00edtulos/frases");
    }

    private void montaTela(Component pai) {
        this.setSize(550, 130);
        this.setLocationRelativeTo(pai);
        this.setResizable(false);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.fill = 0;
        this.getPanelCentral().add((Component)new JLabel("T\u00edtulo:"), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)new JLabel("Frase:"), c);
        Insets insets = c.insets;
        c.gridx = 2;
        c.gridy = 0;
        c.insets.left = 0;
        this.buttonCamposTitulo.setPreferredSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonCamposTitulo, c);
        ++c.gridy;
        this.buttonCamposFrase.setPreferredSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonCamposFrase, c);
        this.textTitulo.setPreferredSize(new Dimension(100, 20));
        this.textFrase.setPreferredSize(new Dimension(100, 20));
        c.gridy = 0;
        c.gridx = 1;
        c.insets.left = insets.left;
        c.insets.right = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.textTitulo, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.textFrase, c);
        for (String s : ConfiguradorAplicativoNovo.CAMPOS_DISPONIVEIS) {
            JMenuItem item = new JMenuItem(s);
            this.menuCampos.add(item);
            item.addActionListener(this);
        }
    }

    public void setFrase(String frase) {
        this.textFrase.setText(frase);
    }

    public void setTitulo(String titulo) {
        this.textTitulo.setText(titulo);
    }

    public String getFrase() {
        return this.textFrase.getText();
    }

    public String getTitulo() {
        return this.textTitulo.getText();
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textTitulo)) {
            Funcoes.mensagem(this, "T\u00edtulo n\u00e3o informado", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.textFrase)) {
            Funcoes.mensagem(this, "Frase n\u00e3o informada", 2);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCamposFrase) {
            this.campoParaAdicionar = this.textFrase;
            this.menuCampos.show(this.buttonCamposFrase.getParent(), this.buttonCamposFrase.getX(), this.buttonCamposFrase.getY() + this.buttonCamposFrase.getHeight());
        } else if (e.getSource() == this.buttonCamposTitulo) {
            this.campoParaAdicionar = this.textTitulo;
            this.menuCampos.show(this.buttonCamposFrase.getParent(), this.buttonCamposFrase.getX(), this.buttonCamposFrase.getY() + this.buttonCamposFrase.getHeight());
        } else if (e.getSource() instanceof JMenuItem) {
            try {
                String texto = "[" + ((JMenuItem)e.getSource()).getText() + "]";
                this.campoParaAdicionar.getDocument().insertString(this.campoParaAdicionar.getCaretPosition(), texto, null);
            }
            catch (Exception exception) {}
        } else {
            super.actionPerformed(e);
        }
    }
}

