/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.configurador.ConfiguradorAplicativoNovo;
import jalis.laboratorio.cadastro.configurador.DiaTituloFraseDTO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class DialogoFraseDiasAgendamentoPushApp
extends AbstractDialogoOKCancelar {
    private TTextField textDias = new TTextField(3, 1);
    private TTextField textTitulo = new TTextField(300);
    private TTextField textFrase = new TTextField(3000);
    private JButton buttonCamposTitulo = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JButton buttonCamposFrase = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("OK", this);
    private JPopupMenu menuCampos = new JPopupMenu();
    private TTextField campoParaAdicionar = null;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Dias", "T\u00edtulo"});
    private JTable table = new JTable(this.modelo);
    private final int COLUNA_DIA = 0;
    private final int COLUNA_TITULO = 1;
    private final int COLUNA_FRASE = 2;
    private int linhaAlterando = -1;

    public DialogoFraseDiasAgendamentoPushApp(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public DialogoFraseDiasAgendamentoPushApp(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public static DialogoFraseDiasAgendamentoPushApp novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoFraseDiasAgendamentoPushApp((Frame)pai, "Configurar t\u00edtulos/frases");
        }
        return new DialogoFraseDiasAgendamentoPushApp((Dialog)pai, "Configurar t\u00edtulos/frases");
    }

    private void montaTela(Component pai) {
        this.setSize(550, 400);
        this.setLocationRelativeTo(pai);
        this.setResizable(false);
        this.modelo.setColumnSize(new int[]{80, 0}, this.table);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.fill = 0;
        this.getPanelCentral().add((Component)new JLabel("Dias:"), c);
        ++c.gridx;
        this.textDias.setPreferredSize(new Dimension(80, 20));
        this.getPanelCentral().add((Component)this.textDias, c);
        ++c.gridx;
        this.getPanelCentral().add((Component)new JLabel(" T\u00edtulo:"), c);
        c.gridx = 0;
        ++c.gridy;
        this.getPanelCentral().add((Component)new JLabel("Frase:"), c);
        Insets insets = c.insets;
        c.gridx = 4;
        c.gridy = 0;
        c.insets.left = 0;
        this.buttonCamposTitulo.setPreferredSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonCamposTitulo, c);
        ++c.gridy;
        this.buttonCamposFrase.setPreferredSize(new Dimension(20, 20));
        this.getPanelCentral().add((Component)this.buttonCamposFrase, c);
        this.textTitulo.setPreferredSize(new Dimension(100, 20));
        this.textFrase.setPreferredSize(new Dimension(100, 20));
        c.gridy = 0;
        c.gridx = 3;
        c.insets.left = insets.left;
        c.insets.right = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.getPanelCentral().add((Component)this.textTitulo, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 3;
        this.getPanelCentral().add((Component)this.textFrase, c);
        c.gridx = 5;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.buttonAdicionar.setPreferredSize(new Dimension(40, 20));
        this.buttonAdicionar.setMaximumSize(this.buttonAdicionar.getPreferredSize());
        this.getPanelCentral().add((Component)this.buttonAdicionar, c);
        c.gridwidth = 6;
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets.top = 2;
        this.getPanelCentral().add((Component)new JScrollPane(this.table), c);
        this.buttonCamposFrase.setFocusable(false);
        this.buttonCamposTitulo.setFocusable(false);
        for (String s : ConfiguradorAplicativoNovo.CAMPOS_DISPONIVEIS) {
            JMenuItem item = new JMenuItem(s);
            this.menuCampos.add(item);
            item.addActionListener(this);
        }
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DialogoFraseDiasAgendamentoPushApp.this.editarItem(DialogoFraseDiasAgendamentoPushApp.this.table.getSelectedRow());
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    DialogoFraseDiasAgendamentoPushApp.this.editarItem(DialogoFraseDiasAgendamentoPushApp.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 127) {
                    DialogoFraseDiasAgendamentoPushApp.this.removerLinha(DialogoFraseDiasAgendamentoPushApp.this.table.getSelectedRow());
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textDias);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAdicionar) {
            this.adicionarDia();
        } else if (e.getSource() == this.buttonCamposFrase) {
            this.campoParaAdicionar = this.textFrase;
            this.menuCampos.show(this.buttonCamposFrase.getParent(), this.buttonCamposFrase.getX(), this.buttonCamposFrase.getY() + this.buttonCamposFrase.getHeight());
        } else if (e.getSource() == this.buttonCamposTitulo) {
            this.campoParaAdicionar = this.textTitulo;
            this.menuCampos.show(this.buttonCamposFrase.getParent(), this.buttonCamposFrase.getX(), this.buttonCamposFrase.getY() + this.buttonCamposFrase.getHeight());
        } else if (e.getSource() instanceof JMenuItem) {
            try {
                String texto = "[" + ((JMenuItem)e.getSource()).getText() + "]";
                this.campoParaAdicionar.getDocument().insertString(this.campoParaAdicionar.getCaretPosition(), texto, null);
            }
            catch (Exception exception) {}
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarDia() {
        String dia = this.textDias.getText();
        if (!Funcoes.isNumeric(dia)) {
            Funcoes.mensagem(this, "Dia incorreto", 1);
            ScreenUtil.requisitarFoco(this.textDias);
            return;
        }
        if (Funcoes.textoVazio(this.textTitulo)) {
            Funcoes.mensagem(this, "T\u00edtulo n\u00e3o informado", 1);
            ScreenUtil.requisitarFoco(this.textTitulo);
            return;
        }
        if (Funcoes.textoVazio(this.textFrase)) {
            Funcoes.mensagem(this, "Frase n\u00e3o informada", 1);
            ScreenUtil.requisitarFoco(this.textFrase);
            return;
        }
        boolean adicionado = this.diaJaAdicionado(dia);
        if (adicionado && this.linhaAlterando == -1) {
            Funcoes.mensagem(this, "Dia j\u00e1 adicionado", 2);
            ScreenUtil.requisitarFoco(this.textDias);
            return;
        }
        if (this.linhaAlterando > -1 && adicionado) {
            this.modelo.setValueAt(this.textTitulo.getText(), this.linhaAlterando, 1);
            this.modelo.setValueAt(this.textFrase.getText(), this.linhaAlterando, 2);
        } else {
            this.modelo.addLine(new String[]{this.textDias.getText(), this.textTitulo.getText(), this.textFrase.getText()});
        }
        this.limparCampos();
    }

    private void limparCampos() {
        this.textDias.clear();
        this.textTitulo.clear();
        this.textFrase.clear();
        this.textDias.setEnabled(true);
        this.linhaAlterando = -1;
        ScreenUtil.requisitarFoco(this.textDias);
    }

    private boolean diaJaAdicionado(String dia) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String d = this.modelo.getValueAt(i, 0).toString();
            if (Integer.parseInt(dia) != Integer.parseInt(d)) continue;
            return true;
        }
        return false;
    }

    private void editarItem(int linha) {
        if (linha > -1) {
            this.linhaAlterando = linha;
            this.textDias.setText(this.modelo.getValueAt(linha, 0).toString());
            this.textTitulo.setText(this.modelo.getValueAt(linha, 1).toString());
            this.textFrase.setText(this.modelo.getValueAt(linha, 2).toString());
            this.textDias.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textTitulo);
        }
    }

    private void removerLinha(int linha) {
        if (linha > -1 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.modelo.removeLine(linha);
        }
    }

    public ArrayList<DiaTituloFraseDTO> getDias() {
        ArrayList<DiaTituloFraseDTO> retorno = new ArrayList<DiaTituloFraseDTO>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            DiaTituloFraseDTO dto = new DiaTituloFraseDTO();
            dto.setDia(Integer.parseInt(this.modelo.getValueAt(i, 0).toString()));
            dto.setTitulo(this.modelo.getValueAt(i, 1).toString());
            dto.setFrase(this.modelo.getValueAt(i, 2).toString());
            retorno.add(dto);
        }
        return retorno;
    }

    public void setDias(ArrayList<DiaTituloFraseDTO> dias) {
        this.modelo.clear();
        for (DiaTituloFraseDTO dto : dias) {
            this.modelo.addLine(new String[]{String.valueOf(dto.getDia()), dto.getTitulo(), dto.getFrase()});
        }
    }
}

