/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configurador;

import jalis.laboratorio.cadastro.configurador.CampoTituloFrase;
import jalis.laboratorio.cadastro.configurador.CampoTituloFraseDias;
import jalis.laboratorio.cadastro.configurador.DiaTituloFraseDTO;
import jalis.laboratorio.cadastro.configurador.DialogoFraseDiasAgendamentoPushApp;
import jalis.laboratorio.cadastro.configurador.DialogoTituloFrasePushApp;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfiguradorAplicativoNovo
extends JDialog
implements ActionListener {
    private JPanel panelCentral = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JCheckBox checkAniversario = ComponenteFactory.novoJCheckBox("Enviar push de anivers\u00e1rio", this);
    private CampoTituloFrase textFraseAniversario = new CampoTituloFrase();
    private JButton buttonCamposAniversario = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar t\u00edtulo e frase");
    private JCheckBox checkResultados = ComponenteFactory.novoJCheckBox("Enviar push de aviso resultados prontos", this);
    private JCheckBox checkAgruparMultiguia = ComponenteFactory.novoJCheckBox("Agrupar requisi\u00e7\u00f5es multiguias", 'A', this);
    private CampoTituloFrase textFraseResultado = new CampoTituloFrase();
    private JButton buttonCamposResultado = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar t\u00edtulo e frase");
    private JCheckBox checkRecoleta = ComponenteFactory.novoJCheckBox("Enviar push com aviso de recoleta de material", this);
    private CampoTituloFrase textFraseRecoleta = new CampoTituloFrase();
    private JButton buttonCamposRecoleta = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar t\u00edtulo e frase");
    private JCheckBox checkRequisicao = ComponenteFactory.novoJCheckBox("Enviar push de requisi\u00e7\u00e3o", this);
    private CampoTituloFrase textFraseRequisicao = new CampoTituloFrase();
    private JButton buttonCamposRequisicao = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar t\u00edtulo e frase");
    private JCheckBox checkAgendamento = ComponenteFactory.novoJCheckBox("Enviar push do agendamento", this);
    private CampoTituloFrase textFraseAgendamento = new CampoTituloFrase();
    private JButton buttonCamposAgendamento = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar t\u00edtulo e frase");
    private JCheckBox checkDiasAgendamento = ComponenteFactory.novoJCheckBox("Enviar push de aviso de agendamento", this);
    private CampoTituloFraseDias textDiasAgendamento = new CampoTituloFraseDias();
    private JButton buttonDiasAgendamento = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configurar dias para mensagens");
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private TTextField textHoraEnvioPushAniversario = new TTextField(5, 6);
    private TTextField textHoraEnvioPushDiasAgendamento = new TTextField(5, 6);
    private JLabel labelHoraAniversario = new JLabel("Hor\u00e1rio para enviar push de anivers\u00e1rio:");
    private JLabel labelHoraDiasAgendamento = new JLabel("Hor\u00e1rio para enviar push de agendamento:");
    private boolean ok = false;
    public static final String[] CAMPOS_DISPONIVEIS = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "nomeSocialPaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "dataEntregaPrevistaRequisicao", "horaEntregaPrevistaRequisicao", "codigoPacienteWeb", "dataHoraAgenda"};

    public ConfiguradorAplicativoNovo(Frame owner) {
        super(owner, "Dados Push");
        this.montaTela();
    }

    public ConfiguradorAplicativoNovo(Dialog owner) {
        super(owner, "Dados Push");
        this.montaTela();
    }

    public static ConfiguradorAplicativoNovo novaInstancia(Window owner) {
        if (owner instanceof Frame) {
            return new ConfiguradorAplicativoNovo((Frame)owner);
        }
        return new ConfiguradorAplicativoNovo((Dialog)owner);
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.setSize(688, 390);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentral.add(this.textFraseAniversario);
        this.panelCentral.add(this.textFraseResultado);
        this.panelCentral.add(this.textFraseRecoleta);
        this.panelCentral.add(this.textFraseRequisicao);
        this.panelCentral.add(this.textFraseAgendamento);
        this.panelCentral.add(this.textDiasAgendamento);
        this.panelCentral.add(this.checkAniversario);
        this.panelCentral.add(this.checkResultados);
        this.panelCentral.add(this.checkAgruparMultiguia);
        this.panelCentral.add(this.checkRecoleta);
        this.panelCentral.add(this.checkRequisicao);
        this.panelCentral.add(this.checkAgendamento);
        this.panelCentral.add(this.checkDiasAgendamento);
        this.panelCentral.add(this.buttonCamposAniversario);
        this.panelCentral.add(this.buttonCamposResultado);
        this.panelCentral.add(this.buttonCamposRecoleta);
        this.panelCentral.add(this.buttonCamposRequisicao);
        this.panelCentral.add(this.buttonCamposAgendamento);
        this.panelCentral.add(this.buttonDiasAgendamento);
        this.panelCentral.add(this.textHoraInicial);
        this.panelCentral.add(this.textHoraFinal);
        this.panelCentral.add(this.textHoraEnvioPushAniversario);
        this.panelCentral.add(this.textHoraEnvioPushDiasAgendamento);
        this.checkAniversario.setBounds(new Rectangle(5, 12, 300, 15));
        this.textFraseAniversario.setBounds(new Rectangle(8, 30, 652, 20));
        this.buttonCamposAniversario.setBounds(new Rectangle(660, 30, 20, 20));
        this.buttonCamposAniversario.setFocusable(false);
        this.checkResultados.setBounds(new Rectangle(5, 52, 300, 15));
        this.checkAgruparMultiguia.setBounds(new Rectangle(305, 52, 300, 15));
        this.textFraseResultado.setBounds(new Rectangle(8, 70, 652, 20));
        this.buttonCamposResultado.setBounds(new Rectangle(660, 70, 20, 20));
        this.buttonCamposResultado.setFocusable(false);
        this.checkRecoleta.setBounds(new Rectangle(5, 92, 360, 15));
        this.textFraseRecoleta.setBounds(new Rectangle(8, 110, 652, 20));
        this.buttonCamposRecoleta.setBounds(new Rectangle(660, 110, 20, 20));
        this.buttonCamposRecoleta.setFocusable(false);
        this.checkRequisicao.setBounds(new Rectangle(5, 132, 360, 15));
        this.textFraseRequisicao.setBounds(new Rectangle(8, 150, 652, 20));
        this.buttonCamposRequisicao.setBounds(new Rectangle(660, 150, 20, 20));
        this.buttonCamposRequisicao.setFocusable(false);
        this.checkAgendamento.setBounds(new Rectangle(5, 172, 360, 15));
        this.textFraseAgendamento.setBounds(new Rectangle(8, 190, 652, 20));
        this.buttonCamposAgendamento.setBounds(new Rectangle(660, 190, 20, 20));
        this.buttonCamposAgendamento.setFocusable(false);
        this.checkDiasAgendamento.setBounds(new Rectangle(5, 212, 360, 15));
        this.textDiasAgendamento.setBounds(new Rectangle(8, 230, 652, 20));
        this.buttonDiasAgendamento.setBounds(new Rectangle(660, 230, 20, 20));
        this.buttonDiasAgendamento.setFocusable(false);
        this.labelHoraDiasAgendamento.setBounds(new Rectangle(5, 252, 260, 20));
        this.textHoraEnvioPushDiasAgendamento.setEnabled(this.checkDiasAgendamento.isSelected());
        this.panelCentral.add(this.labelHoraDiasAgendamento);
        this.textHoraEnvioPushDiasAgendamento.setBounds(256, 252, 70, 20);
        this.labelHoraAniversario.setBounds(new Rectangle(5, 274, 260, 20));
        this.textHoraEnvioPushAniversario.setEnabled(this.checkAniversario.isSelected());
        this.panelCentral.add(this.labelHoraAniversario);
        this.textHoraEnvioPushAniversario.setBounds(256, 274, 70, 20);
        JLabel lab = new JLabel("Hora inicial:");
        lab.setBounds(new Rectangle(5, 296, 90, 20));
        this.panelCentral.add(lab);
        this.textHoraInicial.setBounds(82, 296, 70, 20);
        JLabel lab2 = new JLabel("Hora final:");
        lab2.setBounds(new Rectangle(187, 296, 80, 20));
        this.panelCentral.add(lab2);
        this.textHoraFinal.setBounds(256, 296, 71, 20);
    }

    private void abrirConfigurador(CampoTituloFrase campo) {
        DialogoTituloFrasePushApp diag = DialogoTituloFrasePushApp.novaInstancia(this);
        if (null != diag) {
            diag.setFrase(campo.getFrase());
            diag.setTitulo(campo.getTitulo());
            diag.setVisible(true);
            if (diag.getOK()) {
                campo.setTitulo(diag.getTitulo());
                campo.setFrase(diag.getFrase());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCamposAgendamento) {
            this.abrirConfigurador(this.textFraseAgendamento);
        } else if (e.getSource() == this.buttonCamposRequisicao) {
            this.abrirConfigurador(this.textFraseRequisicao);
        } else if (e.getSource() == this.buttonCamposAniversario) {
            this.abrirConfigurador(this.textFraseAniversario);
        } else if (e.getSource() == this.buttonCamposRecoleta) {
            this.abrirConfigurador(this.textFraseRecoleta);
        } else if (e.getSource() == this.buttonCamposResultado) {
            this.abrirConfigurador(this.textFraseResultado);
        } else if (e.getSource() == this.buttonDiasAgendamento) {
            DialogoFraseDiasAgendamentoPushApp diag = DialogoFraseDiasAgendamentoPushApp.novaInstancia(this);
            if (null != diag) {
                diag.setDias(this.textDiasAgendamento.getDias());
                diag.setVisible(true);
                if (diag.getOK()) {
                    this.textDiasAgendamento.limparDias();
                    for (DiaTituloFraseDTO d : diag.getDias()) {
                        this.textDiasAgendamento.adicionarDias(d);
                    }
                }
            }
        } else if (e.getSource() == this.checkAniversario) {
            this.textFraseAniversario.setEnabled(this.checkAniversario.isSelected());
            this.buttonCamposAniversario.setEnabled(this.checkAniversario.isSelected());
            this.textHoraEnvioPushAniversario.setEnabled(this.checkAniversario.isSelected());
        } else if (e.getSource() == this.checkResultados) {
            this.checkAgruparMultiguia.setEnabled(this.checkResultados.isSelected());
            this.textFraseResultado.setEnabled(this.checkResultados.isSelected());
            this.buttonCamposResultado.setEnabled(this.checkResultados.isSelected());
        } else if (e.getSource() == this.checkRecoleta) {
            this.textFraseRecoleta.setEnabled(this.checkRecoleta.isSelected());
            this.buttonCamposRecoleta.setEnabled(this.checkRecoleta.isSelected());
        } else if (e.getSource() == this.checkRequisicao) {
            this.textFraseRequisicao.setEnabled(this.checkRequisicao.isSelected());
            this.buttonCamposRequisicao.setEnabled(this.checkRequisicao.isSelected());
        } else if (e.getSource() == this.checkAgendamento) {
            this.textFraseAgendamento.setEnabled(this.checkAgendamento.isSelected());
            this.buttonCamposAgendamento.setEnabled(this.checkAgendamento.isSelected());
        } else if (e.getSource() == this.checkDiasAgendamento) {
            this.textDiasAgendamento.setEnabled(this.checkDiasAgendamento.isSelected());
            this.buttonDiasAgendamento.setEnabled(this.checkDiasAgendamento.isSelected());
            this.textHoraEnvioPushDiasAgendamento.setEnabled(this.checkDiasAgendamento.isSelected());
        } else if (e.getSource() == this.buttonSalvar) {
            this.ok = this.validaCampos();
            this.setVisible(!this.ok);
        }
    }

    private boolean validaCampos() {
        if (this.checkAniversario.isSelected() && !this.textFraseAniversario.valido()) {
            Funcoes.mensagem(this, "Frase para push de anivers\u00e1rio n\u00e3o preenchida.", 1);
            this.textFraseAniversario.selectAll();
            this.textFraseAniversario.grabFocus();
            return false;
        }
        if (this.checkResultados.isSelected() && !this.textFraseResultado.valido()) {
            Funcoes.mensagem(this, "Frase para push de resultados n\u00e3o preenchida.", 1);
            this.textFraseResultado.selectAll();
            this.textFraseResultado.grabFocus();
            return false;
        }
        if (this.checkRecoleta.isSelected() && !this.textFraseRecoleta.valido()) {
            Funcoes.mensagem(this, "Frase para push de recoleta n\u00e3o preenchida.", 1);
            this.textFraseRecoleta.selectAll();
            this.textFraseRecoleta.grabFocus();
            return false;
        }
        if (this.checkRequisicao.isSelected() && !this.textFraseRequisicao.valido()) {
            Funcoes.mensagem(this, "Frase para push de requisi\u00e7\u00e3o n\u00e3o preenchida.", 1);
            this.textFraseRequisicao.selectAll();
            this.textFraseRequisicao.grabFocus();
            return false;
        }
        if (this.checkAgendamento.isSelected() && !this.textFraseAgendamento.valido()) {
            Funcoes.mensagem(this, "Frase para push do agendamento n\u00e3o preenchida.", 1);
            this.textFraseAgendamento.selectAll();
            this.textFraseAgendamento.grabFocus();
            return false;
        }
        if (this.checkDiasAgendamento.isSelected() && !this.textDiasAgendamento.valido()) {
            Funcoes.mensagem(this, "Frase para aviso de agendamento n\u00e3o preenchida.", 1);
            this.textDiasAgendamento.selectAll();
            this.textDiasAgendamento.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraInicial.getText()) && !Funcoes.verificaHora(this.textHoraInicial.getText())) {
            Funcoes.mensagem(this, "Hora inicial incorreta.", 1);
            this.textHoraInicial.selectAll();
            this.textHoraInicial.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraFinal.getText()) && !Funcoes.verificaHora(this.textHoraFinal.getText())) {
            Funcoes.mensagem(this, "Hora final incorreta.", 1);
            this.textHoraFinal.selectAll();
            this.textHoraFinal.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraEnvioPushAniversario.getText()) && !Funcoes.verificaHora(this.textHoraEnvioPushAniversario.getText())) {
            Funcoes.mensagem(this, "Hora para envio de push de anivers\u00e1rio incorreta.", 1);
            this.textHoraEnvioPushAniversario.selectAll();
            this.textHoraEnvioPushAniversario.grabFocus();
            return false;
        }
        if (this.checkDiasAgendamento.isSelected() && (Funcoes.textoVazio(this.textHoraEnvioPushDiasAgendamento.getText()) || !Funcoes.verificaHora(this.textHoraEnvioPushDiasAgendamento.getText()))) {
            Funcoes.mensagem(this, "Hora para envio de push de agendamento incorreta.", 1);
            this.textHoraEnvioPushDiasAgendamento.selectAll();
            this.textHoraEnvioPushDiasAgendamento.grabFocus();
            return false;
        }
        return true;
    }

    public boolean ok() {
        return this.ok;
    }

    public boolean isAniversario() {
        return this.checkAniversario.isSelected();
    }

    public void setAniversario(boolean aniversario) {
        this.checkAniversario.setSelected(aniversario);
        this.textFraseAniversario.setEnabled(aniversario);
        this.buttonCamposAniversario.setEnabled(aniversario);
        this.textHoraEnvioPushAniversario.setEnabled(aniversario);
    }

    public String getFraseAniversario() {
        return this.textFraseAniversario.getFrase();
    }

    public void setFraseAniversario(String fraseAniversario) {
        this.textFraseAniversario.setFrase(this.validarNull(fraseAniversario));
    }

    public boolean isResultado() {
        return this.checkResultados.isSelected();
    }

    public void setResultado(boolean resultado) {
        this.checkResultados.setSelected(resultado);
        this.checkAgruparMultiguia.setEnabled(resultado);
        this.textFraseResultado.setEnabled(resultado);
        this.buttonCamposResultado.setEnabled(resultado);
    }

    public boolean isAgruparMultiguia() {
        return this.checkAgruparMultiguia.isSelected();
    }

    public void setAgruparMultiguia(boolean agrupar) {
        this.checkAgruparMultiguia.setSelected(agrupar);
    }

    public String getFraseResultado() {
        return this.textFraseResultado.getFrase();
    }

    public void setFraseResultados(String fraseResultado) {
        this.textFraseResultado.setFrase(this.validarNull(fraseResultado));
    }

    public boolean isRecoleta() {
        return this.checkRecoleta.isSelected();
    }

    public void setRecoleta(boolean recoleta) {
        this.checkRecoleta.setSelected(recoleta);
        this.textFraseRecoleta.setEnabled(recoleta);
        this.buttonCamposRecoleta.setEnabled(recoleta);
    }

    public String getFraseRecoleta() {
        return this.textFraseRecoleta.getFrase();
    }

    public void setFraseRecoleta(String fraseRecoleta) {
        this.textFraseRecoleta.setFrase(this.validarNull(fraseRecoleta));
    }

    public String getTituloRecoleta() {
        return this.textFraseRecoleta.getTitulo();
    }

    public void setTituloRecoleta(String titulo) {
        this.textFraseRecoleta.setTitulo(this.validarNull(titulo));
    }

    public String getTituloAgendamento() {
        return this.textFraseAgendamento.getTitulo();
    }

    public void setTituloAgendamento(String titulo) {
        this.textFraseAgendamento.setTitulo(this.validarNull(titulo));
    }

    public String getTituloAniversario() {
        return this.textFraseAniversario.getTitulo();
    }

    public void setTituloAniversario(String titulo) {
        this.textFraseAniversario.setTitulo(this.validarNull(titulo));
    }

    public String getTituloRequisicao() {
        return this.textFraseRequisicao.getTitulo();
    }

    public void setTituloRequisicao(String titulo) {
        this.textFraseRequisicao.setTitulo(this.validarNull(titulo));
    }

    public String getTituloResultado() {
        return this.textFraseResultado.getTitulo();
    }

    public void setTituloResultados(String titulo) {
        this.textFraseResultado.setTitulo(this.validarNull(titulo));
    }

    public void setHoraInicial(Date hora) {
        if (hora != null) {
            this.textHoraInicial.setText(Funcoes.formataData("HH:mm", hora));
        } else {
            this.textHoraInicial.clear();
        }
    }

    public void setHoraFinal(Date hora) {
        if (hora != null) {
            this.textHoraFinal.setText(Funcoes.formataData("HH:mm", hora));
        } else {
            this.textHoraFinal.clear();
        }
    }

    public void setHoraPushEnvioAniversario(Date hora) {
        if (hora != null) {
            this.textHoraEnvioPushAniversario.setText(Funcoes.formataData("HH:mm", hora));
        } else {
            this.textHoraEnvioPushAniversario.clear();
        }
    }

    public void setHoraPushEnvioDiasAgendamento(Date hora) {
        if (hora != null) {
            this.textHoraEnvioPushDiasAgendamento.setText(Funcoes.formataData("HH:mm", hora));
        } else {
            this.textHoraEnvioPushDiasAgendamento.clear();
        }
    }

    public Date getHoraInicial() {
        if (Funcoes.verificaHora(this.textHoraInicial.getText())) {
            return Funcoes.stringToTime(this.textHoraInicial.getText());
        }
        return null;
    }

    public Date getHoraFinal() {
        if (Funcoes.verificaHora(this.textHoraFinal.getText())) {
            return Funcoes.stringToTime(this.textHoraFinal.getText());
        }
        return null;
    }

    public Date getHoraPushEnvioAniversario() {
        if (Funcoes.verificaHora(this.textHoraEnvioPushAniversario.getText())) {
            return Funcoes.stringToTime(this.textHoraEnvioPushAniversario.getText());
        }
        return null;
    }

    public Date getHoraPushEnvioDiasAgendamento() {
        if (Funcoes.verificaHora(this.textHoraEnvioPushDiasAgendamento.getText())) {
            return Funcoes.stringToTime(this.textHoraEnvioPushDiasAgendamento.getText());
        }
        return null;
    }

    public boolean isRequisicao() {
        return this.checkRequisicao.isSelected();
    }

    public boolean isAgendamento() {
        return this.checkAgendamento.isSelected();
    }

    public boolean isDiasAgendamento() {
        return this.checkDiasAgendamento.isSelected();
    }

    public void setRequisicao(boolean ativar) {
        this.checkRequisicao.setSelected(ativar);
        this.textFraseRequisicao.setEnabled(ativar);
        this.buttonCamposRequisicao.setEnabled(ativar);
    }

    public void setAgendamento(boolean ativar) {
        this.checkAgendamento.setSelected(ativar);
        this.textFraseAgendamento.setEnabled(ativar);
        this.buttonCamposAgendamento.setEnabled(ativar);
    }

    public String getFraseRequisicao() {
        return this.textFraseRequisicao.getFrase();
    }

    public void setFraseRequisicao(String fraseRequisicao) {
        this.textFraseRequisicao.setFrase(this.validarNull(fraseRequisicao));
    }

    public String getFraseAgendamento() {
        return this.textFraseAgendamento.getFrase();
    }

    public void setFraseAgendamento(String fraseRequisicao) {
        this.textFraseAgendamento.setFrase(this.validarNull(fraseRequisicao));
    }

    public void setDiasAgendamento(boolean ativar) {
        this.checkDiasAgendamento.setSelected(ativar);
        this.textDiasAgendamento.setEnabled(ativar);
        this.buttonDiasAgendamento.setEnabled(ativar);
        this.textHoraEnvioPushDiasAgendamento.setEnabled(ativar);
    }

    public void setFrasesDiasAgendamento(List<DiaTituloFraseDTO> dias) {
        this.textDiasAgendamento.limparDias();
        for (DiaTituloFraseDTO d : dias) {
            this.textDiasAgendamento.adicionarDias(d);
        }
    }

    public List<DiaTituloFraseDTO> getFrasesDias() {
        return this.textDiasAgendamento.getDias();
    }

    private String validarNull(String texto) {
        if (null == texto) {
            return "";
        }
        return texto;
    }
}

