/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.configuracaoConvenio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.cadastro.convenio.ConvenioCotaUnidadeSaudeBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.UnidadeSaudeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.ConvenioService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConfiguracaoCotaUnidadeSaude
extends AbstractDialogoOKCancelar {
    private final int COLUNA_COTA_UNIDADE_SAUDE = 0;
    private final int COLUNA_COTA_DESCRICAO_UNIDADE_SAUDE = 1;
    private final int COLUNA_COTA_QUANTIDADE = 2;
    private JPanel painelUnidadeSaude = new JPanel(new GridBagLayout());
    private JLabel labelUnidadeSaude = new JLabel("Unid. Sa\u00fade");
    private JLabel labelQuantidadeExames = new JLabel("Qtde. Exames");
    private JButton buttonOkUnidadeSaude = ComponenteFactory.novoJButton("OK", this);
    private TTextField textUnidadeSaude = ComponenteFactory.novoTTextField(10, 3);
    private JButton buttonPesquisaUnidadeSaude = ComponenteFactory.novoJButton(this, true);
    private JLabel labelDescUnidadeSaude = ComponenteFactory.novoJLabel("", new Dimension(280, 20));
    private TTextField textQtdeExames = ComponenteFactory.novoTTextField(5, 1);
    private ModeloGridTable modeloUnidadeSaude = new ModeloGridTable(new String[]{"Un. Sa\u00fade", "Descri\u00e7\u00e3o", "Qtde"});
    private JTable tableUnidadeSaude = new JTable(this.modeloUnidadeSaude);
    private JScrollPane scrolUnidadeSaude = new JScrollPane(this.tableUnidadeSaude);
    private Set<ConvenioCotaUnidadeSaudeBean> convenioCotaUnidadeSaudeBean;
    private ConvenioService convenioService = new ConvenioService();
    private Integer filial;
    private Integer convenio;

    public ConfiguracaoCotaUnidadeSaude(Dialog pai, String titulo, Integer filial, Integer convenio, Set<ConvenioCotaUnidadeSaudeBean> convenioCotaUnidadeSaudeBean) {
        super(pai, titulo);
        if (convenioCotaUnidadeSaudeBean != null) {
            this.convenioCotaUnidadeSaudeBean = convenioCotaUnidadeSaudeBean;
        }
        this.convenio = convenio;
        this.filial = filial;
        this.montaTela();
    }

    public ConfiguracaoCotaUnidadeSaude(Frame pai, String titulo, Integer filial, Integer convenio, Set<ConvenioCotaUnidadeSaudeBean> convenioCotaUnidadeSaudeBean) {
        super(pai, titulo);
        if (convenioCotaUnidadeSaudeBean != null) {
            this.convenioCotaUnidadeSaudeBean = convenioCotaUnidadeSaudeBean;
        } else {
            convenioCotaUnidadeSaudeBean = new HashSet<ConvenioCotaUnidadeSaudeBean>();
            this.convenioCotaUnidadeSaudeBean = convenioCotaUnidadeSaudeBean;
        }
        this.convenio = convenio;
        this.filial = filial;
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(500, 400);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new BorderLayout());
        Funcoes.defineUpperCase(this.getPanelCentral(), ParametrosGerais.getUpperCase());
        ScreenUtil.setBorda(new Component[]{this.labelDescUnidadeSaude}, new TitledBorder(""));
        this.getPanelCentral().add((Component)this.painelUnidadeSaude, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.painelUnidadeSaude.add((Component)this.labelUnidadeSaude, c);
        c.gridx += 3;
        c.gridwidth = 2;
        this.painelUnidadeSaude.add((Component)this.labelQuantidadeExames, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.textUnidadeSaude.setPreferredSize(new Dimension(70, 20));
        this.textUnidadeSaude.setMinimumSize(new Dimension(70, 20));
        this.textUnidadeSaude.setMaximumSize(new Dimension(70, 20));
        this.painelUnidadeSaude.add((Component)this.textUnidadeSaude, c);
        ++c.gridx;
        c.fill = 0;
        this.buttonPesquisaUnidadeSaude.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisaUnidadeSaude.setMinimumSize(new Dimension(20, 20));
        this.buttonPesquisaUnidadeSaude.setMaximumSize(new Dimension(20, 20));
        this.painelUnidadeSaude.add((Component)this.buttonPesquisaUnidadeSaude, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelDescUnidadeSaude.setMinimumSize(new Dimension(30, 20));
        this.labelDescUnidadeSaude.setPreferredSize(new Dimension(30, 20));
        this.painelUnidadeSaude.add((Component)this.labelDescUnidadeSaude, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.textQtdeExames.setPreferredSize(new Dimension(65, 20));
        this.textQtdeExames.setMinimumSize(new Dimension(65, 20));
        this.textQtdeExames.setMaximumSize(new Dimension(65, 20));
        this.painelUnidadeSaude.add((Component)this.textQtdeExames, c);
        ++c.gridx;
        this.buttonOkUnidadeSaude.setPreferredSize(new Dimension(40, 19));
        this.buttonOkUnidadeSaude.setMinimumSize(new Dimension(40, 19));
        this.buttonOkUnidadeSaude.setMaximumSize(new Dimension(40, 19));
        this.painelUnidadeSaude.add((Component)this.buttonOkUnidadeSaude, c);
        this.modeloUnidadeSaude.setColumnSize(new int[]{80, 0, 50}, this.tableUnidadeSaude);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 5;
        this.painelUnidadeSaude.add((Component)this.scrolUnidadeSaude, c);
        this.montaListeners();
        ScreenUtil.requisitarFoco(this.textUnidadeSaude);
        try {
            this.carregarDados();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void montaListeners() {
        this.buttonPesquisaUnidadeSaude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguracaoCotaUnidadeSaude.this.pesquisaUnidadeSaude(null);
            }
        });
        this.buttonOkUnidadeSaude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude.getText())) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Unidade de sa\u00fade deve ser preenchida.", 2);
                    ScreenUtil.requisitarFoco(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude);
                    return;
                }
                if (Funcoes.textoVazio(ConfiguracaoCotaUnidadeSaude.this.textQtdeExames.getText())) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade de exames deve ser preenchida.", 2);
                    ScreenUtil.requisitarFoco(ConfiguracaoCotaUnidadeSaude.this.textQtdeExames);
                    return;
                }
                if (ConfiguracaoCotaUnidadeSaude.this.labelDescUnidadeSaude.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Unidade de sa\u00fade n\u00e3o cadastrada.", 2);
                    ScreenUtil.requisitarFoco(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude);
                    return;
                }
                if (!Funcoes.textoVazio(ConfiguracaoCotaUnidadeSaude.this.textQtdeExames.getText())) {
                    boolean adicionou = false;
                    for (int i = 0; i < ConfiguracaoCotaUnidadeSaude.this.tableUnidadeSaude.getRowCount(); ++i) {
                        if (!ConfiguracaoCotaUnidadeSaude.this.modeloUnidadeSaude.getValueAt(i, 0).equals(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude.getText())) continue;
                        ConfiguracaoCotaUnidadeSaude.this.modeloUnidadeSaude.setValueAt(ConfiguracaoCotaUnidadeSaude.this.textQtdeExames.getText(), i, 2);
                        adicionou = true;
                        break;
                    }
                    if (!adicionou) {
                        ConfiguracaoCotaUnidadeSaude.this.modeloUnidadeSaude.addLine(new Object[]{ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude.getText(), ConfiguracaoCotaUnidadeSaude.this.labelDescUnidadeSaude.getText(), ConfiguracaoCotaUnidadeSaude.this.textQtdeExames.getText()});
                    }
                    ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude.clear();
                    ConfiguracaoCotaUnidadeSaude.this.labelDescUnidadeSaude.setText("");
                    ConfiguracaoCotaUnidadeSaude.this.textQtdeExames.clear();
                } else if (!Funcoes.textoVazio(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude.getText())) {
                    ScreenUtil.requisitarFoco(ConfiguracaoCotaUnidadeSaude.this.textQtdeExames);
                }
            }
        });
        this.tableUnidadeSaude.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ConfiguracaoCotaUnidadeSaude.this.removeUnidadeSaudeSelecionado();
                } else if (ConfiguracaoCotaUnidadeSaude.this.tableUnidadeSaude.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    ConfiguracaoCotaUnidadeSaude.this.editarUnidadeSaudeCota();
                    ScreenUtil.requisitarFoco(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude);
                }
            }
        });
        this.tableUnidadeSaude.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ConfiguracaoCotaUnidadeSaude.this.editarUnidadeSaudeCota();
                    ScreenUtil.requisitarFoco(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude);
                }
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguracaoCotaUnidadeSaude.this.convenioCotaUnidadeSaudeBean = new HashSet();
                for (int i = 0; i < ConfiguracaoCotaUnidadeSaude.this.tableUnidadeSaude.getRowCount(); ++i) {
                    String unidadeSaude = (String)ConfiguracaoCotaUnidadeSaude.this.modeloUnidadeSaude.getValueAt(i, 0);
                    String descricaoUnidadeSaude = (String)ConfiguracaoCotaUnidadeSaude.this.modeloUnidadeSaude.getValueAt(i, 1);
                    String quantidade = ConfiguracaoCotaUnidadeSaude.this.modeloUnidadeSaude.getValueAt(i, 2).toString();
                    ConfiguracaoCotaUnidadeSaude.this.adicionaUnidadeSaude(unidadeSaude, descricaoUnidadeSaude, quantidade);
                }
            }
        });
        this.textUnidadeSaude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude)) {
                    ConfiguracaoCotaUnidadeSaude.this.pesquisaUnidadeSaude(ConfiguracaoCotaUnidadeSaude.this.textUnidadeSaude.getText());
                }
            }
        });
        this.textUnidadeSaude.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguracaoCotaUnidadeSaude.this.buttonPesquisaUnidadeSaude.doClick();
                }
            }
        });
    }

    private void editarUnidadeSaudeCota() {
        this.textUnidadeSaude.setText(this.modeloUnidadeSaude.getValueAt(this.tableUnidadeSaude.getSelectedRow(), 0).toString());
        this.labelDescUnidadeSaude.setText(this.modeloUnidadeSaude.getValueAt(this.tableUnidadeSaude.getSelectedRow(), 1).toString());
        String quantidade = this.modeloUnidadeSaude.getValueAt(this.tableUnidadeSaude.getSelectedRow(), 2).toString();
        this.textQtdeExames.setText(String.valueOf(quantidade));
    }

    private void removeUnidadeSaudeSelecionado() {
        int row;
        int confirmaExclusao = Funcoes.mensagem(this, "Deseja excluir a uniadde de sa\u00fade?", 4);
        if (confirmaExclusao == 0 && (row = this.tableUnidadeSaude.getSelectedRow()) > -1) {
            try {
                Iterator<ConvenioCotaUnidadeSaudeBean> iterator = this.convenioCotaUnidadeSaudeBean.iterator();
                while (iterator.hasNext()) {
                    ConvenioCotaUnidadeSaudeBean ccusb = iterator.next();
                    if (!ccusb.getUnidadeSaude().getCodigo().equals(this.modeloUnidadeSaude.getValueAt(row, 0))) continue;
                    iterator.remove();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.modeloUnidadeSaude.removeLine(row);
        }
    }

    private void adicionaUnidadeSaude(String unidadeSaude, String descricaoUnidadeSaude, String quantidade) {
        ConvenioCotaUnidadeSaudeBean convenioCotaUnidadeSaude = new ConvenioCotaUnidadeSaudeBean();
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(this.filial);
        convenioCotaUnidadeSaude.setFilial(filialVO);
        ConvenioVO convenioVO = new ConvenioVO();
        convenioVO.setFilial(filialVO);
        convenioVO.setCodigo(this.convenio);
        convenioCotaUnidadeSaude.setCodigo(convenioVO);
        UnidadeSaudeVO unidadeSaudeVO = new UnidadeSaudeVO();
        unidadeSaudeVO.setCodigo(unidadeSaude);
        unidadeSaudeVO.setDescricao(descricaoUnidadeSaude);
        convenioCotaUnidadeSaude.setUnidadeSaude(unidadeSaudeVO);
        convenioCotaUnidadeSaude.setQuantidade(Double.parseDouble(quantidade.toString()));
        this.convenioCotaUnidadeSaudeBean.add(convenioCotaUnidadeSaude);
        this.textQtdeExames.clear();
        this.textUnidadeSaude.clear();
        this.labelDescUnidadeSaude.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pesquisaUnidadeSaude(String codigoUnidadeSaude) {
        if (codigoUnidadeSaude == null) {
            Hashtable unidadeSaude = Pesquisas.unidadeSaude(this, true);
            if (unidadeSaude == null) return;
            this.textUnidadeSaude.setText(unidadeSaude.get("uns_codigo").toString());
            this.labelDescUnidadeSaude.setText(unidadeSaude.get("uns_descricao").toString());
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select uns_codigo, uns_descricao from unidadesaude where fil_codigo=");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and uns_codigo = '");
        buf.append(codigoUnidadeSaude.toUpperCase()).append("'");
        Statement st = Conexao.getStatement();
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                this.textUnidadeSaude.setText(rs.getString("uns_codigo").toString());
                this.labelDescUnidadeSaude.setText(rs.getString("uns_descricao").toString());
            } else {
                this.labelDescUnidadeSaude.setText("N\u00e3o cadastrado");
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar unidade de sa\u00fade.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return;
        }
        Conexao.fecharStatement(st);
        return;
    }

    private void carregarDados() throws Exception {
        if (this.convenioCotaUnidadeSaudeBean == null) {
            this.convenioCotaUnidadeSaudeBean = this.convenioService.loadCotaUnidadeSaude(" where fil_codigo = " + this.filial + " and con_codigo = " + this.convenio);
        }
        for (ConvenioCotaUnidadeSaudeBean convenioUnidadeSaude : this.convenioCotaUnidadeSaudeBean) {
            Double valor = Funcoes.arredondar(convenioUnidadeSaude.getQuantidade(), 1);
            Integer quantidade = valor.intValue();
            this.modeloUnidadeSaude.addLine(new Object[]{convenioUnidadeSaude.getUnidadeSaude().getCodigo(), convenioUnidadeSaude.getUnidadeSaude().getDescricao(), quantidade});
        }
    }

    public Set<ConvenioCotaUnidadeSaudeBean> getConvenioCotaUnidadeSaudeBean() {
        return this.convenioCotaUnidadeSaudeBean;
    }

    public Integer getFilial() {
        return this.filial;
    }

    public void setFilial(Integer filial) {
        this.filial = filial;
    }

    public Integer getConvenio() {
        return this.convenio;
    }

    public void setConvenio(Integer convenio) {
        this.convenio = convenio;
    }
}

