/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.agrupamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class AgrupaSituacao
extends FrmCadPadrao {
    private JPanel panelExame = new JPanel(null);
    private JLabel labelExameFilho = new JLabel("Exame:");
    private JLabel labelSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private TTextField txtCodExameFilho = new TTextField(5);
    private JComboBox comboExameFilho = new JComboBox();
    private TTextField txtCodSituacao = new TTextField(5, 1);
    private TTextField txtCodConvenio = new TTextField(5, 1);
    private JLabel labelDescExameFilho = new JLabel();
    private JLabel labelDescSituacao = new JLabel();
    private JLabel labelDescConvenio = new JLabel();
    private JButton buttonBuscaExameFilho = new JButton();
    private JButton buttonBuscaSituacao = new JButton();
    private JButton buttonBuscaConvenio = new JButton();
    private JButton buttonOK = new JButton("OK");
    private JCheckBox checkIgnorarConvenio = new JCheckBox("Permitir que todos os conv\u00eanios utilizem este agrupamento");
    private JTable tableExames = new JTable();
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame"});
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_MATERIAL = 1;

    public AgrupaSituacao() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
        }
        this.txtCodExameFilho.setUpperCase(true);
    }

    private void posicionaComponentes() {
        this.labelDescSituacao.setBounds(162, 5, this.panelExame.getWidth() - 167, 20);
        this.labelDescConvenio.setBounds(162, 26, this.panelExame.getWidth() - 167, 20);
        this.labelDescExameFilho.setBounds(263, 47, this.panelExame.getWidth() - 311, 20);
        this.buttonOK.setBounds(this.panelExame.getWidth() - 45, 47, 40, 20);
    }

    private void jbInit() throws Exception {
        this.setLabelDescricao("Agrupamento de exames a serem adicionados \u00e0 requisi\u00e7\u00e3o por situa\u00e7\u00e3o");
        this.setLabelFormulario("Agrupamento Exames/Situa\u00e7\u00e3o");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/exm_situacao.jpg"));
        this.panelExame.setPreferredSize(new Dimension(10, 70));
        this.labelSituacao.setBounds(2, 7, 69, 14);
        this.txtCodSituacao.setBounds(71, 5, 69, 20);
        this.buttonBuscaSituacao.setBounds(141, 5, 20, 20);
        this.labelDescSituacao.setBounds(162, 5, 150, 20);
        this.labelConvenio.setBounds(2, 28, 69, 14);
        this.txtCodConvenio.setBounds(71, 26, 69, 20);
        this.buttonBuscaConvenio.setBounds(141, 26, 20, 20);
        this.labelDescConvenio.setBounds(162, 26, 150, 20);
        this.labelExameFilho.setBounds(2, 49, 69, 14);
        this.txtCodExameFilho.setBounds(71, 47, 69, 20);
        this.buttonBuscaExameFilho.setBounds(141, 47, 20, 20);
        this.comboExameFilho.setBounds(162, 47, 100, 20);
        this.labelDescExameFilho.setBounds(263, 47, 150, 20);
        this.buttonOK.setBounds(414, 47, 40, 20);
        Funcoes.imagemPesquisa(this.buttonBuscaExameFilho);
        Funcoes.imagemPesquisa(this.buttonBuscaSituacao);
        Funcoes.imagemPesquisa(this.buttonBuscaConvenio);
        ScreenUtil.setBorda(new Component[]{this.labelDescExameFilho, this.labelDescSituacao, this.labelDescConvenio}, new TitledBorder(""));
        this.painelCentral.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        this.painelCentral.add((Component)this.panelExame, "North");
        this.painelCentral.add((Component)this.scrollExames, "Center");
        this.painelCentral.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.checkIgnorarConvenio), "South");
        this.panelExame.add(this.labelExameFilho);
        this.panelExame.add(this.labelSituacao);
        this.panelExame.add(this.labelConvenio);
        this.panelExame.add(this.txtCodExameFilho);
        this.panelExame.add(this.comboExameFilho);
        this.panelExame.add(this.txtCodSituacao);
        this.panelExame.add(this.txtCodConvenio);
        this.panelExame.add(this.labelDescExameFilho);
        this.panelExame.add(this.labelDescSituacao);
        this.panelExame.add(this.labelDescConvenio);
        this.panelExame.add(this.buttonBuscaExameFilho);
        this.panelExame.add(this.buttonBuscaSituacao);
        this.panelExame.add(this.buttonBuscaConvenio);
        this.panelExame.add(this.buttonOK);
        this.tableExames.setModel(this.modelo);
        this.modelo.setColumnSize(new int[]{100, 80, 0}, this.tableExames);
        this.buttonOK.setMargin(new Insets(2, 2, 2, 2));
        this.buttonBuscaExameFilho.setFocusable(false);
        this.buttonBuscaSituacao.setFocusable(false);
        this.buttonBuscaConvenio.setFocusable(false);
        this.controlaCampos();
        this.panelExame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AgrupaSituacao.this.posicionaComponentes();
            }
        });
        this.buttonBuscaExameFilho.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupaSituacao.this.buscaExame(AgrupaSituacao.this.txtCodExameFilho);
            }
        });
        this.buttonBuscaSituacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupaSituacao.this.buscaSituacao();
            }
        });
        this.buttonBuscaConvenio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupaSituacao.this.buscaConvenio();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(Funcoes.textoVazio(AgrupaSituacao.this.txtCodExameFilho.getText()) || AgrupaSituacao.this.labelDescExameFilho.getText().equals("N\u00e3o cadastrado") || Funcoes.textoVazio(AgrupaSituacao.this.txtCodSituacao.getText()) || Funcoes.textoVazio(AgrupaSituacao.this.txtCodConvenio.getText()))) {
                    DadosMaterial material = (DadosMaterial)AgrupaSituacao.this.comboExameFilho.getSelectedItem();
                    boolean localizaExame = AgrupaSituacao.this.localizaExameFilho(AgrupaSituacao.this.txtCodExameFilho.getText(), material);
                    if (localizaExame) {
                        AgrupaSituacao.this.modelo.addLine(new Object[]{AgrupaSituacao.this.txtCodExameFilho.getText(), AgrupaSituacao.this.comboExameFilho.getSelectedItem(), AgrupaSituacao.this.labelDescExameFilho.getText()});
                    }
                    AgrupaSituacao.this.txtCodExameFilho.clear();
                    AgrupaSituacao.this.comboExameFilho.removeAllItems();
                    AgrupaSituacao.this.labelDescExameFilho.setText("");
                }
                AgrupaSituacao.this.txtCodExameFilho.requestFocus();
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AgrupaSituacao.this.tableExames.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(AgrupaSituacao.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    AgrupaSituacao.this.modelo.removeLine(AgrupaSituacao.this.tableExames.getSelectedRow());
                }
            }
        });
        this.txtCodExameFilho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(AgrupaSituacao.this.txtCodExameFilho.getText())) {
                        ExameUtil.carregarMateriaisColeta(AgrupaSituacao.this.txtCodExameFilho.getText(), Variaveis.filialPadrao, AgrupaSituacao.this.comboExameFilho);
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(AgrupaSituacao.this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
                }
            }
        });
        this.txtCodSituacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupaSituacao.this.txtCodSituacao.getText())) {
                    StringBuilder buf = new StringBuilder("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and sit_codigo = ");
                    buf.append(AgrupaSituacao.this.txtCodSituacao.getText());
                    buf.append(" and sit_inativo = false ");
                    try {
                        if (!AgrupaSituacao.this.buscaSituacaoPai()) {
                            String descricao = DBUtil.getDescricao("select sit_descricao from situacao", buf.toString(), "sit_descricao");
                            AgrupaSituacao.this.labelDescSituacao.setText(descricao);
                        }
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(AgrupaSituacao.this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
                    }
                }
            }
        });
        this.txtCodConvenio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupaSituacao.this.txtCodConvenio.getText())) {
                    StringBuilder buf = new StringBuilder("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and con_codigo = ");
                    buf.append(AgrupaSituacao.this.txtCodConvenio.getText());
                    try {
                        String descricao = DBUtil.getDescricao("select con_fantasia from convenios", buf.toString(), "con_fantasia");
                        AgrupaSituacao.this.labelDescConvenio.setText(descricao);
                        if (AgrupaSituacao.this.buscaDados()) {
                            AgrupaSituacao.this.setStatus(3);
                            AgrupaSituacao.this.controlaCampos();
                        }
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(AgrupaSituacao.this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
                    }
                }
            }
        });
        this.comboExameFilho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupaSituacao.this.txtCodExameFilho.getText())) {
                    StringBuilder buf = new StringBuilder("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and exa_codigo = '");
                    buf.append(AgrupaSituacao.this.txtCodExameFilho.getText());
                    buf.append("'");
                    try {
                        String descricao = DBUtil.getDescricao("select exa_descricao from exames", buf.toString(), "exa_descricao");
                        AgrupaSituacao.this.labelDescExameFilho.setText(descricao);
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(AgrupaSituacao.this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
                    }
                }
            }
        });
        this.checkIgnorarConvenio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AgrupaSituacao.this.checkIgnorarConvenio.isSelected()) {
                    AgrupaSituacao.this.validaQtdeAgrupamentoExame(AgrupaSituacao.this.txtCodSituacao.getText());
                }
            }
        });
    }

    private void validaQtdeAgrupamentoExame(String codigoExame) {
        int qtde = 0;
        int ultimoConvenio = -1;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.con_codigo, count(a.sit_codigo) ");
        buf.append("from exameagrupasituacao a ");
        buf.append("left join agrupasituacao c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo and a.sit_codigo = c.sit_codigo ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.sit_codigo = ");
        buf.append(this.txtCodSituacao.getText());
        buf.append(" and not c.asi_ignorarconvenio ");
        buf.append("group by a.con_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                if (ultimoConvenio == -1) {
                    ultimoConvenio = rs.getInt("con_codigo");
                    ++qtde;
                }
                if (ultimoConvenio == rs.getInt("con_codigo")) continue;
                ++qtde;
            }
            if (qtde != 1 && this.getStatus() == 3 || qtde > 0 && this.getStatus() == 2) {
                Funcoes.mensagem(this, "N\u00e2o \u00e9 poss\u00edvel utilizar o agrupamento para todos os conv\u00eanios,\n pois h\u00e1 configura\u00e7\u00f5es de agrupamento para a situa\u00e7\u00e3o.", 2);
                this.checkIgnorarConvenio.setSelected(false);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + e.toString(), 1);
        }
    }

    private boolean buscaSituacaoPai() {
        boolean retorno = false;
        if (Funcoes.textoVazio(this.txtCodSituacao.getText())) {
            return retorno;
        }
        this.modelo.clear();
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.con_codigo, a.exa_codigo, a.mco_codigo, b.exa_descricao, c.asi_ignorarconvenio ");
        buf.append("from exameagrupasituacao a ");
        buf.append("left join agrupasituacao c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo and a.sit_codigo = c.sit_codigo ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.sit_codigo = ");
        buf.append(this.txtCodSituacao.getText());
        buf.append(" and c.asi_ignorarconvenio ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next();
            if (retorno) {
                if (Funcoes.mensagem(this, "A situa\u00e7\u00e3o j\u00e1 possui agrupamento que permite a utiliza\u00e7\u00e3o para todos os conv\u00eanios, deseja edita-lo?", 4) == 0) {
                    this.setStatus(3);
                    this.controlaCampos();
                    this.checkIgnorarConvenio.setSelected(rs.getBoolean("asi_ignorarconvenio"));
                    this.txtCodConvenio.setText(rs.getString("con_codigo"));
                    if (!Funcoes.textoVazio(this.txtCodSituacao)) {
                        buf.delete(0, buf.length());
                        buf.append("fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and con_codigo = ");
                        buf.append(rs.getString("con_codigo"));
                        String descricao = DBUtil.getDescricao("select con_fantasia from convenios", buf.toString(), "con_fantasia");
                        this.labelDescConvenio.setText(descricao);
                        buf.delete(0, buf.length());
                        buf.append("fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and sit_codigo = ");
                        buf.append(this.txtCodSituacao.getText());
                        buf.append(" and sit_inativo = false ");
                        descricao = DBUtil.getDescricao("select sit_descricao from situacao", buf.toString(), "sit_descricao");
                        this.labelDescSituacao.setText(descricao);
                    }
                    do {
                        DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                        this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao")});
                    } while (rs.next());
                    this.txtCodExameFilho.requestFocus();
                } else {
                    this.limparCampos();
                    this.txtCodSituacao.requestFocus();
                }
            } else {
                this.txtCodConvenio.requestFocus();
            }
            rs.close();
        }
        catch (Exception ex) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.toString(), 1);
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private boolean buscaDados() {
        boolean retorno = false;
        if (Funcoes.textoVazio(this.txtCodSituacao.getText()) || Funcoes.textoVazio(this.txtCodConvenio.getText())) {
            return retorno;
        }
        this.modelo.clear();
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.exa_descricao, c.asi_ignorarconvenio ");
        buf.append("from exameagrupasituacao a ");
        buf.append("left join agrupasituacao c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo and a.sit_codigo = c.sit_codigo ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.sit_codigo = ");
        buf.append(this.txtCodSituacao.getText());
        buf.append(" and a.con_codigo = ");
        buf.append(this.txtCodConvenio.getText());
        buf.append(" order by a.exa_codigo, a.mco_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next();
            if (retorno) {
                this.checkIgnorarConvenio.setSelected(rs.getBoolean("asi_ignorarconvenio"));
                do {
                    DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                    this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao")});
                } while (rs.next());
            }
            rs.close();
            this.txtCodExameFilho.requestFocus();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private boolean localizaExameFilho(String exame, DadosMaterial material) {
        int retorno = ExameUtil.localizaExame(exame, material, this.modelo, 0, 1);
        return retorno < 0;
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodExameFilho.hasFocus()) {
            this.buscaExame(this.txtCodExameFilho);
        } else if (this.txtCodSituacao.hasFocus()) {
            this.buscaSituacao();
        } else if (this.txtCodConvenio.hasFocus()) {
            this.buscaConvenio();
        }
    }

    private void buscaExame(TTextField campo) {
        Hashtable resultado = Pesquisas.exame(this.getTopLevelAncestor(), true, false);
        if (resultado != null) {
            campo.setText(resultado.get("exa_codigo").toString());
        }
        campo.requestFocus();
    }

    private void buscaSituacao() {
        Hashtable situacao = Pesquisas.situacao(this.getTopLevelAncestor(), true, false);
        if (situacao != null) {
            this.txtCodSituacao.setText(situacao.get("sit_codigo").toString());
        }
        this.txtCodSituacao.grabFocus();
    }

    private void buscaConvenio() {
        Hashtable convenio = Pesquisas.convenio(this.getTopLevelAncestor(), true, false);
        if (convenio != null) {
            this.txtCodConvenio.setText(convenio.get("con_codigo").toString());
        }
        this.txtCodConvenio.grabFocus();
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodSituacao.requestFocus();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            Statement st = Conexao.getStatement();
            try {
                SalvaDados salvar = new SalvaDados("agrupasituacao", 1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("sit_codigo", 2, false, true, this.txtCodSituacao.getText());
                salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaSituacao());
                salvar.setOperacao(0);
                salvar.limpar();
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("sit_codigo", 2, false, true, this.txtCodSituacao.getText());
                salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                salvar.adicionaCampo("asi_ignorarconvenio", 4, false, true, this.checkIgnorarConvenio.isSelected());
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaSituacao());
                salvar.setOperacao(0);
                salvar.setTabela("exameagrupasituacao");
                for (int i = 0; i < this.tableExames.getRowCount(); ++i) {
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("sit_codigo", 2, false, true, this.txtCodSituacao.getText());
                    salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                    salvar.adicionaCampo("exa_codigo", 0, false, true, this.modelo.getValueAt(i, 0).toString());
                    salvar.adicionaCampo("mco_codigo", 2, false, true, ((DadosMaterial)this.modelo.getValueAt(i, 1)).getCodigo());
                    DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaSituacao());
                }
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
            }
            Conexao.fecharStatement(st);
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            Statement st = Conexao.getStatement();
            try {
                this.setStatus(4);
                this.controlaCampos();
                SalvaDados salvar = new SalvaDados("agrupasituacao", 1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("sit_codigo", 2, false, true, this.txtCodSituacao.getText());
                salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaSituacao());
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaSituacao");
            }
            Conexao.fecharStatement(st);
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            if (this.buscaDados()) {
                this.setStatus(3);
                this.controlaCampos();
            } else {
                Funcoes.mensagem(this, "Agrupamento n\u00e3o localizado", 2);
                this.setStatus(1);
                this.controlaCampos();
            }
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtCodSituacao.getText())) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o n\u00e3o informada", 1);
            this.txtCodSituacao.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodSituacao.getText()) && this.labelDescSituacao.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o n\u00e3o localizada", 1);
            this.txtCodSituacao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodConvenio.getText())) {
            Funcoes.mensagem(this, "Conv\u00eanio n\u00e3o informado", 1);
            this.txtCodConvenio.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodConvenio.getText()) && this.labelDescConvenio.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conv\u00eanio n\u00e3o localizado", 1);
            this.txtCodConvenio.grabFocus();
            return false;
        }
        if (this.modelo.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum exame foi agrupado", 1);
            this.txtCodExameFilho.requestFocus();
            return false;
        }
        return true;
    }

    private void limparCampos() {
        this.txtCodExameFilho.clear();
        this.txtCodSituacao.clear();
        this.txtCodConvenio.clear();
        this.checkIgnorarConvenio.setSelected(false);
        this.labelDescExameFilho.setText("");
        this.labelDescSituacao.setText("");
        this.labelDescConvenio.setText("");
        this.comboExameFilho.removeAllItems();
        this.modelo.clear();
    }

    private void controlaCampos() {
        this.txtCodExameFilho.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.txtCodSituacao.setEnabled(this.getStatus() == 2);
        this.txtCodConvenio.setEnabled(this.getStatus() == 2);
        this.comboExameFilho.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.buttonBuscaSituacao.setEnabled(this.getStatus() == 2);
        this.buttonBuscaConvenio.setEnabled(this.getStatus() == 2);
        this.buttonBuscaExameFilho.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.buttonOK.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.checkIgnorarConvenio.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901230");
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(AgrupaSituacao.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901231"));
        this.setModuloEdita(Long.parseLong("0101901232"));
        this.setModuloApaga(Long.parseLong("0101901233"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.agrupaSituacao(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodSituacao.setText(resultado.get("sit_codigo").toString());
            this.labelDescSituacao.setText(resultado.get("sit_descricao").toString());
            this.txtCodConvenio.setText(resultado.get("con_codigo").toString());
            this.labelDescConvenio.setText(resultado.get("con_fantasia").toString());
        }
        this.txtCodConvenio.requestFocus();
        return retorno;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

