/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro.agrupamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class AgrupaFaturamento
extends FrmCadPadrao {
    private JPanel panelExame = new JPanel(null);
    private JLabel labelExamePai = new JLabel("Exame Pai:");
    private JLabel labelExameFilho = new JLabel("Exame:");
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private TTextField txtCodExamePai = new TTextField(5);
    private JComboBox comboExamePai = new JComboBox();
    private TTextField txtCodExameFilho = new TTextField(5);
    private JComboBox comboExameFilho = new JComboBox();
    private TTextField txtCodConvenio = new TTextField(5, 1);
    private JLabel labelDescExamePai = new JLabel();
    private JLabel labelDescExameFilho = new JLabel();
    private JLabel labelDescConvenio = new JLabel();
    private JButton buttonBuscaExamePai = new JButton();
    private JButton buttonBuscaExameFilho = new JButton();
    private JButton buttonBuscaConvenio = new JButton();
    private JButton buttonOK = new JButton("OK");
    private JCheckBox checkIgnorarConvenio = new JCheckBox("Permitir que todos os conv\u00eanios utilizem este agrupamento");
    private JCheckBox checkIgnorarMaterial = new JCheckBox("Permitir que todos os materiais de coleta utilizem este agrupamento");
    private JTable tableExames = new JTable();
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame"});
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int TIPO_BUSCA_EXAME = 1;

    public AgrupaFaturamento() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
        }
        this.txtCodExamePai.setUpperCase(true);
        this.txtCodExameFilho.setUpperCase(true);
    }

    private void posicionaComponentes() {
        this.labelDescExamePai.setBounds(263, 5, this.panelExame.getWidth() - 268, 20);
        this.labelDescConvenio.setBounds(162, 26, this.panelExame.getWidth() - 167, 20);
        this.labelDescExameFilho.setBounds(263, 47, this.panelExame.getWidth() - 311, 20);
        this.buttonOK.setBounds(this.panelExame.getWidth() - 45, 47, 40, 20);
    }

    private void jbInit() throws Exception {
        this.setName("AgrupaFaturamento");
        this.setLabelDescricao("Agrupamento de exames a serem faturados por conv\u00eanio");
        this.setLabelFormulario("Agrupamento Exames/Faturamento");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/exm_faturamento.jpg"));
        this.panelExame.setPreferredSize(new Dimension(10, 69));
        this.labelExamePai.setBounds(2, 7, 69, 14);
        this.txtCodExamePai.setBounds(71, 5, 69, 20);
        this.txtCodExamePai.setName("txtCodExamePai");
        this.buttonBuscaExamePai.setBounds(141, 5, 20, 20);
        this.buttonBuscaExamePai.setName("buttonBuscaExamePai");
        this.comboExamePai.setBounds(162, 5, 100, 20);
        this.comboExamePai.setName("comboExamePai");
        this.labelDescExamePai.setBounds(263, 5, 150, 20);
        this.labelConvenio.setBounds(2, 28, 69, 14);
        this.txtCodConvenio.setBounds(71, 26, 69, 20);
        this.txtCodConvenio.setName("txtCodConvenio");
        this.buttonBuscaConvenio.setBounds(141, 26, 20, 20);
        this.buttonBuscaConvenio.setName("buttonBuscaConvenio");
        this.labelDescConvenio.setBounds(162, 26, 150, 20);
        this.labelExameFilho.setBounds(2, 49, 69, 14);
        this.txtCodExameFilho.setBounds(71, 47, 69, 20);
        this.txtCodExameFilho.setName("txtCodExameFilho");
        this.buttonBuscaExameFilho.setBounds(141, 47, 20, 20);
        this.buttonBuscaExameFilho.setName("buttonBuscaExameFilho");
        this.comboExameFilho.setBounds(162, 47, 100, 20);
        this.comboExameFilho.setName("comboExameFilho");
        this.labelDescExameFilho.setBounds(263, 47, 150, 20);
        this.buttonOK.setBounds(414, 47, 40, 20);
        this.buttonOK.setName("buttonOK");
        Funcoes.imagemPesquisa(this.buttonBuscaExamePai);
        Funcoes.imagemPesquisa(this.buttonBuscaExameFilho);
        Funcoes.imagemPesquisa(this.buttonBuscaConvenio);
        ScreenUtil.setBorda(new Component[]{this.labelDescExamePai, this.labelDescExameFilho, this.labelDescConvenio}, new TitledBorder(""));
        JPanel panelIgnorar = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.fill = 2;
        gb.weightx = 1.0;
        panelIgnorar.add((Component)this.checkIgnorarConvenio, gb);
        this.checkIgnorarConvenio.setName("checkIgnorarConvenio");
        ++gb.gridy;
        panelIgnorar.add((Component)this.checkIgnorarMaterial, gb);
        this.checkIgnorarMaterial.setName("checkIgnorarMaterial");
        this.painelCentral.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        this.painelCentral.add((Component)this.panelExame, "North");
        this.painelCentral.add((Component)this.scrollExames, "Center");
        this.painelCentral.add((Component)panelIgnorar, "South");
        this.panelExame.add(this.labelExamePai);
        this.panelExame.add(this.labelExameFilho);
        this.panelExame.add(this.labelConvenio);
        this.panelExame.add(this.txtCodExamePai);
        this.panelExame.add(this.comboExamePai);
        this.panelExame.add(this.txtCodExameFilho);
        this.panelExame.add(this.comboExameFilho);
        this.panelExame.add(this.txtCodConvenio);
        this.panelExame.add(this.labelDescExamePai);
        this.panelExame.add(this.labelDescExameFilho);
        this.panelExame.add(this.labelDescConvenio);
        this.panelExame.add(this.buttonBuscaExamePai);
        this.panelExame.add(this.buttonBuscaExameFilho);
        this.panelExame.add(this.buttonBuscaConvenio);
        this.panelExame.add(this.buttonOK);
        this.tableExames.setModel(this.modelo);
        this.modelo.setColumnSize(new int[]{100, 80, 0}, this.tableExames);
        this.buttonOK.setMargin(new Insets(2, 2, 2, 2));
        this.buttonBuscaExamePai.setFocusable(false);
        this.buttonBuscaExameFilho.setFocusable(false);
        this.buttonBuscaConvenio.setFocusable(false);
        this.controlaCampos();
        this.panelExame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AgrupaFaturamento.this.posicionaComponentes();
            }
        });
        this.buttonBuscaExamePai.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupaFaturamento.this.buscaExame(AgrupaFaturamento.this.txtCodExamePai);
            }
        });
        this.buttonBuscaExameFilho.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupaFaturamento.this.buscaExame(AgrupaFaturamento.this.txtCodExameFilho);
            }
        });
        this.buttonBuscaConvenio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgrupaFaturamento.this.buscaConvenio();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(Funcoes.textoVazio(AgrupaFaturamento.this.txtCodExameFilho.getText()) || AgrupaFaturamento.this.labelDescExameFilho.getText().equals("N\u00e3o cadastrado") || Funcoes.textoVazio(AgrupaFaturamento.this.txtCodConvenio.getText()))) {
                    if (AgrupaFaturamento.this.txtCodExameFilho.getText().equals(AgrupaFaturamento.this.txtCodExamePai.getText()) && ((DadosMaterial)AgrupaFaturamento.this.comboExameFilho.getSelectedItem()).equals(AgrupaFaturamento.this.comboExamePai.getSelectedItem())) {
                        Funcoes.mensagem(AgrupaFaturamento.this, "O exame n\u00e3o pode agrupar ele mesmo", 2);
                    } else {
                        try {
                            DadosMaterial material = (DadosMaterial)AgrupaFaturamento.this.comboExameFilho.getSelectedItem();
                            DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, AgrupaFaturamento.this.txtCodExameFilho.getText(), material);
                            DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(AgrupaFaturamento.this.txtCodConvenio.getText()));
                            int p = ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, dadosExame, material, dadosConvenio, false, false, false, null, null, Integer.parseInt(dadosExame.getCodMetodo()));
                            if (p != 1 && p != 6 && p != 7 && p != 8) {
                                boolean localizaExame = AgrupaFaturamento.this.localizaExameFilho(AgrupaFaturamento.this.txtCodExameFilho.getText(), material);
                                if (localizaExame) {
                                    boolean podeAdicionar = true;
                                    if (dadosConvenio.getExamesPorGuia() > 0 && AgrupaFaturamento.this.modelo.getRowCount() >= dadosConvenio.getExamesPorGuia()) {
                                        boolean bl = podeAdicionar = Funcoes.mensagem(AgrupaFaturamento.this, "O agrupamento tem mais exames que o permitido por guia,\nas guias adicionais ser\u00e3o solicitadas na requisi\u00e7\u00e3o.\nConfirmar a adi\u00e7\u00e3o do exame?", 4) == 0;
                                    }
                                    if (podeAdicionar) {
                                        AgrupaFaturamento.this.modelo.addLine(new Object[]{AgrupaFaturamento.this.txtCodExameFilho.getText(), AgrupaFaturamento.this.comboExameFilho.getSelectedItem(), AgrupaFaturamento.this.labelDescExameFilho.getText()});
                                    }
                                }
                            } else {
                                Funcoes.mensagem(AgrupaFaturamento.this, "Exame n\u00e3o permitido para o conv\u00eanio", 2);
                            }
                        }
                        catch (SQLException sqlex) {
                            Funcoes.mensagem(AgrupaFaturamento.this, "Erro ao obter os dados do exame", 1);
                            ErrorLogger.mostraMensagem(AgrupaFaturamento.this, sqlex.getMessage(), sqlex.getStackTrace(), "AgrupaFaturamento");
                        }
                    }
                    AgrupaFaturamento.this.txtCodExameFilho.clear();
                    AgrupaFaturamento.this.comboExameFilho.removeAllItems();
                    AgrupaFaturamento.this.labelDescExameFilho.setText("");
                    AgrupaFaturamento.this.txtCodExameFilho.requestFocus();
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AgrupaFaturamento.this.tableExames.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(AgrupaFaturamento.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    AgrupaFaturamento.this.modelo.removeLine(AgrupaFaturamento.this.tableExames.getSelectedRow());
                }
            }
        });
        this.txtCodExamePai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(AgrupaFaturamento.this.txtCodExamePai.getText()) && !AgrupaFaturamento.this.buscaExamePai(1)) {
                        ExameUtil.carregarMateriaisColeta(AgrupaFaturamento.this.txtCodExamePai.getText(), Variaveis.filialPadrao, AgrupaFaturamento.this.comboExamePai);
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(AgrupaFaturamento.this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
                }
            }
        });
        this.txtCodExameFilho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(AgrupaFaturamento.this.txtCodExameFilho.getText())) {
                        ExameUtil.carregarMateriaisColeta(AgrupaFaturamento.this.txtCodExameFilho.getText(), Variaveis.filialPadrao, AgrupaFaturamento.this.comboExameFilho);
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(AgrupaFaturamento.this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
                }
            }
        });
        this.txtCodConvenio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupaFaturamento.this.txtCodConvenio.getText())) {
                    StringBuffer buf = new StringBuffer("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and con_codigo = ");
                    buf.append(AgrupaFaturamento.this.txtCodConvenio.getText());
                    try {
                        String descricao = DBUtil.getDescricao("select con_fantasia from convenios", buf.toString(), "con_fantasia");
                        AgrupaFaturamento.this.labelDescConvenio.setText(descricao);
                        if (AgrupaFaturamento.this.buscaDados()) {
                            AgrupaFaturamento.this.setStatus(3);
                            AgrupaFaturamento.this.controlaCampos();
                        }
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(AgrupaFaturamento.this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
                    }
                }
            }
        });
        this.comboExamePai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupaFaturamento.this.txtCodExamePai.getText())) {
                    StringBuffer buf = new StringBuffer("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and exa_codigo = ").append(AgrupaFaturamento.this.txtCodExamePai.getTextDBEscape());
                    try {
                        String descricao = DBUtil.getDescricao("select exa_descricao from exames", buf.toString(), "exa_descricao");
                        AgrupaFaturamento.this.labelDescExamePai.setText(descricao);
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(AgrupaFaturamento.this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
                    }
                }
            }
        });
        this.comboExameFilho.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(AgrupaFaturamento.this.txtCodExameFilho.getText())) {
                    StringBuffer buf = new StringBuffer("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and exa_codigo = ").append(AgrupaFaturamento.this.txtCodExameFilho.getTextDBEscape());
                    try {
                        String descricao = DBUtil.getDescricao("select exa_descricao from exames", buf.toString(), "exa_descricao");
                        AgrupaFaturamento.this.labelDescExameFilho.setText(descricao);
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(AgrupaFaturamento.this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
                    }
                }
            }
        });
        this.checkIgnorarConvenio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AgrupaFaturamento.this.checkIgnorarConvenio.isSelected()) {
                    AgrupaFaturamento.this.validaQtdeAgrupamentoExame(AgrupaFaturamento.this.txtCodExamePai.getText());
                }
            }
        });
        this.tableExames.setName("tableExames");
    }

    private void validaQtdeAgrupamentoExame(String codigoExame) {
        int qtde = 0;
        int ultimoConvenio = -1;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select  a.con_codigo, count(a.exa_codigo) ");
        buf.append("from exameagrupaexameconvenio a ");
        buf.append("left join agrupaexameconvenio c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.con_codigo = c.con_codigo and a.aec_tipo = c.aec_tipo ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = ").append(this.txtCodExamePai.getTextDBEscape());
        buf.append(" and a.aec_tipo = '").append("F").append("' ");
        buf.append(" and not c.aec_ignorarconvenio ");
        buf.append("group by a.con_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                if (ultimoConvenio == -1) {
                    ultimoConvenio = rs.getInt("con_codigo");
                    ++qtde;
                }
                if (ultimoConvenio == rs.getInt("con_codigo")) continue;
                ++qtde;
            }
            if (qtde != 1 && this.getStatus() == 3 || qtde > 0 && this.getStatus() == 2) {
                Funcoes.mensagem(this, "N\u00e2o \u00e9 poss\u00edvel utilizar o agrupamento para todos os conv\u00eanios,\n pois h\u00e1 configura\u00e7\u00f5es de agrupamento para o exame.", 2);
                this.checkIgnorarConvenio.setSelected(false);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + e.toString(), 1);
        }
    }

    private boolean buscaExamePai(int tipoBusca) {
        boolean retorno = false;
        if (Funcoes.textoVazio(this.txtCodExamePai.getText())) {
            return retorno;
        }
        Statement st = Conexao.getStatement();
        StringBuffer buf = new StringBuffer("select a.con_codigo, a.exa_kodigo, a.mco_kodigo, b.exa_descricao, c.aec_ignorarconvenio, c.aec_ignorarmaterial  ");
        buf.append("from exameagrupaexameconvenio a ");
        buf.append("left join agrupaexameconvenio c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.con_codigo = c.con_codigo and a.aec_tipo = c.aec_tipo ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = ").append(this.txtCodExamePai.getTextDBEscape());
        buf.append(" and a.aec_tipo = '").append("F").append("' ");
        if (tipoBusca == 1) {
            buf.append("and c.aec_ignorarconvenio");
        } else {
            buf.append("and not c.aec_ignorarconvenio");
        }
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next();
            if (retorno) {
                if (Funcoes.mensagem(this, "O exame j\u00e1 possui agrupamento que permite a utiliza\u00e7\u00e3o para todos os conv\u00eanios, deseja edita-lo?", 4) == 0) {
                    this.setStatus(3);
                    this.controlaCampos();
                    ExameUtil.carregarMateriaisColeta(this.txtCodExamePai.getText(), Variaveis.filialPadrao, this.comboExamePai);
                    this.checkIgnorarConvenio.setSelected(rs.getBoolean("aec_ignorarconvenio"));
                    this.checkIgnorarMaterial.setSelected(rs.getBoolean("aec_ignorarmaterial"));
                    this.txtCodConvenio.setText(rs.getString("con_codigo"));
                    if (!Funcoes.textoVazio(this.txtCodExamePai)) {
                        buf.delete(0, buf.length());
                        buf.append("fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and con_codigo = ");
                        buf.append(rs.getString("con_codigo"));
                        String descricao = DBUtil.getDescricao("select con_fantasia from convenios", buf.toString(), "con_fantasia");
                        this.labelDescConvenio.setText(descricao);
                    }
                    do {
                        DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_kodigo"));
                        this.modelo.addLine(new Object[]{rs.getString("exa_kodigo"), material, rs.getString("exa_descricao")});
                    } while (rs.next());
                    this.txtCodExameFilho.requestFocus();
                } else {
                    this.limparCampos();
                    this.txtCodExamePai.requestFocus();
                }
            } else {
                this.txtCodConvenio.requestFocus();
            }
            rs.close();
        }
        catch (Exception ex) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.toString(), 1);
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private boolean buscaDados() {
        boolean retorno = false;
        if (Funcoes.textoVazio(this.txtCodExamePai.getText()) || Funcoes.textoVazio(this.txtCodConvenio.getText())) {
            return retorno;
        }
        this.modelo.clear();
        Statement st = Conexao.getStatement();
        StringBuffer buf = new StringBuffer("select a.exa_kodigo, a.mco_kodigo, b.exa_descricao, c.aec_ignorarconvenio, c.aec_ignorarmaterial ");
        buf.append("from exameagrupaexameconvenio a ");
        buf.append("left join agrupaexameconvenio c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and a.con_codigo = c.con_codigo and a.aec_tipo = c.aec_tipo ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.exa_codigo = ").append(this.txtCodExamePai.getTextDBEscape());
        buf.append(" and a.mco_codigo = ");
        buf.append(String.valueOf(((DadosMaterial)this.comboExamePai.getSelectedItem()).getCodigo()));
        buf.append(" and a.con_codigo = ");
        buf.append(this.txtCodConvenio.getText());
        buf.append(" and a.aec_tipo = '").append("F").append("' ");
        buf.append(" order by a.exa_kodigo, a.mco_kodigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            retorno = rs.next();
            if (retorno) {
                this.checkIgnorarConvenio.setSelected(rs.getBoolean("aec_ignorarconvenio"));
                this.checkIgnorarMaterial.setSelected(rs.getBoolean("aec_ignorarmaterial"));
                do {
                    DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_kodigo"));
                    this.modelo.addLine(new Object[]{rs.getString("exa_kodigo"), material, rs.getString("exa_descricao")});
                } while (rs.next());
            }
            rs.close();
            this.txtCodExameFilho.requestFocus();
        }
        catch (Exception ex) {
            Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.toString(), 1);
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private boolean localizaExameFilho(String exame, DadosMaterial material) {
        int retorno = ExameUtil.localizaExame(exame, material, this.modelo, 0, 1);
        return retorno < 0;
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodExamePai.hasFocus()) {
            this.buscaExame(this.txtCodExamePai);
        } else if (this.txtCodExameFilho.hasFocus()) {
            this.buscaExame(this.txtCodExameFilho);
        } else if (this.txtCodConvenio.hasFocus()) {
            this.buscaConvenio();
        }
    }

    private void buscaExame(TTextField campo) {
        Hashtable resultado = Pesquisas.exame(this.getTopLevelAncestor(), true, false);
        if (resultado != null) {
            campo.setText(resultado.get("exa_codigo").toString());
        }
        campo.requestFocus();
    }

    private void buscaConvenio() {
        Hashtable convenio = Pesquisas.convenio(this.getTopLevelAncestor(), true, false);
        if (convenio != null) {
            this.txtCodConvenio.setText(convenio.get("con_codigo").toString());
        }
        this.txtCodConvenio.grabFocus();
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodExamePai.requestFocus();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            Statement st = Conexao.getStatement();
            try {
                SalvaDados salvar = new SalvaDados("agrupaexameconvenio", 1);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("exa_codigo", 0, false, true, this.txtCodExamePai.getTextDBEscape());
                salvar.adicionaCampo("mco_codigo", 2, false, true, ((DadosMaterial)this.comboExamePai.getSelectedItem()).getCodigo());
                salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                salvar.adicionaCampo("aec_tipo", 0, false, true, StringUtil.textoDBEscape("F"));
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaFatura());
                if (this.checkIgnorarMaterial.isSelected()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select count(1) as qtde ");
                    buf.append("   from agrupaexameconvenio ");
                    buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("    and exa_codigo = ").append(this.txtCodExamePai.getTextDBEscape());
                    buf.append("    and con_codigo = ").append(this.txtCodConvenio.getText());
                    buf.append("    and aec_tipo = '").append("F").append("' ");
                    buf.append("    and aec_ignorarmaterial = true ");
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next() && rs.getInt("qtde") > 0) {
                        int resp = Funcoes.mensagem(this, "J\u00e1 existe um agrupamento para o exame ignorando material.\nDeseja que o agrupamento em edi\u00e7\u00e3o ignore material?", 4);
                        if (resp == 0) {
                            buf.delete(0, buf.length());
                            buf.append(" update agrupaexameconvenio ");
                            buf.append("    set aec_ignorarmaterial = false ");
                            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                            buf.append("    and exa_codigo = ").append(this.txtCodExamePai.getTextDBEscape());
                            buf.append("    and aec_tipo = '").append("F").append("' ");
                            buf.append("    and con_codigo = ").append(this.txtCodConvenio.getText());
                            buf.append("    and aec_ignorarmaterial = true ");
                            Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                        } else {
                            this.checkIgnorarMaterial.setSelected(false);
                        }
                    }
                }
                salvar.limpar();
                salvar.setTabela("agrupaexameconvenio");
                salvar.setOperacao(0);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("exa_codigo", 0, false, true, this.txtCodExamePai.getTextDBEscape());
                salvar.adicionaCampo("mco_codigo", 2, false, true, ((DadosMaterial)this.comboExamePai.getSelectedItem()).getCodigo());
                salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                salvar.adicionaCampo("aec_tipo", 0, false, true, StringUtil.textoDBEscape("F"));
                salvar.adicionaCampo("aec_ignorarconvenio", 4, false, true, this.checkIgnorarConvenio.isSelected());
                salvar.adicionaCampo("aec_ignorarmaterial", 4, false, true, this.checkIgnorarMaterial.isSelected());
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaFatura());
                salvar.setTabela("exameagrupaexameconvenio");
                salvar.setOperacao(0);
                for (int i = 0; i < this.tableExames.getRowCount(); ++i) {
                    salvar.limpar();
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("exa_codigo", 0, false, true, this.txtCodExamePai.getTextDBEscape());
                    salvar.adicionaCampo("mco_codigo", 2, false, true, ((DadosMaterial)this.comboExamePai.getSelectedItem()).getCodigo());
                    salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                    salvar.adicionaCampo("aec_tipo", 0, false, true, StringUtil.textoDBEscape("F"));
                    salvar.adicionaCampo("exa_kodigo", 0, false, true, StringUtil.textoDBEscape(this.modelo.getValueAt(i, 0).toString()));
                    salvar.adicionaCampo("mco_kodigo", 2, false, true, ((DadosMaterial)this.modelo.getValueAt(i, 1)).getCodigo());
                    DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaFatura());
                }
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento (438)");
            }
            Conexao.fecharStatement(st);
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            Statement st = Conexao.getStatement();
            try {
                this.setStatus(4);
                this.controlaCampos();
                SalvaDados salvar = new SalvaDados("agrupaexameconvenio", 1);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("exa_codigo", 0, false, true, this.txtCodExamePai.getTextDBEscape());
                salvar.adicionaCampo("mco_codigo", 2, false, true, ((DadosMaterial)this.comboExamePai.getSelectedItem()).getCodigo());
                salvar.adicionaCampo("con_codigo", 2, false, true, this.txtCodConvenio.getText());
                salvar.adicionaCampo("aec_tipo", 0, false, true, StringUtil.textoDBEscape("F"));
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaAgrupaFatura());
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento");
            }
            Conexao.fecharStatement(st);
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            if (this.buscaDados()) {
                this.setStatus(3);
                this.controlaCampos();
            } else {
                Funcoes.mensagem(this, "Agrupamento n\u00e3o localizado", 2);
                this.setStatus(1);
                this.controlaCampos();
            }
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtCodExamePai.getText())) {
            Funcoes.mensagem(this, "Exame pai n\u00e3o informado", 1);
            this.txtCodExamePai.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodExamePai.getText()) && this.labelDescExamePai.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Exame pai n\u00e3o localizado", 1);
            this.txtCodExamePai.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodConvenio.getText())) {
            Funcoes.mensagem(this, "Conv\u00eanio n\u00e3o informado", 1);
            this.txtCodConvenio.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodConvenio.getText()) && this.labelDescConvenio.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Conv\u00eanio n\u00e3o localizado", 1);
            this.txtCodConvenio.grabFocus();
            return false;
        }
        if (this.modelo.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum exame foi agrupado", 1);
            this.txtCodExameFilho.requestFocus();
            return false;
        }
        return true;
    }

    private void limparCampos() {
        this.txtCodExamePai.clear();
        this.txtCodExameFilho.clear();
        this.txtCodConvenio.clear();
        this.labelDescExamePai.setText("");
        this.labelDescExameFilho.setText("");
        this.labelDescConvenio.setText("");
        this.checkIgnorarConvenio.setSelected(false);
        this.checkIgnorarMaterial.setSelected(false);
        this.comboExamePai.removeAllItems();
        this.comboExameFilho.removeAllItems();
        this.modelo.clear();
    }

    private void controlaCampos() {
        this.txtCodExamePai.setEnabled(this.getStatus() == 2);
        this.txtCodExameFilho.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.txtCodConvenio.setEnabled(this.getStatus() == 2);
        this.comboExamePai.setEnabled(this.getStatus() == 2);
        this.comboExameFilho.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.buttonBuscaExamePai.setEnabled(this.getStatus() == 2);
        this.buttonBuscaConvenio.setEnabled(this.getStatus() == 2);
        this.buttonBuscaExameFilho.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.buttonOK.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.checkIgnorarConvenio.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
        this.checkIgnorarMaterial.setEnabled(this.getStatus() == 2 || this.getStatus() == 3);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901210");
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(AgrupaFaturamento.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901211"));
        this.setModuloEdita(Long.parseLong("0101901212"));
        this.setModuloApaga(Long.parseLong("0101901213"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.agrupaFaturamento(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodExamePai.setText(resultado.get("exa_codigo").toString());
            this.labelDescExamePai.setText(resultado.get("exa_descricao").toString());
            this.txtCodConvenio.setText(resultado.get("con_codigo").toString());
            this.labelDescConvenio.setText(resultado.get("con_fantasia").toString());
            if (!Funcoes.textoVazio(this.txtCodExamePai.getText())) {
                try {
                    ExameUtil.carregarMateriaisColeta(this.txtCodExamePai.getText(), Variaveis.filialPadrao, this.comboExamePai);
                    int material = this.localizaMaterial(Integer.parseInt(resultado.get("mco_codigo").toString()));
                    if (material > -1) {
                        this.comboExamePai.setSelectedIndex(material);
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AgrupaFaturamento (600)");
                }
            }
        }
        this.txtCodConvenio.requestFocus();
        return retorno;
    }

    private int localizaMaterial(int codigo) {
        int retorno = -1;
        for (int i = 0; i < this.comboExamePai.getItemCount(); ++i) {
            DadosMaterial m = (DadosMaterial)this.comboExamePai.getItemAt(i);
            if (m.getCodigo() != codigo) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

