/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.pedido.InfoPerguntaPesquisaFornecedor;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class VisualizarPesquisaFornecedor
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo;
    private JTable table;
    private int COLUNA_NUMERO = 0;
    private int COLUNA_DATA = 1;
    private int COLUNA_RESPOSTA = 2;
    private EntidadeBean fornecedor;
    private Boolean selecionarNota = null;
    private NotaFiscalBean cadastro;

    public VisualizarPesquisaFornecedor(Dialog pai, EntidadeBean cadastro) {
        super(pai, "Notas Fiscais de entrada");
        this.fornecedor = cadastro;
        this.montaTela();
    }

    public VisualizarPesquisaFornecedor(Frame pai, EntidadeBean cadastro) {
        super(pai, "Notas Fiscais de entrada");
        this.fornecedor = cadastro;
        this.montaTela();
    }

    public VisualizarPesquisaFornecedor(Frame pai, NotaFiscalBean cadastro, Boolean selecionarNota) {
        super(pai, "Notas Fiscais de entrada");
        this.fornecedor = (EntidadeBean)cadastro.getEntidade().toBean();
        this.cadastro = cadastro;
        this.selecionarNota = selecionarNota;
        this.montaTela();
    }

    private void montaTela() {
        this.modelo = new ModeloGridTable(new String[]{"Numero", "Data", "Hist."});
        this.table = new JTable(this.modelo){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == VisualizarPesquisaFornecedor.this.COLUNA_RESPOSTA) {
                    return Set.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == VisualizarPesquisaFornecedor.this.COLUNA_RESPOSTA;
            }
        };
        this.table.setRowHeight(20);
        this.modelo.setColumnSize(new int[]{0, 0, 32}, this.table);
        JPanel panelCentral = this.getPanelCentral();
        ButtonEditor buttonEditor = new ButtonEditor();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        this.table.getTableHeader().addMouseListener(this.modelo);
        JPanel panel = new JPanel();
        JScrollPane scroll = new JScrollPane(this.table);
        panel.add(scroll);
        this.table.setDefaultRenderer(Set.class, buttonRenderer);
        this.table.setDefaultEditor(Set.class, buttonEditor);
        this.setResizable(false);
        int width = 367;
        int height = 300;
        this.setSize(width, height);
        Dimension dim = new Dimension(width - 10, height - 85);
        scroll.setPreferredSize(dim);
        scroll.setMinimumSize(dim);
        scroll.setMaximumSize(dim);
        this.carregarDadosTabela();
        panelCentral.add(panel);
        Funcoes.montaEnter((JComponent)panelCentral);
        Funcoes.defineUpperCase(panelCentral, ParametrosGerais.getUpperCase());
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.modelo.setSentidoOrdenacao(-1);
        this.buttonOK.setText("Fechar");
        this.buttonOK.setMnemonic('F');
        this.buttonCancelar.setVisible(false);
    }

    private void carregarDadosTabela() {
        EntidadeBean entBean = this.fornecedor;
        NotaFiscalService serviceNota = new NotaFiscalService();
        ArrayList<Object[]> listaNotas = null;
        if (this.fornecedor != null) {
            try {
                listaNotas = serviceNota.buscaNotasFiscaisCadastroFornecedor(Variaveis.filialPadrao, entBean.getCodigo().toString(), entBean.getTipo(), Conexao.getStatement(), false);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar notas fiscais do fornecedor." + e.getMessage(), e.getStackTrace());
            }
            int linhaSelecionar = -1;
            int contPesquisa = -1;
            if (listaNotas != null && listaNotas.size() > 0) {
                for (int i = 0; i < listaNotas.size(); ++i) {
                    String numero = (String)listaNotas.get(i)[0];
                    String data = Funcoes.formataData("dd/MM/yyyy", (Date)listaNotas.get(i)[2]);
                    String pesquisa = (String)listaNotas.get(i)[4];
                    HashSet<String> pesqAux = new HashSet<String>();
                    if (Funcoes.textoVazio(pesquisa) || Funcoes.textoVazio(StringUtil.getValor(pesquisa, "resultado"))) continue;
                    pesqAux.add(pesquisa);
                    this.modelo.addLine(new Object[]{numero, data, pesqAux});
                    ++contPesquisa;
                    if (this.selecionarNota == null || this.cadastro == null || !this.selecionarNota.booleanValue() || !this.cadastro.getNumero().toString().equals(numero) || linhaSelecionar != -1) continue;
                    linhaSelecionar = contPesquisa;
                }
                if (this.selecionarNota != null && this.selecionarNota.booleanValue() && linhaSelecionar > -1) {
                    this.table.setRowSelectionInterval(linhaSelecionar, linhaSelecionar);
                    this.table.scrollRectToVisible(this.table.getCellRect(linhaSelecionar, 0, false));
                }
            }
        }
    }

    class ButtonEditor
    extends DefaultCellEditor {
        private JButton button;
        int linha;

        public ButtonEditor() {
            super(new JCheckBox());
            this.linha = -1;
            this.button = new JButton();
            this.button.setOpaque(true);
            Funcoes.imagemPesquisa(this.button);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.linha = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            Set resultado;
            if (this.linha > -1 && (resultado = (Set)VisualizarPesquisaFornecedor.this.modelo.getValueAt(this.linha, VisualizarPesquisaFornecedor.this.COLUNA_RESPOSTA)) != null && resultado.size() > 0) {
                String aux = resultado.toArray()[0].toString();
                InfoPerguntaPesquisaFornecedor info = new InfoPerguntaPesquisaFornecedor((Frame)Laboratorio.getInstancia(), true, "Resultado da pesquisa");
                info.setInstrucoes(aux);
                info.setVisible(true);
                return resultado;
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.linha = -1;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            isSelected = false;
            Funcoes.imagemPesquisa(this);
            return this;
        }
    }
}

