/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.MaterialAlternativoBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.service.estoque.MaterialService;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class VisualizarMateriaisAlternativos
extends AbstractDialogoOKCancelar {
    private final int COLUNA_CODIGO_MATERIAL = 0;
    private final int COLUNA_DESCRICAO_MATERIAL = 1;
    private final int COLUNA_OBJECT_MATERIAL_ALTERNATIVO = 2;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    private JTable tabela = new JTable(this.modelo);
    private MaterialAlternativoBean beanAlternativo = null;

    public static VisualizarMateriaisAlternativos novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new VisualizarMateriaisAlternativos((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new VisualizarMateriaisAlternativos((Dialog)owner);
        }
        return null;
    }

    public VisualizarMateriaisAlternativos(Frame owner) {
        super(owner, "Alternativos");
        this.montaTela();
    }

    public VisualizarMateriaisAlternativos(Dialog owner) {
        super(owner, "Alternativos");
        this.montaTela();
    }

    public void setMateriaisAlternativos(ArrayList<MaterialAlternativoBean> alternativos) {
        this.modelo.clear();
        for (MaterialAlternativoBean s : alternativos) {
            this.modelo.addLine(new Object[]{s.getMaterial().getCodigo(), s.getMaterial().getDescricao(), s});
        }
        if (this.modelo.getRowCount() > 0) {
            this.tabela.getSelectionModel().setSelectionInterval(0, 0);
            ScreenUtil.requisitarFoco(this.tabela);
        } else {
            ScreenUtil.requisitarFoco(this.getBotaoOK());
        }
    }

    @Override
    public boolean acaoOk() {
        int pos = this.tabela.getSelectedRow();
        if (pos > -1) {
            this.beanAlternativo = (MaterialAlternativoBean)this.modelo.getValueAt(pos, 2);
        }
        return this.beanAlternativo != null;
    }

    private void montaTela() {
        this.setSize(new Dimension(500, 300));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.tabela), "Center");
        this.modelo.setColumnSize(new int[]{100, 0}, this.tabela);
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VisualizarMateriaisAlternativos.this.buttonOK.doClick();
                }
            }
        });
    }

    public MaterialAlternativoBean getBeanAlternativo() {
        return this.beanAlternativo;
    }

    public static MaterialBean getTelaMaterialAlternativo(MaterialBean bean, TTextField textCodigoMaterial) {
        block5: {
            if (bean == null) {
                ArrayList<Object> listaMateriaisPorAlternativo = new ArrayList();
                try {
                    VisualizarMateriaisAlternativos visualizarMateriais;
                    listaMateriaisPorAlternativo = new MaterialService().getTodosMateriaisAlternativo(Variaveis.filialPadrao, textCodigoMaterial.getText().toString());
                    if (listaMateriaisPorAlternativo == null) break block5;
                    if (listaMateriaisPorAlternativo.size() == 1) {
                        return (MaterialBean)((MaterialAlternativoBean)listaMateriaisPorAlternativo.get(0)).getMaterial().toBean();
                    }
                    if (listaMateriaisPorAlternativo.size() <= 1 || (visualizarMateriais = VisualizarMateriaisAlternativos.novaInstancia(Laboratorio.getInstancia())) == null) break block5;
                    visualizarMateriais.setMateriaisAlternativos(listaMateriaisPorAlternativo);
                    visualizarMateriais.setVisible(true);
                    if (visualizarMateriais.getOK() && visualizarMateriais.acaoOk()) {
                        bean = (MaterialBean)visualizarMateriais.getBeanAlternativo().getMaterial().toBean();
                        break block5;
                    }
                    return null;
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel carregar os dados do material alternativo.\n" + e1.getMessage(), e1.getStackTrace());
                    return null;
                }
            }
        }
        return bean;
    }
}

